/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef ComponentDC_H
#define ComponentDC_H

#include <pml/Component.h>
#include <MeshComponent.h>

class PMManagerDC;
#include "PMComponentAPI.h"
/**
 * @ingroup group_cepmodeling_components_physicalmodel
 *
 * @brief
 * The manager of the Component data.
 *
 *
 **/
class PHYSICALMODEL_COMPONENT_API ComponentDC : public camitk::MeshComponent {
    Q_OBJECT
public:
    /// constructors
    ComponentDC(camitk::Component *parent, PMManagerDC * pmManagerDC, ::Component * c=NULL);

    virtual ~ComponentDC() {};

    /**
    * @name camitk::Component rewritten
    * This methods are overloaded from camitk::Component to give the ComponentDC and
    * all its sub classes a different behaviour.
    */
    ///*@{
    virtual void setOpacity(const double);

    virtual const EnhancedModes getEnhancedModes() const;

    virtual const RenderingModes getRenderingModes() const;

    virtual void setName(const QString &);

    /// remove a sub DC: overloaded method to avoir deletion of children that are used in more than one SCDC (that have more than one parent)
    virtual void deleteChildren() {}

    /// return the first non-null subcomponent point set
    virtual vtkSmartPointer< vtkPointSet > getPointSet();
    ///@}

    /// return the component that this dc is managing
    ::Component * getComponent();

    /// get the PMManagerDC (given during instanciation), allows one to get PML/Component maps
    virtual PMManagerDC * getPMManagerDC() {
        return myPMManagerDC;
    }

    /** create all the point data to display specific information
     *  (only works for SCs that have a surface representation).
     *  This will automatically fills up the AtomDC point data pointers.
     */
    virtual void createPointData();

    /// destroy all the point data
    virtual void destroyPointData();

    /// show all properties
    virtual QObject* getPropertyObject() {
        return this;
    }

    /// update a specific property
    virtual void updateProperty(QString name, QVariant value);

protected:

    /// the PMManagerDC
    PMManagerDC *myPMManagerDC;

    /// the managed Component
    ::Component * myComponent;
};


inline ::Component * ComponentDC::getComponent() {
    return ((::Component *)myComponent);
}

inline void ComponentDC::setName(const QString &n) {
    getComponent()->setName(n.toStdString());
    camitk::Component::setName(n);
}

#endif
