/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef CellDC_H
#define CellDC_H

#include <Component.h>
//#include "StructureDC.h"
#include "StructuralComponentDC.h"
//Added by qt3to4:
#include <QPixmap>

class Cell;
class Atom;
class CellDCProperties;
/**
 *  @ingroup group_cepmodeling_components_physicalmodel
 *
 *  @brief
 *  The manager of the Cell data.
 *  CellDC are only created in the StructuralComponentDC constructor, which garanties that each cell has ONE AND ONLY ONE DC.
 *
 *
 **/
class CellDC : public StructuralComponentDC {
    Q_OBJECT
public:
    /// Default constructor
    CellDC(camitk::Component *, PMManagerDC * pmManagerDC, Cell *);

    /// destructor
    virtual ~CellDC();

    /**
     * @name camitk::Component rewritten
     * This methods are overloaded from camitk::Component to give the CellDC another behaviour
     */
    ///@{
    virtual QPixmap getIcon();

    virtual void setName(const QString &);

    /// if selected, creates the 3D representation (that was delayed in the constructor). Blocks all recursivity.
    virtual void setSelected(const bool, const bool recursive=false);

    /// reimplement this method to give the property object to the property editor
    virtual QObject * getPropertyObject();
    ///@}

    /// get the atom this dc is representing
    virtual Cell * getCell();

    /** create all the point data to display specific information
     *  (only works for SCs that have a surface representation).
     *  This will automatically fills up the AtomDC point data pointers.
     */
    virtual void createPointData();

    /// destroy all the point data
    virtual void destroyPointData();

private:
    /// the concrete building of the 3D object
    virtual void initRepresentation();

    /// store the cell here, as well as in the SCDC, because otherwise the down cast lose the specific Structure properties
    Cell *myCell;

    /// the CellDC pixmap
    static QPixmap * myPixmap;

    /// the atom'properties
    CellDCProperties * myProp;
};


inline Cell * CellDC::getCell() {
    return myCell;
}

#endif
