# Driver instructions for Nightly build on a computer
# To configurat a Nightly build, create a cron job using a script that loads this ctest instruction (driver) using the 
# followind command line : ctest -S ctest-nightly-driver.cmake
#
# What this script does ?
# * INFORMATION STEP
# 	Configure SITE and BUILD information to be correctly display on dashboard
# 	Loads information from the CTestConfig.cmake file.
# * UPDATE STEP
#	use svn to udpdate source code to the latest revision BEFORE Nightly start time, which is defined in the CTestConfig.cmake file.
# * CONFIGURE STEP
#	configure the whole CamiTK project and create a new build directory 
# * BUILD STEP 
#	build each subproject of CamiTK
# For each step a report is sent to the dashboard. This allows any developer to be informed (mailing list) of any problem, even BEFORE the script ends !

# Need to be defined, for the build to run.
set(CTEST_SOURCE_DIRECTORY "C:/dev/CamiTK/trunk_debug")
set(CTEST_BINARY_DIRECTORY "C:/dev/CamiTK/build_nightly/debug")

# Script configuration, depending of the build, computer running the script
# Update to feat each computer which runs this script
set( CTEST_SITE "MANNONI-Win7-32")
set( CTEST_BUILD_NAME "Win7-32-MinGW-Debug")
set( CTEST_CMAKE_GENERATOR  "MinGW Makefiles")
set( CTEST_BUILD_CONFIGURATION "Debug")

# Update source code and send reports
# set( CTEST_UPDATE_COMMAND "svn")
find_program(CTEST_SVN_COMMAND svn)
set( CTEST_UPDATE_COMMAND ${CTEST_SVN_COMMAND})

# CMake configuration (put here all the configure flags)
set( CTEST_CONFIGURE_COMMAND "${CMAKE_COMMAND} -G \"${CTEST_CMAKE_GENERATOR}\"")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCMAKE_BUILD_TYPE:STRING=${CTEST_BUILD_CONFIGURATION}")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCMAKE_SKIP_RPATH=TRUE  -DTOOL_CORESCHEMA=TRUE -DTOOL_LML=TRUE -DTOOL_PML=TRUE -DMML_GENERATE_GUI=TRUE -DTOOL_MML=TRUE -DMML_GENERATE_XSD_LIB=TRUE -DACTION_MML=TRUE -DACTION_ITKSEGMENTATION=TRUE -DACTION_ITKFILTERS=TRUE -DAPPLICATION_WIZARD=TRUE -DCOMPONENT_VTKMESH=TRUE -DCOMPONENT_DICOM=TRUE -DCOMPONENT_ITKIMAGE=TRUE -DCOMPONENT_PHYSICALMODEL=TRUE -DCOMPONENT_MML=TRUE -DAPIDOC_GENERATE_FOR_CAMITK_CORE=TRUE ${CTEST_SOURCE_DIRECTORY}")
# -DCAMITK_INSTALL_ROOT=${CTEST_BINARY_DIRECTORY}

# to get CDash server configuration :
include("${CTEST_SOURCE_DIRECTORY}/CTestConfig.cmake")

# The type of build that this script will make 
# For this script we use Nightly build has it is designed to be run once a day
ctest_start(Nightly)

# Update source code
ctest_update(SOURCE ${CTEST_SOURCE_DIRECTORY})
ctest_submit(PARTS Update Notes)

# Configure whole project
ctest_empty_binary_directory(${CTEST_BINARY_DIRECTORY})
ctest_configure()
ctest_submit(PARTS Configure)

# to get subprojects listing (automatically created at confituration step)
include("${CTEST_BINARY_DIRECTORY}/Subprojects.cmake")

# Update CDash configuration to the server
# Project.xml file is automatically generated. If someone added an extension to CamiTK, CDash will automatically be updated according to it.
# To do this, send this file to the server
ctest_submit(FILES "${CTEST_BINARY_DIRECTORY}/Project.xml") 

# Build each subprojects
foreach(subproject ${CAMITK_SUBPROJECTS})
	# tag sub project
	set_property(GLOBAL PROPERTY SubProject ${subproject})
	set_property(GLOBAL PROPERTY Label ${subproject})

	# build each sub project
	set(CTEST_BUILD_TARGET ${subproject})
	ctest_build()
	ctest_submit(PARTS Build)
        # build binary for testing
        set(CTEST_BUILD_TARGET ${subproject}test)
        ctest_build()

	# Run tests
        ctest_test(BUILD "${CTEST_BINARY_DIRECTORY}" INCLUDE_LABEL "${subproject}")
        ctest_submit(PARTS Test)
endforeach() 

# Build documentation
# tag the corresponding subproject
set_property(GLOBAL PROPERTY SubProject apidoc)
set_property(GLOBAL PROPERTY Label apidoc)
# Build apidoc
set(CTEST_BUILD_TARGET apidoc)
ctest_build()
ctest_submit(PARTS Build)



