/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef SELECT_LAST_INSTANCIATED_ACTION_H
#define SELECT_LAST_INSTANCIATED_ACTION_H

#include <Action.h>

using namespace camitk;

/// This action allows to select the last instanciated component
/// Note that only that one will be selected
class SelectLastInstanciatedAction : public Action {

public:
  /// Default Constructor
  SelectLastInstanciatedAction(ActionExtension * extension);

  /// Default Destructor
  virtual ~SelectLastInstanciatedAction();

  /// Returns NULL: no widget at all for this action
  virtual QWidget * getWidget();

public slots:
  /// apply the action select the last instanciated component
  virtual ApplyStatus apply();

};
#endif // SELECT_LAST_INSTANCIATED_ACTION_H
