/**************************************************************************/
/*                   Cameleon                                             */
/*                                                                        */
/*      Copyright (C) 2002 Institut National de Recherche en Informatique et   */
/*      en Automatique. All rights reserved.                              */
/*                                                                        */
/*      This program is free software; you can redistribute it and/or modify  */
/*      it under the terms of the GNU General Public License as published by  */
/*      the Free Software Foundation; either version 2 of the License, or  */
/*      any later version.                                                */
/*                                                                        */
/*      This program is distributed in the hope that it will be useful,   */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*      GNU General Public License for more details.                      */
/*                                                                        */
/*      You should have received a copy of the GNU General Public License  */
/*      along with this program; if not, write to the Free Software       */
/*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          */
/*      02111-1307  USA                                                   */
/*                                                                        */
/*      Contact: Maxence.Guesdon@inria.fr                                */
/**************************************************************************/

%{


open Zog_types
%}

%token EOF KIND NAME SUP ENTITY_START ENTITY_END 
%token ENTITIES_START ENTITIES_END 
%token PARAM_START PARAM_END  EQUAL
%token HEADER_START HEADER_END COMPONENT_START COMPONENT_END 
%token <string> IDENT VALUE

%type <Zog_types.info> info
%type <string> entity_start
%type <string list> entity_params params
%type <string * string> property 
%type <(string * string) list> property_list
%type <Zog_types.component> component component_start
%type <Zog_types.component option> component_opt
%type <Zog_types.component list> children
%type <Zog_types.entity> entity
%type <Zog_types.entity list> entity_list 

%start info
%start entity
%start component

%%
info: info_header info_entities EOF        { { info_header = $1 ; info_entities = $2} }
;

info_header: 
  HEADER_START VALUE HEADER_END { $2 }
;

info_entities: 
  ENTITIES_START entity_list ENTITIES_END { List.rev $2 }
;

entity_list:
  { [] }
| entity_list entity { $2 :: $1 }
; 

entity:
 entity_start entity_params component_opt ENTITY_END 
  { 
    { ent_name = $1 ;
      ent_params = $2 ;
      ent_component = $3;
    } 
  } 
;

entity_start:
      ENTITY_START NAME VALUE SUP   { $3 }
;

entity_params: 
    params { $1 }
;

params:
      { [] }
| PARAM_START VALUE PARAM_END params { $2 :: $4 }
;

component_opt: 
  { None }
| component { Some $1 }
;

children:
  { [] }
| children component   { $1 @ [$2] }
;

component: 
  component_start children COMPONENT_END
  { 
    let comp = $1 in
    comp#set_children $2;
    comp
  } 
;

component_start:
  COMPONENT_START KIND VALUE NAME VALUE property_list SUP   
  {
    let factory = 
      try Zog_register.get_factory $3 
      with Not_found -> 
	raise (Failure ("No factory for kind "^ $3))
    in
    let comp = factory#create () in
    comp#set_name $5 ;
    let f_prop (p,v) =
      if p = "expanded" then 
	comp#set_expanded (v <> "false")
      else
	comp#set_property_value p v
    in
    List.iter f_prop $6;
    comp
  }
;

property_list:
  { [] }
| property_list property  { $1 @ [$2] }
;

property: 
  IDENT EQUAL  VALUE
  { $1, $3 }
;
