(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

{

open StdLabels
open Zog_parser

let print_DEBUG s = print_string s ; print_newline ()

let string_buffer = Buffer.create 32

let reset_string_buffer () = Buffer.reset string_buffer
let ajout_char_string = Buffer.add_char string_buffer
let ajout_string = Buffer.add_string string_buffer
let lecture_string () = Buffer.contents string_buffer


} 

rule token = parse
  [ ' ' '\t']+     { token lexbuf }
| '\n'             { incr Zog_misc.line_number ; token lexbuf }
| "<entity"        { ENTITY_START }
| "</entity>"      { ENTITY_END }
| "<component"        { COMPONENT_START }
| "</component>"      { COMPONENT_END }
| "<header>"        { HEADER_START }
| "</header>"      { HEADER_END }
| "<entities>"        { ENTITIES_START }
| "</entities>"      { ENTITIES_END }
| "<param>"       { PARAM_START }
| "</param>"       { PARAM_END }
| "name="          { NAME }
| "kind="          { KIND }
|  "\""           { value_string lexbuf }
|  '>'             { SUP }
| "="              { EQUAL }

| ['A'-'Z' 'a'-'z' '0'-'9' '_' '.']+
  {
    let s = Lexing.lexeme lexbuf in IDENT s
  }

| eof               { EOF }

and value_string = parse
    [' ' '\013' '\009' '\012'] +
    { 
      value_string lexbuf
    }
    
| [ '\010' ]
    { 
      incr Zog_misc.line_number ; value_string lexbuf 
    }

  | "\""
      {
	let s = lecture_string () in
	reset_string_buffer ();
	VALUE s
      }	

  | _
      {
	let c = (Lexing.lexeme_char lexbuf 0) in
        ajout_char_string c;
        value_string lexbuf
      }

