(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

type doc = int Report.report


type css_names = {
    section_table : string ;
    section_title : string ;
    subsection_table : string ;
    subsection_title : string ;
    elements : string ;
    row : string array;
  } 

let default_css_names = {
    section_table = "sectiontable" ;
    section_title = "sectiontitle" ;
    subsection_table = "subsectiontable" ;
    subsection_title = "subsectiontitle" ;
    elements = "elements" ;
    row = [| "row1" ; "row2" ; "row3" |] ;
  } 

let ref_css_names = ref default_css_names

let css_names () = !ref_css_names

let set_css_names c = 
  let c2 = 
    match c.row with
      [| |] -> { c with row = default_css_names.row }
    | [| r |] -> { c with row = [| r ; default_css_names.row.(1) ;
				   default_css_names.row.(2) |] }
    | [| r0 ; r1 |] -> { c with row = [| r0 ; r1 ; default_css_names.row.(2) ;|] }
    | _ -> c
  in
  ref_css_names := c2
