(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

class type config = Chat_config.config 

class file_config = Chat_config.config

type port = int
type host = string
type address = host * port
type message = string
type version = Chat_proto.version
type id = string
type source = version * id * address
type proto = Chat_proto.proto =
    Hello | HelloOk | Byebye | Message of message 
  | AddOpen of id * address
  | RoomMessage of id * (id * host * port) list * message
  | File of int * string
type info = source * id * proto

let version () = Chat_messages.software_version

let read_info = Chat_proto.read_info_buffer
let read_info_channel = Chat_proto.read_info_channel

let write_info = Chat_proto.write_info
let write_info_channel = Chat_proto.write_info_channel


