(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Menus definition and manipulation *)

type command = string

type menu =
    { mutable mn_label : string ;
      mutable mn_children : menu_item list;
      mutable mn_doc : bool ;
    } 

and menu_item_info =
    { mutable mii_label : string ;
      mutable mii_command : command ;
    } 

and menu_item = 
    Submenu of menu
  | Command of menu_item_info
  | Separator of string

val menu_of_string : string -> menu

val string_of_menu : menu -> string

(** The doc menu, initialized by create_menu, if a doc menu was found. *)
val doc_menu : GMenu.menu ref
