package CamelBones::Foundation::Constants;

use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

our @EXPORT = qw(
    NSCalculationNoError NSCalculationLossOfPrecision NSCalculationUnderflow
    NSCalculationOverflow NSCalculationDivideByZero
    
    NSOrderedAscending NSOrderedSame NSOrderedDescending
    
    NSPositionAfter NSPositionBefore NSPositionBeginning NSPositionEnd NSPositionReplace
    
    NSNetServicesUnknownError NSNetServicesCollisionError NSNetServicesNotFoundError
    NSNetServicesActivityInProgressError NSNetServicesBadArgumentError NSNetServicesCancelledError
    NSNetServicesInvalidError
    
    NSNotificationSuspensionBehaviorDrop NSNotificationSuspensionBehaviorCoalesce
    NSNotificationSuspensionBehaviorHold NSNotificationSuspensionBehaviorDeliverImmediately
    
    NSPostWhenIdle NSPostASAP NSPostNow

    NSMinXEdge NSMinYEdge NSMaxXEdge NSMaxYEdge

    NSRelativeAfter NSRelativeBefore
    
    NSRoundPlain NSRoundDown NSRoundUp NSRoundBankers
    
    NSSaveOptionsYes NSSaveOptionsNo NSSaveOptionsAsk

    NSApplicationDirectory NSDemoApplicationDirectory NSDeveloperApplicationDirectory 
    NSAdminApplicationDirectory NSLibraryDirectory NSDeveloperDirectory NSUserDirectory 
    NSDocumentationDirectory NSAllApplicationsDirectory NSAllLibrariesDirectory 

    NSUserDomainMask NSLocalDomainMask NSNetworkDomainMask NSSystemDomainMask 
    NSAllDomainsMask 
    
    NSEqualToComparison NSLessThanOrEqualToComparison NSLessThanComparison 
    NSGreaterThanOrEqualToComparison NSGreaterThanComparison NSBeginsWithComparison 
    NSEndsWithComparison NSContainsComparison 
    
    NSURLHandleNotLoaded NSURLHandleLoadSucceeded NSURLHandleLoadInProgress 
    NSURLHandleLoadFailed 
    
    NSIndexSubelement NSEverySubelement NSMiddleSubelement NSRandomSubelement 
    NSNoSubelement 
    
    NSNotFound 

    NSOpenStepUnicodeReservedBase 

    NSWindowsNTOperatingSystem NSWindows95OperatingSystem NSSolarisOperatingSystem 
    NSHPUXOperatingSystem NSMACHOperatingSystem NSSunOSOperatingSystem NSOSF1OperatingSystem 
    
    NSNoScriptError NSReceiverEvaluationScriptError NSKeySpecifierEvaluationScriptError 
    NSArgumentEvaluationScriptError NSReceiversCantHandleCommandScriptError NSRequiredArgumentsMissingScriptError 
    NSArgumentsWrongScriptError NSUnknownKeyScriptError NSInternalScriptError 
    NSOperationNotSupportedForKeyScriptError NSCannotCreateScriptCommandError 
    
    NSNoSpecifierError NSNoTopLevelContainersSpecifierError NSContainerSpecifierError 
    NSUnknownKeySpecifierError NSInvalidIndexSpecifierError NSInternalSpecifierError 
    NSOperationNotSupportedForKeySpecifierError 

    NSUndoCloseGroupingRunLoopOrdering 

    NSCaseInsensitiveSearch NSLiteralSearch NSBackwardsSearch NSAnchoredSearch 
    
    NSASCIIStringEncoding NSNEXTSTEPStringEncoding NSJapaneseEUCStringEncoding 
    NSUTF8StringEncoding NSISOLatin1StringEncoding NSSymbolStringEncoding NSNonLossyASCIIStringEncoding 
    NSShiftJISStringEncoding NSISOLatin2StringEncoding NSUnicodeStringEncoding 
    NSWindowsCP1251StringEncoding NSWindowsCP1252StringEncoding NSWindowsCP1253StringEncoding 
    NSWindowsCP1254StringEncoding NSWindowsCP1250StringEncoding NSISO2022JPStringEncoding 
    NSMacOSRomanStringEncoding NSProprietaryStringEncoding 
);

#  NSSaveOptions
use constant NSSaveOptionsYes => 0;
use constant NSSaveOptionsNo => 1;
use constant NSSaveOptionsAsk => 2;

# NSCalculationError
use constant NSCalculationNoError => 0;
use constant NSCalculationLossOfPrecision => 1;
use constant NSCalculationUnderflow => 2;
use constant NSCalculationOverflow => 3;
use constant NSCalculationDivideByZero => 4;

# NSComparisonResult
use constant NSOrderedAscending => -1;
use constant NSOrderedSame => 0;
use constant NSOrderedDescending => 1;

# NSInsertionPosition
use constant NSPositionAfter => 0;
use constant NSPositionBefore => 1;
use constant NSPositionBeginning => 2;
use constant NSPositionEnd => 3;
use constant NSPositionReplace => 4;

# NSNetServicesError
use constant NSNetServicesUnknownError => -72000;
use constant NSNetServicesCollisionError => -72001;
use constant NSNetServicesNotFoundError => -72002;
use constant NSNetServicesActivityInProgressError => -72003;
use constant NSNetServicesBadArgumentError => -72004;
use constant NSNetServicesCancelledError => -72005;
use constant NSNetServicesInvalidError => -72006;

# NSNotificationCoalescing
use constant NSNotificationSuspensionBehaviorDrop => 1;
use constant NSNotificationSuspensionBehaviorCoalesce => 2;
use constant NSNotificationSuspensionBehaviorHold => 3;
use constant NSNotificationSuspensionBehaviorDeliverImmediately => 4;

# NSPostingStyle
use constant NSPostWhenIdle => 1;
use constant NSPostASAP => 2;
use constant NSPostNow => 3;

# NSRectEdge
use constant NSMinXEdge => 0;
use constant NSMinYEdge => 1;
use constant NSMaxXEdge => 2;
use constant NSMaxYEdge => 3;

# NSRelativePosition
use constant NSRelativeAfter => 0;
use constant NSRelativeBefore => 1;

# NSRoundingMode
use constant NSRoundPlain => 0;
use constant NSRoundDown => 1;
use constant NSRoundUp => 2;
use constant NSRoundBankers => 3;

# NSSaveOptions
use constant NSSaveOptionsYes => 0;
use constant NSSaveOptionsNo => 1;
use constant NSSaveOptionsAsk => 2;

# NSSearchPathDirectory
use constant NSApplicationDirectory => 1;
use constant NSDemoApplicationDirectory => 2;
use constant NSDeveloperApplicationDirectory => 3;
use constant NSAdminApplicationDirectory => 4;
use constant NSLibraryDirectory => 5;
use constant NSDeveloperDirectory => 6;
use constant NSUserDirectory => 7;
use constant NSDocumentationDirectory => 8;
use constant NSAllApplicationsDirectory => 100;
use constant NSAllLibrariesDirectory => 101;

# NSSearchPathDomainMask
use constant NSUserDomainMask => 1;
use constant NSLocalDomainMask => 2;
use constant NSNetworkDomainMask => 4;
use constant NSSystemDomainMask => 8;
use constant NSAllDomainsMask => 0x0ffff;

# NSTestComparisonOperation
use constant NSEqualToComparison => 0;
use constant NSLessThanOrEqualToComparison => 1;
use constant NSLessThanComparison => 2;
use constant NSGreaterThanOrEqualToComparison => 3;
use constant NSGreaterThanComparison => 4;
use constant NSBeginsWithComparison => 5;
use constant NSEndsWithComparison => 6;
use constant NSContainsComparison => 7;

# NSURLHandleStatus
use constant NSURLHandleNotLoaded => 0;
use constant NSURLHandleLoadSucceeded => 1;
use constant NSURLHandleLoadInProgress => 2;
use constant NSURLHandleLoadFailed => 3;

# NSWhoseSubelementIdentifier
use constant NSIndexSubelement => 0;
use constant NSEverySubelement => 1;
use constant NSMiddleSubelement => 2;
use constant NSRandomSubelement => 3;
use constant NSNoSubelement => 4;

# NSNotFound
use constant NSNotFound => 0x7fffffff;

# NSOpenStepUnicodeReservedBase
use constant NSOpenStepUnicodeReservedBase => 0xF400;

# NSProcessInfo - Operating Systems
use constant NSWindowsNTOperatingSystem => 1;
use constant NSWindows95OperatingSystem => 2;
use constant NSSolarisOperatingSystem => 3;
use constant NSHPUXOperatingSystem => 4;
use constant NSMACHOperatingSystem => 5;
use constant NSSunOSOperatingSystem => 6;
use constant NSOSF1OperatingSystem => 7;

# NSScriptCommand - General Command Execution Errors
use constant NSNoScriptError => 0;
use constant NSReceiverEvaluationScriptError => 1;
use constant NSKeySpecifierEvaluationScriptError => 2;
use constant NSArgumentEvaluationScriptError => 3;
use constant NSReceiversCantHandleCommandScriptError => 4;
use constant NSRequiredArgumentsMissingScriptError => 5;
use constant NSArgumentsWrongScriptError => 6;
use constant NSUnknownKeyScriptError => 7;
use constant NSInternalScriptError => 8;
use constant NSOperationNotSupportedForKeyScriptError => 9;
use constant NSCannotCreateScriptCommandError => 10;

# NSScriptCommand - Specifier Evaluation Errors
use constant NSNoSpecifierError => 0;
use constant NSNoTopLevelContainersSpecifierError => 1;
use constant NSContainerSpecifierError => 2;
use constant NSUnknownKeySpecifierError => 3;
use constant NSInvalidIndexSpecifierError => 4;
use constant NSInternalSpecifierError => 5;
use constant NSOperationNotSupportedForKeySpecifierError => 6;

# NSUndoCloseGroupingRunLoopOrdering
use constant NSUndoCloseGroupingRunLoopOrdering => 350000;

# Search Types
use constant NSCaseInsensitiveSearch => 1;
use constant NSLiteralSearch => 2;
use constant NSBackwardsSearch => 4;
use constant NSAnchoredSearch => 8;

# String Encodings
use constant NSASCIIStringEncoding => 1;
use constant NSNEXTSTEPStringEncoding => 2;
use constant NSJapaneseEUCStringEncoding => 3;
use constant NSUTF8StringEncoding => 4;
use constant NSISOLatin1StringEncoding => 5;
use constant NSSymbolStringEncoding => 6;
use constant NSNonLossyASCIIStringEncoding => 7;
use constant NSShiftJISStringEncoding => 8;
use constant NSISOLatin2StringEncoding => 9;
use constant NSUnicodeStringEncoding => 10;
use constant NSWindowsCP1251StringEncoding => 11;
use constant NSWindowsCP1252StringEncoding => 12;
use constant NSWindowsCP1253StringEncoding => 13;
use constant NSWindowsCP1254StringEncoding => 14;
use constant NSWindowsCP1250StringEncoding => 15;
use constant NSISO2022JPStringEncoding => 21;
use constant NSMacOSRomanStringEncoding => 30;
use constant NSProprietaryStringEncoding => 65536;

# Happy perl
1;
