/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: Basic.pmod,v 1.11 2004/01/13 11:01:38 vida Exp $
 */
//! file: Basic.pmod
//!  Handler of Camas Formbutton file format, in basic mode
//! cvs_version: $Id: Basic.pmod,v 1.11 2004/01/13 11:01:38 vida Exp $

// === CAMAS BASIC ===
#define LINE_COMMENT	0x00
#define LINE_DIRECTIVE	0x01

//! class: File
//!  Handler of basicmode reader.
class File
{
  string datafile;	// file to be used...
  /*
   * PRIVATE FUNCTIONS
   */
  static int qualify_line(string line)
  {
    if (!line || line == "")
      return LINE_COMMENT;
    if (sizeof(line) >=1 && line [0..0] == "#")
      return LINE_COMMENT;
    if (sizeof(line) >=1 && line [0..0] == " ")
      return LINE_COMMENT;
    if (sizeof(line/"\t") == 2)
      return LINE_DIRECTIVE;
    return -1;
  }

  /*
   * Public functions
   */
  void create(string path)
  {
    datafile = Stdio.read_bytes(path);
    if (datafile == 0) throw("Unable to read "+path+" file !");
  }

  mapping doindex()
  {
    mapping out = ([ ]);
    foreach((datafile-"\r")/"\n",string foo)
    {
      if(qualify_line(foo) == LINE_DIRECTIVE)
      {
        array l= foo / "\t";

				out += ([ l[0] : l[1] ]);
      }
    }
    return out;
  }
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

