<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2004 Ian Berry                                            |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | cacti: a php-based graphing solution                                    |
 +-------------------------------------------------------------------------+
 | Most of this code has been designed, written and is maintained by       |
 | Ian Berry. See about.php for specific developer credit. Any questions   |
 | or comments regarding this code should be directed to:                  |
 | - iberry@raxnet.net                                                     |
 +-------------------------------------------------------------------------+
 | - raXnet - http://www.raxnet.net/                                       |
 +-------------------------------------------------------------------------+
*/

/* make sure these values refect your acual database/host/user/password */
$database_type = "mysql";
$database_default = "cacti";
$database_hostname = "localhost";
$database_username = "cactiuser";
$database_password = "cactiuser";

/* ----- you probably do not need to change anything below this line ----- */

/* this should be auto-detected, set it manually if needed */
$config["cacti_server_os"] = (strstr(PHP_OS, "WIN")) ? "win32" : "unix";

/* built-in snmp support */
$config["php_snmp_support"] = function_exists("snmpget");

/* used for includes */
$config["base_path"] = ereg_replace("(.*)[\/\\]include", "\\1", dirname(__FILE__));
$config["library_path"] = ereg_replace("(.*[\/\\])include", "\\1lib", dirname(__FILE__));
$config["include_path"] = dirname(__FILE__);

/* colors */
$colors["dark_outline"] = "454E53";
$colors["dark_bar"] = "AEB4B7";
$colors["panel"] = "E5E5E5";
$colors["panel_text"] = "000000";
$colors["panel_link"] = "000000";
$colors["light"] = "F5F5F5";
$colors["alternate"] = "E7E9F2";
$colors["panel_dark"] = "C5C5C5";

$colors["header"] = "00438C";
$colors["header_panel"] = "6d88ad";
$colors["header_text"] = "ffffff";
$colors["form_background_dark"] = "E1E1E1";

$colors["form_alternate1"] = "F5F5F5";
$colors["form_alternate2"] = "E5E5E5";

if ((isset($no_http_headers) ? $no_http_headers : false) != true) {
	/* we don't want these pages cached */
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache");
	
	/* initilize php session */
	session_start();
}

/* display ALL errors */
error_reporting(E_ALL);

include_once($config["include_path"] . "/config_arrays.php");
include_once($config["include_path"] . "/config_form.php");
include_once($config["library_path"] . "/functions.php");
include_once($config["library_path"] . "/form.php");
include_once($config["library_path"] . "/database.php");
include_once($config["library_path"] . "/variables.php");
include_once($config["library_path"] . "/auth.php");

/* current cacti version */
$config["cacti_version"] = "0.8.5a";

?>
