# Copyright (C) 2007, 2009-2011 Aaron Bentley
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA


import bzrlib
from bzrlib.trace import warning


__version__ = '1.1.0'
version_info = (1, 1, 0)

minimum_bzrlib_version = (2, 2)
maximum_bzrlib_version = (2, 4)


TOO_OLD = 'too_old'
COMPATIBLE = 'compatible'
MAYBE_TOO_NEW = 'maybe_too_new'
TOO_NEW = 'too_new'


def check_version_compatibility(bzrlib_version, min_version, max_version):
    """Check whether a bzrlib version is compatible with desired version.

    If the bzrlib_version is not less than min_version and not greater than
    max_version, it is considered COMPATIBLE.  If the version exceeds
    max_version by 1 and is not a 'candidate' or 'final' version, it is
    considered MAYBE_TOO_NEW.  Other values greater than max_version are
    considered TOO_NEW, and values lower than min_version are considered
    TOO_OLD.
    """
    bzrlib_version = bzrlib.version_info[:2]
    if bzrlib_version < min_version:
        return TOO_OLD
    if bzrlib_version <= max_version:
        return COMPATIBLE
    max_plus = (max_version[0], max_version[1] + 1)
    if bzrlib_version == max_plus:
        if bzrlib.version_info[3] not in ('final', 'candidate'):
            return COMPATIBLE
        return MAYBE_TOO_NEW
    return TOO_NEW


compatibility = check_version_compatibility(bzrlib.version_info,
                                            minimum_bzrlib_version,
                                            maximum_bzrlib_version)
if compatibility == TOO_OLD:
    warning('bzr %s is too old for pipeline %s', bzrlib.__version__,
            __version__)
elif compatibility != COMPATIBLE:
    warning('bzr %s is too new for pipeline %s', bzrlib.__version__,
            __version__)
if compatibility not in (TOO_OLD, TOO_NEW):
    from real_init import *
    __doc__ = real_init.__doc__
