from bzrlib import tests
from bzrlib.plugins.pipeline.pipeline import PipeStorage


class TestCaseWithPipes(tests.TestCaseWithTransport):

    def make_branch_and_checkout(self, branch_path, checkout_path='checkout'):
        branch = self.make_branch(branch_path)
        return branch.create_checkout(checkout_path, lightweight=True)

    def connect_many(self, *branches):
        prev = None
        for branch in branches:
            if prev is not None:
                PipeStorage.connect(prev, branch)
            prev = branch

    def assertBaseEqual(self, left, right):
        self.assertEqual([l.base for l in left], [r.base for r in right])

    def create_long_pipeline(self):
        foo = self.make_branch('foo')
        bar = self.make_branch('bar')
        baz = self.make_branch('baz')
        qux = self.make_branch('qux')
        quxx = self.make_branch('quxx')
        self.connect_many(foo, bar, baz, qux, quxx)
        return [foo, bar, baz, qux, quxx]
