/* MountItem.c generated by valac 0.32.1, the Vala compiler
 * generated from MountItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2015-2016 Solus Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_LIST_ITEM (list_item_get_type ())
#define LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_ITEM, ListItem))
#define LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_ITEM, ListItemClass))
#define IS_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_ITEM))
#define IS_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_ITEM))
#define LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_ITEM, ListItemClass))

typedef struct _ListItem ListItem;
typedef struct _ListItemClass ListItemClass;
typedef struct _ListItemPrivate ListItemPrivate;

#define TYPE_MOUNT_ITEM (mount_item_get_type ())
#define MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ITEM, MountItem))
#define MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ITEM, MountItemClass))
#define IS_MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ITEM))
#define IS_MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ITEM))
#define MOUNT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ITEM, MountItemClass))

typedef struct _MountItem MountItem;
typedef struct _MountItemClass MountItemClass;
typedef struct _MountItemPrivate MountItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ListItem {
	GtkBox parent_instance;
	ListItemPrivate * priv;
	gchar* item_class;
	gchar* category_name;
	GtkToolButton* name_button;
	GtkOverlay* overlay;
	GtkSpinner* spin;
};

struct _ListItemClass {
	GtkBoxClass parent_class;
};

struct _MountItem {
	ListItem parent_instance;
	MountItemPrivate * priv;
};

struct _MountItemClass {
	ListItemClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	MountItem* self;
	GMount* mount;
};

struct _Block4Data {
	int _ref_count_;
	MountItem* self;
	GMount* mount;
};


static gpointer mount_item_parent_class = NULL;
static GType mount_item_type_id = 0;

GType list_item_get_type (void) G_GNUC_CONST;
GType list_item_register_type (GTypeModule * module);
GType mount_item_get_type (void) G_GNUC_CONST;
GType mount_item_register_type (GTypeModule * module);
enum  {
	MOUNT_ITEM_DUMMY_PROPERTY
};
MountItem* mount_item_new (GMount* mount, const gchar* class);
MountItem* mount_item_construct (GType object_type, GMount* mount, const gchar* class);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
ListItem* list_item_construct (GType object_type);
void list_item_set_button (ListItem* self, const gchar* label, GtkImage* image, gboolean spinner);
GtkImage* list_item_get_icon (ListItem* self, GIcon* icon);
static void __lambda13_ (Block3Data* _data3_);
static void mount_item_do_unmount (MountItem* self, GMount* mount);
static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda16_ (Block3Data* _data3_);
void list_item_open_directory (ListItem* self, const gchar* location);
static void ___lambda16__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda14_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void ____lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda15_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		MountItem* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->mount);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda13_ (Block3Data* _data3_) {
	MountItem* self;
	GMount* _tmp0_ = NULL;
	self = _data3_->self;
	_tmp0_ = _data3_->mount;
	mount_item_do_unmount (self, _tmp0_);
}


static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda13_ (self);
}


static void __lambda16_ (Block3Data* _data3_) {
	MountItem* self;
	GMount* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self = _data3_->self;
	_tmp0_ = _data3_->mount;
	_tmp1_ = g_mount_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	list_item_open_directory ((ListItem*) self, _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}


static void ___lambda16__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda16_ (self);
}


MountItem* mount_item_construct (GType object_type, GMount* mount, const gchar* class) {
	MountItem * self = NULL;
	Block3Data* _data3_;
	GMount* _tmp0_ = NULL;
	GMount* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	GMount* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GMount* _tmp21_ = NULL;
	GIcon* _tmp22_ = NULL;
	GIcon* _tmp23_ = NULL;
	GtkImage* _tmp24_ = NULL;
	GtkImage* _tmp25_ = NULL;
	GtkButton* unmount_button = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkStyleContext* _tmp28_ = NULL;
	GtkButton* _tmp29_ = NULL;
	GtkButton* _tmp30_ = NULL;
	GtkButton* _tmp31_ = NULL;
	GtkOverlay* _tmp32_ = NULL;
	GtkButton* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	GMount* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	GtkToolButton* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GMount* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	GtkToolButton* _tmp48_ = NULL;
	g_return_val_if_fail (mount != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = mount;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->mount);
	_data3_->mount = _tmp1_;
	self = (MountItem*) list_item_construct (object_type);
	_data3_->self = g_object_ref (self);
	_tmp2_ = class;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (((ListItem*) self)->item_class);
	((ListItem*) self)->item_class = _tmp3_;
	_tmp4_ = ((ListItem*) self)->item_class;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("device")))) {
		switch (0) {
			default:
			{
				GMount* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp8_ = _data3_->mount;
				_tmp9_ = g_mount_can_eject (_tmp8_);
				if (_tmp9_) {
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp10_ = _ ("Removable devices");
					_tmp11_ = g_strdup (_tmp10_);
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp11_;
				} else {
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					_tmp12_ = _ ("Local volumes");
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp13_;
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("network")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp14_ = _ ("Network folders");
				_tmp15_ = g_strdup (_tmp14_);
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp15_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				_tmp16_ = _ ("Other");
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp17_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp18_ = _data3_->mount;
	_tmp19_ = g_mount_get_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _data3_->mount;
	_tmp22_ = g_mount_get_symbolic_icon (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = list_item_get_icon ((ListItem*) self, _tmp23_);
	_tmp25_ = _tmp24_;
	list_item_set_button ((ListItem*) self, _tmp20_, _tmp25_, FALSE);
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp26_ = (GtkButton*) gtk_button_new_from_icon_name ("media-eject-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp26_);
	unmount_button = _tmp26_;
	_tmp27_ = unmount_button;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "unmount-button");
	_tmp29_ = unmount_button;
	gtk_button_set_relief (_tmp29_, GTK_RELIEF_NONE);
	_tmp30_ = unmount_button;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp30_, FALSE);
	_tmp31_ = unmount_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp31_, GTK_ALIGN_END);
	_tmp32_ = ((ListItem*) self)->overlay;
	_tmp33_ = unmount_button;
	gtk_overlay_add_overlay (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = unmount_button;
	g_signal_connect_data (_tmp34_, "clicked", (GCallback) ___lambda13__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp35_ = _data3_->mount;
	_tmp36_ = g_mount_can_eject (_tmp35_);
	if (_tmp36_) {
		GtkButton* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		_tmp37_ = unmount_button;
		_tmp38_ = _ ("Eject");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp37_, _tmp38_);
	} else {
		GtkButton* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		_tmp39_ = unmount_button;
		_tmp40_ = _ ("Unmount");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp39_, _tmp40_);
	}
	_tmp41_ = ((ListItem*) self)->name_button;
	_tmp42_ = _ ("Open \"%s\"");
	_tmp43_ = _data3_->mount;
	_tmp44_ = g_mount_get_name (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf (_tmp42_, _tmp45_);
	_tmp47_ = _tmp46_;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp41_, _tmp47_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_tmp48_ = ((ListItem*) self)->name_button;
	g_signal_connect_data (_tmp48_, "clicked", (GCallback) ___lambda16__gtk_tool_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (unmount_button);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}


MountItem* mount_item_new (GMount* mount, const gchar* class) {
	return mount_item_construct (TYPE_MOUNT_ITEM, mount, class);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		MountItem* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->mount);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ___lambda14_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	MountItem* self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		GMount* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data4_->mount;
		_tmp1_ = res;
		g_mount_eject_with_operation_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_signal_emit_by_name (self, "send-message", _tmp3_, GTK_MESSAGE_ERROR);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("MountItem.vala:78: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda14_ (self, source_object, res);
	block4_data_unref (self);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void ___lambda15_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	MountItem* self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		GMount* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data4_->mount;
		_tmp1_ = res;
		g_mount_unmount_with_operation_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_signal_emit_by_name (self, "send-message", _tmp3_, GTK_MESSAGE_ERROR);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("MountItem.vala:90: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda15_ (self, source_object, res);
	block4_data_unref (self);
}


static void mount_item_do_unmount (MountItem* self, GMount* mount) {
	Block4Data* _data4_;
	GMount* _tmp0_ = NULL;
	GMount* _tmp1_ = NULL;
	GMountOperation* operation = NULL;
	GMountOperation* _tmp2_ = NULL;
	GMountOperation* _tmp3_ = NULL;
	GMount* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = mount;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->mount);
	_data4_->mount = _tmp1_;
	_tmp2_ = g_mount_operation_new ();
	operation = _tmp2_;
	_tmp3_ = operation;
	g_mount_operation_set_password_save (_tmp3_, G_PASSWORD_SAVE_FOR_SESSION);
	_tmp4_ = _data4_->mount;
	_tmp5_ = g_mount_can_eject (_tmp4_);
	if (_tmp5_) {
		GMount* _tmp6_ = NULL;
		GMountOperation* _tmp7_ = NULL;
		gchar* safe_remove = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* device_name = NULL;
		GMount* _tmp10_ = NULL;
		GDrive* _tmp11_ = NULL;
		GDrive* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp6_ = _data4_->mount;
		_tmp7_ = operation;
		g_mount_eject_with_operation (_tmp6_, G_MOUNT_UNMOUNT_NONE, _tmp7_, NULL, ____lambda14__gasync_ready_callback, block4_data_ref (_data4_));
		_tmp8_ = _ ("You can now safely remove");
		_tmp9_ = g_strdup (_tmp8_);
		safe_remove = _tmp9_;
		_tmp10_ = _data4_->mount;
		_tmp11_ = g_mount_get_drive (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_drive_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		device_name = _tmp14_;
		_tmp15_ = safe_remove;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = device_name;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat (_tmp16_, " \"", _tmp18_, "\"", NULL);
		_tmp20_ = _tmp19_;
		g_signal_emit_by_name (self, "send-message", _tmp20_, GTK_MESSAGE_INFO);
		_g_free0 (_tmp20_);
		_g_free0 (device_name);
		_g_free0 (safe_remove);
	} else {
		GMount* _tmp21_ = NULL;
		GMountOperation* _tmp22_ = NULL;
		_tmp21_ = _data4_->mount;
		_tmp22_ = operation;
		g_mount_unmount_with_operation (_tmp21_, G_MOUNT_UNMOUNT_NONE, _tmp22_, NULL, ____lambda15__gasync_ready_callback, block4_data_ref (_data4_));
	}
	_g_object_unref0 (operation);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_ENUM) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_enum (param_values + 2), data2);
}


static void mount_item_class_init (MountItemClass * klass) {
	mount_item_parent_class = g_type_class_peek_parent (klass);
	g_signal_new ("send_message", TYPE_MOUNT_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_ENUM, G_TYPE_NONE, 2, G_TYPE_STRING, GTK_TYPE_MESSAGE_TYPE);
}


static void mount_item_instance_init (MountItem * self) {
}


GType mount_item_get_type (void) {
	return mount_item_type_id;
}


GType mount_item_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (MountItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountItem), 0, (GInstanceInitFunc) mount_item_instance_init, NULL };
	mount_item_type_id = g_type_module_register_type (module, TYPE_LIST_ITEM, "MountItem", &g_define_type_info, 0);
	return mount_item_type_id;
}



