/* panel.c generated by valac 0.32.1, the Vala compiler
 * generated from panel.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <BudgieToplevel.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define BUDGIE_TYPE_MAIN_PANEL (budgie_main_panel_get_type ())
#define BUDGIE_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanel))
#define BUDGIE_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanelClass))
#define BUDGIE_IS_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_MAIN_PANEL))
#define BUDGIE_IS_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_MAIN_PANEL))
#define BUDGIE_MAIN_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanelClass))

typedef struct _BudgieMainPanel BudgieMainPanel;
typedef struct _BudgieMainPanelClass BudgieMainPanelClass;
typedef struct _BudgieMainPanelPrivate BudgieMainPanelPrivate;

#define BUDGIE_TYPE_PANEL (budgie_panel_get_type ())
#define BUDGIE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL, BudgiePanel))
#define BUDGIE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL, BudgiePanelClass))
#define BUDGIE_IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL))
#define BUDGIE_IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL))
#define BUDGIE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL, BudgiePanelClass))

typedef struct _BudgiePanel BudgiePanel;
typedef struct _BudgiePanelClass BudgiePanelClass;
typedef struct _BudgiePanelPrivate BudgiePanelPrivate;

#define BUDGIE_TYPE_PANEL_MANAGER (budgie_panel_manager_get_type ())
#define BUDGIE_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManager))
#define BUDGIE_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))
#define BUDGIE_IS_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_IS_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_PANEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))

typedef struct _BudgiePanelManager BudgiePanelManager;
typedef struct _BudgiePanelManagerClass BudgiePanelManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define BUDGIE_TYPE_POPOVER_MANAGER_IMPL (budgie_popover_manager_impl_get_type ())
#define BUDGIE_POPOVER_MANAGER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_POPOVER_MANAGER_IMPL, BudgiePopoverManagerImpl))
#define BUDGIE_POPOVER_MANAGER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_POPOVER_MANAGER_IMPL, BudgiePopoverManagerImplClass))
#define BUDGIE_IS_POPOVER_MANAGER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_POPOVER_MANAGER_IMPL))
#define BUDGIE_IS_POPOVER_MANAGER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_POPOVER_MANAGER_IMPL))
#define BUDGIE_POPOVER_MANAGER_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_POPOVER_MANAGER_IMPL, BudgiePopoverManagerImplClass))

typedef struct _BudgiePopoverManagerImpl BudgiePopoverManagerImpl;
typedef struct _BudgiePopoverManagerImplClass BudgiePopoverManagerImplClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define UUID_TYPE_UUID_FLAGS (uuid_uuid_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _BudgieMainPanel {
	GtkBox parent_instance;
	BudgieMainPanelPrivate * priv;
};

struct _BudgieMainPanelClass {
	GtkBoxClass parent_class;
};

struct _BudgieMainPanelPrivate {
	gint _intended_size;
};

struct _BudgiePanel {
	BudgieToplevel parent_instance;
	BudgiePanelPrivate * priv;
};

struct _BudgiePanelClass {
	BudgieToplevelClass parent_class;
};

struct _BudgiePanelPrivate {
	GdkRectangle scr;
	GdkRectangle small_scr;
	GdkRectangle orig_scr;
	GtkBox* layout;
	GtkBox* main_layout;
	GSettings* _settings;
	BudgiePanelManager* manager;
	BudgiePopoverManager* popover_manager;
	gboolean expanded;
	BudgieShadowBlock* shadow;
	GHashTable* pending;
	GHashTable* creating;
	GHashTable* applets;
	GHashTable* initial_config;
	GList* expected_uuids;
	GRecMutex __lock_expected_uuids;
	gint scale;
	GtkBox* start_box;
	GtkBox* center_box;
	GtkBox* end_box;
	gint* icon_sizes;
	gint icon_sizes_length1;
	gint _icon_sizes_size_;
	gint current_icon_size;
	gint current_small_icon_size;
	gboolean is_fully_loaded;
	gboolean need_migratory;
	GRecMutex __lock_need_migratory;
	gdouble render_scale;
	gboolean initial_anim;
};

struct _Block1Data {
	int _ref_count_;
	BudgiePanel* self;
	BudgieAppletInfo* info;
	BudgiePanelAction action;
};

typedef enum  {
	UUID_UUID_FLAGS_LOWER_CASE = 1 << 0,
	UUID_UUID_FLAGS_UPPER_CASE = 1 << 1,
	UUID_UUID_FLAGS_DEFAULT_CASE = 1 << 2,
	UUID_UUID_FLAGS_RANDOM_TYPE = 1 << 3,
	UUID_UUID_FLAGS_DEFAULT_TYPE = 1 << 4,
	UUID_UUID_FLAGS_TIME_TYPE = 1 << 5,
	UUID_UUID_FLAGS_TIME_SAFE_TYPE = 1 << 6
} LibUUIDUUIDFlags;


static gpointer budgie_main_panel_parent_class = NULL;
static gpointer budgie_panel_parent_class = NULL;

GType budgie_main_panel_get_type (void) G_GNUC_CONST;
#define BUDGIE_MAIN_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanelPrivate))
enum  {
	BUDGIE_MAIN_PANEL_DUMMY_PROPERTY,
	BUDGIE_MAIN_PANEL_INTENDED_SIZE
};
BudgieMainPanel* budgie_main_panel_new (gint size);
BudgieMainPanel* budgie_main_panel_construct (GType object_type, gint size);
void budgie_main_panel_set_intended_size (BudgieMainPanel* self, gint value);
static void budgie_main_panel_real_get_preferred_height (GtkWidget* base, gint* m, gint* n);
gint budgie_main_panel_get_intended_size (BudgieMainPanel* self);
static void budgie_main_panel_real_get_preferred_height_for_width (GtkWidget* base, gint w, gint* m, gint* n);
static void budgie_main_panel_finalize (GObject* obj);
static void _vala_budgie_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType budgie_panel_get_type (void) G_GNUC_CONST;
GType budgie_panel_manager_get_type (void) G_GNUC_CONST;
#define BUDGIE_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_PANEL, BudgiePanelPrivate))
enum  {
	BUDGIE_PANEL_DUMMY_PROPERTY,
	BUDGIE_PANEL_SETTINGS,
	BUDGIE_PANEL_NSCALE
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
gboolean budgie_panel_activate_action (BudgiePanel* self, gint remote_action);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block1Data* _data1_);
static gboolean _____lambda4__gsource_func (gpointer self);
void budgie_panel_update_geometry (BudgiePanel* self, GdkRectangle* screen, BudgiePanelPosition position, gint size);
GSettings* budgie_panel_get_settings (BudgiePanel* self);
#define BUDGIE_PANEL_KEY_SIZE "size"
#define BUDGIE_PANEL_KEY_POSITION "location"
static void budgie_panel_placement (BudgiePanel* self);
static void budgie_panel_update_sizes (BudgiePanel* self);
static void budgie_panel_real_reset_shadow (BudgieToplevel* base);
static GList* budgie_panel_real_get_applets (BudgieToplevel* base);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void budgie_panel_initial_applet_placement (BudgiePanel* self, gboolean repar, gboolean repos);
static void budgie_panel_applet_reparent (BudgiePanel* self, BudgieAppletInfo* info);
static void budgie_panel_applet_reposition (BudgiePanel* self, BudgieAppletInfo* info);
static void budgie_panel_on_fully_loaded (BudgiePanel* self);
static gboolean budgie_panel_initial_animation (BudgiePanel* self);
static gboolean _budgie_panel_initial_animation_gsource_func (gpointer self);
static gboolean budgie_panel_add_migratory (BudgiePanel* self);
static gboolean _budgie_panel_add_migratory_gsource_func (gpointer self);
static gdouble _budgie_sine_ease_out_budgie_tween_func (gdouble factor, gpointer self);
static void _vala_BudgiePropChange_array_free (BudgiePropChange* array, gint array_length);
static void __lambda5_ (BudgiePanel* self, BudgieAnimation* a);
gdouble budgie_panel_get_nscale (BudgiePanel* self);
static void ___lambda5__budgie_anim_completion_func (BudgieAnimation* src, gpointer self);
BudgiePanel* budgie_panel_new (BudgiePanelManager* manager, const gchar* uuid, GSettings* settings);
BudgiePanel* budgie_panel_construct (GType object_type, BudgiePanelManager* manager, const gchar* uuid, GSettings* settings);
void budgie_panel_set_nscale (BudgiePanel* self, gdouble value);
BudgiePopoverManagerImpl* budgie_popover_manager_impl_new (BudgiePanel* owner);
BudgiePopoverManagerImpl* budgie_popover_manager_impl_construct (GType object_type, BudgiePanel* owner);
GType budgie_popover_manager_impl_get_type (void) G_GNUC_CONST;
static void _g_hash_table_unref0_ (gpointer var);
static void _budgie_panel_on_fully_loaded_budgie_panel_panel_loaded (BudgiePanel* _sender, gpointer self);
#define BUDGIE_PANEL_KEY_SHADOW "enable-shadow"
#define BUDGIE_PANEL_KEY_REGIONS "theme-regions"
static void budgie_panel_update_theme_regions (BudgiePanel* self);
static void _budgie_panel_update_theme_regions_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void budgie_panel_set_expanded (BudgiePanel* self, gboolean expanded);
static void budgie_panel_on_extension_loaded (BudgiePanel* self, const gchar* name);
static void _budgie_panel_on_extension_loaded_budgie_panel_manager_extension_loaded (BudgiePanelManager* _sender, const gchar* name, gpointer self);
static void budgie_panel_load_applets (BudgiePanel* self);
void budgie_panel_destroy_children (BudgiePanel* self);
BudgieAppletInfo* budgie_panel_manager_load_applet_instance (BudgiePanelManager* self, const gchar* uuid, gchar** name, GSettings* psettings);
static void budgie_panel_add_applet (BudgiePanel* self, BudgieAppletInfo* info);
BudgieAppletInfo* budgie_panel_manager_create_new_applet (BudgiePanelManager* self, const gchar* name, const gchar* uuid);
#define BUDGIE_PANEL_KEY_APPLETS "applets"
static void budgie_panel_add_pending (BudgiePanel* self, const gchar* uuid, const gchar* plugin_name);
void budgie_panel_manager_modprobe (BudgiePanelManager* self, const gchar* name);
static void budgie_panel_add_new_applet_at (BudgiePanel* self, const gchar* id, GtkBox* target_region);
GType uuid_uuid_flags_get_type (void) G_GNUC_CONST;
gchar* uuid_new (LibUUIDUUIDFlags flags);
static void budgie_panel_add_new (BudgiePanel* self, const gchar* plugin_name, const gchar* initial_uuid);
static void budgie_panel_real_add_new_applet (BudgieToplevel* base, const gchar* id);
void budgie_panel_create_default_layout (BudgiePanel* self, const gchar* name, GKeyFile* config);
static void budgie_panel_set_applets (BudgiePanel* self);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void budgie_panel_real_remove_applet (BudgieToplevel* base, BudgieAppletInfo* info);
static void budgie_panel_budge_em_left (BudgiePanel* self, const gchar* alignment, gint after);
static void budgie_panel_applet_updated (BudgiePanel* self, GObject* o, GParamSpec* p);
static void _budgie_panel_applet_updated_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean budgie_panel_manager_is_extension_valid (BudgiePanelManager* self, const gchar* name);
gboolean budgie_panel_manager_is_extension_loaded (BudgiePanelManager* self, const gchar* name);
static void budgie_panel_real_map (GtkWidget* base);
static void budgie_panel_real_get_preferred_width (GtkWidget* base, gint* m, gint* n);
static void budgie_panel_real_get_preferred_width_for_height (GtkWidget* base, gint h, gint* m, gint* n);
static void budgie_panel_real_get_preferred_height (GtkWidget* base, gint* m, gint* n);
static void budgie_panel_real_get_preferred_height_for_width (GtkWidget* base, gint w, gint* m, gint* n);
static gboolean ___lambda8_ (BudgiePanel* self);
static gboolean ____lambda8__gsource_func (gpointer self);
static gboolean budgie_panel_applet_at_start_of_region (BudgiePanel* self, BudgieAppletInfo* info);
static gboolean budgie_panel_applet_at_end_of_region (BudgiePanel* self, BudgieAppletInfo* info);
static gchar* budgie_panel_get_box_left (BudgiePanel* self, BudgieAppletInfo* info);
static gchar* budgie_panel_get_box_right (BudgiePanel* self, BudgieAppletInfo* info);
static gboolean budgie_panel_real_can_move_applet_left (BudgieToplevel* base, BudgieAppletInfo* info);
static gboolean budgie_panel_real_can_move_applet_right (BudgieToplevel* base, BudgieAppletInfo* info);
static void budgie_panel_conflict_swap (BudgiePanel* self, BudgieAppletInfo* info, gint old_position);
static void budgie_panel_budge_em_right (BudgiePanel* self, const gchar* alignment);
static void budgie_panel_real_move_applet_left (BudgieToplevel* base, BudgieAppletInfo* info);
static void budgie_panel_real_move_applet_right (BudgieToplevel* base, BudgieAppletInfo* info);
static gboolean budgie_panel_real_draw (GtkWidget* base, cairo_t* cr);
void budgie_panel_perform_migration (BudgiePanel* self, gint current_migration_level);
#define BUDGIE_BUDGIE_MIGRATION_LEVEL 1
void budgie_panel_set_settings (BudgiePanel* self, GSettings* value);
static GObject * budgie_panel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void budgie_panel_finalize (GObject* obj);
static void _vala_budgie_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gchar* BUDGIE_MIGRATION_1_APPLETS[2];

BudgieMainPanel* budgie_main_panel_construct (GType object_type, gint size) {
	BudgieMainPanel * self = NULL;
	gint _tmp0_ = 0;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	self = (BudgieMainPanel*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, NULL);
	_tmp0_ = size;
	budgie_main_panel_set_intended_size (self, _tmp0_);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "budgie-panel");
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_BACKGROUND);
	return self;
}


BudgieMainPanel* budgie_main_panel_new (gint size) {
	return budgie_main_panel_construct (BUDGIE_TYPE_MAIN_PANEL, size);
}


static void budgie_main_panel_real_get_preferred_height (GtkWidget* base, gint* m, gint* n) {
	BudgieMainPanel * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (BudgieMainPanel*) base;
	_tmp0_ = self->priv->_intended_size;
	_vala_m = _tmp0_ - 5;
	_tmp1_ = self->priv->_intended_size;
	_vala_n = _tmp1_ - 5;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}


static void budgie_main_panel_real_get_preferred_height_for_width (GtkWidget* base, gint w, gint* m, gint* n) {
	BudgieMainPanel * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (BudgieMainPanel*) base;
	_tmp0_ = self->priv->_intended_size;
	_vala_m = _tmp0_ - 5;
	_tmp1_ = self->priv->_intended_size;
	_vala_n = _tmp1_ - 5;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}


gint budgie_main_panel_get_intended_size (BudgieMainPanel* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_intended_size;
	result = _tmp0_;
	return result;
}


void budgie_main_panel_set_intended_size (BudgieMainPanel* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_intended_size = _tmp0_;
	g_object_notify ((GObject *) self, "intended-size");
}


static void budgie_main_panel_class_init (BudgieMainPanelClass * klass) {
	budgie_main_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieMainPanelPrivate));
	((GtkWidgetClass *) klass)->get_preferred_height = budgie_main_panel_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = budgie_main_panel_real_get_preferred_height_for_width;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_main_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_main_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_main_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_MAIN_PANEL_INTENDED_SIZE, g_param_spec_int ("intended-size", "intended-size", "intended-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void budgie_main_panel_instance_init (BudgieMainPanel * self) {
	self->priv = BUDGIE_MAIN_PANEL_GET_PRIVATE (self);
}


static void budgie_main_panel_finalize (GObject* obj) {
	BudgieMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanel);
	G_OBJECT_CLASS (budgie_main_panel_parent_class)->finalize (obj);
}


/**
 * The main panel area - i.e. the bit that's rendered
 */
GType budgie_main_panel_get_type (void) {
	static volatile gsize budgie_main_panel_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_main_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieMainPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_main_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMainPanel), 0, (GInstanceInitFunc) budgie_main_panel_instance_init, NULL };
		GType budgie_main_panel_type_id;
		budgie_main_panel_type_id = g_type_register_static (gtk_box_get_type (), "BudgieMainPanel", &g_define_type_info, 0);
		g_once_init_leave (&budgie_main_panel_type_id__volatile, budgie_main_panel_type_id);
	}
	return budgie_main_panel_type_id__volatile;
}


static void _vala_budgie_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanel);
	switch (property_id) {
		case BUDGIE_MAIN_PANEL_INTENDED_SIZE:
		g_value_set_int (value, budgie_main_panel_get_intended_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_MAIN_PANEL, BudgieMainPanel);
	switch (property_id) {
		case BUDGIE_MAIN_PANEL_INTENDED_SIZE:
		budgie_main_panel_set_intended_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgiePanel* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ____lambda4_ (Block1Data* _data1_) {
	BudgiePanel* self;
	gboolean result = FALSE;
	BudgieAppletInfo* _tmp0_ = NULL;
	BudgieApplet* _tmp1_ = NULL;
	BudgieApplet* _tmp2_ = NULL;
	BudgieApplet* _tmp3_ = NULL;
	BudgiePanelAction _tmp4_ = 0;
	self = _data1_->self;
	_tmp0_ = _data1_->info;
	g_object_get (_tmp0_, "applet", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->action;
	budgie_applet_invoke_action (_tmp3_, _tmp4_);
	_g_object_unref0 (_tmp3_);
	result = FALSE;
	return result;
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}


gboolean budgie_panel_activate_action (BudgiePanel* self, gint remote_action) {
	gboolean result = FALSE;
	Block1Data* _data1_;
	const gchar* uuid = NULL;
	gint _tmp0_ = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	uuid = NULL;
	_data1_->info = NULL;
	_tmp0_ = remote_action;
	_data1_->action = (BudgiePanelAction) _tmp0_;
	_tmp1_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		BudgieAppletInfo* _tmp5_ = NULL;
		BudgieApplet* _tmp6_ = NULL;
		BudgieApplet* _tmp7_ = NULL;
		BudgieApplet* _tmp8_ = NULL;
		BudgiePanelAction _tmp9_ = 0;
		BudgiePanelAction _tmp10_ = 0;
		BudgiePanelAction _tmp11_ = 0;
		gboolean _tmp12_ = FALSE;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		uuid = _tmp2_;
		_data1_->info = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = _data1_->info;
		g_object_get (_tmp5_, "applet", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		g_object_get (_tmp8_, "supported-actions", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = _data1_->action;
		_tmp12_ = (_tmp10_ & _tmp11_) != 0;
		_g_object_unref0 (_tmp8_);
		if (_tmp12_) {
			gtk_window_present ((GtkWindow*) self);
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
			result = TRUE;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
	}
	result = FALSE;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


/**
     * Force update the geometry
     */
void budgie_panel_update_geometry (BudgiePanel* self, GdkRectangle* screen, BudgiePanelPosition position, gint size) {
	GdkRectangle small = {0};
	GdkRectangle _tmp0_ = {0};
	gchar* old_class = NULL;
	BudgiePanelPosition _tmp1_ = 0;
	BudgiePanelPosition _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp7_ = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GtkStyleContext* _tmp13_ = NULL;
	BudgiePanelPosition _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	BudgiePanelPosition _tmp17_ = 0;
	BudgiePanelPosition _tmp22_ = 0;
	BudgiePanelPosition _tmp23_ = 0;
	BudgiePanelPosition _tmp24_ = 0;
	BudgiePanelPosition _tmp27_ = 0;
	GdkRectangle _tmp28_ = {0};
	GdkRectangle _tmp29_ = {0};
	gboolean _tmp30_ = FALSE;
	BudgieShadowBlock* _tmp33_ = NULL;
	GdkRectangle _tmp34_ = {0};
	gint _tmp35_ = 0;
	BudgieShadowBlock* _tmp36_ = NULL;
	BudgiePanelPosition _tmp37_ = 0;
	GtkBox* _tmp38_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = *screen;
	small = _tmp0_;
	_tmp1_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_position_class_name (_tmp2_);
	old_class = _tmp3_;
	_tmp4_ = old_class;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		GtkStyleContext* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp6_ = old_class;
		gtk_style_context_remove_class (_tmp5_, _tmp6_);
	}
	_tmp7_ = size;
	if (_tmp7_ == 0) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
		_tmp9_ = _tmp8_;
		size = _tmp9_;
	}
	_tmp10_ = self->priv->_settings;
	_tmp11_ = size;
	g_settings_set_int (_tmp10_, BUDGIE_PANEL_KEY_SIZE, _tmp11_);
	_tmp12_ = size;
	budgie_toplevel_set_intended_size ((BudgieToplevel*) self, _tmp12_);
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp14_ = position;
	_tmp15_ = budgie_position_class_name (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_style_context_add_class (_tmp13_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = position;
	switch (_tmp17_) {
		case BUDGIE_PANEL_POSITION_TOP:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp18_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
			_tmp19_ = _tmp18_;
			small.height = _tmp19_;
			break;
		}
		default:
		{
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			_tmp20_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
			_tmp21_ = _tmp20_;
			small.width = _tmp21_;
			break;
		}
	}
	_tmp22_ = position;
	_tmp23_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp24_ = _tmp23_;
	if (_tmp22_ != _tmp24_) {
		GSettings* _tmp25_ = NULL;
		BudgiePanelPosition _tmp26_ = 0;
		_tmp25_ = self->priv->_settings;
		_tmp26_ = position;
		g_settings_set_enum (_tmp25_, BUDGIE_PANEL_KEY_POSITION, (gint) _tmp26_);
	}
	_tmp27_ = position;
	budgie_toplevel_set_position ((BudgieToplevel*) self, _tmp27_);
	_tmp28_ = small;
	self->priv->small_scr = _tmp28_;
	_tmp29_ = *screen;
	self->priv->orig_scr = _tmp29_;
	_tmp30_ = self->priv->expanded;
	if (_tmp30_) {
		GdkRectangle _tmp31_ = {0};
		_tmp31_ = self->priv->orig_scr;
		self->priv->scr = _tmp31_;
	} else {
		GdkRectangle _tmp32_ = {0};
		_tmp32_ = self->priv->small_scr;
		self->priv->scr = _tmp32_;
	}
	_tmp33_ = self->priv->shadow;
	_tmp34_ = self->priv->orig_scr;
	_tmp35_ = _tmp34_.width;
	budgie_shadow_block_set_required_size (_tmp33_, _tmp35_);
	_tmp36_ = self->priv->shadow;
	_tmp37_ = position;
	budgie_shadow_block_set_position (_tmp36_, _tmp37_);
	_tmp38_ = self->priv->layout;
	gtk_widget_queue_resize ((GtkWidget*) _tmp38_);
	gtk_widget_queue_resize ((GtkWidget*) self);
	budgie_panel_placement (self);
	budgie_panel_update_sizes (self);
	_g_free0 (old_class);
}


static void budgie_panel_real_reset_shadow (BudgieToplevel* base) {
	BudgiePanel * self;
	BudgieShadowBlock* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	gint _tmp2_ = 0;
	BudgieShadowBlock* _tmp3_ = NULL;
	self = (BudgiePanel*) base;
	_tmp0_ = self->priv->shadow;
	_tmp1_ = self->priv->orig_scr;
	_tmp2_ = _tmp1_.width;
	budgie_shadow_block_set_required_size (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->shadow;
	budgie_shadow_block_set_removal (_tmp3_, 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GList* budgie_panel_real_get_applets (BudgieToplevel* base) {
	BudgiePanel * self;
	GList* result = NULL;
	GList* ret = NULL;
	const gchar* key = NULL;
	BudgieAppletInfo* appl_info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	self = (BudgiePanel*) base;
	ret = NULL;
	key = NULL;
	appl_info = NULL;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		BudgieAppletInfo* _tmp4_ = NULL;
		BudgieAppletInfo* _tmp5_ = NULL;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		appl_info = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = appl_info;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		ret = g_list_append (ret, _tmp5_);
	}
	result = ret;
	return result;
}


/**
     * Loop the applets, performing a reparent or reposition
     */
static void budgie_panel_initial_applet_placement (BudgiePanel* self, gboolean repar, gboolean repos) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* uuid = NULL;
	BudgieAppletInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = repar;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = repos;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	uuid = NULL;
	info = NULL;
	_tmp3_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp3_);
	while (TRUE) {
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
		uuid = _tmp4_;
		info = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = repar;
		if (_tmp7_) {
			BudgieAppletInfo* _tmp8_ = NULL;
			_tmp8_ = info;
			budgie_panel_applet_reparent (self, _tmp8_);
		}
		_tmp9_ = repos;
		if (_tmp9_) {
			BudgieAppletInfo* _tmp10_ = NULL;
			_tmp10_ = info;
			budgie_panel_applet_reposition (self, _tmp10_);
		}
	}
}


static gboolean _budgie_panel_initial_animation_gsource_func (gpointer self) {
	gboolean result;
	result = budgie_panel_initial_animation ((BudgiePanel*) self);
	return result;
}


static gboolean _budgie_panel_add_migratory_gsource_func (gpointer self) {
	gboolean result;
	result = budgie_panel_add_migratory ((BudgiePanel*) self);
	return result;
}


static void budgie_panel_on_fully_loaded (BudgiePanel* self) {
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	_tmp1_ = g_hash_table_size (_tmp0_);
	if (_tmp1_ < ((guint) 1)) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->initial_anim;
		if (!_tmp2_) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _budgie_panel_initial_animation_gsource_func, g_object_ref (self), g_object_unref);
		}
		return;
	}
	budgie_panel_initial_applet_placement (self, TRUE, FALSE);
	budgie_panel_initial_applet_placement (self, FALSE, TRUE);
	g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
	_tmp3_ = self->priv->initial_anim;
	if (!_tmp3_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _budgie_panel_initial_animation_gsource_func, g_object_ref (self), g_object_unref);
	}
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->need_migratory;
		g_rec_mutex_lock (&self->priv->__lock_need_migratory);
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = self->priv->need_migratory;
			if (!_tmp5_) {
				{
					gboolean _tmp6_ = FALSE;
					_tmp6_ = self->priv->need_migratory;
					g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
				}
				return;
			}
		}
		__finally9:
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = self->priv->need_migratory;
			g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _budgie_panel_add_migratory_gsource_func, g_object_ref (self), g_object_unref);
}


static gdouble _budgie_sine_ease_out_budgie_tween_func (gdouble factor, gpointer self) {
	gdouble result;
	result = budgie_sine_ease_out (factor);
	return result;
}


static void _vala_BudgiePropChange_array_free (BudgiePropChange* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			budgie_prop_change_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void __lambda5_ (BudgiePanel* self, BudgieAnimation* a) {
	BudgieAnimation* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	_tmp0_ = a;
	_tmp1_ = _tmp0_->widget;
	_tmp2_ = budgie_panel_get_nscale (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BUDGIE_TYPE_PANEL) ? ((BudgiePanel*) _tmp1_) : NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 1.0) {
		BudgieAnimation* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->widget;
		gtk_widget_hide (_tmp5_);
	} else {
		BudgieAnimation* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		_tmp6_ = a;
		_tmp7_ = _tmp6_->widget;
		gtk_widget_show ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp7_) : NULL));
	}
}


static void ___lambda5__budgie_anim_completion_func (BudgieAnimation* src, gpointer self) {
	__lambda5_ ((BudgiePanel*) self, src);
}


static gboolean budgie_panel_initial_animation (BudgiePanel* self) {
	gboolean result = FALSE;
	BudgieAnimation* anim = NULL;
	BudgieAnimation* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	BudgiePropChange _tmp4_ = {0};
	BudgiePropChange* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->initial_anim = TRUE;
	_tmp0_ = budgie_animation_new ();
	anim = _tmp0_;
	anim->widget = (GtkWidget*) self;
	anim->length = 512 * BUDGIE_MSECOND;
	anim->tween = _budgie_sine_ease_out_budgie_tween_func;
	anim->tween_target = NULL;
	_tmp1_ = g_strdup ("nscale");
	g_value_init (&_tmp2_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp2_, 1.0);
	g_value_init (&_tmp3_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp3_, 0.0);
	memset (&_tmp4_, 0, sizeof (BudgiePropChange));
	_g_free0 (_tmp4_.property);
	_tmp4_.property = _tmp1_;
	G_IS_VALUE (&_tmp4_.old) ? (g_value_unset (&_tmp4_.old), NULL) : NULL;
	_tmp4_.old = _tmp2_;
	G_IS_VALUE (&_tmp4_.new) ? (g_value_unset (&_tmp4_.new), NULL) : NULL;
	_tmp4_.new = _tmp3_;
	_tmp5_ = g_new0 (BudgiePropChange, 1);
	_tmp5_[0] = _tmp4_;
	anim->changes = (_vala_BudgiePropChange_array_free (anim->changes, anim->changes_length1), NULL);
	anim->changes = _tmp5_;
	anim->changes_length1 = 1;
	budgie_animation_start (anim, ___lambda5__budgie_anim_completion_func, self);
	result = FALSE;
	_g_object_unref0 (anim);
	return result;
}


static void _g_hash_table_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}


static void _budgie_panel_on_fully_loaded_budgie_panel_panel_loaded (BudgiePanel* _sender, gpointer self) {
	budgie_panel_on_fully_loaded ((BudgiePanel*) self);
}


static void _budgie_panel_update_theme_regions_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	budgie_panel_update_theme_regions ((BudgiePanel*) self);
}


static void _budgie_panel_on_extension_loaded_budgie_panel_manager_extension_loaded (BudgiePanelManager* _sender, const gchar* name, gpointer self) {
	budgie_panel_on_extension_loaded ((BudgiePanel*) self, name);
}


BudgiePanel* budgie_panel_construct (GType object_type, BudgiePanelManager* manager, const gchar* uuid, GSettings* settings) {
	BudgiePanel * self = NULL;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	BudgiePanelManager* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	BudgiePopoverManagerImpl* _tmp9_ = NULL;
	GHashFunc _tmp10_ = NULL;
	GEqualFunc _tmp11_ = NULL;
	GHashTable* _tmp12_ = NULL;
	GHashFunc _tmp13_ = NULL;
	GEqualFunc _tmp14_ = NULL;
	GHashTable* _tmp15_ = NULL;
	GHashFunc _tmp16_ = NULL;
	GEqualFunc _tmp17_ = NULL;
	GHashTable* _tmp18_ = NULL;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp19_ = NULL;
	GdkScreen* _tmp20_ = NULL;
	GdkVisual* _tmp21_ = NULL;
	GdkVisual* _tmp22_ = NULL;
	GdkVisual* _tmp23_ = NULL;
	GtkStyleContext* _tmp25_ = NULL;
	GtkBox* _tmp26_ = NULL;
	GtkBox* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	BudgieMainPanel* _tmp30_ = NULL;
	GtkBox* _tmp31_ = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBox* _tmp33_ = NULL;
	GtkBox* _tmp34_ = NULL;
	BudgiePanelPosition _tmp35_ = 0;
	BudgiePanelPosition _tmp36_ = 0;
	BudgieShadowBlock* _tmp37_ = NULL;
	BudgieShadowBlock* _tmp38_ = NULL;
	BudgieShadowBlock* _tmp39_ = NULL;
	BudgieShadowBlock* _tmp40_ = NULL;
	BudgieShadowBlock* _tmp41_ = NULL;
	GtkBox* _tmp42_ = NULL;
	BudgieShadowBlock* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	BudgieShadowBlock* _tmp45_ = NULL;
	GSettings* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	GSettings* _tmp48_ = NULL;
	BudgieShadowBlock* _tmp49_ = NULL;
	GtkBox* _tmp50_ = NULL;
	GtkBox* _tmp51_ = NULL;
	GtkBox* _tmp52_ = NULL;
	GtkBox* _tmp53_ = NULL;
	GtkBox* _tmp54_ = NULL;
	GtkBox* _tmp55_ = NULL;
	GtkBox* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBox* _tmp58_ = NULL;
	GtkBox* _tmp59_ = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkBox* _tmp61_ = NULL;
	GSettings* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	GSettings* _tmp64_ = NULL;
	GtkWidget* _tmp65_ = NULL;
	BudgiePanelManager* _tmp66_ = NULL;
	_tmp0_ = settings;
	_tmp1_ = uuid;
	self = (BudgiePanel*) g_object_new (object_type, "type-hint", GDK_WINDOW_TYPE_HINT_DOCK, "window-position", GTK_WIN_POS_NONE, "settings", _tmp0_, "uuid", _tmp1_, NULL);
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->initial_config);
	self->priv->initial_config = _tmp4_;
	_tmp5_ = settings;
	_tmp6_ = g_settings_get_int (_tmp5_, BUDGIE_PANEL_KEY_SIZE);
	budgie_toplevel_set_intended_size ((BudgieToplevel*) self, _tmp6_);
	_tmp7_ = manager;
	self->priv->manager = _tmp7_;
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	_tmp8_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	self->priv->scale = _tmp8_;
	budgie_panel_set_nscale (self, 1.0);
	_tmp9_ = budgie_popover_manager_impl_new (self);
	_g_object_unref0 (self->priv->popover_manager);
	self->priv->popover_manager = (BudgiePopoverManager*) _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->pending);
	self->priv->pending = _tmp12_;
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->creating);
	self->priv->creating = _tmp15_;
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->applets);
	self->priv->applets = _tmp18_;
	__g_list_free__g_free0_0 (self->priv->expected_uuids);
	self->priv->expected_uuids = NULL;
	g_signal_connect_object (self, "panel-loaded", (GCallback) _budgie_panel_on_fully_loaded_budgie_panel_panel_loaded, self, 0);
	_tmp19_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = gdk_screen_get_rgba_visual (_tmp20_);
	_tmp22_ = _g_object_ref0 (_tmp21_);
	vis = _tmp22_;
	_tmp23_ = vis;
	if (_tmp23_ == NULL) {
		g_warning ("panel.vala:306: Compositing not available, things will Look Bad (TM)");
	} else {
		GdkVisual* _tmp24_ = NULL;
		_tmp24_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp24_);
	}
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp25_, "budgie-container");
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->main_layout);
	self->priv->main_layout = _tmp26_;
	_tmp27_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp27_);
	_tmp28_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = budgie_main_panel_new (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = (GtkBox*) _tmp30_;
	_tmp31_ = self->priv->layout;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp31_, FALSE);
	gtk_widget_set_vexpand ((GtkWidget*) self, FALSE);
	_tmp32_ = self->priv->main_layout;
	_tmp33_ = self->priv->layout;
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, FALSE, FALSE, (guint) 0);
	_tmp34_ = self->priv->main_layout;
	gtk_widget_set_valign ((GtkWidget*) _tmp34_, GTK_ALIGN_START);
	_tmp35_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp36_ = _tmp35_;
	_tmp37_ = budgie_shadow_block_new (_tmp36_);
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->shadow);
	self->priv->shadow = _tmp37_;
	_tmp38_ = self->priv->shadow;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp38_, TRUE);
	_tmp39_ = self->priv->shadow;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp39_, FALSE);
	_tmp40_ = self->priv->shadow;
	gtk_widget_set_halign ((GtkWidget*) _tmp40_, GTK_ALIGN_START);
	_tmp41_ = self->priv->shadow;
	gtk_widget_show_all ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->main_layout;
	_tmp43_ = self->priv->shadow;
	gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 0);
	_tmp44_ = self->priv->_settings;
	_tmp45_ = self->priv->shadow;
	g_settings_bind (_tmp44_, BUDGIE_PANEL_KEY_SHADOW, (GObject*) _tmp45_, "visible", G_SETTINGS_BIND_GET);
	_tmp46_ = self->priv->_settings;
	_tmp47_ = g_settings_get_boolean (_tmp46_, BUDGIE_PANEL_KEY_SHADOW);
	budgie_toplevel_set_shadow_visible ((BudgieToplevel*) self, _tmp47_);
	_tmp48_ = self->priv->_settings;
	g_settings_bind (_tmp48_, BUDGIE_PANEL_KEY_SHADOW, (GObject*) self, "shadow-visible", G_SETTINGS_BIND_DEFAULT);
	_tmp49_ = self->priv->shadow;
	g_object_bind_property_with_closures ((GObject*) self, "shadow-width", (GObject*) _tmp49_, "removal", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp50_ = self->priv->layout;
	g_object_bind_property_with_closures ((GObject*) self, "intended-size", (GObject*) _tmp50_, "intended-size", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp51_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (self->priv->start_box);
	self->priv->start_box = _tmp51_;
	_tmp52_ = self->priv->start_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp52_, GTK_ALIGN_START);
	_tmp53_ = self->priv->layout;
	_tmp54_ = self->priv->start_box;
	gtk_box_pack_start (_tmp53_, (GtkWidget*) _tmp54_, TRUE, TRUE, (guint) 0);
	_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->center_box);
	self->priv->center_box = _tmp55_;
	_tmp56_ = self->priv->layout;
	_tmp57_ = self->priv->center_box;
	gtk_box_set_center_widget (_tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->end_box);
	self->priv->end_box = _tmp58_;
	_tmp59_ = self->priv->layout;
	_tmp60_ = self->priv->end_box;
	gtk_box_pack_end (_tmp59_, (GtkWidget*) _tmp60_, TRUE, TRUE, (guint) 0);
	_tmp61_ = self->priv->end_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp61_, GTK_ALIGN_END);
	_tmp62_ = self->priv->_settings;
	_tmp63_ = g_settings_get_boolean (_tmp62_, BUDGIE_PANEL_KEY_REGIONS);
	budgie_toplevel_set_theme_regions ((BudgieToplevel*) self, _tmp63_);
	g_signal_connect_object ((GObject*) self, "notify::theme-regions", (GCallback) _budgie_panel_update_theme_regions_g_object_notify, self, 0);
	_tmp64_ = self->priv->_settings;
	g_settings_bind (_tmp64_, BUDGIE_PANEL_KEY_REGIONS, (GObject*) self, "theme-regions", G_SETTINGS_BIND_DEFAULT);
	budgie_panel_update_theme_regions (self);
	_tmp65_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp65_);
	budgie_panel_set_expanded (self, FALSE);
	_tmp66_ = self->priv->manager;
	g_signal_connect_object (_tmp66_, "extension-loaded", (GCallback) _budgie_panel_on_extension_loaded_budgie_panel_manager_extension_loaded, self, G_CONNECT_AFTER);
	budgie_panel_update_sizes (self);
	budgie_panel_load_applets (self);
	_g_object_unref0 (vis);
	return self;
}


BudgiePanel* budgie_panel_new (BudgiePanelManager* manager, const gchar* uuid, GSettings* settings) {
	return budgie_panel_construct (BUDGIE_TYPE_PANEL, manager, uuid, settings);
}


static void budgie_panel_update_theme_regions (BudgiePanel* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_toplevel_get_theme_regions ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkBox* _tmp2_ = NULL;
		GtkStyleContext* _tmp3_ = NULL;
		GtkBox* _tmp4_ = NULL;
		GtkStyleContext* _tmp5_ = NULL;
		GtkBox* _tmp6_ = NULL;
		GtkStyleContext* _tmp7_ = NULL;
		_tmp2_ = self->priv->start_box;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
		gtk_style_context_add_class (_tmp3_, "start-region");
		_tmp4_ = self->priv->center_box;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		gtk_style_context_add_class (_tmp5_, "center-region");
		_tmp6_ = self->priv->end_box;
		_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
		gtk_style_context_add_class (_tmp7_, "end-region");
	} else {
		GtkBox* _tmp8_ = NULL;
		GtkStyleContext* _tmp9_ = NULL;
		GtkBox* _tmp10_ = NULL;
		GtkStyleContext* _tmp11_ = NULL;
		GtkBox* _tmp12_ = NULL;
		GtkStyleContext* _tmp13_ = NULL;
		_tmp8_ = self->priv->start_box;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
		gtk_style_context_remove_class (_tmp9_, "start-region");
		_tmp10_ = self->priv->center_box;
		_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
		gtk_style_context_remove_class (_tmp11_, "center-region");
		_tmp12_ = self->priv->end_box;
		_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
		gtk_style_context_remove_class (_tmp13_, "end-region");
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void budgie_panel_update_sizes (BudgiePanel* self) {
	gint size = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint small_size = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	const gchar* key = NULL;
	BudgieAppletInfo* info = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_sizes;
	_tmp0__length1 = self->priv->icon_sizes_length1;
	_tmp1_ = _tmp0_[0];
	size = _tmp1_;
	_tmp2_ = self->priv->icon_sizes;
	_tmp2__length1 = self->priv->icon_sizes_length1;
	_tmp3_ = _tmp2_[0];
	small_size = _tmp3_;
	key = NULL;
	info = NULL;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gint* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->icon_sizes;
				_tmp7__length1 = self->priv->icon_sizes_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->icon_sizes;
				_tmp8__length1 = self->priv->icon_sizes_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
				_tmp12_ = _tmp11_;
				if (_tmp10_ > (_tmp12_ - 5)) {
					break;
				}
				_tmp13_ = self->priv->icon_sizes;
				_tmp13__length1 = self->priv->icon_sizes_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				size = _tmp15_;
				_tmp16_ = self->priv->icon_sizes;
				_tmp16__length1 = self->priv->icon_sizes_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_ - 1];
				small_size = _tmp18_;
			}
		}
	}
	_tmp19_ = size;
	self->priv->current_icon_size = _tmp19_;
	_tmp20_ = small_size;
	self->priv->current_small_icon_size = _tmp20_;
	_tmp21_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp21_);
	while (TRUE) {
		gconstpointer _tmp22_ = NULL;
		gconstpointer _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		BudgieAppletInfo* _tmp25_ = NULL;
		BudgieApplet* _tmp26_ = NULL;
		BudgieApplet* _tmp27_ = NULL;
		BudgieApplet* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		_tmp24_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp22_), (gpointer*) (&_tmp23_));
		key = _tmp22_;
		info = _tmp23_;
		if (!_tmp24_) {
			break;
		}
		_tmp25_ = info;
		g_object_get (_tmp25_, "applet", &_tmp26_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
		_tmp30_ = _tmp29_;
		_tmp31_ = size;
		_tmp32_ = small_size;
		g_signal_emit_by_name (_tmp28_, "panel-size-changed", _tmp30_ - 5, _tmp31_, _tmp32_);
		_g_object_unref0 (_tmp28_);
	}
}


void budgie_panel_destroy_children (BudgiePanel* self) {
	const gchar* key = NULL;
	BudgieAppletInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GSettings* app_settings = NULL;
		BudgieAppletInfo* _tmp4_ = NULL;
		BudgieApplet* _tmp5_ = NULL;
		BudgieApplet* _tmp6_ = NULL;
		BudgieApplet* _tmp7_ = NULL;
		BudgieAppletInfo* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GSettings* _tmp12_ = NULL;
		GSettings* _tmp13_ = NULL;
		BudgieAppletInfo* _tmp14_ = NULL;
		GSettings* _tmp15_ = NULL;
		GSettings* _tmp16_ = NULL;
		GSettings* _tmp17_ = NULL;
		GSettings* _tmp18_ = NULL;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		info = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = info;
		g_object_get (_tmp4_, "applet", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = info;
		g_object_get (_tmp8_, "uuid", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = budgie_applet_get_applet_settings (_tmp7_, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp7_);
		app_settings = _tmp13_;
		_tmp14_ = info;
		g_object_get (_tmp14_, "settings", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		g_settings_reset (_tmp17_, NULL);
		_g_object_unref0 (_tmp17_);
		_tmp18_ = app_settings;
		if (_tmp18_ != NULL) {
			GSettings* _tmp19_ = NULL;
			_tmp19_ = app_settings;
			g_settings_reset (_tmp19_, NULL);
		}
		_g_object_unref0 (app_settings);
	}
}


static void budgie_panel_on_extension_loaded (BudgiePanel* self, const gchar* name) {
	GHashTable* todo = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gconstpointer _tmp19_ = NULL;
	GHashTable* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	todo = NULL;
	_tmp0_ = self->priv->pending;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	todo = (GHashTable*) _tmp2_;
	_tmp3_ = todo;
	if (_tmp3_ != NULL) {
		GHashTableIter iter = {0};
		GHashTable* _tmp4_ = NULL;
		gchar* uuid = NULL;
		GHashTable* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp4_ = todo;
		g_hash_table_iter_init (&iter, _tmp4_);
		uuid = NULL;
		while (TRUE) {
			gconstpointer _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			gchar* _tmp7_ = NULL;
			gchar* uname = NULL;
			BudgieAppletInfo* info = NULL;
			BudgiePanelManager* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			BudgieAppletInfo* _tmp11_ = NULL;
			BudgieAppletInfo* _tmp12_ = NULL;
			BudgieAppletInfo* _tmp14_ = NULL;
			_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp5_), (gpointer*) NULL);
			_g_free0 (uuid);
			_tmp7_ = g_strdup (_tmp5_);
			uuid = _tmp7_;
			if (!_tmp6_) {
				break;
			}
			uname = NULL;
			_tmp8_ = self->priv->manager;
			_tmp9_ = uuid;
			_tmp11_ = budgie_panel_manager_load_applet_instance (_tmp8_, _tmp9_, &_tmp10_, NULL);
			_g_free0 (uname);
			uname = _tmp10_;
			info = _tmp11_;
			_tmp12_ = info;
			if (_tmp12_ == NULL) {
				const gchar* _tmp13_ = NULL;
				_tmp13_ = uname;
				g_critical ("panel.vala:432: Failed to load applet when we know it exists: %s", _tmp13_);
				_g_object_unref0 (info);
				_g_free0 (uname);
				_g_free0 (uuid);
				return;
			}
			_tmp14_ = info;
			budgie_panel_add_applet (self, _tmp14_);
			_g_object_unref0 (info);
			_g_free0 (uname);
		}
		_tmp15_ = self->priv->pending;
		_tmp16_ = name;
		g_hash_table_remove (_tmp15_, _tmp16_);
		_g_free0 (uuid);
	}
	todo = NULL;
	_tmp17_ = self->priv->creating;
	_tmp18_ = name;
	_tmp19_ = g_hash_table_lookup (_tmp17_, _tmp18_);
	todo = (GHashTable*) _tmp19_;
	_tmp20_ = todo;
	if (_tmp20_ != NULL) {
		GHashTableIter iter = {0};
		GHashTable* _tmp21_ = NULL;
		gchar* uuid = NULL;
		GHashTable* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		_tmp21_ = todo;
		g_hash_table_iter_init (&iter, _tmp21_);
		uuid = NULL;
		while (TRUE) {
			gconstpointer _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			gchar* _tmp24_ = NULL;
			BudgieAppletInfo* info = NULL;
			BudgiePanelManager* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			BudgieAppletInfo* _tmp28_ = NULL;
			BudgieAppletInfo* _tmp29_ = NULL;
			BudgieAppletInfo* _tmp30_ = NULL;
			_tmp23_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp22_), (gpointer*) NULL);
			_g_free0 (uuid);
			_tmp24_ = g_strdup (_tmp22_);
			uuid = _tmp24_;
			if (!_tmp23_) {
				break;
			}
			_tmp25_ = self->priv->manager;
			_tmp26_ = name;
			_tmp27_ = uuid;
			_tmp28_ = budgie_panel_manager_create_new_applet (_tmp25_, _tmp26_, _tmp27_);
			info = _tmp28_;
			_tmp29_ = info;
			if (_tmp29_ == NULL) {
				g_critical ("panel.vala:450: Failed to load applet when we know it exists");
				_g_object_unref0 (info);
				_g_free0 (uuid);
				return;
			}
			_tmp30_ = info;
			budgie_panel_add_applet (self, _tmp30_);
			_g_object_unref0 (info);
		}
		_tmp31_ = self->priv->creating;
		_tmp32_ = name;
		g_hash_table_remove (_tmp31_, _tmp32_);
		_g_free0 (uuid);
	}
}


/**
     * Load all pre-configured applets
     */
static void budgie_panel_load_applets (BudgiePanel* self) {
	gchar** applets = NULL;
	GSettings* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint applets_length1 = 0;
	gint _applets_size_ = 0;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, BUDGIE_PANEL_KEY_APPLETS);
	applets = _tmp2_;
	applets_length1 = _vala_array_length (_tmp1_);
	_applets_size_ = applets_length1;
	_tmp4_ = applets;
	_tmp4__length1 = applets_length1;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp5_ = applets;
		_tmp5__length1 = applets_length1;
		_tmp3_ = _tmp5__length1 == 0;
	}
	if (_tmp3_) {
		g_signal_emit_by_name (self, "panel-loaded");
		self->priv->is_fully_loaded = TRUE;
		applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	{
		GList* _tmp6_ = NULL;
		_tmp6_ = self->priv->expected_uuids;
		g_rec_mutex_lock (&self->priv->__lock_expected_uuids);
		{
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp7_ = FALSE;
					_tmp7_ = TRUE;
					while (TRUE) {
						gint _tmp9_ = 0;
						gchar** _tmp10_ = NULL;
						gint _tmp10__length1 = 0;
						gchar** _tmp11_ = NULL;
						gint _tmp11__length1 = 0;
						gint _tmp12_ = 0;
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
						if (!_tmp7_) {
							gint _tmp8_ = 0;
							_tmp8_ = i;
							i = _tmp8_ + 1;
						}
						_tmp7_ = FALSE;
						_tmp9_ = i;
						_tmp10_ = applets;
						_tmp10__length1 = applets_length1;
						if (!(_tmp9_ < _tmp10__length1)) {
							break;
						}
						_tmp11_ = applets;
						_tmp11__length1 = applets_length1;
						_tmp12_ = i;
						_tmp13_ = _tmp11_[_tmp12_];
						_tmp14_ = g_strdup (_tmp13_);
						self->priv->expected_uuids = g_list_append (self->priv->expected_uuids, _tmp14_);
					}
				}
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						gint _tmp17_ = 0;
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gchar* name = NULL;
						BudgieAppletInfo* info = NULL;
						BudgiePanelManager* _tmp19_ = NULL;
						gchar** _tmp20_ = NULL;
						gint _tmp20__length1 = 0;
						gint _tmp21_ = 0;
						const gchar* _tmp22_ = NULL;
						gchar* _tmp23_ = NULL;
						BudgieAppletInfo* _tmp24_ = NULL;
						BudgieAppletInfo* _tmp25_ = NULL;
						if (!_tmp15_) {
							gint _tmp16_ = 0;
							_tmp16_ = i;
							i = _tmp16_ + 1;
						}
						_tmp15_ = FALSE;
						_tmp17_ = i;
						_tmp18_ = applets;
						_tmp18__length1 = applets_length1;
						if (!(_tmp17_ < _tmp18__length1)) {
							break;
						}
						name = NULL;
						_tmp19_ = self->priv->manager;
						_tmp20_ = applets;
						_tmp20__length1 = applets_length1;
						_tmp21_ = i;
						_tmp22_ = _tmp20_[_tmp21_];
						_tmp24_ = budgie_panel_manager_load_applet_instance (_tmp19_, _tmp22_, &_tmp23_, NULL);
						_g_free0 (name);
						name = _tmp23_;
						info = _tmp24_;
						_tmp25_ = info;
						if (_tmp25_ == NULL) {
							const gchar* _tmp26_ = NULL;
							gchar** _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp39_ = 0;
							const gchar* _tmp40_ = NULL;
							const gchar* _tmp41_ = NULL;
							BudgiePanelManager* _tmp42_ = NULL;
							const gchar* _tmp43_ = NULL;
							_tmp26_ = name;
							if (_tmp26_ == NULL) {
								GList* g = NULL;
								GList* _tmp27_ = NULL;
								gchar** _tmp28_ = NULL;
								gint _tmp28__length1 = 0;
								gint _tmp29_ = 0;
								const gchar* _tmp30_ = NULL;
								GCompareFunc _tmp31_ = NULL;
								GList* _tmp32_ = NULL;
								GList* _tmp33_ = NULL;
								gchar** _tmp35_ = NULL;
								gint _tmp35__length1 = 0;
								gint _tmp36_ = 0;
								const gchar* _tmp37_ = NULL;
								_tmp27_ = self->priv->expected_uuids;
								_tmp28_ = applets;
								_tmp28__length1 = applets_length1;
								_tmp29_ = i;
								_tmp30_ = _tmp28_[_tmp29_];
								_tmp31_ = g_strcmp0;
								_tmp32_ = g_list_find_custom (_tmp27_, _tmp30_, _tmp31_);
								g = _tmp32_;
								_tmp33_ = g;
								if (_tmp33_ != NULL) {
									GList* _tmp34_ = NULL;
									_tmp34_ = g;
									self->priv->expected_uuids = g_list_remove_link (self->priv->expected_uuids, _tmp34_);
								}
								_tmp35_ = applets;
								_tmp35__length1 = applets_length1;
								_tmp36_ = i;
								_tmp37_ = _tmp35_[_tmp36_];
								g_message ("panel.vala:490: Unable to load invalid applet: %s", _tmp37_);
								_g_object_unref0 (info);
								_g_free0 (name);
								continue;
							}
							_tmp38_ = applets;
							_tmp38__length1 = applets_length1;
							_tmp39_ = i;
							_tmp40_ = _tmp38_[_tmp39_];
							_tmp41_ = name;
							budgie_panel_add_pending (self, _tmp40_, _tmp41_);
							_tmp42_ = self->priv->manager;
							_tmp43_ = name;
							budgie_panel_manager_modprobe (_tmp42_, _tmp43_);
						} else {
							BudgieAppletInfo* _tmp44_ = NULL;
							_tmp44_ = info;
							budgie_panel_add_applet (self, _tmp44_);
						}
						_g_object_unref0 (info);
						_g_free0 (name);
					}
				}
			}
		}
		__finally10:
		{
			GList* _tmp45_ = NULL;
			_tmp45_ = self->priv->expected_uuids;
			g_rec_mutex_unlock (&self->priv->__lock_expected_uuids);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * Add a new applet to the panel (Raven UI)
     *
     * Explanation: Try to find the most underpopulated region first,
     * and add the applet there. Determine a suitable position,
     * set the alignment+position, stuff an initial config in,
     * and hope for the best when we initiate add_new
     *
     * If the @target_region is set, we'll use that instead
     */
static void budgie_panel_add_new_applet_at (BudgiePanel* self, const gchar* id, GtkBox* target_region) {
	gint position = 0;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkBox* target = NULL;
	gchar* align = NULL;
	BudgieAppletInfo* info = NULL;
	gchar* uuid = NULL;
	GtkBox** regions = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkBox** _tmp8_ = NULL;
	gint regions_length1 = 0;
	gint _regions_size_ = 0;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp25_ = NULL;
	GtkBox* _tmp26_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	BudgieAppletInfo* _tmp34_ = NULL;
	BudgieAppletInfo* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GList* kids = NULL;
	GtkBox* _tmp37_ = NULL;
	GList* _tmp38_ = NULL;
	guint nkids = 0U;
	GList* _tmp39_ = NULL;
	guint _tmp40_ = 0U;
	gint _tmp41_ = 0;
	guint _tmp42_ = 0U;
	gint _tmp44_ = 0;
	BudgieAppletInfo* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GHashTable* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	BudgieAppletInfo* _tmp50_ = NULL;
	BudgieAppletInfo* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->applets;
	_tmp1_ = g_hash_table_size (_tmp0_);
	position = ((gint) _tmp1_) + 1;
	target = NULL;
	align = NULL;
	info = NULL;
	uuid = NULL;
	_tmp2_ = self->priv->start_box;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = self->priv->center_box;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = self->priv->end_box;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_tmp8_ = g_new0 (GtkBox*, 3 + 1);
	_tmp8_[0] = _tmp3_;
	_tmp8_[1] = _tmp5_;
	_tmp8_[2] = _tmp7_;
	regions = _tmp8_;
	regions_length1 = 3;
	_regions_size_ = regions_length1;
	_tmp9_ = target_region;
	if (_tmp9_ != NULL) {
		GList* kids = NULL;
		GtkBox* _tmp10_ = NULL;
		GList* _tmp11_ = NULL;
		GList* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		GtkBox* _tmp14_ = NULL;
		_tmp10_ = target_region;
		_tmp11_ = gtk_container_get_children ((GtkContainer*) _tmp10_);
		kids = _tmp11_;
		_tmp12_ = kids;
		_tmp13_ = g_list_length (_tmp12_);
		position = (gint) _tmp13_;
		_tmp14_ = target_region;
		target = _tmp14_;
		_g_list_free0 (kids);
	} else {
		GtkBox** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		_tmp15_ = regions;
		_tmp15__length1 = regions_length1;
		{
			GtkBox** region_collection = NULL;
			gint region_collection_length1 = 0;
			gint _region_collection_size_ = 0;
			gint region_it = 0;
			region_collection = _tmp15_;
			region_collection_length1 = _tmp15__length1;
			for (region_it = 0; region_it < _tmp15__length1; region_it = region_it + 1) {
				GtkBox* _tmp16_ = NULL;
				GtkBox* region = NULL;
				_tmp16_ = _g_object_ref0 (region_collection[region_it]);
				region = _tmp16_;
				{
					GList* kids = NULL;
					GtkBox* _tmp17_ = NULL;
					GList* _tmp18_ = NULL;
					guint len = 0U;
					GList* _tmp19_ = NULL;
					guint _tmp20_ = 0U;
					guint _tmp21_ = 0U;
					gint _tmp22_ = 0;
					_tmp17_ = region;
					_tmp18_ = gtk_container_get_children ((GtkContainer*) _tmp17_);
					kids = _tmp18_;
					_tmp19_ = kids;
					_tmp20_ = g_list_length (_tmp19_);
					len = _tmp20_;
					_tmp21_ = len;
					_tmp22_ = position;
					if (_tmp21_ < ((guint) _tmp22_)) {
						guint _tmp23_ = 0U;
						GtkBox* _tmp24_ = NULL;
						_tmp23_ = len;
						position = (gint) _tmp23_;
						_tmp24_ = region;
						target = _tmp24_;
					}
					_g_list_free0 (kids);
					_g_object_unref0 (region);
				}
			}
		}
	}
	_tmp25_ = target;
	_tmp26_ = self->priv->start_box;
	if (_tmp25_ == _tmp26_) {
		gchar* _tmp27_ = NULL;
		_tmp27_ = g_strdup ("start");
		_g_free0 (align);
		align = _tmp27_;
	} else {
		GtkBox* _tmp28_ = NULL;
		GtkBox* _tmp29_ = NULL;
		_tmp28_ = target;
		_tmp29_ = self->priv->center_box;
		if (_tmp28_ == _tmp29_) {
			gchar* _tmp30_ = NULL;
			_tmp30_ = g_strdup ("center");
			_g_free0 (align);
			align = _tmp30_;
		} else {
			gchar* _tmp31_ = NULL;
			_tmp31_ = g_strdup ("end");
			_g_free0 (align);
			align = _tmp31_;
		}
	}
	_tmp32_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
	_g_free0 (uuid);
	uuid = _tmp32_;
	_tmp33_ = uuid;
	_tmp34_ = budgie_applet_info_new (NULL, _tmp33_, NULL, NULL);
	_g_object_unref0 (info);
	info = _tmp34_;
	_tmp35_ = info;
	_tmp36_ = align;
	g_object_set (_tmp35_, "alignment", _tmp36_, NULL);
	_tmp37_ = target;
	_tmp38_ = gtk_container_get_children ((GtkContainer*) _tmp37_);
	kids = _tmp38_;
	_tmp39_ = kids;
	_tmp40_ = g_list_length (_tmp39_);
	nkids = _tmp40_;
	_tmp41_ = position;
	_tmp42_ = nkids;
	if (((guint) _tmp41_) >= _tmp42_) {
		guint _tmp43_ = 0U;
		_tmp43_ = nkids;
		position = (gint) _tmp43_;
	}
	_tmp44_ = position;
	if (_tmp44_ < 0) {
		position = 0;
	}
	_tmp45_ = info;
	_tmp46_ = position;
	g_object_set (_tmp45_, "position", _tmp46_, NULL);
	_tmp47_ = self->priv->initial_config;
	_tmp48_ = uuid;
	_tmp49_ = g_strdup (_tmp48_);
	_tmp50_ = info;
	_tmp51_ = _g_object_ref0 (_tmp50_);
	g_hash_table_insert (_tmp47_, _tmp49_, _tmp51_);
	_tmp52_ = id;
	_tmp53_ = uuid;
	budgie_panel_add_new (self, _tmp52_, _tmp53_);
	_g_list_free0 (kids);
	regions = (_vala_array_free (regions, regions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (uuid);
	_g_object_unref0 (info);
	_g_free0 (align);
}


/**
     * Add a new applet to the panel (Raven UI)
     */
static void budgie_panel_real_add_new_applet (BudgieToplevel* base, const gchar* id) {
	BudgiePanel * self;
	const gchar* _tmp0_ = NULL;
	self = (BudgiePanel*) base;
	g_return_if_fail (id != NULL);
	_tmp0_ = id;
	budgie_panel_add_new_applet_at (self, _tmp0_, NULL);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void budgie_panel_create_default_layout (BudgiePanel* self, const gchar* name, GKeyFile* config) {
	gint s_index = 0;
	gint c_index = 0;
	gint e_index = 0;
	gint index = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (config != NULL);
	s_index = -1;
	c_index = -1;
	e_index = -1;
	index = 0;
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gchar** applets = NULL;
		GKeyFile* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gsize _tmp7_;
		gchar** _tmp8_ = NULL;
		gint applets_length1 = 0;
		gint _applets_size_ = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp1_ = config;
		_tmp2_ = name;
		_tmp3_ = g_key_file_has_key (_tmp1_, _tmp2_, "Children", &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		if (!_tmp0_) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = name;
			g_warning ("panel.vala:590: Config for panel %s does not specify applets", _tmp4_);
			return;
		}
		_tmp5_ = config;
		_tmp6_ = name;
		_tmp8_ = g_key_file_get_string_list (_tmp5_, _tmp6_, "Children", &_tmp7_, &_inner_error_);
		applets = _tmp8_;
		applets_length1 = _tmp7_;
		_applets_size_ = applets_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp9_ = applets;
		_tmp9__length1 = applets_length1;
		{
			gchar** appl_collection = NULL;
			gint appl_collection_length1 = 0;
			gint _appl_collection_size_ = 0;
			gint appl_it = 0;
			appl_collection = _tmp9_;
			appl_collection_length1 = _tmp9__length1;
			for (appl_it = 0; appl_it < _tmp9__length1; appl_it = appl_it + 1) {
				gchar* _tmp10_ = NULL;
				gchar* appl = NULL;
				_tmp10_ = g_strdup (appl_collection[appl_it]);
				appl = _tmp10_;
				{
					BudgieAppletInfo* info = NULL;
					gchar* uuid = NULL;
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* alignment = NULL;
					gchar* _tmp13_ = NULL;
					GKeyFile* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp18_ = FALSE;
					GKeyFile* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					GKeyFile* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gchar* id = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_ = NULL;
					const gchar* _tmp39_ = NULL;
					BudgieAppletInfo* _tmp40_ = NULL;
					gboolean _tmp41_ = FALSE;
					GKeyFile* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					const gchar* _tmp52_ = NULL;
					const gchar* _tmp53_ = NULL;
					GQuark _tmp55_ = 0U;
					static GQuark _tmp54_label0 = 0;
					static GQuark _tmp54_label1 = 0;
					BudgieAppletInfo* _tmp62_ = NULL;
					const gchar* _tmp63_ = NULL;
					BudgieAppletInfo* _tmp64_ = NULL;
					gint _tmp65_ = 0;
					GHashTable* _tmp66_ = NULL;
					const gchar* _tmp67_ = NULL;
					gchar* _tmp68_ = NULL;
					BudgieAppletInfo* _tmp69_ = NULL;
					BudgieAppletInfo* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					info = NULL;
					uuid = NULL;
					_tmp11_ = appl;
					_tmp12_ = string_strip (_tmp11_);
					_g_free0 (appl);
					appl = _tmp12_;
					_tmp13_ = g_strdup ("start");
					alignment = _tmp13_;
					_tmp14_ = config;
					_tmp15_ = appl;
					_tmp16_ = g_key_file_has_group (_tmp14_, _tmp15_);
					if (!_tmp16_) {
						const gchar* _tmp17_ = NULL;
						_tmp17_ = appl;
						g_warning ("panel.vala:601: Panel applet %s missing from config", _tmp17_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						continue;
					}
					_tmp19_ = config;
					_tmp20_ = appl;
					_tmp21_ = g_key_file_has_key (_tmp19_, _tmp20_, "ID", &_inner_error_);
					_tmp18_ = _tmp21_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch11_g_error;
					}
					if (!_tmp18_) {
						const gchar* _tmp22_ = NULL;
						_tmp22_ = appl;
						g_warning ("panel.vala:606: Applet %s is missing ID", _tmp22_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						continue;
					}
					_tmp23_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
					_g_free0 (uuid);
					uuid = _tmp23_;
					_tmp25_ = config;
					_tmp26_ = appl;
					_tmp27_ = g_key_file_get_string (_tmp25_, _tmp26_, "ID", &_inner_error_);
					_tmp24_ = _tmp27_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch11_g_error;
					}
					_tmp28_ = _tmp24_;
					_tmp24_ = NULL;
					_tmp29_ = _tmp28_;
					_tmp30_ = string_strip (_tmp29_);
					_tmp31_ = _tmp30_;
					_g_free0 (_tmp29_);
					id = _tmp31_;
					_tmp33_ = uuid;
					if (_tmp33_ == NULL) {
						_tmp32_ = TRUE;
					} else {
						const gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						_tmp34_ = uuid;
						_tmp35_ = string_strip (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp32_ = g_strcmp0 (_tmp36_, "") == 0;
						_g_free0 (_tmp36_);
					}
					if (_tmp32_) {
						const gchar* _tmp37_ = NULL;
						const gchar* _tmp38_ = NULL;
						_tmp37_ = id;
						_tmp38_ = name;
						g_warning ("panel.vala:614: Could not add new applet %s from config %s", _tmp37_, _tmp38_);
						_g_free0 (id);
						_g_free0 (_tmp24_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						continue;
					}
					_tmp39_ = uuid;
					_tmp40_ = budgie_applet_info_new (NULL, _tmp39_, NULL, NULL);
					_g_object_unref0 (info);
					info = _tmp40_;
					_tmp42_ = config;
					_tmp43_ = appl;
					_tmp44_ = g_key_file_has_key (_tmp42_, _tmp43_, "Alignment", &_inner_error_);
					_tmp41_ = _tmp44_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (id);
						_g_free0 (_tmp24_);
						_g_free0 (alignment);
						_g_free0 (uuid);
						_g_object_unref0 (info);
						_g_free0 (appl);
						applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch11_g_error;
					}
					if (_tmp41_) {
						gchar* _tmp45_ = NULL;
						GKeyFile* _tmp46_ = NULL;
						const gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						_tmp46_ = config;
						_tmp47_ = appl;
						_tmp48_ = g_key_file_get_string (_tmp46_, _tmp47_, "Alignment", &_inner_error_);
						_tmp45_ = _tmp48_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (id);
							_g_free0 (_tmp24_);
							_g_free0 (alignment);
							_g_free0 (uuid);
							_g_object_unref0 (info);
							_g_free0 (appl);
							applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
							goto __catch11_g_error;
						}
						_tmp49_ = _tmp45_;
						_tmp45_ = NULL;
						_tmp50_ = _tmp49_;
						_tmp51_ = string_strip (_tmp50_);
						_g_free0 (alignment);
						alignment = _tmp51_;
						_g_free0 (_tmp50_);
						_g_free0 (_tmp45_);
					}
					_tmp52_ = alignment;
					_tmp53_ = _tmp52_;
					_tmp55_ = (NULL == _tmp53_) ? 0 : g_quark_from_string (_tmp53_);
					if (_tmp55_ == ((0 != _tmp54_label0) ? _tmp54_label0 : (_tmp54_label0 = g_quark_from_static_string ("center")))) {
						switch (0) {
							default:
							{
								gint _tmp56_ = 0;
								gint _tmp57_ = 0;
								_tmp56_ = c_index;
								c_index = _tmp56_ + 1;
								_tmp57_ = c_index;
								index = _tmp57_;
								break;
							}
						}
					} else if (_tmp55_ == ((0 != _tmp54_label1) ? _tmp54_label1 : (_tmp54_label1 = g_quark_from_static_string ("end")))) {
						switch (0) {
							default:
							{
								gint _tmp58_ = 0;
								gint _tmp59_ = 0;
								_tmp58_ = e_index;
								e_index = _tmp58_ + 1;
								_tmp59_ = e_index;
								index = _tmp59_;
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								gint _tmp60_ = 0;
								gint _tmp61_ = 0;
								_tmp60_ = s_index;
								s_index = _tmp60_ + 1;
								_tmp61_ = s_index;
								index = _tmp61_;
								break;
							}
						}
					}
					_tmp62_ = info;
					_tmp63_ = alignment;
					g_object_set (_tmp62_, "alignment", _tmp63_, NULL);
					_tmp64_ = info;
					_tmp65_ = index;
					g_object_set (_tmp64_, "position", _tmp65_, NULL);
					_tmp66_ = self->priv->initial_config;
					_tmp67_ = uuid;
					_tmp68_ = g_strdup (_tmp67_);
					_tmp69_ = info;
					_tmp70_ = _g_object_ref0 (_tmp69_);
					g_hash_table_insert (_tmp66_, _tmp68_, _tmp70_);
					_tmp71_ = id;
					_tmp72_ = uuid;
					budgie_panel_add_new (self, _tmp71_, _tmp72_);
					_g_free0 (id);
					_g_free0 (_tmp24_);
					_g_free0 (alignment);
					_g_free0 (uuid);
					_g_object_unref0 (info);
					_g_free0 (appl);
				}
			}
		}
		applets = (_vala_array_free (applets, applets_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp73_ = NULL;
		const gchar* _tmp74_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp73_ = e;
		_tmp74_ = _tmp73_->message;
		g_warning ("panel.vala:641: Error loading default config: %s", _tmp74_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void budgie_panel_set_applets (BudgiePanel* self) {
	gchar** uuids = NULL;
	gint uuids_length1 = 0;
	gint _uuids_size_ = 0;
	const gchar* uuid = NULL;
	BudgieAppletInfo* plugin = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	GSettings* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	uuids = NULL;
	uuids_length1 = 0;
	_uuids_size_ = uuids_length1;
	uuid = NULL;
	plugin = NULL;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		uuid = _tmp1_;
		plugin = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = uuids;
		_tmp4__length1 = uuids_length1;
		_tmp5_ = uuid;
		_tmp6_ = g_strdup (_tmp5_);
		_vala_array_add2 (&uuids, &uuids_length1, &_uuids_size_, _tmp6_);
	}
	_tmp7_ = self->priv->_settings;
	_tmp8_ = uuids;
	_tmp8__length1 = uuids_length1;
	g_settings_set_strv (_tmp7_, BUDGIE_PANEL_KEY_APPLETS, _tmp8_);
	uuids = (_vala_array_free (uuids, uuids_length1, (GDestroyNotify) g_free), NULL);
}


static void budgie_panel_real_remove_applet (BudgieToplevel* base, BudgieAppletInfo* info) {
	BudgiePanel * self;
	gint position = 0;
	BudgieAppletInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* alignment = NULL;
	BudgieAppletInfo* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* uuid = NULL;
	BudgieAppletInfo* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gulong notify_id = 0UL;
	BudgieAppletInfo* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
	BudgieAppletInfo* _tmp11_ = NULL;
	gulong _tmp12_ = 0UL;
	BudgieAppletInfo* _tmp13_ = NULL;
	BudgieApplet* _tmp14_ = NULL;
	BudgieApplet* _tmp15_ = NULL;
	BudgieApplet* _tmp16_ = NULL;
	GtkContainer* _tmp17_ = NULL;
	BudgieAppletInfo* _tmp18_ = NULL;
	BudgieApplet* _tmp19_ = NULL;
	BudgieApplet* _tmp20_ = NULL;
	BudgieApplet* _tmp21_ = NULL;
	GSettings* app_settings = NULL;
	BudgieAppletInfo* _tmp22_ = NULL;
	BudgieApplet* _tmp23_ = NULL;
	BudgieApplet* _tmp24_ = NULL;
	BudgieApplet* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GSettings* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	BudgieAppletInfo* _tmp29_ = NULL;
	GSettings* _tmp30_ = NULL;
	GSettings* _tmp31_ = NULL;
	GSettings* _tmp32_ = NULL;
	GHashTable* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GSettings* _tmp36_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	self = (BudgiePanel*) base;
	_tmp0_ = info;
	g_object_get (_tmp0_, "position", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	position = _tmp2_;
	_tmp3_ = info;
	g_object_get (_tmp3_, "alignment", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	alignment = _tmp5_;
	_tmp6_ = info;
	g_object_get (_tmp6_, "uuid", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	uuid = _tmp8_;
	_tmp9_ = info;
	_tmp10_ = g_object_get_data ((GObject*) _tmp9_, "notify_id");
	notify_id = (gulong) ((guintptr) _tmp10_);
	_tmp11_ = info;
	_tmp12_ = notify_id;
	g_signal_handler_disconnect (_tmp11_, _tmp12_);
	_tmp13_ = info;
	g_object_get (_tmp13_, "applet", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp16_);
	_tmp18_ = info;
	g_object_get (_tmp18_, "applet", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	gtk_container_remove (_tmp17_, (GtkWidget*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (_tmp16_);
	_tmp22_ = info;
	g_object_get (_tmp22_, "applet", &_tmp23_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp26_ = uuid;
	_tmp27_ = budgie_applet_get_applet_settings (_tmp25_, _tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp25_);
	app_settings = _tmp28_;
	_tmp29_ = info;
	g_object_get (_tmp29_, "settings", &_tmp30_, NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_;
	g_settings_reset (_tmp32_, NULL);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = self->priv->applets;
	_tmp34_ = uuid;
	g_hash_table_remove (_tmp33_, _tmp34_);
	_tmp35_ = uuid;
	g_signal_emit_by_name ((BudgieToplevel*) self, "applet-removed", _tmp35_);
	_tmp36_ = app_settings;
	if (_tmp36_ != NULL) {
		GSettings* _tmp37_ = NULL;
		_tmp37_ = app_settings;
		g_settings_reset (_tmp37_, NULL);
	}
	budgie_panel_set_applets (self);
	_tmp38_ = alignment;
	_tmp39_ = position;
	budgie_panel_budge_em_left (self, _tmp38_, _tmp39_);
	_g_object_unref0 (app_settings);
	_g_free0 (uuid);
	_g_free0 (alignment);
}


static void _budgie_panel_applet_updated_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	budgie_panel_applet_updated ((BudgiePanel*) self, _sender, pspec);
}


static void budgie_panel_add_applet (BudgiePanel* self, BudgieAppletInfo* info) {
	GtkBox* pack_target = NULL;
	BudgieAppletInfo* initial_info = NULL;
	GHashTable* _tmp0_ = NULL;
	BudgieAppletInfo* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	BudgieAppletInfo* _tmp6_ = NULL;
	BudgieAppletInfo* _tmp7_ = NULL;
	gboolean _tmp22_ = FALSE;
	BudgieAppletInfo* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GQuark _tmp40_ = 0U;
	static GQuark _tmp39_label0 = 0;
	static GQuark _tmp39_label1 = 0;
	GHashTable* _tmp44_ = NULL;
	BudgieAppletInfo* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	BudgieAppletInfo* _tmp48_ = NULL;
	BudgieAppletInfo* _tmp49_ = NULL;
	BudgieAppletInfo* _tmp50_ = NULL;
	BudgieApplet* _tmp51_ = NULL;
	BudgieApplet* _tmp52_ = NULL;
	BudgieApplet* _tmp53_ = NULL;
	BudgiePopoverManager* _tmp54_ = NULL;
	BudgieAppletInfo* _tmp55_ = NULL;
	BudgieApplet* _tmp56_ = NULL;
	BudgieApplet* _tmp57_ = NULL;
	BudgieApplet* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	GtkBox* _tmp63_ = NULL;
	BudgieAppletInfo* _tmp64_ = NULL;
	BudgieApplet* _tmp65_ = NULL;
	BudgieApplet* _tmp66_ = NULL;
	BudgieApplet* _tmp67_ = NULL;
	GtkBox* _tmp68_ = NULL;
	BudgieAppletInfo* _tmp69_ = NULL;
	BudgieApplet* _tmp70_ = NULL;
	BudgieApplet* _tmp71_ = NULL;
	BudgieApplet* _tmp72_ = NULL;
	BudgieAppletInfo* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gulong id = 0UL;
	BudgieAppletInfo* _tmp76_ = NULL;
	gulong _tmp77_ = 0UL;
	BudgieAppletInfo* _tmp78_ = NULL;
	gulong _tmp79_ = 0UL;
	BudgieAppletInfo* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	pack_target = NULL;
	initial_info = NULL;
	_tmp0_ = self->priv->initial_config;
	_tmp1_ = info;
	g_object_get (_tmp1_, "uuid", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp0_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((BudgieAppletInfo*) _tmp5_);
	_g_object_unref0 (initial_info);
	initial_info = _tmp6_;
	_g_free0 (_tmp4_);
	_tmp7_ = initial_info;
	if (_tmp7_ != NULL) {
		BudgieAppletInfo* _tmp8_ = NULL;
		BudgieAppletInfo* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		BudgieAppletInfo* _tmp13_ = NULL;
		BudgieAppletInfo* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GHashTable* _tmp17_ = NULL;
		BudgieAppletInfo* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp8_ = info;
		_tmp9_ = initial_info;
		g_object_get (_tmp9_, "alignment", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		g_object_set (_tmp8_, "alignment", _tmp12_, NULL);
		_g_free0 (_tmp12_);
		_tmp13_ = info;
		_tmp14_ = initial_info;
		g_object_get (_tmp14_, "position", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		g_object_set (_tmp13_, "position", _tmp16_, NULL);
		_tmp17_ = self->priv->initial_config;
		_tmp18_ = info;
		g_object_get (_tmp18_, "uuid", &_tmp19_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		g_hash_table_remove (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = self->priv->is_fully_loaded;
	if (!_tmp22_) {
		{
			GList* _tmp23_ = NULL;
			_tmp23_ = self->priv->expected_uuids;
			g_rec_mutex_lock (&self->priv->__lock_expected_uuids);
			{
				GList* exp_fin = NULL;
				GList* _tmp24_ = NULL;
				BudgieAppletInfo* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				GCompareFunc _tmp29_ = NULL;
				GList* _tmp30_ = NULL;
				GList* _tmp31_ = NULL;
				GList* _tmp32_ = NULL;
				_tmp24_ = self->priv->expected_uuids;
				_tmp25_ = info;
				g_object_get (_tmp25_, "uuid", &_tmp26_, NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strcmp0;
				_tmp30_ = g_list_find_custom (_tmp24_, _tmp28_, _tmp29_);
				_tmp31_ = _tmp30_;
				_g_free0 (_tmp28_);
				exp_fin = _tmp31_;
				_tmp32_ = exp_fin;
				if (_tmp32_ != NULL) {
					GList* _tmp33_ = NULL;
					_tmp33_ = exp_fin;
					self->priv->expected_uuids = g_list_remove_link (self->priv->expected_uuids, _tmp33_);
				}
			}
			__finally12:
			{
				GList* _tmp34_ = NULL;
				_tmp34_ = self->priv->expected_uuids;
				g_rec_mutex_unlock (&self->priv->__lock_expected_uuids);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (initial_info);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp35_ = info;
	g_object_get (_tmp35_, "alignment", &_tmp36_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp40_ = (NULL == _tmp38_) ? 0 : g_quark_from_string (_tmp38_);
	g_free (_tmp38_);
	if (_tmp40_ == ((0 != _tmp39_label0) ? _tmp39_label0 : (_tmp39_label0 = g_quark_from_static_string ("start")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp41_ = NULL;
				_tmp41_ = self->priv->start_box;
				pack_target = _tmp41_;
				break;
			}
		}
	} else if (_tmp40_ == ((0 != _tmp39_label1) ? _tmp39_label1 : (_tmp39_label1 = g_quark_from_static_string ("end")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp42_ = NULL;
				_tmp42_ = self->priv->end_box;
				pack_target = _tmp42_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkBox* _tmp43_ = NULL;
				_tmp43_ = self->priv->center_box;
				pack_target = _tmp43_;
				break;
			}
		}
	}
	_tmp44_ = self->priv->applets;
	_tmp45_ = info;
	g_object_get (_tmp45_, "uuid", &_tmp46_, NULL);
	_tmp47_ = _tmp46_;
	_tmp48_ = info;
	_tmp49_ = _g_object_ref0 (_tmp48_);
	g_hash_table_insert (_tmp44_, _tmp47_, _tmp49_);
	budgie_panel_set_applets (self);
	_tmp50_ = info;
	g_object_get (_tmp50_, "applet", &_tmp51_, NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp54_ = self->priv->popover_manager;
	budgie_applet_update_popovers (_tmp53_, _tmp54_);
	_g_object_unref0 (_tmp53_);
	_tmp55_ = info;
	g_object_get (_tmp55_, "applet", &_tmp56_, NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp59_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
	_tmp60_ = _tmp59_;
	_tmp61_ = self->priv->current_icon_size;
	_tmp62_ = self->priv->current_small_icon_size;
	g_signal_emit_by_name (_tmp58_, "panel-size-changed", _tmp60_, _tmp61_, _tmp62_);
	_g_object_unref0 (_tmp58_);
	_tmp63_ = pack_target;
	_tmp64_ = info;
	g_object_get (_tmp64_, "applet", &_tmp65_, NULL);
	_tmp66_ = _tmp65_;
	_tmp67_ = _tmp66_;
	gtk_box_pack_start (_tmp63_, (GtkWidget*) _tmp67_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp67_);
	_tmp68_ = pack_target;
	_tmp69_ = info;
	g_object_get (_tmp69_, "applet", &_tmp70_, NULL);
	_tmp71_ = _tmp70_;
	_tmp72_ = _tmp71_;
	_tmp73_ = info;
	g_object_get (_tmp73_, "position", &_tmp74_, NULL);
	_tmp75_ = _tmp74_;
	gtk_container_child_set ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp72_, "position", _tmp75_, NULL);
	_g_object_unref0 (_tmp72_);
	_tmp76_ = info;
	_tmp77_ = g_signal_connect_object ((GObject*) _tmp76_, "notify", (GCallback) _budgie_panel_applet_updated_g_object_notify, self, 0);
	id = _tmp77_;
	_tmp78_ = info;
	_tmp79_ = id;
	g_object_set_data_full ((GObject*) _tmp78_, "notify_id", (gpointer) ((guintptr) _tmp79_), NULL);
	_tmp80_ = info;
	g_signal_emit_by_name ((BudgieToplevel*) self, "applet-added", _tmp80_);
	_tmp81_ = self->priv->is_fully_loaded;
	if (_tmp81_) {
		_g_object_unref0 (initial_info);
		return;
	}
	{
		GList* _tmp82_ = NULL;
		_tmp82_ = self->priv->expected_uuids;
		g_rec_mutex_lock (&self->priv->__lock_expected_uuids);
		{
			GList* _tmp83_ = NULL;
			guint _tmp84_ = 0U;
			_tmp83_ = self->priv->expected_uuids;
			_tmp84_ = g_list_length (_tmp83_);
			if (_tmp84_ == ((guint) 0)) {
				self->priv->is_fully_loaded = TRUE;
				g_signal_emit_by_name (self, "panel-loaded");
			}
		}
		__finally13:
		{
			GList* _tmp85_ = NULL;
			_tmp85_ = self->priv->expected_uuids;
			g_rec_mutex_unlock (&self->priv->__lock_expected_uuids);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (initial_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (initial_info);
}


static void budgie_panel_applet_reparent (BudgiePanel* self, BudgieAppletInfo* info) {
	GtkBox* new_parent = NULL;
	BudgieAppletInfo* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	GtkBox* _tmp9_ = NULL;
	BudgieAppletInfo* _tmp10_ = NULL;
	BudgieApplet* _tmp11_ = NULL;
	BudgieApplet* _tmp12_ = NULL;
	BudgieApplet* _tmp13_ = NULL;
	GtkContainer* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	BudgieAppletInfo* _tmp16_ = NULL;
	BudgieApplet* _tmp17_ = NULL;
	BudgieApplet* _tmp18_ = NULL;
	BudgieApplet* _tmp19_ = NULL;
	GtkBox* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	new_parent = NULL;
	_tmp0_ = info;
	g_object_get (_tmp0_, "alignment", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	g_free (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("start")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp6_ = NULL;
				_tmp6_ = self->priv->start_box;
				new_parent = _tmp6_;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("end")))) {
		switch (0) {
			default:
			{
				GtkBox* _tmp7_ = NULL;
				_tmp7_ = self->priv->end_box;
				new_parent = _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkBox* _tmp8_ = NULL;
				_tmp8_ = self->priv->center_box;
				new_parent = _tmp8_;
				break;
			}
		}
	}
	_tmp9_ = new_parent;
	_tmp10_ = info;
	g_object_get (_tmp10_, "applet", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp13_);
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer) == _tmp14_;
	_g_object_unref0 (_tmp13_);
	if (_tmp15_) {
		return;
	}
	_tmp16_ = info;
	g_object_get (_tmp16_, "applet", &_tmp17_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = new_parent;
	gtk_widget_reparent ((GtkWidget*) _tmp19_, (GtkWidget*) _tmp20_);
	_g_object_unref0 (_tmp19_);
}


static void budgie_panel_applet_reposition (BudgiePanel* self, BudgieAppletInfo* info) {
	BudgieAppletInfo* _tmp0_ = NULL;
	BudgieApplet* _tmp1_ = NULL;
	BudgieApplet* _tmp2_ = NULL;
	BudgieApplet* _tmp3_ = NULL;
	GtkContainer* _tmp4_ = NULL;
	BudgieAppletInfo* _tmp5_ = NULL;
	BudgieApplet* _tmp6_ = NULL;
	BudgieApplet* _tmp7_ = NULL;
	BudgieApplet* _tmp8_ = NULL;
	BudgieAppletInfo* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = info;
	g_object_get (_tmp0_, "applet", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp3_);
	_tmp5_ = info;
	g_object_get (_tmp5_, "applet", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = info;
	g_object_get (_tmp9_, "position", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	gtk_container_child_set (_tmp4_, (GtkWidget*) _tmp8_, "position", _tmp11_, NULL);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp3_);
}


static void budgie_panel_applet_updated (BudgiePanel* self, GObject* o, GParamSpec* p) {
	BudgieAppletInfo* info = NULL;
	GObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GParamSpec* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = o;
	info = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, budgie_applet_info_get_type ()) ? ((BudgieAppletInfo*) _tmp0_) : NULL;
	_tmp1_ = self->priv->is_fully_loaded;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = p;
	_tmp3_ = _tmp2_->name;
	if (g_strcmp0 (_tmp3_, "alignment") == 0) {
		BudgieAppletInfo* _tmp4_ = NULL;
		_tmp4_ = info;
		budgie_panel_applet_reparent (self, _tmp4_);
	} else {
		GParamSpec* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = p;
		_tmp6_ = _tmp5_->name;
		if (g_strcmp0 (_tmp6_, "position") == 0) {
			BudgieAppletInfo* _tmp7_ = NULL;
			_tmp7_ = info;
			budgie_panel_applet_reposition (self, _tmp7_);
		}
	}
	g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
}


static void budgie_panel_add_new (BudgiePanel* self, const gchar* plugin_name, const gchar* initial_uuid) {
	gchar* uuid = NULL;
	gchar* rname = NULL;
	GHashTable* table = NULL;
	BudgiePanelManager* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp4_ = NULL;
	BudgiePanelManager* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	BudgieAppletInfo* info = NULL;
	BudgiePanelManager* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	BudgieAppletInfo* _tmp42_ = NULL;
	BudgieAppletInfo* _tmp43_ = NULL;
	BudgieAppletInfo* _tmp44_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	uuid = NULL;
	rname = NULL;
	table = NULL;
	_tmp0_ = self->priv->manager;
	_tmp1_ = plugin_name;
	_tmp2_ = budgie_panel_manager_is_extension_valid (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = plugin_name;
		g_warning ("panel.vala:795: Not loading invalid plugin: %s", _tmp3_);
		_g_free0 (rname);
		_g_free0 (uuid);
		return;
	}
	_tmp4_ = initial_uuid;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
		_g_free0 (uuid);
		uuid = _tmp5_;
	} else {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = initial_uuid;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (uuid);
		uuid = _tmp7_;
	}
	_tmp8_ = self->priv->manager;
	_tmp9_ = plugin_name;
	_tmp10_ = budgie_panel_manager_is_extension_loaded (_tmp8_, _tmp9_);
	if (!_tmp10_) {
		GHashTable* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gconstpointer _tmp13_ = NULL;
		GHashTable* _tmp14_ = NULL;
		GHashTable* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		GHashFunc _tmp26_ = NULL;
		GEqualFunc _tmp27_ = NULL;
		GHashTable* _tmp28_ = NULL;
		GHashTable* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
		GHashTable* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		BudgiePanelManager* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		_tmp11_ = self->priv->creating;
		_tmp12_ = plugin_name;
		_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
		table = (GHashTable*) _tmp13_;
		_tmp14_ = table;
		if (_tmp14_ != NULL) {
			GHashTable* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp15_ = table;
			_tmp16_ = uuid;
			_tmp17_ = g_hash_table_contains (_tmp15_, _tmp16_);
			if (!_tmp17_) {
				GHashTable* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				_tmp18_ = table;
				_tmp19_ = uuid;
				_tmp20_ = g_strdup (_tmp19_);
				_tmp21_ = uuid;
				_tmp22_ = g_strdup (_tmp21_);
				g_hash_table_insert (_tmp18_, _tmp20_, _tmp22_);
			}
			_g_free0 (rname);
			_g_free0 (uuid);
			return;
		}
		_tmp23_ = self->priv->creating;
		_tmp24_ = plugin_name;
		_tmp25_ = g_strdup (_tmp24_);
		_tmp26_ = g_str_hash;
		_tmp27_ = g_str_equal;
		_tmp28_ = g_hash_table_new_full (_tmp26_, _tmp27_, _g_free0_, _g_free0_);
		g_hash_table_insert (_tmp23_, _tmp25_, _tmp28_);
		_tmp29_ = self->priv->creating;
		_tmp30_ = plugin_name;
		_tmp31_ = g_hash_table_lookup (_tmp29_, _tmp30_);
		table = (GHashTable*) _tmp31_;
		_tmp32_ = table;
		_tmp33_ = uuid;
		_tmp34_ = g_strdup (_tmp33_);
		_tmp35_ = uuid;
		_tmp36_ = g_strdup (_tmp35_);
		g_hash_table_insert (_tmp32_, _tmp34_, _tmp36_);
		_tmp37_ = self->priv->manager;
		_tmp38_ = plugin_name;
		budgie_panel_manager_modprobe (_tmp37_, _tmp38_);
		_g_free0 (rname);
		_g_free0 (uuid);
		return;
	}
	_tmp39_ = self->priv->manager;
	_tmp40_ = plugin_name;
	_tmp41_ = uuid;
	_tmp42_ = budgie_panel_manager_create_new_applet (_tmp39_, _tmp40_, _tmp41_);
	info = _tmp42_;
	_tmp43_ = info;
	if (_tmp43_ == NULL) {
		g_critical ("panel.vala:823: Failed to load applet when we know it exists");
		_g_object_unref0 (info);
		_g_free0 (rname);
		_g_free0 (uuid);
		return;
	}
	_tmp44_ = info;
	budgie_panel_add_applet (self, _tmp44_);
	_g_object_unref0 (info);
	_g_free0 (rname);
	_g_free0 (uuid);
	return;
}


static void budgie_panel_add_pending (BudgiePanel* self, const gchar* uuid, const gchar* plugin_name) {
	gchar* rname = NULL;
	GHashTable* table = NULL;
	BudgiePanelManager* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	BudgiePanelManager* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	BudgieAppletInfo* info = NULL;
	BudgiePanelManager* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	BudgieAppletInfo* _tmp39_ = NULL;
	BudgieAppletInfo* _tmp40_ = NULL;
	BudgieAppletInfo* _tmp41_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	g_return_if_fail (plugin_name != NULL);
	rname = NULL;
	table = NULL;
	_tmp0_ = self->priv->manager;
	_tmp1_ = plugin_name;
	_tmp2_ = budgie_panel_manager_is_extension_valid (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = plugin_name;
		_tmp4_ = uuid;
		g_warning ("panel.vala:836: Not adding invalid plugin: %s %s", _tmp3_, _tmp4_);
		_g_free0 (rname);
		return;
	}
	_tmp5_ = self->priv->manager;
	_tmp6_ = plugin_name;
	_tmp7_ = budgie_panel_manager_is_extension_loaded (_tmp5_, _tmp6_);
	if (!_tmp7_) {
		GHashTable* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		GHashTable* _tmp11_ = NULL;
		GHashTable* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		GHashFunc _tmp23_ = NULL;
		GEqualFunc _tmp24_ = NULL;
		GHashTable* _tmp25_ = NULL;
		GHashTable* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gconstpointer _tmp28_ = NULL;
		GHashTable* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		BudgiePanelManager* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		_tmp8_ = self->priv->pending;
		_tmp9_ = plugin_name;
		_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
		table = (GHashTable*) _tmp10_;
		_tmp11_ = table;
		if (_tmp11_ != NULL) {
			GHashTable* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp12_ = table;
			_tmp13_ = uuid;
			_tmp14_ = g_hash_table_contains (_tmp12_, _tmp13_);
			if (!_tmp14_) {
				GHashTable* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				_tmp15_ = table;
				_tmp16_ = uuid;
				_tmp17_ = g_strdup (_tmp16_);
				_tmp18_ = uuid;
				_tmp19_ = g_strdup (_tmp18_);
				g_hash_table_insert (_tmp15_, _tmp17_, _tmp19_);
			}
			_g_free0 (rname);
			return;
		}
		_tmp20_ = self->priv->pending;
		_tmp21_ = plugin_name;
		_tmp22_ = g_strdup (_tmp21_);
		_tmp23_ = g_str_hash;
		_tmp24_ = g_str_equal;
		_tmp25_ = g_hash_table_new_full (_tmp23_, _tmp24_, _g_free0_, _g_free0_);
		g_hash_table_insert (_tmp20_, _tmp22_, _tmp25_);
		_tmp26_ = self->priv->pending;
		_tmp27_ = plugin_name;
		_tmp28_ = g_hash_table_lookup (_tmp26_, _tmp27_);
		table = (GHashTable*) _tmp28_;
		_tmp29_ = table;
		_tmp30_ = uuid;
		_tmp31_ = g_strdup (_tmp30_);
		_tmp32_ = uuid;
		_tmp33_ = g_strdup (_tmp32_);
		g_hash_table_insert (_tmp29_, _tmp31_, _tmp33_);
		_tmp34_ = self->priv->manager;
		_tmp35_ = plugin_name;
		budgie_panel_manager_modprobe (_tmp34_, _tmp35_);
		_g_free0 (rname);
		return;
	}
	_tmp36_ = self->priv->manager;
	_tmp37_ = uuid;
	_tmp39_ = budgie_panel_manager_load_applet_instance (_tmp36_, _tmp37_, &_tmp38_, NULL);
	_g_free0 (rname);
	rname = _tmp38_;
	info = _tmp39_;
	_tmp40_ = info;
	if (_tmp40_ == NULL) {
		g_critical ("panel.vala:860: Failed to load applet when we know it exists");
		_g_object_unref0 (info);
		_g_free0 (rname);
		return;
	}
	_tmp41_ = info;
	budgie_panel_add_applet (self, _tmp41_);
	_g_object_unref0 (info);
	_g_free0 (rname);
}


static void budgie_panel_real_map (GtkWidget* base) {
	BudgiePanel * self;
	self = (BudgiePanel*) base;
	GTK_WIDGET_CLASS (budgie_panel_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel));
	budgie_panel_placement (self);
}


static void budgie_panel_real_get_preferred_width (GtkWidget* base, gint* m, gint* n) {
	BudgiePanel * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	self = (BudgiePanel*) base;
	_tmp0_ = self->priv->scr;
	_tmp1_ = _tmp0_.width;
	_vala_m = _tmp1_;
	_tmp2_ = self->priv->scr;
	_tmp3_ = _tmp2_.width;
	_vala_n = _tmp3_;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}


static void budgie_panel_real_get_preferred_width_for_height (GtkWidget* base, gint h, gint* m, gint* n) {
	BudgiePanel * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	self = (BudgiePanel*) base;
	_tmp0_ = self->priv->scr;
	_tmp1_ = _tmp0_.width;
	_vala_m = _tmp1_;
	_tmp2_ = self->priv->scr;
	_tmp3_ = _tmp2_.width;
	_vala_n = _tmp3_;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}


static void budgie_panel_real_get_preferred_height (GtkWidget* base, gint* m, gint* n) {
	BudgiePanel * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	self = (BudgiePanel*) base;
	_tmp0_ = self->priv->scr;
	_tmp1_ = _tmp0_.height;
	_vala_m = _tmp1_;
	_tmp2_ = self->priv->scr;
	_tmp3_ = _tmp2_.height;
	_vala_n = _tmp3_;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}


static void budgie_panel_real_get_preferred_height_for_width (GtkWidget* base, gint w, gint* m, gint* n) {
	BudgiePanel * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	self = (BudgiePanel*) base;
	_tmp0_ = self->priv->scr;
	_tmp1_ = _tmp0_.height;
	_vala_m = _tmp1_;
	_tmp2_ = self->priv->scr;
	_tmp3_ = _tmp2_.height;
	_vala_n = _tmp3_;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}


static gboolean ___lambda8_ (BudgiePanel* self) {
	gboolean result = FALSE;
	GdkWindow* _tmp0_ = NULL;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	if (_tmp0_ != NULL) {
		GdkWindow* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_focus (_tmp1_, (guint32) GDK_CURRENT_TIME);
	}
	gtk_window_present ((GtkWindow*) self);
	result = FALSE;
	return result;
}


static gboolean ____lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda8_ ((BudgiePanel*) self);
	return result;
}


void budgie_panel_set_expanded (BudgiePanel* self, gboolean expanded) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkAllocation alloc = {0};
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	GtkAllocation _tmp11_ = {0};
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->expanded;
	_tmp1_ = expanded;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = expanded;
	self->priv->expanded = _tmp2_;
	_tmp3_ = expanded;
	if (!_tmp3_) {
		GdkRectangle _tmp4_ = {0};
		_tmp4_ = self->priv->small_scr;
		self->priv->scr = _tmp4_;
	} else {
		GdkRectangle _tmp5_ = {0};
		_tmp5_ = self->priv->orig_scr;
		self->priv->scr = _tmp5_;
	}
	_tmp6_ = self->priv->scr;
	_tmp7_ = _tmp6_.width;
	_tmp8_ = self->priv->scr;
	_tmp9_ = _tmp8_.height;
	memset (&_tmp10_, 0, sizeof (GtkAllocation));
	_tmp10_.x = 0;
	_tmp10_.y = 0;
	_tmp10_.width = _tmp7_;
	_tmp10_.height = _tmp9_;
	alloc = _tmp10_;
	_tmp11_ = alloc;
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp11_);
	gtk_widget_queue_resize ((GtkWidget*) self);
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		_tmp12_ = gtk_events_pending ();
		if (!_tmp12_) {
			break;
		}
		gtk_main_iteration ();
	}
	_tmp13_ = expanded;
	if (_tmp13_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda8__gsource_func, g_object_ref (self), g_object_unref);
	}
}


static void budgie_panel_placement (BudgiePanel* self) {
	BudgiePanelPosition _tmp0_ = 0;
	BudgiePanelPosition _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	BudgiePanelPosition _tmp5_ = 0;
	BudgiePanelPosition _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->scale;
	budgie_set_struts ((GtkWindow*) self, _tmp1_, (glong) ((_tmp3_ - 5) * _tmp4_));
	_tmp5_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp6_ = _tmp5_;
	switch (_tmp6_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			GtkBox* _tmp7_ = NULL;
			GtkAlign _tmp8_ = 0;
			GtkAlign _tmp9_ = 0;
			GdkRectangle _tmp11_ = {0};
			gint _tmp12_ = 0;
			GdkRectangle _tmp13_ = {0};
			gint _tmp14_ = 0;
			GtkBox* _tmp15_ = NULL;
			BudgieShadowBlock* _tmp16_ = NULL;
			_tmp7_ = self->priv->main_layout;
			_tmp8_ = gtk_widget_get_valign ((GtkWidget*) _tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != GTK_ALIGN_START) {
				GtkBox* _tmp10_ = NULL;
				_tmp10_ = self->priv->main_layout;
				gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
			}
			gtk_window_set_gravity ((GtkWindow*) self, GDK_GRAVITY_NORTH_WEST);
			_tmp11_ = self->priv->orig_scr;
			_tmp12_ = _tmp11_.x;
			_tmp13_ = self->priv->orig_scr;
			_tmp14_ = _tmp13_.y;
			gtk_window_move ((GtkWindow*) self, _tmp12_, _tmp14_);
			_tmp15_ = self->priv->main_layout;
			_tmp16_ = self->priv->shadow;
			gtk_container_child_set ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_, "position", 1, NULL);
			break;
		}
		default:
		{
			GtkBox* _tmp17_ = NULL;
			GtkAlign _tmp18_ = 0;
			GtkAlign _tmp19_ = 0;
			GdkRectangle _tmp21_ = {0};
			gint _tmp22_ = 0;
			GdkRectangle _tmp23_ = {0};
			gint _tmp24_ = 0;
			GdkRectangle _tmp25_ = {0};
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			GtkBox* _tmp29_ = NULL;
			BudgieShadowBlock* _tmp30_ = NULL;
			_tmp17_ = self->priv->main_layout;
			_tmp18_ = gtk_widget_get_valign ((GtkWidget*) _tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_ != GTK_ALIGN_END) {
				GtkBox* _tmp20_ = NULL;
				_tmp20_ = self->priv->main_layout;
				gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_END);
			}
			gtk_window_set_gravity ((GtkWindow*) self, GDK_GRAVITY_SOUTH_WEST);
			_tmp21_ = self->priv->orig_scr;
			_tmp22_ = _tmp21_.x;
			_tmp23_ = self->priv->orig_scr;
			_tmp24_ = _tmp23_.y;
			_tmp25_ = self->priv->orig_scr;
			_tmp26_ = _tmp25_.height;
			_tmp27_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
			_tmp28_ = _tmp27_;
			gtk_window_move ((GtkWindow*) self, _tmp22_, _tmp24_ + (_tmp26_ - _tmp28_));
			_tmp29_ = self->priv->main_layout;
			_tmp30_ = self->priv->shadow;
			gtk_container_child_set ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_, "position", 0, NULL);
			break;
		}
	}
}


static gboolean budgie_panel_applet_at_start_of_region (BudgiePanel* self, BudgieAppletInfo* info) {
	gboolean result = FALSE;
	BudgieAppletInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = info;
	g_object_get (_tmp0_, "position", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}


static gboolean budgie_panel_applet_at_end_of_region (BudgiePanel* self, BudgieAppletInfo* info) {
	gboolean result = FALSE;
	BudgieAppletInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	BudgieAppletInfo* _tmp3_ = NULL;
	BudgieApplet* _tmp4_ = NULL;
	BudgieApplet* _tmp5_ = NULL;
	BudgieApplet* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = info;
	g_object_get (_tmp0_, "position", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = info;
	g_object_get (_tmp3_, "applet", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp6_);
	_tmp8_ = gtk_container_get_children (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_list_length (_tmp9_);
	_tmp11_ = ((guint) _tmp2_) >= (_tmp10_ - 1);
	_g_list_free0 (_tmp9_);
	_g_object_unref0 (_tmp6_);
	result = _tmp11_;
	return result;
}


static gchar* budgie_panel_get_box_left (BudgiePanel* self, BudgieAppletInfo* info) {
	gchar* result = NULL;
	GtkWidget* parent = NULL;
	BudgieAppletInfo* _tmp0_ = NULL;
	BudgieApplet* _tmp1_ = NULL;
	BudgieApplet* _tmp2_ = NULL;
	BudgieApplet* _tmp3_ = NULL;
	GtkContainer* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	parent = NULL;
	_tmp0_ = info;
	g_object_get (_tmp0_, "applet", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp3_);
	parent = (GtkWidget*) _tmp4_;
	_tmp5_ = parent;
	_tmp6_ = self->priv->end_box;
	_tmp7_ = _tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget);
	_g_object_unref0 (_tmp3_);
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		_tmp8_ = g_strdup ("center");
		result = _tmp8_;
		return result;
	} else {
		GtkWidget* _tmp9_ = NULL;
		GtkBox* _tmp10_ = NULL;
		_tmp9_ = parent;
		_tmp10_ = self->priv->center_box;
		if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget)) {
			gchar* _tmp11_ = NULL;
			_tmp11_ = g_strdup ("start");
			result = _tmp11_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


static gchar* budgie_panel_get_box_right (BudgiePanel* self, BudgieAppletInfo* info) {
	gchar* result = NULL;
	GtkWidget* parent = NULL;
	BudgieAppletInfo* _tmp0_ = NULL;
	BudgieApplet* _tmp1_ = NULL;
	BudgieApplet* _tmp2_ = NULL;
	BudgieApplet* _tmp3_ = NULL;
	GtkContainer* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	parent = NULL;
	_tmp0_ = info;
	g_object_get (_tmp0_, "applet", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp3_);
	parent = (GtkWidget*) _tmp4_;
	_tmp5_ = parent;
	_tmp6_ = self->priv->start_box;
	_tmp7_ = _tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget);
	_g_object_unref0 (_tmp3_);
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		_tmp8_ = g_strdup ("center");
		result = _tmp8_;
		return result;
	} else {
		GtkWidget* _tmp9_ = NULL;
		GtkBox* _tmp10_ = NULL;
		_tmp9_ = parent;
		_tmp10_ = self->priv->center_box;
		if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget)) {
			gchar* _tmp11_ = NULL;
			_tmp11_ = g_strdup ("end");
			result = _tmp11_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


static gboolean budgie_panel_real_can_move_applet_left (BudgieToplevel* base, BudgieAppletInfo* info) {
	BudgiePanel * self;
	gboolean result = FALSE;
	BudgieAppletInfo* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	BudgieAppletInfo* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (BudgiePanel*) base;
	_tmp0_ = info;
	_tmp1_ = budgie_panel_applet_at_start_of_region (self, _tmp0_);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = info;
	_tmp3_ = budgie_panel_get_box_left (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean budgie_panel_real_can_move_applet_right (BudgieToplevel* base, BudgieAppletInfo* info) {
	BudgiePanel * self;
	gboolean result = FALSE;
	BudgieAppletInfo* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	BudgieAppletInfo* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (BudgiePanel*) base;
	_tmp0_ = info;
	_tmp1_ = budgie_panel_applet_at_end_of_region (self, _tmp0_);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = info;
	_tmp3_ = budgie_panel_get_box_right (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void budgie_panel_conflict_swap (BudgiePanel* self, BudgieAppletInfo* info, gint old_position) {
	const gchar* key = NULL;
	BudgieAppletInfo* val = NULL;
	BudgieAppletInfo* conflict = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	BudgieAppletInfo* _tmp24_ = NULL;
	BudgieAppletInfo* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	g_return_if_fail (self != NULL);
	conflict = NULL;
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		BudgieAppletInfo* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		BudgieAppletInfo* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp6_ = val;
		g_object_get (_tmp6_, "alignment", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = info;
		g_object_get (_tmp10_, "alignment", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strcmp0 (_tmp9_, _tmp13_) == 0;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp9_);
		if (_tmp14_) {
			BudgieAppletInfo* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			BudgieAppletInfo* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp15_ = val;
			g_object_get (_tmp15_, "position", &_tmp16_, NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = info;
			g_object_get (_tmp18_, "position", &_tmp19_, NULL);
			_tmp20_ = _tmp19_;
			_tmp5_ = _tmp17_ == _tmp20_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			BudgieAppletInfo* _tmp21_ = NULL;
			BudgieAppletInfo* _tmp22_ = NULL;
			_tmp21_ = info;
			_tmp22_ = val;
			_tmp4_ = _tmp21_ != _tmp22_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			BudgieAppletInfo* _tmp23_ = NULL;
			_tmp23_ = val;
			conflict = _tmp23_;
			break;
		}
	}
	_tmp24_ = conflict;
	if (_tmp24_ == NULL) {
		return;
	}
	_tmp25_ = conflict;
	_tmp26_ = old_position;
	g_object_set (_tmp25_, "position", _tmp26_, NULL);
}


static void budgie_panel_budge_em_right (BudgiePanel* self, const gchar* alignment) {
	const gchar* key = NULL;
	BudgieAppletInfo* val = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alignment != NULL);
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		BudgieAppletInfo* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = val;
		g_object_get (_tmp4_, "alignment", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = alignment;
		_tmp9_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
		_g_free0 (_tmp7_);
		if (_tmp9_) {
			BudgieAppletInfo* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp10_ = val;
			g_object_get (_tmp10_, "position", &_tmp11_, NULL);
			_tmp12_ = _tmp11_;
			g_object_set (_tmp10_, "position", _tmp12_ + 1, NULL);
		}
	}
}


static void budgie_panel_budge_em_left (BudgiePanel* self, const gchar* alignment, gint after) {
	const gchar* key = NULL;
	BudgieAppletInfo* val = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alignment != NULL);
	_tmp0_ = self->priv->applets;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		BudgieAppletInfo* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = val;
		g_object_get (_tmp4_, "alignment", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = alignment;
		_tmp9_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
		_g_free0 (_tmp7_);
		if (_tmp9_) {
			BudgieAppletInfo* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			_tmp10_ = val;
			g_object_get (_tmp10_, "position", &_tmp11_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = after;
			if (_tmp12_ > _tmp13_) {
				BudgieAppletInfo* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				_tmp14_ = val;
				g_object_get (_tmp14_, "position", &_tmp15_, NULL);
				_tmp16_ = _tmp15_;
				g_object_set (_tmp14_, "position", _tmp16_ - 1, NULL);
			}
		}
	}
}


static void budgie_panel_real_move_applet_left (BudgieToplevel* base, BudgieAppletInfo* info) {
	BudgiePanel * self;
	gchar* new_home = NULL;
	gint new_position = 0;
	BudgieAppletInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint old_position = 0;
	BudgieAppletInfo* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	BudgieAppletInfo* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	BudgieAppletInfo* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	self = (BudgiePanel*) base;
	new_home = NULL;
	_tmp0_ = info;
	g_object_get (_tmp0_, "position", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	new_position = _tmp2_;
	_tmp3_ = info;
	g_object_get (_tmp3_, "position", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	old_position = _tmp5_;
	_tmp6_ = info;
	_tmp7_ = budgie_panel_applet_at_start_of_region (self, _tmp6_);
	if (!_tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		BudgieAppletInfo* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		BudgieAppletInfo* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		_tmp8_ = new_position;
		new_position = _tmp8_ - 1;
		_tmp9_ = new_position;
		if (_tmp9_ < 0) {
			new_position = 0;
		}
		_tmp10_ = info;
		_tmp11_ = new_position;
		g_object_set (_tmp10_, "position", _tmp11_, NULL);
		_tmp12_ = info;
		_tmp13_ = old_position;
		budgie_panel_conflict_swap (self, _tmp12_, _tmp13_);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
		_g_free0 (new_home);
		return;
	}
	_tmp14_ = info;
	_tmp15_ = budgie_panel_get_box_left (self, _tmp14_);
	_g_free0 (new_home);
	new_home = _tmp15_;
	_tmp16_ = new_home;
	if (_tmp16_ != NULL) {
		GtkBox* new_parent = NULL;
		BudgieAppletInfo* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GQuark _tmp22_ = 0U;
		static GQuark _tmp21_label0 = 0;
		static GQuark _tmp21_label1 = 0;
		gchar* old_home = NULL;
		BudgieAppletInfo* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		guint len = 0U;
		GtkBox* _tmp29_ = NULL;
		GList* _tmp30_ = NULL;
		GList* _tmp31_ = NULL;
		guint _tmp32_ = 0U;
		guint _tmp33_ = 0U;
		BudgieAppletInfo* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		BudgieAppletInfo* _tmp36_ = NULL;
		guint _tmp37_ = 0U;
		const gchar* _tmp38_ = NULL;
		new_parent = NULL;
		_tmp17_ = info;
		g_object_get (_tmp17_, "alignment", &_tmp18_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
		g_free (_tmp20_);
		if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("end")))) {
			switch (0) {
				default:
				{
					GtkBox* _tmp23_ = NULL;
					_tmp23_ = self->priv->center_box;
					new_parent = _tmp23_;
					break;
				}
			}
		} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("center")))) {
			switch (0) {
				default:
				{
					GtkBox* _tmp24_ = NULL;
					_tmp24_ = self->priv->start_box;
					new_parent = _tmp24_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					GtkBox* _tmp25_ = NULL;
					_tmp25_ = self->priv->end_box;
					new_parent = _tmp25_;
					break;
				}
			}
		}
		_tmp26_ = info;
		g_object_get (_tmp26_, "alignment", &_tmp27_, NULL);
		_tmp28_ = _tmp27_;
		old_home = _tmp28_;
		_tmp29_ = new_parent;
		_tmp30_ = gtk_container_get_children ((GtkContainer*) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_list_length (_tmp31_);
		_tmp33_ = _tmp32_;
		_g_list_free0 (_tmp31_);
		len = _tmp33_;
		_tmp34_ = info;
		_tmp35_ = new_home;
		g_object_set (_tmp34_, "alignment", _tmp35_, NULL);
		_tmp36_ = info;
		_tmp37_ = len;
		g_object_set (_tmp36_, "position", (gint) _tmp37_, NULL);
		_tmp38_ = old_home;
		budgie_panel_budge_em_left (self, _tmp38_, 0);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
		_g_free0 (old_home);
	}
	_g_free0 (new_home);
}


static void budgie_panel_real_move_applet_right (BudgieToplevel* base, BudgieAppletInfo* info) {
	BudgiePanel * self;
	gchar* new_home = NULL;
	gint new_position = 0;
	BudgieAppletInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint old_position = 0;
	BudgieAppletInfo* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint len = 0U;
	BudgieAppletInfo* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	BudgieAppletInfo* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	self = (BudgiePanel*) base;
	new_home = NULL;
	_tmp0_ = info;
	g_object_get (_tmp0_, "position", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	new_position = _tmp2_;
	_tmp3_ = info;
	g_object_get (_tmp3_, "position", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	old_position = _tmp5_;
	_tmp6_ = info;
	_tmp7_ = budgie_panel_applet_at_end_of_region (self, _tmp6_);
	if (!_tmp7_) {
		gint _tmp8_ = 0;
		BudgieAppletInfo* _tmp9_ = NULL;
		BudgieApplet* _tmp10_ = NULL;
		BudgieApplet* _tmp11_ = NULL;
		BudgieApplet* _tmp12_ = NULL;
		GtkContainer* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		gint _tmp17_ = 0;
		guint _tmp18_ = 0U;
		BudgieAppletInfo* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		BudgieAppletInfo* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		_tmp8_ = new_position;
		new_position = _tmp8_ + 1;
		_tmp9_ = info;
		g_object_get (_tmp9_, "applet", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp12_);
		_tmp14_ = gtk_container_get_children (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_list_length (_tmp15_);
		len = _tmp16_ - 1;
		_g_list_free0 (_tmp15_);
		_g_object_unref0 (_tmp12_);
		_tmp17_ = new_position;
		_tmp18_ = len;
		if (((guint) _tmp17_) > _tmp18_) {
			guint _tmp19_ = 0U;
			_tmp19_ = len;
			new_position = (gint) _tmp19_;
		}
		_tmp20_ = info;
		_tmp21_ = new_position;
		g_object_set (_tmp20_, "position", _tmp21_, NULL);
		_tmp22_ = info;
		_tmp23_ = old_position;
		budgie_panel_conflict_swap (self, _tmp22_, _tmp23_);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
		_g_free0 (new_home);
		return;
	}
	_tmp24_ = info;
	_tmp25_ = budgie_panel_get_box_right (self, _tmp24_);
	_g_free0 (new_home);
	new_home = _tmp25_;
	_tmp26_ = new_home;
	if (_tmp26_ != NULL) {
		const gchar* _tmp27_ = NULL;
		BudgieAppletInfo* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		BudgieAppletInfo* _tmp30_ = NULL;
		_tmp27_ = new_home;
		budgie_panel_budge_em_right (self, _tmp27_);
		_tmp28_ = info;
		_tmp29_ = new_home;
		g_object_set (_tmp28_, "alignment", _tmp29_, NULL);
		_tmp30_ = info;
		g_object_set (_tmp30_, "position", 0, NULL);
		g_signal_emit_by_name ((BudgieToplevel*) self, "applets-changed");
	}
	_g_free0 (new_home);
}


static gboolean budgie_panel_real_draw (GtkWidget* base, cairo_t* cr) {
	BudgiePanel * self;
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp4_ = {0};
	cairo_surface_t* buffer = NULL;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	cairo_surface_t* _tmp9_ = NULL;
	cairo_t* cr2 = NULL;
	cairo_surface_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	GtkWidget* _tmp12_ = NULL;
	cairo_t* _tmp13_ = NULL;
	gdouble d = 0.0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gdouble y = 0.0;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	BudgiePanelPosition _tmp18_ = 0;
	BudgiePanelPosition _tmp19_ = 0;
	cairo_t* _tmp26_ = NULL;
	self = (BudgiePanel*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->render_scale;
	if (_tmp0_ == 0.0) {
		cairo_t* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = cr;
		_tmp2_ = GTK_WIDGET_CLASS (budgie_panel_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel), _tmp1_);
		result = _tmp2_;
		return result;
	} else {
		gdouble _tmp3_ = 0.0;
		_tmp3_ = self->priv->render_scale;
		if (_tmp3_ == 1.0) {
			result = GDK_EVENT_STOP;
			return result;
		}
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
	alloc = _tmp4_;
	_tmp5_ = alloc;
	_tmp6_ = _tmp5_.width;
	_tmp7_ = alloc;
	_tmp8_ = _tmp7_.height;
	_tmp9_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp6_, _tmp8_);
	buffer = _tmp9_;
	_tmp10_ = buffer;
	_tmp11_ = cairo_create (_tmp10_);
	cr2 = _tmp11_;
	_tmp12_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp13_ = cr2;
	gtk_container_propagate_draw ((GtkContainer*) self, _tmp12_, _tmp13_);
	_tmp14_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) self);
	_tmp15_ = _tmp14_;
	d = (gdouble) _tmp15_;
	_tmp16_ = d;
	_tmp17_ = self->priv->render_scale;
	y = _tmp16_ * _tmp17_;
	_tmp18_ = budgie_toplevel_get_position ((BudgieToplevel*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == BUDGIE_PANEL_POSITION_TOP) {
		cairo_t* _tmp20_ = NULL;
		cairo_surface_t* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		_tmp20_ = cr;
		_tmp21_ = buffer;
		_tmp22_ = y;
		cairo_set_source_surface (_tmp20_, _tmp21_, (gdouble) 0, -_tmp22_);
	} else {
		cairo_t* _tmp23_ = NULL;
		cairo_surface_t* _tmp24_ = NULL;
		gdouble _tmp25_ = 0.0;
		_tmp23_ = cr;
		_tmp24_ = buffer;
		_tmp25_ = y;
		cairo_set_source_surface (_tmp23_, _tmp24_, (gdouble) 0, _tmp25_);
	}
	_tmp26_ = cr;
	cairo_paint (_tmp26_);
	result = GDK_EVENT_STOP;
	_cairo_destroy0 (cr2);
	_cairo_surface_destroy0 (buffer);
	return result;
}


/**
     * Specialist operation, perform a migration after we changed applet configurations
     * See: https://github.com/solus-project/budgie-desktop/issues/555
     */
void budgie_panel_perform_migration (BudgiePanel* self, gint current_migration_level) {
	gint _tmp0_ = 0;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = current_migration_level;
	if (_tmp0_ != 0) {
		gint _tmp1_ = 0;
		_tmp1_ = current_migration_level;
		g_warning ("panel.vala:1160: Unknown migration level: %d", _tmp1_);
		return;
	}
	self->priv->need_migratory = TRUE;
	_tmp2_ = self->priv->is_fully_loaded;
	if (_tmp2_) {
		g_message ("panel.vala:1165: Performing migration to level %d", BUDGIE_BUDGIE_MIGRATION_LEVEL);
		budgie_panel_add_migratory (self);
	}
}


/**
     * Very simple right now. Just add the applets to the end of the panel
     */
static gboolean budgie_panel_add_migratory (BudgiePanel* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->need_migratory;
		g_rec_mutex_lock (&self->priv->__lock_need_migratory);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->need_migratory;
			if (!_tmp1_) {
				result = FALSE;
				{
					gboolean _tmp2_ = FALSE;
					_tmp2_ = self->priv->need_migratory;
					g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
				}
				return result;
			}
			self->priv->need_migratory = FALSE;
			{
				const gchar** new_applet_collection = NULL;
				gint new_applet_collection_length1 = 0;
				gint _new_applet_collection_size_ = 0;
				gint new_applet_it = 0;
				new_applet_collection = BUDGIE_MIGRATION_1_APPLETS;
				new_applet_collection_length1 = G_N_ELEMENTS (BUDGIE_MIGRATION_1_APPLETS);
				for (new_applet_it = 0; new_applet_it < G_N_ELEMENTS (BUDGIE_MIGRATION_1_APPLETS); new_applet_it = new_applet_it + 1) {
					const gchar* new_applet = NULL;
					new_applet = new_applet_collection[new_applet_it];
					{
						const gchar* _tmp3_ = NULL;
						const gchar* _tmp4_ = NULL;
						GtkBox* _tmp5_ = NULL;
						_tmp3_ = new_applet;
						g_message ("panel.vala:1181: Adding migratory applet: %s", _tmp3_);
						_tmp4_ = new_applet;
						_tmp5_ = self->priv->end_box;
						budgie_panel_add_new_applet_at (self, _tmp4_, _tmp5_);
					}
				}
			}
		}
		__finally14:
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = self->priv->need_migratory;
			g_rec_mutex_unlock (&self->priv->__lock_need_migratory);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = FALSE;
	return result;
}


GSettings* budgie_panel_get_settings (BudgiePanel* self) {
	GSettings* result;
	GSettings* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}


void budgie_panel_set_settings (BudgiePanel* self, GSettings* value) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	g_object_notify ((GObject *) self, "settings");
}


gdouble budgie_panel_get_nscale (BudgiePanel* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->render_scale;
	result = _tmp0_;
	return result;
}


void budgie_panel_set_nscale (BudgiePanel* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->render_scale = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "nscale");
}


static GObject * budgie_panel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BudgiePanel * self;
	parent_class = G_OBJECT_CLASS (budgie_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL, BudgiePanel);
	budgie_toplevel_set_position ((BudgieToplevel*) self, BUDGIE_PANEL_POSITION_NONE);
	return obj;
}


static void budgie_panel_class_init (BudgiePanelClass * klass) {
	budgie_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgiePanelPrivate));
	((BudgieToplevelClass *) klass)->reset_shadow = budgie_panel_real_reset_shadow;
	((BudgieToplevelClass *) klass)->get_applets = budgie_panel_real_get_applets;
	((BudgieToplevelClass *) klass)->add_new_applet = budgie_panel_real_add_new_applet;
	((BudgieToplevelClass *) klass)->remove_applet = budgie_panel_real_remove_applet;
	((GtkWidgetClass *) klass)->map = budgie_panel_real_map;
	((GtkWidgetClass *) klass)->get_preferred_width = budgie_panel_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = budgie_panel_real_get_preferred_width_for_height;
	((GtkWidgetClass *) klass)->get_preferred_height = budgie_panel_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = budgie_panel_real_get_preferred_height_for_width;
	((BudgieToplevelClass *) klass)->can_move_applet_left = budgie_panel_real_can_move_applet_left;
	((BudgieToplevelClass *) klass)->can_move_applet_right = budgie_panel_real_can_move_applet_right;
	((BudgieToplevelClass *) klass)->move_applet_left = budgie_panel_real_move_applet_left;
	((BudgieToplevelClass *) klass)->move_applet_right = budgie_panel_real_move_applet_right;
	((GtkWidgetClass *) klass)->draw = budgie_panel_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_panel_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_PANEL_SETTINGS, g_param_spec_object ("settings", "settings", "settings", G_TYPE_SETTINGS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_PANEL_NSCALE, g_param_spec_double ("nscale", "nscale", "nscale", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("panel_loaded", BUDGIE_TYPE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void budgie_panel_instance_init (BudgiePanel * self) {
	gint* _tmp0_ = NULL;
	self->priv = BUDGIE_PANEL_GET_PRIVATE (self);
	self->priv->expanded = TRUE;
	self->priv->pending = NULL;
	self->priv->creating = NULL;
	self->priv->applets = NULL;
	self->priv->initial_config = NULL;
	g_rec_mutex_init (&self->priv->__lock_expected_uuids);
	self->priv->scale = 1;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 16;
	_tmp0_[1] = 24;
	_tmp0_[2] = 32;
	_tmp0_[3] = 48;
	_tmp0_[4] = 96;
	_tmp0_[5] = 128;
	_tmp0_[6] = 256;
	self->priv->icon_sizes = _tmp0_;
	self->priv->icon_sizes_length1 = 7;
	self->priv->_icon_sizes_size_ = self->priv->icon_sizes_length1;
	self->priv->is_fully_loaded = FALSE;
	g_rec_mutex_init (&self->priv->__lock_need_migratory);
	self->priv->need_migratory = FALSE;
	self->priv->render_scale = 0.0;
	self->priv->initial_anim = FALSE;
}


static void budgie_panel_finalize (GObject* obj) {
	BudgiePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL, BudgiePanel);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->main_layout);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->popover_manager);
	_g_object_unref0 (self->priv->shadow);
	_g_hash_table_unref0 (self->priv->pending);
	_g_hash_table_unref0 (self->priv->creating);
	_g_hash_table_unref0 (self->priv->applets);
	_g_hash_table_unref0 (self->priv->initial_config);
	g_rec_mutex_clear (&self->priv->__lock_expected_uuids);
	__g_list_free__g_free0_0 (self->priv->expected_uuids);
	_g_object_unref0 (self->priv->start_box);
	_g_object_unref0 (self->priv->center_box);
	_g_object_unref0 (self->priv->end_box);
	self->priv->icon_sizes = (g_free (self->priv->icon_sizes), NULL);
	g_rec_mutex_clear (&self->priv->__lock_need_migratory);
	G_OBJECT_CLASS (budgie_panel_parent_class)->finalize (obj);
}


/**
 * The toplevel window for a panel
 */
GType budgie_panel_get_type (void) {
	static volatile gsize budgie_panel_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanel), 0, (GInstanceInitFunc) budgie_panel_instance_init, NULL };
		GType budgie_panel_type_id;
		budgie_panel_type_id = g_type_register_static (BUDGIE_TYPE_TOPLEVEL, "BudgiePanel", &g_define_type_info, 0);
		g_once_init_leave (&budgie_panel_type_id__volatile, budgie_panel_type_id);
	}
	return budgie_panel_type_id__volatile;
}


static void _vala_budgie_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgiePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_PANEL, BudgiePanel);
	switch (property_id) {
		case BUDGIE_PANEL_SETTINGS:
		g_value_set_object (value, budgie_panel_get_settings (self));
		break;
		case BUDGIE_PANEL_NSCALE:
		g_value_set_double (value, budgie_panel_get_nscale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgiePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_PANEL, BudgiePanel);
	switch (property_id) {
		case BUDGIE_PANEL_SETTINGS:
		budgie_panel_set_settings (self, g_value_get_object (value));
		break;
		case BUDGIE_PANEL_NSCALE:
		budgie_panel_set_nscale (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



