/***************************************************************************
 *            song-properties.c
 *
 *  lun avr 10 18:39:17 2006
 *  Copyright  2006  Rouquier Philippe
 *  brasero-app@wanadoo.fr
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n.h>

#include <gtk/gtkdialog.h>
#include <gtk/gtkbox.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkstock.h>
#include <gtk/gtktable.h>

#include "song-properties.h"

static void brasero_song_props_class_init (BraseroSongPropsClass *klass);
static void brasero_song_props_init (BraseroSongProps *sp);
static void brasero_song_props_finalize (GObject *object);

struct BraseroSongPropsPrivate {
	GtkWidget *title;
	GtkWidget *artist;
	GtkWidget *composer;
	GtkWidget *isrc;
	GtkWidget *label;
};

static GObjectClass *parent_class = NULL;

GType
brasero_song_props_get_type ()
{
	static GType type = 0;

	if(type == 0) {
		static const GTypeInfo our_info = {
			sizeof (BraseroSongPropsClass),
			NULL,
			NULL,
			(GClassInitFunc)brasero_song_props_class_init,
			NULL,
			NULL,
			sizeof (BraseroSongProps),
			0,
			(GInstanceInitFunc)brasero_song_props_init,
		};

		type = g_type_register_static (GTK_TYPE_DIALOG, 
					       "BraseroSongProps",
					       &our_info,
					       0);
	}

	return type;
}

static void
brasero_song_props_class_init (BraseroSongPropsClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS(klass);

	parent_class = g_type_class_peek_parent(klass);
	object_class->finalize = brasero_song_props_finalize;
}

static void
brasero_song_props_init (BraseroSongProps *obj)
{
	GtkWidget *label;
	GtkWidget *table;

	obj->priv = g_new0 (BraseroSongPropsPrivate, 1);
	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (obj)->vbox), 0);
	gtk_window_set_default_size (GTK_WINDOW (obj), 400, 300);

	obj->priv->label = gtk_label_new (NULL);
	gtk_label_set_single_line_mode (GTK_LABEL (obj->priv->label), FALSE);
	gtk_label_set_use_markup (GTK_LABEL (obj->priv->label), TRUE);
	gtk_label_set_justify (GTK_LABEL (obj->priv->label), GTK_JUSTIFY_FILL);
	gtk_label_set_line_wrap (GTK_LABEL (obj->priv->label), TRUE);
	gtk_misc_set_alignment (GTK_MISC (obj->priv->label), 0.0, 0.5);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (obj)->vbox), obj->priv->label, FALSE, FALSE, 4);

	label = gtk_label_new (_("This information will be written to the disc using CD-TEXT technology.\n"
				 "It can be read and displayed by some audio CD players."));
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_FILL);
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (obj)->vbox), label, FALSE, FALSE, 0);
	gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

	table = gtk_table_new (4, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (table), 8);
	gtk_table_set_col_spacings (GTK_TABLE (table), 6);

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (obj)->vbox), table, TRUE, TRUE, 12);

	label = gtk_label_new (_("Title:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	obj->priv->title = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), obj->priv->title, 1, 2, 0, 1);

	label = gtk_label_new (_("Artist:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	obj->priv->artist = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), obj->priv->artist, 1, 2, 1, 2);

	label = gtk_label_new (_("Composer:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	obj->priv->composer = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), obj->priv->composer, 1, 2, 2, 3);

	label = gtk_label_new ("ISRC:");
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	obj->priv->isrc = gtk_entry_new ();
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
	gtk_table_attach_defaults (GTK_TABLE (table), obj->priv->isrc, 1, 2, 3, 4);

	gtk_dialog_add_buttons (GTK_DIALOG (obj),
				GTK_STOCK_APPLY, GTK_RESPONSE_ACCEPT,
				GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				NULL);

	gtk_window_set_title (GTK_WINDOW (obj), _("Song information"));
}

static void
brasero_song_props_finalize (GObject *object)
{
	BraseroSongProps *cobj;

	cobj = BRASERO_SONG_PROPS(object);
	
	g_free (cobj->priv);

	G_OBJECT_CLASS (parent_class)->finalize (object);
}

GtkWidget *
brasero_song_props_new ()
{
	BraseroSongProps *obj;
	
	obj = BRASERO_SONG_PROPS (g_object_new (BRASERO_TYPE_SONG_PROPS, NULL));
	
	return GTK_WIDGET (obj);
}

void
brasero_song_props_get_properties (BraseroSongProps *self,
				   char **artist,
				   char **title,
				   char **composer,
				   int *isrc)
{
	if (artist)
		*artist = g_strdup (gtk_entry_get_text (GTK_ENTRY (self->priv->artist)));
	if (title)
		*title = g_strdup (gtk_entry_get_text (GTK_ENTRY (self->priv->title)));
	if (composer)
		*composer = g_strdup (gtk_entry_get_text (GTK_ENTRY (self->priv->composer)));
	if (isrc) {
		const char *string;

		string = gtk_entry_get_text (GTK_ENTRY (self->priv->isrc));
		*isrc = (int) g_strtod (string, NULL);
	}
		
}

void
brasero_song_props_set_properties (BraseroSongProps *self,
				   int track_num,
				   const char *artist,
				   const char *title,
				   const char *composer,
				   int isrc)
{
	char *string;

	string = g_strdup_printf (_("<b><big>Song information for track %02i</big></b>"), track_num);
	gtk_label_set_markup (GTK_LABEL (self->priv->label), string);
	g_free (string);

	if (artist)
		gtk_entry_set_text (GTK_ENTRY (self->priv->artist), artist);
	if (title)
		gtk_entry_set_text (GTK_ENTRY (self->priv->title), title);
	if (composer)
		gtk_entry_set_text (GTK_ENTRY (self->priv->composer), composer);
	if (isrc) {
		char *string;

		string = g_strdup_printf ("%i", isrc);
		gtk_entry_set_text (GTK_ENTRY (self->priv->isrc), string);
		g_free (string);
	}
}
