#include <signal.h>
#include <stdio.h>
#include <sys/ucontext.h>
#include <stdlib.h>
#include <execinfo.h>

#if #cpu(i386)
void show_registers(struct sigcontext *ctx)
{
  fprintf(stderr, "Registers:\n");
  fprintf(stderr, "  EAX: %08lx  EBX: %08lx  ECX: %08lx  EDX: %08lx\n",
	  ctx->eax, ctx->ebx, ctx->ecx, ctx->edx);
  fprintf(stderr, "  EDI: %08lx  ESI: %08lx  EBP: %08lx  ESP: %08lx\n\n",
	  ctx->edi, ctx->esi, ctx->ebp, ctx->esp);
  fprintf(stderr, "  EIP: %08lx  EFLAGS: %08lx\n\n", ctx->eip, ctx->eflags);
  fprintf(stderr, "  Trap: %08lx  Code: %08lx\n", ctx->trapno, ctx->err);
}
#endif /* i386 */

#if #cpu(arm)
void show_registers(struct sigcontext *ctx)
{
  fprintf(stderr, "Registers:\n");
  fprintf(stderr, "  R0: %08lx  R1: %08lx  R2: %08lx  R3: %08lx\n",
	  ctx->arm_r0, ctx->arm_r1, ctx->arm_r2, ctx->arm_r3);
  fprintf(stderr, "  R4: %08lx  R5: %08lx  R6: %08lx  R7: %08lx\n",
	  ctx->arm_r4, ctx->arm_r5, ctx->arm_r6, ctx->arm_r7);
  fprintf(stderr, "  R8: %08lx  R9: %08lx  SL: %08lx  FP: %08lx\n",
	  ctx->arm_r8, ctx->arm_r9, ctx->arm_r10, ctx->arm_fp);
  fprintf(stderr, "  IP: %08lx  SP: %08lx  LR: %08lx  PC: %08lx\n",
	  ctx->arm_ip, ctx->arm_sp, ctx->arm_lr, ctx->arm_pc);
  fprintf(stderr, "  CPSR: %08lx  Addr: %08lx\n", ctx->arm_cpsr,
	  ctx->fault_address);
}
#endif /* arm */

void catch_segv(int sig, struct siginfo *info, struct ucontext *ctx)
{
#if #cpu(i386) || #cpu(arm)
  struct sigcontext *sc = &ctx->uc_mcontext;
#endif
  void *bfp[20];
  int bc;
  fprintf(stderr, "*** Segmentation fault\n");
#if #cpu(i386) || #cpu(arm)
  show_registers(sc);
#endif
  fprintf(stderr, "Backtrace:\n");
  bc = backtrace(bfp, 20);
  backtrace_symbols_fd(bfp, bc, 2); 
  fprintf(stderr, "*** Press RETURN to continue\n");
  getchar();
  exit(128+sig);
}

void install_segv_handler(void)
{
  struct sigaction sa;
  sa.sa_handler = catch_segv;
  sa.sa_flags = SA_SIGINFO;
  if (sigaction(SIGSEGV, &sa, NULL))
    perror("sigaction");
  if (sigaction(SIGILL, &sa, NULL))
    perror("sigaction");
}
