#! /bin/bash
#
# create a tarball, keymaps.tgz with essential compiled keymaps in it

. ./common.sh

if [ $# != 1 ]; then
    error "usage: $0 archive-path"
fi

archive=$1

curdir=`pwd`

if [ ${debug} ${verbose} ]; then
    loadkeysarg="-v"
else
    loadkeysarg="-q"
fi

##
## Keymap list
##   must keep utilities/dbootstrap/kbdconfig.c sync'd up with this
##
case "$arch" in
    m68k)
        # sync'd 16 Sept 2001, aph
        # removed 24.09.2001, cts: mac/mac-de-latin1-nodeadkeys.kmap.gz
	export keymaps="amiga/amiga-de.kmap.gz
	amiga/amiga-es.kmap.gz
	amiga/amiga-fr.kmap.gz
	amiga/amiga-it.kmap.gz
	amiga/amiga-us.kmap.gz
	amiga/amiga-se.kmap.gz
	amiga/amiga-sg.kmap.gz
	atari/atari-us.kmap.gz
	atari/atari-de.kmap.gz
	atari/atari-se.kmap.gz
	atari/atari-uk.kmap.gz
	mac/mac-us-std.kmap.gz
	mac/mac-us-ext.kmap.gz
	mac/mac-de2-ext.kmap.gz
	mac/mac-fr2-ext.kmap.gz
	mac/mac-fr3.kmap.gz"
	;;
    powerpc)
        # sync'd 16 Sept 2001, aph
	export keymaps="i386/qwerty/us.kmap.gz
	i386/azerty/be-latin1.kmap.gz
	i386/qwerty/br-abnt2.kmap.gz
	i386/qwerty/br-latin1.kmap.gz
	i386/qwerty/bg.kmap.gz
	i386/qwertz/croat.kmap.gz
	i386/qwerty/cz-lat2.kmap.gz
	i386/qwerty/dk-latin1.kmap.gz
	i386/dvorak/dvorak.kmap.gz
	i386/qwerty/es.kmap.gz
	i386/qwerty/fi-latin1.kmap.gz
	i386/azerty/fr-latin0.kmap.gz
	i386/azerty/fr-latin1.kmap.gz
	i386/qwerty/cf.kmap.gz
	i386/qwertz/de-latin1-nodeadkeys.kmap.gz
	i386/qwerty/hebrew.kmap.gz
	i386/qwertz/hu.kmap.gz
	i386/qwerty/is-latin1.kmap.gz
	i386/qwerty/it.kmap.gz
	i386/qwerty/jp106.kmap.gz
	i386/qwerty/no-latin1.kmap.gz
	i386/qwerty/pl.kmap.gz
	i386/qwerty/pt-latin1.kmap.gz
	i386/qwerty/ru.kmap.gz
	i386/qwerty/se-latin1.kmap.gz
	i386/qwertz/slovene.kmap.gz
	i386/qwerty/sk-qwerty.kmap.gz
        i386/qwertz/fr_CH-latin1.kmap.gz
        i386/qwertz/sg-latin1.kmap.gz
	i386/qwerty/trq.kmap.gz
	i386/qwerty/uk.kmap.gz
	i386/qwerty/mac-usb-us.kmap.gz
	i386/azerty/mac-usb-fr.kmap.gz
	i386/qwertz/mac-usb-de-latin1-nodeadkeys.kmap.gz
	amiga/amiga-us.kmap.gz
	amiga/amiga-fr.kmap.gz
	amiga/amiga-de.kmap.gz
	amiga/amiga-it.kmap.gz
	amiga/amiga-es.kmap.gz
	amiga/amiga-se.kmap.gz
	amiga/amiga-sg.kmap.gz"
	;;
    sparc)
        # sync'd 23 Sept 2001, aph
	export keymaps="sun/sunkeymap.kmap.gz
	i386/qwerty/us.kmap.gz
        sun/sundvorak.kmap.gz
	sun/sunt5-fi-latin1.kmap.gz
	sun/sunt5-fr-latin1.kmap.gz
	sun/sunt5-de-latin1.kmap.gz
	sun/sunt5-ru.kmap.gz
	sun/sunt4-es.kmap.gz
	sun/sunt5-es.kmap.gz
        sun/sun-pl.kmap.gz
        sun/sunt5-cz-us.kmap.gz 
        sun/sunt5-uk.kmap.gz"
	;;
    arm)
        # sync'd 23 Sept 2001, aph
	export keymaps="i386/qwerty/us.kmap.gz
        i386/azerty/be-latin1.kmap.gz
	i386/qwerty/br-abnt2.kmap.gz
	i386/qwerty/br-latin1.kmap.gz
	i386/qwerty/bg.kmap.gz
	i386/qwertz/croat.kmap.gz
	i386/qwerty/cz-lat2.kmap.gz
	i386/qwerty/dk-latin1.kmap.gz
	i386/dvorak/dvorak.kmap.gz
	i386/qwerty/fi-latin1.kmap.gz
	i386/azerty/fr-latin0.kmap.gz
	i386/azerty/fr-latin1.kmap.gz
	i386/qwerty/cf.kmap.gz
	i386/qwertz/de-latin1-nodeadkeys.kmap.gz
	i386/qwerty/hebrew.kmap.gz
	i386/qwertz/hu.kmap.gz
	i386/qwerty/is-latin1.kmap.gz
	i386/qwerty/it.kmap.gz
	i386/qwerty/jp106.kmap.gz
	i386/qwerty/no-latin1.kmap.gz
	i386/qwerty/pl.kmap.gz
	i386/qwerty/pt-latin1.kmap.gz
	i386/qwerty/ru.kmap.gz
	i386/qwerty/se-latin1.kmap.gz
	i386/qwertz/slovene.kmap.gz
	i386/qwerty/sk-qwerty.kmap.gz
	i386/qwerty/es.kmap.gz
        i386/qwertz/fr_CH-latin1.kmap.gz
        i386/qwertz/sg-latin1.kmap.gz
	i386/qwerty/trq.kmap.gz
	i386/qwerty/uk.kmap.gz"
	;;
    mips)
        # sync'd 23 Sept 2001, aph
        export keymaps="i386/qwerty/us.kmap.gz
        i386/azerty/be-latin1.kmap.gz
        i386/qwerty/bg.kmap.gz
        i386/qwertz/croat.kmap.gz
        i386/qwerty/cz-lat2.kmap.gz
        i386/qwerty/dk-latin1.kmap.gz
        i386/dvorak/dvorak.kmap.gz
        i386/qwerty/fi-latin1.kmap.gz
        i386/azerty/fr-latin0.kmap.gz
        i386/azerty/fr-latin1.kmap.gz
        i386/qwerty/cf.kmap.gz
        i386/qwertz/de-latin1-nodeadkeys.kmap.gz
        i386/qwerty/hebrew.kmap.gz
        i386/qwertz/hu.kmap.gz
        i386/qwerty/is-latin1.kmap.gz
        i386/qwerty/it.kmap.gz
        i386/qwerty/jp106.kmap.gz
        i386/qwerty/no-latin1.kmap.gz
        i386/qwerty/pl.kmap.gz
        i386/qwerty/pt-latin1.kmap.gz
        i386/qwerty/ru.kmap.gz
        i386/qwerty/se-latin1.kmap.gz
        i386/qwertz/slovene.kmap.gz
        i386/qwerty/sk-qwerty.kmap.gz
        i386/qwerty/es.kmap.gz
        i386/qwertz/fr_CH-latin1.kmap.gz
        i386/qwertz/sg-latin1.kmap.gz
        i386/qwerty/trq.kmap.gz
        i386/qwerty/uk.kmap.gz"
	;;
    *)
        # sync'd 23 Sept 2001, aph
	export keymaps="i386/qwerty/us.kmap.gz
        i386/azerty/be-latin1.kmap.gz
	i386/qwerty/br-abnt2.kmap.gz
	i386/qwerty/br-latin1.kmap.gz
	i386/qwerty/bg.kmap.gz
	i386/qwertz/croat.kmap.gz
	i386/qwerty/cz-lat2.kmap.gz
	i386/qwerty/dk-latin1.kmap.gz
	i386/dvorak/dvorak.kmap.gz
	i386/qwerty/fi-latin1.kmap.gz
	i386/azerty/fr-latin0.kmap.gz
	i386/azerty/fr-latin1.kmap.gz
	i386/qwerty/cf.kmap.gz
	i386/qwertz/de-latin1-nodeadkeys.kmap.gz
	i386/qwerty/hebrew.kmap.gz
	i386/qwertz/hu.kmap.gz
	i386/qwerty/is-latin1.kmap.gz
	i386/qwerty/it.kmap.gz
	i386/qwerty/jp106.kmap.gz
	i386/qwerty/no-latin1.kmap.gz
	i386/qwerty/pl.kmap.gz
	i386/qwerty/pt-latin1.kmap.gz
	i386/qwerty/ru.kmap.gz
	i386/qwerty/se-latin1.kmap.gz
	i386/qwertz/slovene.kmap.gz
	i386/qwerty/sk-qwerty.kmap.gz
	i386/qwerty/es.kmap.gz
        i386/qwertz/fr_CH-latin1.kmap.gz
        i386/qwertz/sg-latin1.kmap.gz
	i386/qwerty/trq.kmap.gz
	i386/qwerty/uk.kmap.gz"
	;;
esac

extractdir=${tmpdir}/boot-floppies/extract-tmp-$$
kmaptmpdir=${tmpdir}/boot-floppies/tmp-$$
scriptdir=`pwd`/utilities/writemaps

rm -rf $extractdir
make_tmpdir $extractdir

info "downloading console-data"
package=`grab_paths console-data`

info "extracting $package to $extractdir"
if [ -z "$package" ] || [ ! -f $package ]; then
    error "unable to find console-data package path"
fi
dpkg-deb --extract $package $extractdir

##
## creating binary keymaps
##

rm -rf $kmaptmpdir
make_tmpdir $kmaptmpdir

info "converting keymaps"
for i in $keymaps; do
    test -f $extractdir/usr/share/keymaps/$i
    debug "keymap $i"
    j=`basename $i .kmap.gz`
    k=`dirname $i`
    f=`basename $i`
    mkdir -p $kmaptmpdir/$k
    $scriptdir/loadkeys -b $loadkeysarg $extractdir/usr/share/keymaps/$k/$f > $kmaptmpdir/$k/${j}.bmap
done

if [ "$arch" = arm ]; then
    # generate Acorn legacy keymaps
    for k in `find $extractdir/usr/share/keymaps/i386 -name *.inc.gz` \
             `find $extractdir/usr/share/keymaps/i386 -name *.kmap.gz`; do
        ka=`echo $k | sed 's/keymaps/keymaps-acorn/;s/\.gz$//'`
        mkdir -p `dirname $ka`
        zcat $k | /usr/share/console/ps2-to-riscpc > $ka
    done
    for kmap in $keymaps; do
        debug "keymap $kmap acorn"
        j=`basename $kmap .kmap.gz`
        k=`dirname $kmap | sed s:i386/::`
        mkdir -p $kmaptmpdir/acorn/$k
	$scriptdir/loadkeys -b $loadkeysarg $extractdir/usr/share/keymaps-acorn/i386/$k/$j.kmap > $kmaptmpdir/acorn/$k/${j}.bmap
    done
fi

rm -rf $extractdir

info "making keymaps.tgz"
( cd $kmaptmpdir && GZIP=-9 tar czf $curdir/keymaps.tgz * )
testexit

# check for empty tarball
[ -f keymaps.tgz ]
tar -tzf keymaps.tgz  | grep '.\+' >/dev/null 2>/dev/null || error "empty keymaps.tgz"

if [ ! ${debug} ]; then
    rm -rf $kmaptmpdir
fi

info keymap tarball is `ls -l keymaps.tgz`
