//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<T, 4>, 2240> laguerre3 = {{
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(0.61248773400035441372705568899743424188675775638604e9) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.35204789737752362425049635886299775785128782532338e10) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.53680020529340456542399945558001901900007952546989e10) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.44534031167752568381323984620072514172994661540171e11) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.12226434763229329677261432059244153549746269983841e12) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.51928144111428742292292453631991614690587389994904e12) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.97428426563622634057559347373791034771828164883086e12) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.3324381244018248505151003408444078258062512743881e14) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.33370020703520225304974334354074929274249826530701e14) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.80676208197265431223389966116130786752172758946929e14) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.37709198164073899574491439717306334644653651087643e15) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.43784677681230003590939175326930086254310296977861e15) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.71751164134703529160531275753374390004620108776236e15) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.75474163633107959381273333540455867778846765466731e15) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.10048213277050885981803871378237693755448856069989e16) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.10527174037983159903287634170928938343127358723874e16) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.10714192604719650298629709048594099989758377336641e16) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.10793165886036598413491640043052411777219226808173e16) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.12520056327602887353590139034934048397213872282597e16) }}, 
      {{ SC_(0.6e1), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.12796190491413846860531891431736127176350842769258e16) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(0.57021748735352796844833665641714981145537658965832e9) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.33392337350031500089312750393952812869969520242424e10) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.51104706607057706503593300411908865340079809564711e10) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.43033684039351042149204372971415695875947452322601e11) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.11878421144708082332834762334306478479136415095637e12) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.50766913019696586493282931975810537104713641422173e12) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.95466760718538857591082062972549747072346150612994e12) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.32872226240917190297091739750525454366627699186064e14) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.32997259328655255330496759553150199138853700279145e14) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.79898329260889892967192058996859678757129709781078e14) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.37428017493482775405894670005457409154697608991328e15) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.43466223450876443481509940956447737669130708637296e15) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.71270545904261412829731553082318032163659205189309e15) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.7497285196890962326633452898612092751671091947701e15) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.99845803303929955008572627409241608030868175838179e15) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.10461023358117816588476498791118019449318399295782e16) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.10647064052554109781969489136618692170398077176558e16) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.10725625259217407089116034019717976945427232766523e16) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.12443623656417308867522424203310475916181187862679e16) }}, 
      {{ SC_(0.6e1), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.12718355604200258530774511416682851768226221644704e16) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.49284811793209280365434949754966958001727610684493e9) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.29997862506208045020727302705263463492969194184528e10) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(0.46259460134591536879819144489901451018431480056059e10) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.40158369321443255951219796747513198534532980552585e11) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.1120699625624019830448773936385820118244175747615e12) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.48509038473703058950212476663392650648272020840751e12) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.91641718510448442971341501529316096562199222581998e12) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.32139411296589331991485384644984994696859399675058e14) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.32262120245377330138811808763450924797742804132045e14) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.78361281470358220056716850107433788659136608638212e14) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.36870888982652886020361269968737789868814568588064e15) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.42835095990188177652844730504615356961881860142468e15) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.70317345799024105504252323584691230510601850060279e15) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.73978540734723097232993500405412015992828695917165e15) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.98583204388899485014640108498828265136751380914859e15) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.10329759730285883611535736100827742332871039794527e16) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.10513856938469798930399543075676194173463962645542e16) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.10591599150778794161004483492934728758631873253144e16) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.1229192323834801613580240381635673120588670474927e16) }}, 
      {{ SC_(0.6e1), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.12563867825730434806513584802886506865386445819117e16) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.31056176609328262744354290307490499447749128627984e9) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.12698681640625e3), SC_(0.21474641645375196945003617651061372691638804186296e10) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.33939912866617433675302309449585922660229492695138e10) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.3246939393485798363604662321181037517515150375214e11) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.93785476831971153918912095143821834557237292167987e11) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.42229348699358054630103206097276707070997137917402e12) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.80921665035606831983918570980305083995391250863279e12) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.30021987362168608006705510091464548855616102605746e14) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.3013793009404698889289850495408042782537109837479e14) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.7389695059502189306373674846273437884319461768123e14) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.35240744843758068568366054624709488158274087060876e15) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.4098729207588772848089021141281301420706627999216e15) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.67521178818255342139438661537971495337615596039104e15) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.71061224267344889512925363465089197035709820934262e15) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.94874872695964208516621641733125659722361544545777e15) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.99441667971961652225223077796484088222447277866909e15) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.10122530692858831068332258430998293296495283930143e16) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.10197856775415755500167732055815127952881513946199e16) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.11846028047307665541922047585702480764211063113749e16) }}, 
      {{ SC_(0.6e1), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.12109745881583554125132338218009211405499508666071e16) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.24278455726195980361923424496753165147487010730985e9) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.18030561300133652370839361014673853459811752535873e10) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.28881912653305133981890911698470926640429114963515e10) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.29108812862427597218212064605049495961212544330731e11) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.85616143635967071526809182235517018079343589729518e11) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.39352212446993374561133734251485121814802348879652e12) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.75965534404424419844204496845212470192096727671235e12) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.29007606682763749078137760938450840888887892431046e14) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.29120279915635749780172021234758221516201513893146e14) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.71745423807489525509070867847267145602821278253669e14) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.34448448721794017468717487738286623037893967559024e15) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.4008857272032547098139448124146495500684039156006e15) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.66158192958719979428580597488440490193264309489379e15) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.69638877078679263739469509705373976108324301755808e15) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.9306471468871133044489467037648480350793545046173e15) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.97559109159816676915953242609482016333608597005721e15) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.99314621712374015523569716516073804333679788291835e15) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.10005602904979136235528290138828979990104151199654e16) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.11628181660003715807927735007640600139772036681539e16) }}, 
      {{ SC_(0.6e1), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.11887861388958864158184058615107773425485087664827e16) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.22309335653387736494310721981505397269088117661973e9) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.16989221636139193381325228565875327380060701000354e10) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(0.27341067762482514123133136489132498264704946000748e10) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.28054797583055755151994997428941789365119484852733e11) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.83027843509612007538993540360122495875672501473246e11) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.38430118332897729090795123137235693236025494217705e12) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.74370607174932254937454808736955812958708844808005e12) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.28675882807252638302604168226582949972059845232418e14) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.28787482721484525669184501655178856435990926591034e14) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.71039936747584251596658119656419799500423645170633e14) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.34187667987176147122943487377169456156512676186783e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.3979266971096269031664978356460423014801874194127e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.65708986178291296466389097975953830127225652838055e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.69170060942959882164308394065320608453667121070456e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.92467756155357394469763677609918463328256277300454e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.9693822194793565324003870619174741124567454813067e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.98684438214284245747452658604014567509934172562005e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.9942192768918591144094672304162837084176807851261e15) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.11556311630008029484805513108607960025482527214338e16) }}, 
      {{ SC_(0.6e1), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.11814656361262310323168186358564055763512052428856e16) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.20472704063585550572054075403266601673974226695776e9) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.15997889262816446708281543607323243912570229527701e10) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(0.25868597662803047883961134532020870343614747398855e10) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.2703255997940056487508759349934282273548803505756e11) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.80504712142545830147413723108570439687353136010007e11) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.37526023270465036692532134830793943113993440173405e12) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.7280357733096316479015820934739475713653365420028e12) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.28347319935904825425003716294190117634582641535533e14) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.28457854710332732427862760747600280129524146103231e14) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.70340230337322354287887370031837408689205236722915e14) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.33928532323866537276985347969554661936977357178908e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.394985867474115863830769160644688844359708678963e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.65262321045709583453053595283373997823597487494525e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.68703874832734710727831921962607909094608729357816e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.91873988506019802302087295182743488563062439489215e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.96320627537289498588052934051700431881826025020999e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.98057586899137901094485009404002119831895812692111e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.98791175073829953268191648688861705308879039964707e15) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.11484811762474479414963902337591060686954480309955e16) }}, 
      {{ SC_(0.6e1), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.11741826986419223750776857560528002452315184531949e16) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(0.18761460449981524043369054387724982176351982725087e9) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.15054647153702910909609626497135024525439296451247e10) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(0.24462079498615275113443202393413586386847989290027e10) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.26041334231383446365108360062827659690683870156163e11) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.78045437623836571934474494248511821324408483248655e11) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.36639646286530571873201058492025378062954144612149e12) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.71264054610154159953190976324587324166673183741124e12) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.28021893973645105557062633383604925307129880583555e14) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.28131371740366029192812388504563846746381174260792e14) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.69646266686380072622018077547850562592743043673864e14) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.33671033430135016309268384982805298891076656915505e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.39206314874154852521985239871756570568259940811869e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.64818186056623930598750506763920821307507264083892e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.68240306944926664885772794899947157348885752289274e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.91283398096222317653686205605693483643506280778013e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.95706311957843483197898948086674703868502877212331e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.97434053671779183851887408367976927638954191816106e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.98163757056057568724796637425147719028678450613088e15) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.11413680532238488326260275605844568908655692453017e16) }}, 
      {{ SC_(0.6e1), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.11669371722330319882997811510591362069747527848209e16) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(0.67715006694439331210368043397959491308636568103362e11) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.73817303030957317323371394486904472697229926525406e12) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.13098558591448318697071777220856583432999831498671e13) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.22977424102575837424702215555898144786349856858211e14) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.89702582414011428545171276160388908028107073825988e14) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.62798003429155639989236762060722455740467329281041e15) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.14624651702194449024597721116057402923773627105075e16) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.16596857649089166578836876429002431247941308584683e18) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.16681248175420993528938078859472985884759360147021e18) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.5435554822080933731633077044432198124008991818063e18) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.4273468551248211353795732342515325148969499319854e19) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.52179236460848158751192695480449955221394422074323e19) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.10096885049765082869829217105395829032895964658858e20) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.10803050810137912008698161866483343277738463515917e20) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.15835541759093552308603119943991308006156521250075e20) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.16852126907427937325182482573141155932096619817246e20) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.17253346363615269759989102409559177134758905831796e20) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.17423481269330380781864215079437338191352169792228e20) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.21245099484407530108678077640469477278300888718997e20) }}, 
      {{ SC_(0.8e1), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.21873459892109164125208544943714137488770982237018e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(0.61302099126643393145903758273914829012173637835484e11) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.6864674936827371981309267525189425700520367170897e12) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.12244944388490422172498339573515672991127089116904e13) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.21932329790412455879351274835620473667598919254324e14) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.86262731137879792307762287152978657943206605974738e14) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.60910586651842165569974325349901866652963033929584e15) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.14229226983421378564979194277828747332017690851019e16) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.16348551593670760291014787563508413471091998572553e18) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.16431837769992427427159144244295674195115025874701e18) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.53654437917855760536879348025818053129362946648891e18) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.42308732721576030811659045999023438305875469229261e19) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.51671968275443647976974127944181455156395297550016e19) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.10006502008647809813010846994847289141346923328038e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.10707160285899236931180881971209147390217006318054e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.15701543451779865383265510411255132031181098785104e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.16710631265412616932612303877122888719690329365954e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.17108907442051658867725191756715355685460367230275e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.17277796858988693082176870257954838459407004651476e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.21071810697535905198128996817505895298605570847497e20) }}, 
      {{ SC_(0.8e1), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.21695694711797939215198655170013954670775223995221e20) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.50029881584531259711920692545205427742741024520243e11) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.5923877231722611609847160647550282495507852077825e12) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(0.1068124000653320696456438820480332694255893482414e13) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.19965450425673391029509622797710792277311212027616e14) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.79725871757929772594113857945850169649490770738922e14) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.57283516772951066580630752081192647112999433645674e15) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.13466249318776619676463009132764907736828958763943e16) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.15861654244188167296631897990556936176344594072965e18) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.15942768764717564714587924805509094546621329882249e18) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.52275878780177586583731873317935504589087735645493e18) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.414679439454610646771291688620843517702282962541e19) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.50670345354101649193921284498416666091452730055264e19) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.98278549520803007764840007705858890290864151476072e19) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.10517608509131201524266939026120374447150954396375e20) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.15436516925834427732132986324330006939196579468999e20) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.16430752001169520718606858255894957082474945476951e20) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.16823197041815305953469961210311689243066992148067e20) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.16989618885587841922445274617601730300241166819919e20) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.20728935832080655369872625308042729171705529931609e20) }}, 
      {{ SC_(0.8e1), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.21343948921007846007850127862298152393080261904481e20) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.26205600051336500119631398576848853214404144005735e11) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.12698681640625e3), SC_(0.37373031395238729260803608361341296270349897424314e12) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.69792336361967502372217127773886947143711522459029e12) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.14954212616902133777970414205064801567654217158155e14) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.62629057993079616681118660592038197731615796553851e14) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.47506506357298101360013372031674176298886189971056e15) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.11387035424175230766707550800262637222525017276979e16) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.1447609716125466448161535814716822969313398687385e18) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.145509848411255016265804057552487899128865574865e18) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.48324059338057372602814032302253660879514632804142e18) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.390325343461725165775617628261476847529799805715e19) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.47766543009018009813468897230936146536131204089437e19) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.93085271323655866757533430738735356979379548719926e19) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.99664338449439748393646255557139819201067567385988e19) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.14664748903424211264003171767673666493956579769087e20) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.15615543369403949823701415240056856426889124840719e20) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.15990931456080405920651603260574251215154813968338e20) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.16150134894756415770748474866665345678933826570185e20) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.19729393014358609524745292873466628096681907555511e20) }}, 
      {{ SC_(0.8e1), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.20318438276702455138600991007603156943792552030292e20) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.18523340702622345396830045774502873973472244662797e11) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.29352448817711353285068929637944553541761939201641e12) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.55882039118204375397257490391999104088555310137965e12) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.12887721563060981713791748488966687854941501184506e14) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.5534835054316147099803970882567515534474925412204e14) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.4318852975077349565047906564578001830017460549125e15) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.10456739289032081150155682185021244935964264116148e16) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.13823855646268530098279890270785012636408063897842e18) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.13895786447346802195540481932582399973876439819461e18) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.46447923869666349879137052595602565650284369810052e18) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.3786240833274428477773540720801879135635388410226e19) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.46369978861368662689633690808972034647894499609949e19) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.90579791644923363462497932185143919572402638218542e19) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.97004403811391032094402207973974435006308836017962e19) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.14291673730989423570325074578687191942679918963255e20) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.15221364432894564416149507074418034397046905053101e20) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.15588464842825309715035512372147441803644960832785e20) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.1574416077294093629633384150485601697864003189673e20) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.19245614590761948362411807428969920559405312979152e20) }}, 
      {{ SC_(0.8e1), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.19822031971404707846169971267269875744903562791799e20) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.16435495503294283577044187127680877690731714083345e11) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.27032763521372139525375029575205264598044386573662e12) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(0.51812875534299678246884844285846263902126079704557e12) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.1225641701315042423183192307725032471825189192879e14) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.5309097698059863085654579127544287776126008934302e14) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.41827300005196231599682651279308191477904704740216e15) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.10161728298775619413848042606036024652772647738027e16) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.13612221320525920768361562679601552643294472022654e18) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.13683188958706194697599003449875396090702703154239e18) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.45836847626451074414940237861976192306244544133263e18) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.374792386877437430315049855309289603541292806683e19) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.4591245552746346983813892304733845030790072677193e19) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.89757833528591955770101345829130018609299434541724e19) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.96131655541110427454562641441548071655958469099035e19) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.14169172665429954018744050926830465856301603985805e20) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.15091918508015939123088509344542542089783364314847e20) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.15456291407438947560805120661002236736580363846838e20) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.15610832970117494385869853803333273051787627322398e20) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.19086675973616140651530751166383392507207541193023e20) }}, 
      {{ SC_(0.8e1), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.19658935907488061093622127907845282608828780339934e20) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.1455237734460207726297886923489154742473092577085e11) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.2487305711766109023276394494853920809345253624096e12) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(0.48002397927023011575351809525013632419132996745139e12) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.11652145023219267314747185259033304404297770708132e14) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.50914108130178336545199287448319170617458277700009e14) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.40503596282889432585578769047667158598748797429356e15) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.98739976662522539940194188479855438452946847253252e15) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.1340342172677690192098573546004751166194433841162e18) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.13473437255536620472900311243243152235541918903627e18) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.45232805406269531186172211865353002703073638980146e18) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.37099461895975587939002262388636084818098374970058e19) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.45458882052233018145282462977311312856350551020701e19) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.88942401644365119036050064832644455045978590613656e19) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.95265777658313096285795858101317969096517563053044e19) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.14047590339755544665186048147925567204808919632749e20) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.14963435789412686725013392144007566786838641836842e20) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.15325098547921576785585673799951071690714085819018e20) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.15478493079044790774938548018297417741988311538465e20) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.18928885837646580388591191294030623561078464854925e20) }}, 
      {{ SC_(0.8e1), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.19497014026270056263449362234176742272999229406522e20) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(0.12856873790409686189347241885979466980493657285606e11) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.22863897185487070049248956586844501834115078872771e12) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(0.4443654111473249765495320678811513680000839367862e12) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.11073914367519493844027555800879111750034333357629e14) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.48815284717381878805787258115443975294980874540247e14) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.39216532206869164143348087874518151097655844263108e15) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.95933934391899039901861141875675217702333890309978e15) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.13197424322425247584165614503831831173124917788644e18) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.13266498689541082851120900275461364765055772770441e18) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.44635727812756625964666387676484598156162008131397e18) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.36723052207550446348130466084841489811956576937507e19) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.45009229208489981937678201431271351061857201263553e19) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.88133451578743944695058658886835283564788497411996e19) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.94406723806210257783517652040577861252811545582282e19) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.13926920848062097534804582231076725488152670342501e20) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.14835910133929012761770253932953458230932604387611e20) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.15194880028940923802204745812983586414124197333115e20) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.15347134825542647739694490199635813909379282539038e20) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.18772237069730243974484257449238439071840254086073e20) }}, 
      {{ SC_(0.8e1), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.19336259082224284465264896341659261073376653225895e20) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.2654889513620312899509622905805297409365029571346e14) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(-0.81115902648784667641185275246238844520373452897371e15) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(-0.18303177801793206294198107175735995171382374716554e16) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(-0.10362838518885829819552800019438641893900246820923e18) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(-0.69734704097532272722141569113044686708404135376113e18) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(-0.10522211502686932614640768244048940260106379941192e20) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(-0.34107339289224241052789636524169975289845647416489e20) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(-0.24072773216663507048509584241925850900805754581485e23) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(-0.24242232838565992362685520446389253906141174455606e23) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(-0.12411154970271265927561376866342160654493910392942e24) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(-0.21410129593338849822100499569387110948424755161124e25) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(-0.28203925001699859587572608553481047640744138844515e25) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(-0.70134003056787947871720938847553330941633839594574e25) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(-0.76990308490274215720852975650583096964781237682073e25) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(-0.13048719354757900151200163995608577257302425662115e26) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(-0.14218162449436221009130053183039474271867088074342e26) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(-0.1468721441925118729790840910911249950717069916788e26) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(-0.14887370644938910462057842329445974287143894697588e26) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(-0.19571076528400033122280880328554895378487065013398e26) }}, 
      {{ SC_(0.11e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(-0.2037393778116807934910772001986582338275962326715e26) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(-0.22918952906373994072097950582497674882707489024392e14) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(-0.73041964998999856830365433264431033124408793228917e15) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(-0.16612960429082370458421577225205805175841639064411e16) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(-0.97018865877489785536449493423953754325325866249193e17) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(-0.65997769350597274070873216045696912908473229553669e18) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(-0.10081964490177939391669722440701060744101119976398e20) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(-0.32825276631470436842165035722211891612476752436023e20) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(-0.23574648194090967083023273640861338315277346145925e23) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(-0.23740921247709684499306633202845230723180756124965e23) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(-0.12189926779977627760333872375927493941085072875383e24) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(-0.21115568713539824523954704739784049841436440978665e25) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(-0.27825498237488086881149742902897221281528466735298e25) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(-0.69267783481277876159700247128485466511427236849697e25) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(-0.76047437600786628647511744572821765374892979052873e25) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(-0.12896401741742076242343033403989113421097788702529e26) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(-0.14053484125439343471902052403103515238017323914548e26) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(-0.14517604700571381534492255609244246916253518313612e26) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(-0.14715660958730284226057942267657991682388251226149e26) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(-0.19350890358516091987303969149063122054477936168068e26) }}, 
      {{ SC_(0.11e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(-0.20145555320322521930807018455535636727796572671007e26) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(-0.16958585581594607097295153207343594718459181376761e14) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(-0.59023401437588327267062005651833438346118943127075e15) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(-0.13646998766591427587511403953781296911609259101083e16) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(-0.84928928065825130329877476108452350916912201421678e17) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(-0.59061862567375597034786113437101235930675237745957e18) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(-0.92511218502269766642756868755907224213695843921581e19) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(-0.3039121159201599712146161074049379472731023751431e20) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(-0.22606349173557214348012634186082994349473475318186e23) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(-0.22766410057758185354644302490839019475244512950292e23) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(-0.11758172362527371866558266573619679615007448541372e24) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(-0.20537457692346387649876764905861750513415633817835e25) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(-0.27082441584092159936673844002881905895550196010877e25) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(-0.67564423516083963314259881941111016741900293433894e25) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(-0.74193081810531929322961299295322862052577009759575e25) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(-0.12596600093333655793274005603399152562677835449588e26) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(-0.13729312810307112508553928833908426501325931892589e26) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(-0.1418371018663457935210323066076506948251250550189e26) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(-0.14377625829014690115835287415265973556300425205109e26) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(-0.18917253248512115182763300374822280258577803750661e26) }}, 
      {{ SC_(0.11e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(-0.19695750931770426740326570123804745930767113448983e26) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(-0.64420104398621373943337896751502702669528961726701e13) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.3024232887864172498464577114594820104540271195964e15) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(-0.73808122395959669985981500802166438905423230324203e15) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(-0.56366295474973599689942144445294137459430926727971e17) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(-0.42021616650043858255184060857715608341012712975699e18) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(-0.71166981311102060286589503944822486236356087786369e19) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(-0.240370682841446123897814293219511399040233827311e20) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(-0.19913936705005225147699715498074540532349127374583e23) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(-0.20056591745714354754624181283742675046827935984615e23) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(-0.1054484536772156392346883807040992393965652295082e24) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(-0.18888276664991738582202828909330761791879606281357e25) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(-0.24960060126582100505951654402810154041817565602064e25) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(-0.62680011405943049978015103342941915821581899329213e25) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(-0.68873646781387944384723081694123781350139686823305e25) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(-0.11734768728892171131333210760531661498579662714689e26) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(-0.12797115823661832064703359842964867004313204542155e26) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(-0.13223432433629925182729242715614129367111286521269e26) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(-0.13405388953558674398463738806767626578491123984891e26) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(-0.17668752490617326721187573488433906452619563687806e26) }}, 
      {{ SC_(0.11e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(-0.18400507034655644693471665674772407728528583781447e26) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(-0.38057773025950007011433938578152274885854686279073e13) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(-0.21257728460504762101588904440616909660868350634803e15) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(-0.53466483709829787588430660084701911858549149164171e15) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(-0.45630394111540644149132092366374209497812461895313e17) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(-0.35293630489753437359931148235227579212050882960221e18) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(-0.62264213386115029051141580300639173840126979291097e19) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(-0.21334814099760262201799426040773769408601031650255e20) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(-0.1867994623823792738421969432962968916403080478257e23) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(-0.18814552901252353984179681851065922765347730623698e23) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(-0.99818386465219789941768899647738808852451608293366e23) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(-0.18109627147419215781748830714773982707131922235748e25) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(-0.23956543775264971756101290974171542030662220798159e25) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(-0.60360082588325970072887626867629308393586545333928e25) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(-0.66345982639185044591753571011980613032990282286734e25) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(-0.11324254375927948989197977222235751815767526259164e26) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(-0.123529142999845849892314145644740249681359512758e26) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(-0.12765784237079676321261623509836597446906080575884e26) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(-0.12942013523947598980208231989986697239622558341797e26) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(-0.17072996213109986290982330046409789966910173466105e26) }}, 
      {{ SC_(0.11e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(-0.17782339030237702240778460899315312015090387649893e26) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(-0.31701143747485673927093043589401707044451376507138e13) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(-0.18845389342276811073887560075343064569078610173145e15) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(-0.47902174667541057092297024091753601952701904549563e15) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(-0.42485287587912884259888662446308135041554406172101e17) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(-0.33277531068116750941841789128076410395632751137819e18) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(-0.59528750204833632898436058376380970771974918278532e19) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(-0.20497174898628728011697612124087090434541311659417e20) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(-0.18284300873756345436070368584539621189135349034845e23) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(-0.18416316835944659195229657804961331201400396090374e23) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(-0.98003225311657747582023110913125033212053137139539e23) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(-0.17856627708365344232607111313218265575387883198068e25) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(-0.23630269656410520354976644201774848377234988218507e25) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(-0.59604277290456583334164546701059225003213904332431e25) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(-0.65522337288913879701167843563168909581844975470468e25) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(-0.11190342361401442777889240874201299903181378582893e26) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(-0.12207988548257585591697413948669665281342976921754e26) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(-0.12616461747751417780894813998166341762177246381257e26) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(-0.12790818291151875321420888164921639851281959760912e26) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(-0.16878502485366037199255357413310547116519135939798e26) }}, 
      {{ SC_(0.11e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(-0.17580513047863062225136663265295850112819552396737e26) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(-0.2630134823976753935638930109755610192696870285461e13) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(-0.16681032554276412627302058363645046229500291315404e15) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(-0.42862761709582401501090039741841954986691762566036e15) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(-0.39537016389253099039775564474483191769364486092522e17) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(-0.31366044530205691007535921357641963378960303753655e18) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(-0.56902488553618315562186379436794723110046238483825e19) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(-0.19689422029159103883485961523868449679656022681374e20) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(-0.17896272769745241294919834696660211330277655916077e23) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(-0.18025742902098689331696828742317666456556663123771e23) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(-0.96218069191148681196623939668868818760209721511544e23) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(-0.17606841319897328737463280865987797621532884093821e25) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(-0.23308035059908738518734555323746607423076245199683e25) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(-0.58857075228638333728610341013363089755536555800652e25) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(-0.64707987121534884897302142026095064703574490453895e25) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(-0.11057869884316759515856405662946232526105389738031e26) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(-0.12064608461657512104891381322146937408672826363603e26) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(-0.12468727061862346001987017770804354411687836468454e26) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(-0.12641228772290442809255106301005704551858725174635e26) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(-0.16686022926841747385056997612130920204577570104166e26) }}, 
      {{ SC_(0.11e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(-0.17380769444883450695584716321421440567290130641382e26) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(-0.21729817764891506437429238683755664863601728748634e13) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(-0.14741794199318079691783150348936010140299278982706e15) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.38303808294839088317154753828178855823718714819912e15) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(-0.36774506601193768994948770895098500569492667323219e17) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(-0.29554289347548519369132966198112693764504042720276e18) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(-0.54381506779248390125978208673092979039231174322549e19) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(-0.18910596152007470826765455628699090391768141377221e20) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(-0.17515729951961390708292251009846421269145994177086e23) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(-0.1764269843472754898275268345413217391716888116616e23) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(-0.944624717464144632193117392510934006509397997893e23) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(-0.17360231258962961745870991242616494004077112966429e25) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(-0.22989794976530417757393086661885387896834929884485e25) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(-0.58118388269419642512280314745882015815270934950093e25) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(-0.63902837730324253969898682883107037820317574425468e25) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(-0.10926823017753051141001936783888318607814071571909e26) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(-0.11922759204274230599800554914651908396667268668742e26) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(-0.12322564984532432043614432623004822411851436713275e26) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(-0.12493229620228475901063146703748691705538945203686e26) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(-0.16495538765300047118143276158613459992646404118956e26) }}, 
      {{ SC_(0.11e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(-0.17183088885039785427838154802795741719241049007174e26) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(0.15089512149113030156742408314693520900670054202735e15) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.66479267974159821682739049334222655828402804124797e16) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.16315193986400175984544927975327738988661298665481e17) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.13848792695889625458742901153960072205581397409569e19) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.11226666239737710640452918716688528411170504061517e20) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.21995449009979201790368785613984942214775001522725e21) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.79749594517593139345031920557544620084654916353303e21) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.10422811567670420344781231477742925636200236874246e25) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.10503037495440178519973687468607051208500302748839e25) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.62581954269415863047321929870657460657018985074233e25) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.14050660055413122611592689915703959603099115862285e27) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.18986054995819939231881263520022303833576140625492e27) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.51350046097700413765043452210276280871029647322849e27) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.56856706970596173962754521542724001974649764786303e27) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.10116344430865160866332137293516457455345267423119e28) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.11110462050458988440062213131259010000392811950859e28) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.11511347725214371112631884048561813554472540720287e28) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.11682776747246834052550367252666928020390029075862e28) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.15749999743310645827251475403424012152704288120405e28) }}, 
      {{ SC_(0.12e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.16456902761642253374478422388844458038185868238816e28) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(0.12797616858475630749532613256443753412399305300296e15) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.59175071474259835999702506007779552515961924801906e16) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.1465389794349193893870277025280715847107713475904e17) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.12878604037114727603378406219720534662328138747077e19) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.1056668854623173789974418655623155928208577176598e20) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.20987252560961407851201813369914836140364889525086e21) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.76467066854446095660815416985323430923407241109701e21) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.10187065085729510673950998741334312253047463412786e25) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.10265628282963081674980621136578598901268495187589e25) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.61362961591418100271288542633064711262910477786695e25) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.13839504368277724366353142868306119104684751452498e27) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.18707800013445058363069766090993331620760855958139e27) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.50657368262887635003446449738991426205915374954352e27) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.56096232594588307676279404096995784320900834995775e27) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.99873804134477401039087069594765663211342895360938e27) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.10969927209204595005343192607227974848012638711713e28) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.11366171678208657297286961492469371085310005537151e28) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.115356201376595312102897878299903481035661465636e28) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.15556490839725484907378435711933380932159508758724e28) }}, 
      {{ SC_(0.12e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.16255447208439028155170352204289101670907902512106e28) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.912787233211290365386294138273176558386425070392e14) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.4670297691189698806522725538241743548055246554129e16) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(0.11782751950431067317433543429366778093426396831846e17) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.11121391069923603426297206572606928134005134588953e19) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.93516417901952787977212467423707406795635002548275e19) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.19096294487497323793597248273650238020893341273387e21) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.70269244067839997806764764988478292425153933014877e21) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.97301426634749083623700529421877454296731902508697e24) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.98054738477521368425490920198960969970840798144769e24) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.5898991602156310410471321295680496601076728807048e25) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.1342588287232902396698535836363084942897175520825e27) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.18162458724386797046722362124033255826751828835281e27) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.49297611130454531487888359421850243401184910502504e27) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.5460315113882064608019426177060057129232100096236e27) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.97339574078466738452975313236000939958452587979591e27) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.10693728683875054136642150813998764736871153065998e28) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.11080836820701329575522670713030565320365575134326e28) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.11246386362536432582732124308057459728276303696792e28) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.15175988745491709788540637050298217932619551658061e28) }}, 
      {{ SC_(0.12e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.15859294697602927773795466791982141894835066040032e28) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.30669403555955475045501504329231407071643509822856e14) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(0.22195362368392307540962281204185190731491772448714e16) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.59548425283625128011179809770627081963135334526973e16) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.70765698115972864720365567058940114875419689232274e18) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.64297715482292040599682395287217905368132263177349e19) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.14317273525063349738413997854722351194481097765573e21) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.54324013709342987533478848634587578589635193779611e21) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.84695015278344597614205775474385748535772045168522e24) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.85358470107972306322026197549212284677291985584321e24) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.52365505574820482123051909712961918374169986014966e25) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.12251965950133559816410922277906972840290055628367e27) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.16612559942033747256454190585773992290954104203137e27) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.45416317820793414288818115827457511849216368263535e27) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.50339493165355246281838476041863102784296796920976e27) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.90085950976373843441797677908431184218510601282076e27) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.99028861283167388113084152838984050374079700394113e27) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.10263721077088402247451856893204115463216562066125e28) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.10418057576338782908582063908145350817267206366277e28) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.14085027354633664326268132682903004516085027963959e28) }}, 
      {{ SC_(0.12e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.14723272104302523768363319696060951497031015044023e28) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.16887704351450991018685233596331322096508201142624e14) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.14982496663482270919683226420050697395112591025055e16) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.41604846777533303451385031081878760178523709534238e16) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.56048427295724550891851695527300238861337735391786e18) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.53060383881289739752992473120406905044090974035265e19) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.12362711325153677075678409070861081694157918407854e21) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.47659826609221046744798512063582249005166856368299e21) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.78969223667432326058167100404581038356079770886026e24) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.79591500988481620867243818586428336802856992540148e24) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.49315276268127982962112688398968506053021969556607e25) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.11700956771745070237863342341103721023275218927599e27) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.1588391154683622041518668594491445754662366368634e27) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.43582492599491107038618720494260520572911393042546e27) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.48324027746408211450271370074109080478658255955611e27) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.86647918208307375256722035433814017432526968015152e27) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.95278883507036975866094738774980090194670969473009e27) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.98762035955917407398920963397084205278327026573701e27) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.10025196309831058720580759299007374529642176901403e28) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.13566921141617066651661087030285785468969145251346e28) }}, 
      {{ SC_(0.12e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.14183662882278432235544256438259337739718004808762e28) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.1371758997670242362597592923739115139206306349191e14) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.13097957729254589812294470412516390938204730007741e16) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(0.36814629310779197742155328672703399983253519079282e16) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.51799898536933262465862829282669425357182294774576e18) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.49732630774478064658808294207599264004527698921483e19) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.11767423823105340746694048487097271986438169225069e21) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.45610109119358173943628750851173539961712725202357e21) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.77140793580056691514560063546127076237166235982541e24) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.7774986930488715494772085280593220368271695293111e24) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.48335244015011405486292457289837255720901438185212e25) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.11522390494661416795537271227971538367521340095618e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.15647608850272115211636919502896709062851313804155e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.42986449826586541205277075027249928322879253999222e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.47668804373519072653259691638477391382839806200907e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.85528883972167230978933111346393887442208830156863e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.94058084652211217306924997380113123666536671780833e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.97500389781142265620831481997267571102109301935575e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.98972881269195399673665504173581581311293573037944e27) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.13398136116763406279668533456152679997803953891948e28) }}, 
      {{ SC_(0.12e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.14007857751799801613292889805606379238589809284795e28) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.11087455152725669690336999127635541199366193206449e14) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.114298544738269485495642645761518863152547008762e16) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(0.32528353139820957592046324698519204484584342822678e16) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.47846196898007952561885272835221106180245846165324e18) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.46596026321457495558054702071835067666631668546118e19) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.11198398937569157591072184692729324755337706840231e21) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.4364116691644226355528015469878669499374712293422e21) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.75351166303082167385068080076461055104138470390934e24) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.75947295014677286014551169931700437037061286618733e24) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.47373063323099918674326217893148567533299340970097e25) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.1134632208146244350816263841931166039130601125468e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.15414528499673027826449573949659242988620551352158e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.42397879074300157867990971617116297425323888441215e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.47021724502303723804286670218216440735804061296368e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.8442309698373555502734747078009926418959829118306e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.92851623806045466096435859247898429925669389144473e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.9625351707495603102063278022018713566094051828873e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.9770875839196635539273999354348101085610770052048e27) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.13231275887494988805817963480031370795758178190906e28) }}, 
      {{ SC_(0.12e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.13834050057350967106337042642392164832916907978381e28) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(0.8914473376236519046594075259259974713006020331586e13) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.99556750538951405803859495412582853012247729779298e15) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(0.28697972310337048760330849315701318902212471340687e16) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.44168746237888575662390395745711256123296579433002e18) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.4364059738670264362114140545202379829018126427409e19) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.10654583869776673689812402605998394964945395097005e21) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.41750107301241516472603609135916785954570308796498e21) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.73599593307886028314238854975476412977223870973225e24) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.74183025171204531116275901586287219645344398502117e24) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.46428438605635774042133100500637633526789942972204e25) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.11172719768872813890703928506885495451265240125016e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.15184630549907723648875643083040389109652202053313e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.41816695191605961442868168469657477267171179091714e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.46382696125000481264587683389385370357600885552113e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.83330414681960249913247277101710432328816884025869e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.91659347885618043036455803756433239086002662277599e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.95021260576502787816271336957886653419755374617402e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.96459435429943507802633678873106141685553806000112e27) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.13066320499841988334636530718445236195831714149717e28) }}, 
      {{ SC_(0.12e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.13662219168500569252058661094364207415724497488309e28) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.13897497591274047533498009684367939859600181843518e17) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(-0.20002307006890941043339501295122373403490232944341e19) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(-0.64050586382051827869987827157623534685759993050653e19) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(-0.19246767972362894525289805373252842015364087926783e22) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(-0.2770362238751076620721553727290628621521017849494e23) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(-0.12082321082909358544481168701974172202477942490852e25) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(-0.61661693049993423631480196836916988104562096069146e25) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(-0.5228564461713116863844169077889220012667766200322e29) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(-0.52792239710741060118429184004989018109107253052917e29) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(-0.49760705159672721838807424817096956077973153352282e30) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(-0.24748605065264601303136041086200981804984421066546e32) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(-0.36108156388134807374055355322696204764951737256006e32) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(-0.12580948429114832873173514397868889437461289133398e33) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(-0.14295760810815052130210379406913204064890876991041e33) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(-0.29448884636246585980174365130639538686239042565306e33) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(-0.33122405209398397881354999013459487773098995548134e33) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(-0.34627997101450477912801131852690477232319022239384e33) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(-0.35275927811393035283601232816648099904086225302233e33) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(-0.51306067544458847740405180616630837584805819553878e33) }}, 
      {{ SC_(0.15e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(-0.54209922817079398591861371120952594311662132988295e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(-0.1108969523782202948051596666890175276549733744887e17) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(-0.17147873490556443289300617987401189158186797772709e19) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(-0.55611699358534959509555624693365208065031765087464e19) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(-0.17524869442695041008570803619262391695306276386643e22) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(-0.25632247884801680271198515683813768021611812006099e23) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(-0.11380988566242083723935299510664782702542461924261e25) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(-0.58452385446256261378623617485142537127621969054e25) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(-0.50798466713808737514459152749731253442733370198038e29) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(-0.51291618470604208677666438179021641353878484543973e29) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(-0.48542902554094442344715694061245942096241198343427e30) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(-0.24281875530633145208183316159517421414126458390205e32) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(-0.35444140812737774979061623457570752749441797456168e32) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(-0.12368069799745308896377375065087751459258693117772e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(-0.1405591889496863706326323465444153137238773552893e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(-0.28978063744801881297726276469759109785847302901053e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(-0.32596988165507805467532914716532466039464507383761e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(-0.34080322958905333784271341630630434829198618310942e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(-0.34718695349578432825667798711838232425208935322733e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(-0.50515611972206934631163112679780531827566260767488e33) }}, 
      {{ SC_(0.15e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(-0.53377789206657381415050187229943603902451194054228e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(-0.69628550614503463613761719274731535920169112863944e16) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(-0.12530263788055304980035614551020913279794701390085e19) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(-0.41723383238716439275931659608009793662178116584574e19) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(-0.14500941761957267533845337591388263855312431597018e22) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(-0.21913561479678192363066577052549759496020268796687e23) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(-0.1009036492239361297115968560359114961219760818751e25) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(-0.52494323474465677801312655836030434477642383466431e25) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(-0.47941570203747557502869527845544425337680953199911e29) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(-0.48408821461610312168521176605743566479219005563314e29) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(-0.4619015283676354960306629814114026136782893623078e30) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(-0.23372926950992373003831133234268324928545102380329e32) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(-0.34150117827784134413435405254128207819361512521147e32) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(-0.11952348755672462409917870886824033760787264896556e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(-0.13587446993187484595324873975110117680636441427842e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(-0.28057400758216787706963376173665155387505322234537e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(-0.31569383601119784977781487061410968869152108130771e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(-0.33009116878494956175532588486296619618003231596185e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(-0.33628763766314209036195082116339067537532346096085e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(-0.48968647568970475389786968154186053185269595428412e33) }}, 
      {{ SC_(0.15e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(-0.51749128249816473831460970937046572384471800906678e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(-0.15076812509700354132482366951975623824828830263294e16) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.46471912971616384860389261685483900167238895654419e18) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(-0.16905808278427297091143378974286821328329960077914e19) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(-0.80811390011627817590103098111422133721897189816465e21) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(-0.13543327493143529872353566504306002845909652906776e23) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(-0.69880320934737308339911974581704921293584589716447e24) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(-0.37834090333321357485409678800989334227626361595514e25) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(-0.4024322970702381449188014826665064833453310570285e29) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(-0.40640145896671498247198672042250027046813683186173e29) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(-0.39753704061058489507918414237259285548486007310758e30) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(-0.20832750192100961674564355492639860655346657547023e32) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(-0.30527369370097887038245001230730081805629890784123e32) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(-0.10782008953565113605062945215599690705142618800025e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(-0.12267886507333495450023738317869000009165787476656e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(-0.25456388752150022923105283544219702350015445623895e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(-0.2866487561493634933275903476481483989593614228562e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(-0.2998083268226442142777226680079185296152076962569e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(-0.30547315343641023736269472979842164002221519959217e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(-0.44588634600644563093959295218548836288433573046471e33) }}, 
      {{ SC_(0.15e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(-0.4713681943198456641766010279724364324810227153636e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(-0.63736783767973822242974600380497034019294634239547e15) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(-0.27406362235449020902043169285823767594164304924689e18) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(-0.1048666474524126999818431493087242263882389507565e19) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(-0.59737448534169695270614623703960047579494218236652e21) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(-0.10578474992055505965214444013660072479553560488179e23) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(-0.57941363161480976135012188030625280893072008266999e24) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(-0.32027081373453749152056938849253040209526411471848e25) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(-0.36841557118322968204519823748906528784845072069995e29) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(-0.37207111877232497462219932804214362206228397849217e29) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(-0.36858649737918813157674755965814176794338256834011e30) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(-0.19661478878118159538985773137317341586991727486576e32) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(-0.2885348186146557458574708697663270625104644287557e32) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(-0.10237764499965121611785770300972199686879201967308e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(-0.11653864550056450112140557796200765001775042160485e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(-0.2424189903540897046757010758303766845861492209618e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(-0.27307935971013472585679245100969932115592625270665e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(-0.28565777077013707087898632614786827012287494342802e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(-0.29107294492141426866156967468720900710227603127657e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(-0.42538289827595459867493820237435568422792305068675e33) }}, 
      {{ SC_(0.15e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(-0.44977202718693223931776281434924346505453448274561e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(-0.46967897367522764776619473581894493217633276050021e15) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(-0.22860564658395407230339459916783581942018625913619e18) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(-0.89056954506416400078116008529816021834733689073495e18) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(-0.53930878548628048382319669840795736800548367079143e21) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(-0.9732430149773009503473408516436811523583708500975e22) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(-0.54403092985383690470082299597213759014670313419167e24) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(-0.30283414723259723041287936404911835466573539510199e25) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(-0.35768537713744104023323100588779741427808639879003e29) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(-0.36124159895210687463709750932011458744272600385929e29) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(-0.35938135886302327840367652827853486218916861412064e30) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(-0.19284899250381597617895669841182327013214699496724e32) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(-0.28314808526814094278512649896300549379155477749919e32) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(-0.10062117051933306023981481862134025691728484021997e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(-0.11455641793982716140022018965728731564089225647617e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(-0.23849225053037190941455075678180607790503860314246e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(-0.26869097761844147083988141620918494379426274050795e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(-0.28108102147153832653757827347111048631657363067945e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(-0.28641527267710933817277761533314704661215069960466e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(-0.41874613300718390959429684535604859823578208559785e33) }}, 
      {{ SC_(0.15e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(-0.44278079161188152778490397388855274200744308265643e33) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(-0.34243704568385927090084377972628582328825274317013e15) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(-0.19014700921019201163084990887975806912477114208126e18) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(-0.75462289553484000973740189158325872508592921013247e18) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(-0.48650259599176169760848526143895179130527692323398e21) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(-0.89494743959617109802670799262400048989706548552339e22) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(-0.5106637145404383656602706576182832812278895161114e24) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(-0.28628310622022186111528099968809246971180010125511e25) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(-0.34724683207322238640413216175261077436205843182489e29) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(-0.35070623383952820585437938474385390312152996121205e29) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(-0.35039076563753792986595162920540589528678700821386e30) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(-0.18915051117672647585554156204555990183444189729843e32) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(-0.27785520919760433075188965326671624063678493211346e32) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(-0.98892821339661604658749346236854667506979609940683e32) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(-0.11260565742620309273529368178554337435475784764003e33) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(-0.23462487403411025857805330880059663505026538772097e33) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(-0.26436841294930588298727390430667755286893875340595e33) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(-0.276572708891878485457938276079164337172956203198e33) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(-0.28182716002455584106491273008047825852269528523491e33) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(-0.41220600724269610006380517522263876682280213575956e33) }}, 
      {{ SC_(0.15e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(-0.43589097924584966823476019138168699481681313814431e33) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(-0.24672758032939657278709906026773303881570027007364e15) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(-0.15769214272781451294475902703987859652527522078431e18) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.6379567287051213218111238270109676522079452186235e18) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(-0.43851422939576170830538802217512663313308897389984e21) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(-0.82252436708829401312333441025244502258853814245284e22) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(-0.4792054398359163774915667412186298982246297744782e24) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(-0.27057594059011014211130169180031683044750366286903e25) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(-0.33709257603124293195507028119800782045906909741744e29) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(-0.34045760513207184782093332672320294037673131611059e29) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(-0.34161007485887152238616864912870480347288507162545e30) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(-0.18551822752793620713822325188153262242725685533531e32) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(-0.27265467193999091898539544511315099900724392737831e32) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(-0.97192179293684933315046857174580532063103657123436e32) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(-0.11068590013273104512181340846994193230564361908758e33) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(-0.23081602756115793256370959941397733891750628652849e33) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(-0.26011074910924910611853955074413958404756343137404e33) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(-0.27213188281855178261218817125866024382548846342993e33) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(-0.27730764236939947790289699259241391177249293262925e33) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(-0.40576121435044118588462972832105434546536361800046e33) }}, 
      {{ SC_(0.15e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(-0.42910122386691981061040626096253678706190307675951e33) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(0.50233958213933091481556756926100573547874232094054e17) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.11109423266031709914153858783927085719523688868867e20) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.39081842154282765284532530332430894623970132549408e20) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.18227713296295012175223024577585534054558363436995e23) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.31947045675481698112603715443085590953583305423557e24) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.18299617184176162280023440477921333396096635992331e26) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.1048741594737987651639784322340092001259210825773e27) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.16709392027475601597453535769399875878228995911653e31) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.16882490292815347297737783754053067230610069916271e31) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.18563337181845203987465669262650786770637199950992e32) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.12055029515350726388385560208511706327872275858073e34) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.18046248323929698314579628682469318787465246907743e34) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.68445492874724925809578878619638737640954598883664e34) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.78452635719678510746170484035872111471922272752428e34) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.16973572771972187565362410058062257400086602104375e35) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.1924375659079197078836080976061638017639056325322e35) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.20179247720751744370334363749101622327159753620443e35) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.20582692094623424620919127961595574320408855452749e35) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.30706177786579732145788727616877967751862026587334e35) }}, 
      {{ SC_(0.16e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.32565439353582396626049780034304221724191993725509e35) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(0.39144262976111062001040790257198820782376894645183e17) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.93946359169760655852237969851869668037050090915964e19) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.33520672218429269333576967863094373817466956040661e20) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.16475226352025508074365944215659294885027735798331e23) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.29383820887001530085483863874704214151422124222947e24) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.17161518327551953907629910526854855125842389799905e26) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.99028920929173139026116070485494946413158885671896e26) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.16201407360337514222308944241902563343801662209673e31) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.16369574108109305210961119372262850817071285070832e31) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.18077908156304259564018512322038327349674787967557e32) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.11812210760044394936303727046916532113731011274171e34) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.17691806915802320564789012447893611259970828933182e34) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.67208685894750394919941141113129962495028729571887e34) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.77047043830181647039844160570427958334683499199535e34) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.16683792134524168752385147293364666302228129075364e35) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.18917786709136892733685480613451055515995918179382e35) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.19838444491162691032491650332795317978867767437334e35) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.20235505141127640292662449974477191996156766099522e35) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.30201021666857662799477096490080162433586363979659e35) }}, 
      {{ SC_(0.16e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.32031661461515822811899278162004785685167481784967e35) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.23372833945672876871009721108513070628777521926613e17) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.66743335305123487274647957143020579828473584782742e19) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(0.24527476479498498719057633836800876086167554956716e20) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.13430468725538133999724935780437295037696453373137e23) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.24821930259421622107569062566854999932275927682602e24) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.15080717863057284099485149461214450479917657621035e26) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.882395947921383105024686719708572394458883569935e26) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.15228483995825675484284777189043318409379031447308e31) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.15387177834459646578286655732715343612140938633364e31) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.17142477477141509499889692665160555737235700319977e32) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.11340247881412951437547133346306504718864112429694e34) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.17002390519182979567839540436926444176326235690797e34) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.64797595718402992456269088372028298433905154538852e34) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.74306315881848582497793330548724170622170519611931e34) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.16118075444622167795026492553535960808153915363602e35) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.18281299373707256076409110414106755763297417086589e35) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.19172945990837312515306853658758336525424624228221e35) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.19557520721906097876987422244125638835835875273478e35) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.292139699654978917573793301052607441881825284108e35) }}, 
      {{ SC_(0.16e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.30988594406865470755204575454432344262650823114461e35) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.42235817004164247396091193754912808490135009373415e16) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(0.2258685595327441677798893241233813078458460016035e19) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.91689821064294505668033227646731096701766721059982e19) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.71447947988328171691693360808973893010937805216206e22) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.14784248545140507745397250452689603874763259533344e24) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.1016366748156639270701599778738969093996875282093e26) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.62090626629669973210032323482499963588005347680142e26) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.12627529650581726848577396522315779153441196546385e31) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.12760701805949493049998190647752200498505063386322e31) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.14600716852307464441864338393573833952129447172798e32) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.10028102348651510136377986690114539821758136279363e34) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.15082020095653232773676286725185652338442347079668e34) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.58041269678926019673782373726843066445073233130142e34) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.66621801866378653762922155010429020791811146244658e34) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.14526813407907159441043328347296931435441781532765e35) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.16490064389087864897597466441977092128381927959496e35) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.17299709339172213739415974853453930333565735218722e35) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.17648987504958340816927865390815722189813066155159e35) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.26431011341159640698698850154535070237724742929664e35) }}, 
      {{ SC_(0.16e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.28047028665387483308135962257305491243960044960008e35) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.15885564407235044547491023867968950916811590698909e16) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.12662417098028100980074621151068856625450714523878e19) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.54433979705676182354511271430007365110376068988658e19) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.51550043549365965230019623080268728874827897269309e22) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.11329295792090024761427813565589072716216805910412e24) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.83106509254530137628716394816749630716536505159275e25) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.51921775455225193686499227197429780400038458607139e26) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.11488887904422512686538321081942069537437740626765e31) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.11610785117436369741736851838323355853870906702795e31) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.13466459980708956727965479731501789932476742801988e32) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.94266856429068819659066839919481315053568196116131e33) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.14199872280093523466307759159527047029129563882797e34) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.54916099824704458123308991900647958747304376771922e34) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.63064893417084829421997283764470874402028505785345e34) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.1378753453185119329243965179516070023842521040081e35) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.15657393239346351522388324966270079370015366872251e35) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.1642872720694566987104382246221477685296633345041e35) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.16761512517015029115344859046031553122376935039861e35) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.25134559160184366642895362434778755280931588737668e35) }}, 
      {{ SC_(0.16e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.26676326249859660927286233196954351258725464463451e35) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.11188774670482768069829076509779501595048263093907e16) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.10376360632188560257040675159390498431248851932517e19) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(0.45528284255034542346699670577025762926902700081308e19) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.46156955694503160391787656096189155194773060561394e22) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.10356052777112723811080472713945391563858435060315e24) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.77666199955991768581708164857028254815069473817358e25) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.48893433982899221382370433556938596853381104656119e26) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.11131202527285071646305090076054272123159654227975e31) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.11249543518484262867099754329003241266428180698935e31) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.13107078621845933449561803203223255070287574187868e32) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.92338366504030659897277272935363082352246726166459e33) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.13916724194825382523522632660564041535338009105298e34) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.53909888119511127520910843714434556178131528369722e34) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.61919329237686557807995081867898001245619583220584e34) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.13549042281320821383025101038378894160520171797667e35) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.15388702261727910051548443550060894426221104131743e35) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.16147646185474131544506244188743666366649759819731e35) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.16475097244337919777172081430698406075764784340257e35) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.2471581302717718273330106558942270668269580665207e35) }}, 
      {{ SC_(0.16e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.26233545458247779399501329223065798516718021380795e35) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.77644042136441753608206387125166433621657356622054e15) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.8474890540086640140732176070592917740001140511704e18) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(0.37982055299686142249325651661193175676043407979984e19) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.41291929734585543415702803481799637281720291329054e22) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.94611053375165527130537647213213910739613695747915e23) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.72559562810587384925105458280845422002790578656244e25) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.46030602920697002771217623560057672156263103643568e26) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.1078395569521184925990095791430166134879759579615e31) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.10898837284644734661245374944259387363306650737723e31) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.12756687856208395519695851574017849175000787179654e32) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.90446861392263395138721857314907483333902307193475e33) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.13638868985627778192770743007297325294701224173184e34) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.52920959906114511474323350252066009503061732270315e34) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.60793272663424526880642145050042567502072004744183e34) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.13314417407286711124447047729578297525469906409946e35) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.15124333848778604168561169645754216873352165378337e35) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.15871073476582253059048305912664502029476803616533e35) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.16193270084313363936107168700617927817242089055022e35) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.2430360701993448663323726041420006791587300451631e35) }}, 
      {{ SC_(0.16e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.2579765447900192973126656903168411152190120824265e35) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(0.5297128410350209632949648109839312974008732961469e15) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.68979691128084950112845858001941317747483883038609e18) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(0.31602488012634929031214413391083499153963955793749e19) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.36906787440627926332648923260048370950389401590056e22) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.86385809704282586999304303110689460513728314323387e23) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.67767508412228221150189790868659123020544280911462e25) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.43324843514795901350104606642054503851788067014878e26) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.10446863119180606327945887633103653528338526698732e31) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.10558379679512662813424441617536184422929919421613e31) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.12415077781349523997309682924889144371527902108029e32) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.88591679116984033067339624796092157109629738640121e33) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.13366214313687787273785347562184174295693980245806e34) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.51949038113177662141172881680320204182430695699081e34) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.59686413662097216429424010965343148179015568553308e34) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.13083601379725553191883338130164320186552400123418e35) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.14864223099669355062442630095010077289304601946963e35) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.15598941593763701276436117741405841785651315153103e35) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.15915962441943964458204271708025513905469596122393e35) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.2389784580558404544735263068587901357040764089831e35) }}, 
      {{ SC_(0.16e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.25368553255135009920656162770721574734839305165891e35) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.16835759643034236257953725148520240561404628201926e20) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.10893031341791870859363988732258087836735465936437e26) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.17957750800089107092129935276264025973557392271513e27) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.50088842060820030660088008039805564632369875945552e32) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.12362620371076551137454507893335687705962665884731e35) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.24664179419103100287681650761791481295020982199267e38) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.62259508558223105885034942877599365239721265558061e39) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.26490114942384932450948341522751303885192769667454e47) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.26984715288014727919328670776881673651154999030438e47) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.19784553574470650500538170441978016609524232588137e49) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.33737653380516468773412897631406650179755679261691e52) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.69133024526517954444787693684418475556662724250333e52) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.73833944902060417837119042213113793776487208102967e53) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.94073038095317564939217941358670703421495886541365e53) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.37002601719349382297182032078548946155324154985378e54) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.4623116206430900676317959084644573504328833881106e54) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.50292064563512935696876653982037350985131453969896e54) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.52089203158390920849265306865009285834329002616505e54) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.10587950565375210113447322206379893258441893821851e55) }}, 
      {{ SC_(0.28e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.11751067846519589575025977408680528699239269329535e55) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(-0.89724654517650600952187586316507861937068402433819e19) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.70501039615297291760121639585298805810086427194785e25) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.12392451992525862631670680984505098509146581913807e27) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.40702318785681471453039273478082054014327203143201e32) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.10476904725631189629434817596732656990010591621118e35) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.21816513439750283140846334717439897358476376341641e38) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.55866145698296082114947892612266848925395698364568e39) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.25044565593807267095445972647518372240492440322859e47) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.25513152001312543861344744406305302862275621122588e47) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.18859503380717786752600192086501573951570086175591e49) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.32529006914539311065059051931257376092883415250536e52) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.6671908699513475958799246499875897590580295106155e52) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.71465226339156801083140010474422948014903539465995e53) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.91081044905321793226180487216200210146249989815872e53) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.35881972163746420840999121133529949595480070377733e54) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.44842145931340948322795209780377838276955584766534e54) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.48785579978187229973193103138209431928041554880964e54) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.50530843159852944435841581426015320476757025202982e54) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.10279121267311408312149460734435549780353690038787e55) }}, 
      {{ SC_(0.28e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.11409587507226644665260692025151001461340761376758e55) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(-0.83878381639711204091739272986692587508313990119595e18) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.28217794141202170905617514210918955488768234646038e25) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(0.57408930041243345300440818312898616080447569417598e26) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.26713456845623674311542974484763082526799756364373e32) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.74973295004119674401463106252541637107617863293343e34) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.1703772978542448309265056497777974607920827194875e38) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.44917380041490299123087177865046381882522260561908e39) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.22377779741119181887128710984023243137326922779696e47) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.22798226254429515066978941421839129100741989999832e47) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.1713270184563564821947720253518351959040621342843e49) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.30235577732906916988145935280442167144523526791971e52) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.6213239765217041106134362816427365427112245449859e52) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.66945432215618547753090048405428256786477314273291e53) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.85369622080848474268416726458860002941006054719755e53) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.33737967999539368390812097993348958341412559200472e54) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.42183714013753860672960925547721399998150894484962e54) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.45901939518518062273335681805001477275144752449357e54) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.47547739031458586198100013206013664733387574259638e54) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.96872851373465372484348655218015423553651963778019e54) }}, 
      {{ SC_(0.28e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.10755074160655130324682950937688241242701348418451e55) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.72546676839251933027058608533224826980102388232903e17) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(0.99452759492318358807776681920484502454837301234727e23) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.42604878830509845958779637538374688482341156535884e25) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.71648133610323341298398235054516775821700929179652e31) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.26647937078772337786362180696058500544579227244727e34) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.79904431749228041725452676266878030792317330063778e37) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.2307269253831622597281321555040398080303955364599e39) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.15917093644853113785813674916245841748430329708e47) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.16219967578961932808570843841200598487704912296156e47) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.12817497933739775795110805362493206738001738979751e49) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.24251639583888835336936074564097189272303147915783e52) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.50122149752344077643739849971959781209319435873034e52) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.54977704396136482960613958778075124783128065539369e53) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.70230200665621836975545995561389884715838526386868e53) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.28020794186966106977969070788148884498833665151733e54) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.35088092215864331664534132282061982826987336073755e54) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.38202486591760462592498917580436449404704763706425e54) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.39581539380665906317723125475402623915762751677211e54) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.81021722724520305323962060588650944142980127155151e54) }}, 
      {{ SC_(0.28e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.90013473462954124827572090295038087922418076589202e54) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(-0.49274777221478057496531303487709605619467769162398e17) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.6325152795115993016380711121657813622765140552189e22) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.89545582947021917851467475214516482955599039019089e24) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.35912068140269484291331427360185102771010515967136e31) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.15597571594657675752223460055845766212109316859991e34) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.54225173606926363036770415518864982200702225423065e37) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.16423101461549186717013974669825872589983365381989e39) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.13401837243896595403368212189193796116632009199317e47) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.13658489009016962484462282367749813441756332369564e47) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.11073201533230227054546633618364715407351204005928e49) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.21704871547947812362196878143690282629610996573136e52) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.44988928750299613926036027983023958345998097353565e52) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.49794920300711509697563319103870608290511739378389e53) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.63665477174029587739219541704117177042202094074113e53) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.25524271297574809022785522264711271563865850691722e54) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.31986210880900382499402165212441120086612002836873e54) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.34835237540682318048091216711932249499352445613566e54) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.36097029323800386148118140460333662071756247178793e54) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.74064305959938631336270944943457890555638691220358e54) }}, 
      {{ SC_(0.28e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.8231213167489931828030811417083497741992476896125e54) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(-0.35496436168338893803203570874213198857147582086442e17) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.15185846454148377906338296050903646184100835195212e21) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(0.49792718921269128222652161628565066181287848935409e24) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.28375149142167086727665846625854818009649642711189e31) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.1300950054623817511084792974706076683654198958958e34) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.4758480387016663330910435048746056389504187277968e37) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.14648162975821326895560583581017547091918606466137e39) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.12651901268174570332017575684221722234826200231198e47) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.12894711753110476707736585735872744236121047256075e47) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.105443224915917283547178150669003331736732281242e49) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.20914705834409552587110234249873181959239359819876e52) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.43393278899758395457698030294560586661732991556485e52) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.48174384243884528180623880541564326688447251000553e53) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.61611669322874087176344017469725380312018006986608e53) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.24740774303466806838118856765796994820032443323956e54) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.31012250741025600741258462749651359625762757734339e54) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.3377775849517192071997372020286153256453145713607e54) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.35002640224115522721697373949977747528177794474575e54) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.71875811482280194480909740913335364344476421922115e54) }}, 
      {{ SC_(0.28e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.79889092769570879806659227024891781944940989040718e54) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(-0.18950209178425471157463971046157378460943119148383e17) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(-0.20692404641905589370533998771951939155533708570585e22) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(0.26297403160194487533323907228663215747459299434439e24) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.22357240362270708664799120737397298948579749383997e31) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.10834590409511059424986116223703194797874419265512e34) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.41727706873057351874444297556126677961077397434787e37) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.13058048815153080543622338863902651082280867653029e39) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.11942423299190949476018871632877475397763248537939e47) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.12172111179789993374314926990288378157214683656902e47) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.1003979822763859980338530217338745238373484837743e49) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.20152276528421011517501698551890407954798795512325e52) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.41852197601496966432061617332036481097019699584493e52) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.46604700487067258136415336573898767467103983186224e53) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.59621745804091143211672436774437865214062544418306e53) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.23980467412791563794272294998655868718578968034134e54) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.30066886341242654474413549165805412254546301104618e54) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.32751232730288932940048844111327444219024325729677e54) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.33940244056089766000667634217784434321634982380748e54) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.69749671125478321374879305012380823810121786324491e54) }}, 
      {{ SC_(0.28e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.77534830401778729865239548352948049790800708581448e54) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(-0.57071598395670510649979626384151301722978047491938e16) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(-0.24175586516694390362330011176989022987135213482562e22) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(0.12884707674127405924425724227942119191613787630186e24) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.17564708898864086115880240759817575013972011166297e31) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.90094671588017186053852553968997874090462624509757e33) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.36565008875251524728797993707619956363910765890186e37) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.11634241131539329959273010022347258731919414666432e39) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.11271301933286738288914833277809118166064996506298e47) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.1148855001203216045673966903348821440657681261374e47) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.95585488980750414895781635785545471466687120614006e48) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.19416646160239611971025914715513410159075316172304e52) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.40363887954703812972257543835255291188802181306692e52) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.45084332487432407020250060647132449807345104584892e53) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.57693793192121117062833906501076794075455676537583e53) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.23242689698820928420782668223715582236675627478342e54) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.29149309242697453879229762491809005549329753751094e54) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.31754787822386445347634210258682127826108368105881e54) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.32908940239908249750707073959663050012997198708335e54) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.67684174196932714837573547210525321901188100756139e54) }}, 
      {{ SC_(0.28e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.75247464789406254881646576715850940360968543281461e54) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(0.10999723182968291453614806876732087604997675328875e20) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.34816107995000250435639682340253442347372567560489e26) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.17886849305242356450260813514229045084762073776349e28) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.10503930504771183356074550848878999262007833510402e35) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.73553066722381618500803339756356762198284504624408e37) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.5538188934403863186821810746493427538729366001867e41) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.23961072093738698340228617582074544474367121229783e43) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.16406069822528156992611213359520052742424767967602e52) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.16759788346820384904819611827457083226472082036547e52) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.23628945095297356918574451494762828460738846888478e54) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.1232950829256676245317136507967813920374878971557e58) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.28118474617559213271913744489014319442820512247439e58) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.42718125298886498020586557145596612220734824247332e59) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.56421570570438385551868251798112624211081644754738e59) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.2719158195735901934308917204078620361851437667156e60) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.35112755443351191222204143299638137036047695173494e60) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.38676396790775534215489863855548423340435503235137e60) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.40267330995238668247034509817146109564882805328877e60) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.9091276056398603312150447657677287095739721548481e60) }}, 
      {{ SC_(0.32e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.10246794066531661559753421937892608296517890145017e61) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(0.67101337764335444619832750694255707083436604528415e18) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.16241127394807005442764918640086425895422529263411e26) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.10479986363958544296525831631278972472670478306763e28) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.81457354904736733628383983952457681260134878098883e34) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.60292545775719504274922942213160721248303892245743e37) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.47907943199158795353005539943788245981966759215451e41) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.21094421289663185507951031457065709093752641578152e43) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.15373734585797459603878475032869737490760179434778e52) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.15705901920188732701602357558641170911194272740406e52) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.22356824040844733057690493198272231709519637341446e54) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.11821879815575534800532372782550627229068647608851e58) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.26990287253215009373076736732240456427376723779646e58) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.41144099603769657000784061229020148313011544750806e59) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.54360642546573364787831336418177745406674319748724e59) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.26246048202788539359396011213738869831268480706631e60) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.33901507864364849988284358282806714307386916179263e60) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.37346247783030708729119132328021685067137792580674e60) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.38884212812261058405479834252826080293000450692588e60) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.87868623202875744916521528027441463707616541820232e60) }}, 
      {{ SC_(0.32e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.9904970933638028979930027699619891738593077354648e60) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(-0.39418024433937211855639959059749438597351680401702e19) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.21945076544301124170948783790071054291269061025092e25) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(0.33070883827794102588711696662120797772003624730607e27) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.48563469795989448826516685902490388226309489363502e34) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.40318006528929334197581309411225900967778035526549e37) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.35765566548583703401159594334480537333716001237694e41) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.16320008288770695183582243296927199911904718263474e43) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.13494109890053800061362895856437317734691082063261e52) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.13786913965349179148758354160397392903281795132128e52) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.20008254145695716398883597947847068186784265570372e54) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.10866578202028634980659126016272752822554839501029e58) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.24863809194990656316035271865849519018691629128369e58) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.38162655088998505887223629999685542598274128239543e59) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.50455061435990913604655924572950237668868338367805e59) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.24449492950204826007836199424966348646978374149033e60) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.31599130624389990447461933535729481194075716362141e60) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.34817464939704710446748008710330550925343510510916e60) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.36254558301978683689323521232922513645343965269922e60) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.82073471835208667922511968444219722076812070759193e60) }}, 
      {{ SC_(0.32e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.92541175030769033992840124757330125958615660649087e60) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.34767003244266321899096149100119699169539553951002e18) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.17074498410800360239014807928583498252380756786676e24) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.46960126832842412240310365960140043562097124466815e23) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.95311843607577707246526542884541866299967559900284e33) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.11571948584802024493830541197814470743423538893234e37) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.14592865748742210764098619879875140705273194096078e41) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.74476035425023241632890194738565864492008791212413e42) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.90936792603560242395601494705127607601784626540361e51) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.92935703137037893697414869073178560150837684685031e51) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.14306528364796596194954921271135522553330289577151e54) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.84276023197699906333090184371251323489429605342632e57) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.1941210368476886973818957028893230479319444550836e58) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.30419361931338465006762312565678887204139374623349e59) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.4029882207736942195223849341434434556445603345131e59) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.1974517284036275468549318730778250897299017754876e60) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.25563706554524614722877043772183206768006290349496e60) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.28185817319311875664243168075373339550032455015794e60) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.29357197980320030472694387226943495691683655129482e60) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.66821359200404688039243547160368294189510272446085e60) }}, 
      {{ SC_(0.32e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.75403070575956973230941133282295178994702251131288e60) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(-0.82829485479772225199109356404432073693543786776427e16) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(-0.36983557935788911192797799572146680051405967114983e22) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(-0.14390288588811182183686707792658593697110689220826e25) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.40204641681549519964288358140203716515970946244517e33) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.6046700801223954269404109324111031736568941280992e36) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.92142941565380342270863740417776928078607071863244e40) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.49881445446269394550445362993109717539524644466849e42) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.74503951784935085800347375468339055214379722850354e51) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.76152398601318404809160845111890554020325705738832e51) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.12080500973881285741420577575188927844147478238988e54) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.74159064439052373949227477101522458609244277238199e57) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.17139493611090953254442139764241281150428960194877e58) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.27141412596572266654060222308812440310433988268931e59) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.35992971192890355762092503175647061340790597508753e59) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.17734311609964833337458350884459406430878137637691e60) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.2298053014606589241494394653968346109968783973671e60) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.25346077191771102679364656991564628114172708697112e60) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.26403080170946365599050960128890001754070006579763e60) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.60262591182852953929705568502949735572050131159081e60) }}, 
      {{ SC_(0.32e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.68028991441096338541245167586557134125561984259282e60) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(-0.50496708702691648661401947402115423150612692942205e17) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.75485029644374306567107767477586998660189222134583e22) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(-0.97092504775116702625992575231289947939116508764e24) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.29905063234622119752123882895114870488160341027171e33) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.4850917055764413156222477520232841681239775431556e36) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.78908777839299949809660227085464515659572829232044e40) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.43585328614540090973248669297367698466953658587628e42) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.69694214291720491655190213718198044678283288046614e51) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.71239626756134554936442938189920762406154448240904e51) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.1141589580567485641125035833206553427830524928365e54) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.71055763597069501541696037624394092768824714114279e57) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.16440847495725933621779463361586183254171688853654e58) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.2612676929480656329904598247358826067299120229457e59) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.34659266861774579962447242091100144231808471459054e59) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.17109184337198472216128613245423612638218967750159e60) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.22177021867820119386912126690431887901559926026622e60) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.24462572551933353447546890677650172596180118473896e60) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.2548390743458848692809325785026683581683362538272e60) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.5821817176285496998789884534615693613977043761042e60) }}, 
      {{ SC_(0.32e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.65729837208747978256831172065477794983760821280586e60) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(-0.55136627956932194273563339740697311499788334368279e17) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.99861102140791890644641302097875201336678306069079e22) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(-0.57228405128495149386689390631479103910157548663304e24) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.2214613947954068610538664432349842138739825755778e33) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.38835423822998294641894597685347216811864872502724e36) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.67513535170583164938598482367980683137002166832105e40) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.38058325573142940008215067817429924405230388069948e42) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.65185207987785011344783745453482446228573587745436e51) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.6663381702625812292752561626308643863787939887826e51) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.10786705488334864255673692154970585179475464619457e54) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.68078255768732070734722852660339614144994947451597e57) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.15769787561161380877848837293058420077025002483814e58) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.25148869063245157944063595967837072655911281501267e59) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.33373434697474133002510086469769328132323281636903e59) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.16505402605875523035566358657038146101416719843237e60) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.21400728426533974996188481818804926738210446364354e60) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.23608900584148629200890755719890896635021889995786e60) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.24595732077850904277945516447582318850852017148858e60) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.56240938356963973123978518468015581376957683853167e60) }}, 
      {{ SC_(0.32e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.63505954214182796289392342951556715316655739839102e60) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(-0.3942645895083537625574118828229643257211900740936e17) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.84294512634677064441795986319490091074678347321013e22) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.28998419188777330011231973963029370619651349113588e24) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.16324867772468091081304173265704265963801017836655e33) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.31024768226844629173925353489789140274997435607553e36) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.5771025829127958454192186174359767096100886459393e40) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.33209602924875822282423216820881943461260366842317e42) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.60958740098935953811511375780760893267225968012075e51) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.62316412467422691494226923938771319378247769365909e51) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.10191104032755952229686806327523051822314153673624e54) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.65221606829231005462234403409544590900731560441334e57) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.15125259787214174675752642479455616980998178722566e58) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.24206424344714827208129330592706611281663705185948e59) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.32133811914623484351967944028361578182839476281975e59) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.15922261108606243446062136902543530815201300190903e60) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.20650757844299949399849896263931275319419403954896e60) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.22784086503902756420761305368893296975869212916188e60) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.237375425537776771307251035640462824008860896292e60) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.54328754369512172708327480333255828864417787382524e60) }}, 
      {{ SC_(0.32e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.61354957806595371320303190584157607584029182846491e60) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.25419315924149875007371610234696649505007172769753e20) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.98147606994478535641819275836202280585694523896319e25) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(-0.20861147383722826276911770080908162939858530817371e28) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(-0.58662906858200537296776801909444561428134884878597e38) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(-0.75865539222874454359755102693356639123477037424547e42) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(-0.1695046526984175160913163650213687029226489502928e48) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(-0.27505118155451057606304393207025328776042413433892e50) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(-0.13569634805393063359600468613726765666387979714905e62) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(-0.13953717382991874041546131700867716531854838304472e62) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(-0.89482414136441493320647327836351018467480855550897e64) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(-0.61265017322562462694530082133674320548912297983034e69) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(-0.17858266359404648160531544853286958308960605241372e70) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(-0.60818555915204679198734317228971543721776906380647e71) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(-0.87221513134540221913175968390363464334829298009342e71) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(-0.66895258300754642802854195025092631157402033582362e72) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(-0.93149270378309351019733213506315181125675740664117e72) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(-0.10557020622200268737123209921563143612794221484977e73) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(-0.11122711091556718035503065647866305953241070910743e73) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(-0.31923014044153480060402416496223681118821520406848e73) }}, 
      {{ SC_(0.41e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(-0.3727078906643500543713578199592587387917778160971e73) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(-0.11068016580747548632626366758235169490778609161226e20) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.16820929767724442543975522991847893997860230675137e26) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(-0.14482110911669557732129210315679221248561646851659e28) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(-0.38982384405979647383275684471489599291214325802374e38) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(-0.5660008578183693336501219330625399397050776279047e42) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(-0.13844982068375210958201341383946196919117779517605e48) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(-0.23080057431158927143956149760297513120107586468293e50) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(-0.12452369178338198071628977789532651910511867571771e62) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(-0.1280561662141204711089665606662368338252675896932e62) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(-0.83200880691063515134461712042224157364724895431051e64) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(-0.57991172123894455959547752463169257214138305919123e69) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(-0.16928625955525904584672052656260029554382144882629e70) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(-0.57914325350825197035996328166012110835765976645936e71) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(-0.83093042178479596808976357542309280567209992587267e71) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(-0.63882757780543106703617385406248916096073948323499e72) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(-0.88988286201437191785841092981970303442103409295739e72) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(-0.10086878687553857549443332912468079687999773408047e73) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(-0.106280086129324008127046505265519246012876755797e73) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(-0.30539307383233936474035362086714674739087624236237e73) }}, 
      {{ SC_(0.41e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(-0.35661387037443452788259039526917889244076411880967e73) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.57071806871990297835770085115737011816166072345254e19) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.83602835029331108483826876032953054137050163694379e25) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(-0.32605670939276417357655988117227611354786441337479e27) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(-0.16784936234194392839638605252986809776441734910197e38) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(-0.31199170774753176185463747882848211554179203794208e42) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(-0.92006158170349937687043037252815796651933619505863e47) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(-0.16205523881541417807361226653842667518652476137203e50) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(-0.10479997142199955468533080558976489029874592281237e62) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(-0.10778629707936833836643133446904785075364926530614e62) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(-0.71899502369589437707147792891069740807748147937015e64) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(-0.51946801357001690845955437085088179802281991047643e69) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(-0.15208637124882335332758246176908531713588035650018e70) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(-0.52505596540299028567632994397585949505794895628135e71) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(-0.7539942283817674848523230291681366935530527208666e71) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(-0.58249124798067524797230597564211228343574094831555e72) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(-0.81202596177450506445709134094029292580663300133347e72) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(-0.92070054540542353718199386626018201322889497829261e72) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(-0.97020902907007354022012292745001056543836026098928e72) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(-0.27945014468939628009207005073599736523039751841738e73) }}, 
      {{ SC_(0.41e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(-0.32643190699062421955174308725628994473005521485078e73) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(-0.11638098878883185404071426284025733774525872818313e19) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.4820478922241670739904241805367302196821794165608e24) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.18028572502075407380626802264093731193207576605188e26) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(-0.10344641329671518107639317217685370346064616827232e37) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(-0.47951828419557036397443969824633839397524246767777e41) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(-0.26128895058751169209961960887367392275922443511205e47) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(-0.54800205649687628370026503290672776310887185936249e49) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(-0.62171180297616842692286491518717310457161744187216e61) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(-0.63967052364000101534892877174892162732981104268441e61) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(-0.46242509389987516617469346563273458676697235008194e64) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(-0.37267336828934228274351943124034761437642254340297e69) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(-0.11008277711696230654556586928931794679606430612995e70) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(-0.39067683700910858541298936300286579384959605130305e71) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(-0.5625269556714907295189763375090803721864016107247e71) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(-0.44099662103629972459425342173303660362095497038002e72) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(-0.61619675835608586956856265233896340289520991700577e72) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(-0.69927032641425706961006871618913249151745296475473e72) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(-0.73713824509815646466758091894582228169659165707057e72) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(-0.21385164590219968714564623100031741356693762201802e73) }}, 
      {{ SC_(0.41e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(-0.25006487306137423524077756352261875456711393539503e73) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.38756432787003897112394230576769513606571947771529e18) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.99839989345285547538184487258457516863522476198653e23) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(-0.49853515675952341423879069601691425307315450005619e25) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(-0.20703626346223992513149054721841249552292037676472e36) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(-0.17788999256438247803681415262183226225635377746675e41) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(-0.13652899739422701988778282284035621578560602823046e47) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(-0.31429365275889322289079354872507617764945120947442e49) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(-0.47752894251726036193006212493542977764254812468721e61) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(-0.491418154422385043465314079144909533971653215621e61) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(-0.37013033219545181956252106796571743384994805843335e64) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(-0.31531601893121155833953237185394892820409008424281e69) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(-0.93560449174017270992926516843653681084101092455443e69) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(-0.33671025920845933994628330404706359743128884449482e71) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(-0.48547902785506115081107471593969299206814079814412e71) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(-0.38342801257718425392155329928952849385489018673392e72) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(-0.53638338755841488414666051437494065888408897957385e72) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(-0.6089640716801969399750748987025041150970512947946e72) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(-0.64205885063398489887611624729520045394561471921696e72) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(-0.18694659877287876792786166426086039507588733485358e73) }}, 
      {{ SC_(0.41e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(-0.218718722409308456586240728039465456449834443671e73) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.39904754079242376592002759268138467606037039734643e18) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.10189001009097865402366220564318831743294144929342e24) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(-0.42918687555550874859874826339311369654239232796521e25) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(-0.1151068044262893075425560397545812481549033633774e36) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(-0.12663312084210513047239702981750785288194047083153e41) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(-0.10962660898850710282455424139756407560301206382129e47) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(-0.26056821692743657744935836782038316256880592789176e49) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(-0.43714131912107494130379425306924012662054811196202e61) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(-0.44988522307357322573741774680246203596065179611056e61) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(-0.34355707288876586284004263128481334807866368412994e64) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(-0.29818241109745229656590730863344860961358416681219e69) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(-0.88610230674684299948868646060297634782036168945087e69) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(-0.32039151274788874804440750667683974546918286008973e71) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(-0.46215994418152381763951866169538023759743727319216e71) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(-0.36591895781418019516193088684151288857469458203439e72) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(-0.51209003990586443701751285356459773759185743443067e72) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(-0.58146896977368645682691596124004226974185180713823e72) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(-0.61310700590854934687090590676640794792162596071696e72) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(-0.17873429196565537183694295307275306802851338721637e73) }}, 
      {{ SC_(0.41e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(-0.20914752701677190350213150169820114321351731360709e73) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.23814064270628925932374601491769017987207167984736e18) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.69929296960759805716913293689686080628972639807548e23) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(-0.26961099618889940997924329478187194202858969003127e25) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(-0.61750915689853607701504418512485648830252765729121e35) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(-0.89693761349554688024987239265828716821197287253054e40) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(-0.87884892725228915019765917512904761318730268620943e46) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(-0.21578934771366929645242109168128340893728439124054e49) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(-0.40008525238128332752148623239763519117976521642327e61) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(-0.41177590320103816066295035661579257120564960875981e61) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(-0.31884471364704101118276914177627629742048549798212e64) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(-0.28195699847084293524922578689922418180517364239186e69) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(-0.83915509699116147296400601053787049039806563376846e69) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(-0.30484430059789664086239492597223896239340370655202e71) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(-0.43993353600063919183393943460099155271188707798633e71) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(-0.34918988409330997620795189408254043922786861219854e72) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(-0.48887004499374786076347645733736919681359796636954e72) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(-0.55518491841138759952195876521067463200616974892712e72) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(-0.58542872586271560151990933199570714145132575434884e72) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(-0.17087391643982559292131727667490401459425399952619e73) }}, 
      {{ SC_(0.41e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(-0.19998492541202024256975749986171443811079709638996e73) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(0.40711948512157230147880359995277465040996843914162e17) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.32501921548266647189603772086953178607775442882282e23) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.11852242048826970088830541028479867117837664207482e25) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(-0.31600552147926110338671183117665880279439817429618e35) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(-0.63196186774256337032724976942103729095306155704798e40) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(-0.70340645274857472158861627490662854534125285055461e46) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(-0.17850659337726892706200991328689558873343859721589e49) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(-0.36609287137306391697266638699334555505968966863277e61) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(-0.37681511669909514362070659660311262374898893103155e61) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(-0.29586622098251424893778431403915214422439245303448e64) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(-0.26659284940190086426089374672129836105377147802328e69) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(-0.79463430187079415076461571563649160393001591605559e69) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(-0.29003306042235692662243162485823418936400711614878e71) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(-0.41874988749106071026077477732955288128993747757124e71) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(-0.33320691663765414274005456637938123640286361610155e72) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(-0.46667716799936462182104365541775542599092022637108e72) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(-0.53005991307940787942986127470642183859561841589863e72) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(-0.55896939225711764978562532549614018753339655321111e72) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(-0.16335076857642208614245131720237561482457092780815e73) }}, 
      {{ SC_(0.41e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(-0.19121391202291572296449027033658220467866804505022e73) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.21359474784266081689770425925832397437477262193879e19) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(-0.4010850781004399948143042288840675571042365793259e26) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.23866196019292253682652447029177669047583988172241e28) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.11059725670377187735390085931929897586000631975326e39) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.21477932899019225802466796495889574800663243670749e43) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.73240038041454877326015927164978577972770724458566e48) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.13922090122902779381217026707692529447192100244206e51) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.14728016087569667397190828754034493940094897658165e63) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.15156252306464377174991878171124363445534520033844e63) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.11546822787289685140391005308513806341009256667913e66) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.10578235992023012122210745155465353458375714854618e71) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.31700159700280375187847446742234210056855072672343e71) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.11823970244954685220527044789719445964560394682583e73) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.17114997332841744915759235105827955211584341118446e73) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.13831189378946387269327579836857053966297663685826e74) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.19423549179450721994821004329951968476465025032177e74) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.22084282336084540624080065867344952176724780172895e74) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.2329878711939915580986493074900525496363685150844e74) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.68698686097979329874903517836254812165706398555655e74) }}, 
      {{ SC_(0.42e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.80525561720036237740551891365146248108066846059254e74) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(-0.13203964059174156801603409350818409234526335380614e20) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(-0.23287578042319556937454899896558861712563427257454e26) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.93840851076226959505232367134984477990223413205822e27) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.71614872297792229970625174847809376568791993950891e38) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.15817924320835532465965577165264175403612467391702e43) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.59395055973079666367814585781032381053652944940961e48) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.11614084379786886666821411731662778135181341597376e51) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.13482779169735847590027930975081228749043710900988e63) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.13875690644323172463902212564461995107281844136912e63) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.10714813980379049989046388188091564767362007713602e66) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.99983242707840675626152676308336608862343317954264e70) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.3000729710472778472938024147660820710141685818408e71) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.11244826991446433250167081508059324856202734916124e73) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.16284066911056948947669471530404862405912241192573e73) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.13192361801140956202291405982794564805336924202591e74) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.18533666317436350076962593400132265442043990939219e74) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.2107559446732915486913573257609814420792480283209e74) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.2223598625810591572859446569635006250350808395047e74) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.65644755359655936227499981627583344691797636132031e74) }}, 
      {{ SC_(0.42e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.76959423016291892461725987412454459183659204871158e74) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(-0.71444195102282619490413072573261620192277066633173e19) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(-0.99937645376208120496442316574079144135563230678117e24) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(-0.18098636500779619378869171381812673954517457870581e27) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.29137473989540111064148772810774292035765179994334e38) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.8488822311954510134981366734878451882483730616555e42) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.38900628671843989679026839384924092726373854551798e48) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.80586469750742682224070506370843067124752761310452e50) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.11292296312725344140109981139844351076836274257992e63) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.11622861987949849068534884255718974000736105160342e63) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.92223241452533838939325380184689165967554230777165e65) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.89299763441244239074091328065948877154852161458406e70) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.26881813860453921851314081710833675612000672950873e71) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.10168317155263015921265931740412242801931115879417e73) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.14738520621678082631824483447226345390170193138602e73) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.11999844525269967231911290659597259927316401501989e74) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.16871554061345071886388238323323195541108946580806e74) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.19191177720825835528118235442583612115579415202175e74) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.20250300127306462978777953496453657034353300094747e74) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.59928842754255881278061767154512711287277717307866e74) }}, 
      {{ SC_(0.42e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.70283125705887393374898970533384900075677361431288e74) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(-0.37232259440551007904419108647161913688867149131376e18) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.12656616309227519234804062150230535575389105373578e24) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.11121125033168497162790871509632901343057840560871e26) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.14173827162180799967103697414037216309076062920444e37) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.1193458926715322948295029085476813154016420189069e42) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.1055453489534846641266669543418816728387523734135e48) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.26266094983142122494568778827797558508629040543892e50) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.66011202522174076815871997486791659576418473322679e62) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.67970219541792296184145740179755223106238693024715e62) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.58597666076404317143494031021224791081602796496336e65) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.63499919797998424645926800383437963837948279129038e70) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.19290935564081822247733655422527561443818826509063e71) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.75070956336131595838789912667020690214659087700923e72) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.10911217946372322543693942581358144469063932044255e73) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.90187542661418182230613108757780048803699259726556e73) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.12710365781824840096911046327504024271824169123875e74) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.14470797052435878411306593441864915314524649901624e74) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.15275085745694370407276596387840974426104216046952e74) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.45540815114604128649362267107066655756251253024203e74) }}, 
      {{ SC_(0.42e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.53466347202715989861729340330777367209839211099474e74) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(-0.39153630455495741045774375280380675698257034398595e18) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(-0.17018972911970248668275785929257027580160663090018e24) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.69595031894312660777154484919015428711067607371055e25) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.23037961127207740667796861812511909567327144419796e36) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.42077649904104640362928050896857145193997745614009e41) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.53838415983797634806590889741503775771818379652116e47) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.14778454217617661914180607041369474600235202599649e50) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.5032566866979539081935004409215402001246270126687e62) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.5182957148136669332140993143739629704922250597426e62) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.46615222543646183546502915508206402466652934906839e65) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.53487606264692007612533128828321396142399772251962e70) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.16324712792563530867999746102974246145226380354393e71) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.6444734571967625430181383191639775796913445138712e72) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.93801892931730344937532629105929383365124993336535e72) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.78126447327792031669649189893780406266951945843716e73) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.11023798767626438671609586655033250029347208880008e74) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.12556301602772680943254896899059665562520939570186e74) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.13256671936314523803637803812730743976381906848935e74) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.39671197866986465841190450269103357640529670712364e74) }}, 
      {{ SC_(0.42e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.46600412271264562696192507709355676651691796916768e74) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.75112362374663554622838398775779190778000533604808e16) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(-0.68299719028723832659095653649381958368665181606756e23) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(0.26676344338761785917279658579704059056828374574534e25) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.11527280684578809913541257837053784751836808082056e36) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.29414337819894127315688347915106359905803698530856e41) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.42875755084946924524135465601747368211517173269987e47) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.12172772048343296139687023363165642974547143320732e50) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.45954255478584641406312101561461618746257220147249e62) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.47330719250630961064035753969371676689615988013155e62) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.43179651814758524918102489195358268985866298065539e65) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.5050578215371748464687405574198691004626393058384e70) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.15438610485816687868511059642371269797406018664942e71) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.61243430592197366821369756849629360514442622786223e72) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.89180293489915106761137442488975580989150620604614e72) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.74467257749650229718029881025365277381205000023372e73) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.10511708727720574234592073801468652291755351445577e74) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.11974832632998994486427980937819623292779087763047e74) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.12643564930405974456766897905964336028460280888218e74) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.37883854947329912122821020738375826960244536840201e74) }}, 
      {{ SC_(0.42e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.44508937001096843661171192692373665219556623780698e74) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.24565187894375561478602985479526809894987173320785e18) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.16295779320359730578176400403041222603074582007918e22) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(-0.28475528012815508064467089848313514603059442859311e23) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.53521891155934491433908159858052198688115315091441e35) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.20444961684938658513189623988523488223683969805551e41) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.34087265812424033022158873850456892079644146407893e47) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.10014878571206603175162812446352808885174299408327e50) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.41953402954771808131097239237485266834459567983017e62) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.43212960218620579457406250403213750977559491925557e62) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.39991204678288114806274797777595506011661443085718e65) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.47686212169009055294381797872994668228212194159921e70) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.14599455388825526395547053631833399307007953031173e71) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.58194987586218400412745807589906970890508585720702e72) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.8478095812990871484279804814296566546203174982475e72) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.70975358908717129955950362084539872988926313901386e73) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.10022838682726826373828597344131283094941753479207e74) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.1141964771458760688690602217260894866077291801412e74) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.12058136204543258855246988573968628887008955133869e74) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.36175115782931656193607847971626786814301996844939e74) }}, 
      {{ SC_(0.42e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.42509087746976641235473617693756520838448652816798e74) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(0.28636382745591284493391021479054556399086857712201e18) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.34131499480302620247421412127257300868082901083074e23) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.12136997328955125169475211926963002263868258636075e25) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.21921339008008381095236976740386318408675497661823e35) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.14125343007513024809917126294313115314153354235071e41) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.27053201284938285806272711101390606626231617902347e47) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.82298126374339139045427133134838529978399134361676e49) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.38292474241041168961370575367551811283862671296689e62) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.39444809051629628021199184437182624740069602615241e62) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.37032542468462972316896954637203984569417518555373e65) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.45020283674990046651772860405781684617674479379689e70) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.13804821086954732244782437916196907703077937115118e71) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.55294656981994831146521491341324628996868514559215e72) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.80593459254998107740190300369670136649132375049038e72) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.67643289742340588528549816420746060624897677740371e73) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.95561615147274617520075536887135276689508332528364e73) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.10889587801508199007476160897902526822177299598222e74) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.11499166812286141205461363248472488699475558580658e74) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.34541608097167435332183334799603030666056287566857e74) }}, 
      {{ SC_(0.42e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.40596948626747484005828714990390698791661972366296e74) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.29274124972633701570564292792031859629711879838857e20) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(-0.43551505296472007762182583258767163285663695146822e26) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.24455546141674762028980914801678476587962659025292e28) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(-0.44860498498388343742934326820509820115044504619735e39) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(-0.35932655218892004205858182423674489692897442756058e44) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(-0.47037022246279297816598769010931325915837303401464e50) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(-0.14615196666916328996784412454045334845765429827795e53) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(-0.15913095488560146744508198573647780920019427652806e66) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(-0.16413088821949460258127704634006614333903145963927e66) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(-0.21073282920616312629232703845759786403626518197732e69) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(-0.4655330002921972977222878037589602118478572238595e74) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(-0.15166545156907125288350216619915917563544867967108e75) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(-0.74437396731306058953025262438777948266668965321046e76) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(-0.11080232092013776235023981122241759543882337635608e77) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(-0.10483957808091797906097583143677121209443584433792e78) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(-0.15104478172497687075315559198658302216821980421276e78) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(-0.17340437114876778749564805156956445918166936912147e78) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(-0.18367967720887278567016618596884991290819858312266e78) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(-0.58751299094600472689015374414918656420331205183898e78) }}, 
      {{ SC_(0.45e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(-0.69693141609850983120993020431531230192680193988462e78) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(-0.16684661217739277666198397970770987984811087994828e20) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(-0.194551759062453755910615531609665584349690227622e26) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.83839154351725995911566678804821490629756198330423e27) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(-0.26114802125593751881999007819348947458860662788706e39) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(-0.25336814784035961443322189894592839818128233517725e44) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(-0.37290403939153211715621822181229802537137052984718e50) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(-0.11970873741494677668563168294976400593454647559022e53) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(-0.14460857918609100105772506470820471007130803322658e66) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(-0.14916262041689471651382101593166755895371007300724e66) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(-0.19436426523182449402977121469602612261170672743232e69) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(-0.43806715909354543644934075240707343453715879325229e74) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(-0.14295011407046961505692411410234648994724449517351e75) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(-0.70515668285003909372716830966621510643561174731402e76) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(-0.10501625147980215352949717933686353601546803747292e77) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(-0.99632365566829006137896021069715159039632639159213e77) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(-0.14360343374974471878484473226369188566014798322108e78) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(-0.16488770110404943041422384023322849571226742442932e78) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(-0.17466990653988925739631263127844278071271051930333e78) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(-0.55943164112120066996155176980076108543387279108017e78) }}, 
      {{ SC_(0.45e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(-0.66374671778835615061106907275595257720512678787067e78) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.60341102903970817465629836527296942664383007219215e19) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.45951503536934950447309131429467587768340298086962e25) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(-0.35032066840676987480391666052772913110515848075275e27) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(-0.8305778807963484169055791107743191778177638568682e38) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(-0.12418279194202088406978444893968482259110836191659e44) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(-0.2332220423605303254878100707358942946042216280311e50) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(-0.80033591342532725993993494030209934966796613185064e52) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(-0.11933756047424799413830351469272123573613375499298e66) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(-0.12311306579710795071214515153024184776996876194134e66) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(-0.16526377267017562638652053409778355871558725495314e69) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(-0.38779904242549596651866105496117791129365969797541e74) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(-0.12696149770652710559839924998882256794167076535682e75) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(-0.63268071285690107145017479406955376823354918209641e76) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(-0.94315607262634119149544528728219377600806138898648e76) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(-0.89964549906468387762111981298317372447963282203614e77) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(-0.12977916900431059311175893739958384256718566666756e78) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(-0.14906208078982675632997616659309814093904428954593e78) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(-0.15792639806980751147233645262030916661693734960713e78) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(-0.50714590444049195943441554518375000278495182731574e78) }}, 
      {{ SC_(0.45e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(-0.60194173038716297422780011839202284406287894637518e78) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(-0.18253260877797764992750354000317206528923983665559e19) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.73946943613766903950931608210878463232355174687162e24) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.32370319359833569594523274885456122088581350495781e26) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(-0.82500392120735413298555180294044875821042087444241e36) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(-0.12817941084113251882825626123069576850063412666378e43) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(-0.54719171788719775083707720610314862368576977146453e49) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(-0.23238237438843154912169908487509421648268269290893e52) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(-0.66699601369524401585244551501454389010443465618146e65) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(-0.68839406223598354479997330607998598784763060125259e65) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(-0.10120040259379092953635612936812625075216995401234e69) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(-0.26846089785251847935133506102733153107762992492581e74) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(-0.88769051573501320696816215005365976547770798601523e74) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(-0.45620096792925838654790341659221588064002106379683e76) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(-0.68210774978916700451537794151541569006784898245873e76) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(-0.66136987524580307242269410424342351312373430708626e77) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(-0.95652541722774255153412977647631567014836391799747e77) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(-0.10997122122894360053007627043100217768346864173535e78) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(-0.11655783530023270959884177725299867911303276065742e78) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(-0.37731206032352365914876708929449329992287455874807e78) }}, 
      {{ SC_(0.45e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(-0.44835854807885337834962841104499559098502297668907e78) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.81464730308514291790955054812081785084985872782559e18) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(-0.7755659144622048806584041505317005251764462229187e23) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.53665454490884156928244439712324212505169961977013e25) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.14504784318758867293103291029025386340989492141124e36) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(-0.37640444007883531637674751598294723145660286799466e42) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(-0.25842958456491327021003550171607722930283378449049e49) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(-0.12309189168293629927868226960661325527673140145106e52) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(-0.49707033777482524297842373862629728367057899894763e65) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(-0.51312992598835180588742492745896035067598577941467e65) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(-0.79017794680761591428669772452867569988916289157763e68) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(-0.22309642855468898837703420170924859501646062926286e74) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(-0.74141236532301395993437122842557503685733027292229e74) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(-0.38701691425289108731795960983914690726558977823801e76) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(-0.5795399481157823806876178780247512749701055801335e76) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(-0.5665882940877040849069564942803722757749390974443e77) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(-0.82051251811832676219362840053925933363770991161142e77) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(-0.94380059638508116035033900280289772296489937387914e77) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(-0.10005322172271841100268525743082821928607609841622e78) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(-0.32519942758777374075144640527935348814713681398308e78) }}, 
      {{ SC_(0.45e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(-0.38665965103193938037332568536616172608348194824624e78) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.72413661121559299010680116115717551526264493743781e18) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.67881905423496700999236989655513868913775011329425e23) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(-0.99818854762116167570376810172961762895622194888639e24) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.12906772033618559755390956750298262495559972202533e36) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(-0.24614915485002465976525652441570206235737099109054e42) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(-0.20044702200359641892041032677462703744252860207732e49) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(-0.99329247753367376635696498141857809221830935821504e51) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(-0.45044470958002410532192469100564215995888914293673e65) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(-0.46503237690009959147736572560167376524932481751263e65) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(-0.72738032391030033321059670356626506329568596949499e68) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(-0.20970935470297452005348050560256113055686398711447e74) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(-0.6981010177928984554612947977433493120069419153101e74) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(-0.36631912352769728297329091975852324896018735936738e76) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(-0.54882396859720707564671628077739356964994903041733e76) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(-0.53804802942821536043461681183029182163868589045869e77) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(-0.77952150125623056923488632950606821328032853399736e77) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(-0.89679735596126858994138734145283982751718707285726e77) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(-0.95076845201674713762755834820526966667127231390139e77) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(-0.30944452104817332234110188373979189312059542460008e78) }}, 
      {{ SC_(0.45e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(-0.36799935371595952757616496589992329045135430705121e78) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.33252645457044408631279390528637819358312477201633e18) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.11483560684388803497075065554278875153562703657879e24) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(-0.35794016703975172774608571376815792250658373770363e25) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.92977138450765292283402986514466302063615553172253e35) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(-0.15949943281665382460080074668994985859122746550158e42) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(-0.15515037911344884531528033959947219483448957998808e49) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(-0.80043928280098414821983667625988412726556745469951e51) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(-0.40809403185316856070980496599903149133490031551001e65) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(-0.42134157682475158792560506142630683691630179926328e65) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(-0.66946140040927977436402500169848048593506966031597e68) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(-0.19710763510408441626498019698166171485505549571423e74) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(-0.65726329277208679533590061324665636541578984414974e74) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(-0.34670355512546552986840478610509846912034635968223e76) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(-0.51969962817787806739761093994722930583282064500493e76) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(-0.51091333256966059739530364964810016074638126078237e77) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(-0.74053263255291032948749285662558387732024169566712e77) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(-0.85208276683329338297682384139102670627824063571859e77) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(-0.90342459985702419002170217470607758455632738477839e77) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(-0.29443587111849658676857666533292047061683845210936e78) }}, 
      {{ SC_(0.45e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(-0.35021952695818267888629224968171311185386284106826e78) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(-0.73819339394390948538561004701028550197833191316843e17) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.97436012295256134096121994735911896215994354539306e23) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.3590793652136163629394344329319763764198675950356e25) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.58697436539336138214750144065091213142617912513818e35) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(-0.10232993097120978607346305651137750484401893699268e42) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(-0.11983433576597672081401826908047364081609355643254e49) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(-0.64412951999386022447089506727656680491124839052783e51) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(-0.36963537985184819745245085785278975968577388995451e65) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(-0.38166307767179149895193094308848773942951602864047e65) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(-0.61605085087986960802381364937894992796161978885499e68) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(-0.18524624947434368696488150298614456622641748058275e74) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(-0.61876114204970943223574085055633422800684328007007e74) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(-0.32811491438921383317215468738753124311706991066799e76) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(-0.49208633339854035783256166523388881338207129152126e76) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(-0.48511656022229745520048845791737654703740031073762e77) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(-0.70345035039321876833392790636091919048075988828817e77) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(-0.80954793312314045746657374100847933397983828946714e77) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(-0.85838566907989240579722944017822122162893144120735e77) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(-0.28013893619064636659853856672393961760519984022334e78) }}, 
      {{ SC_(0.45e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(-0.33327957380998208681970170799654079959221588832505e78) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(0.31101763331955668194447487120587936364346256014167e20) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(0.42267833981947035220265591128673251413883339951645e26) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(-0.27563975272532007331260848379833724903407802405148e28) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(-0.65405977491530370754836310447385983318854476542225e39) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(-0.1799903088898663524015618856288291891867493808538e45) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(-0.62436340815042534040285637249066104829387839949218e51) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(-0.27339223220708666325296171470054985818058666608929e54) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(-0.14631272033298605340890946932067241338126030321208e68) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(-0.15114215438481721410077424958849169364033819347547e68) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(-0.27601472386636982179411627497478741597555457793174e71) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(-0.11025962464533033838642553295976962012397545121313e77) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(-0.3799570754845538116614387506599134436759244083397e77) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(-0.22422829419353665265949814814354836949617820760875e79) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(-0.34009502809176549418106379416079988229889708318749e79) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(-0.35772117909293679342741673810218810571733259897595e80) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(-0.52430089289383546766310422093242129865815249794125e80) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(-0.60583259246953723319154714375919613247448317568898e80) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(-0.64347035019810259410638642885764592466672053261792e80) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(-0.21736733403239177932138563415697454110920201364344e81) }}, 
      {{ SC_(0.47e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(-0.25992402909300571713171690757861655684392300484906e81) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(0.17976281268623917719266591994390673123544566479837e20) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(0.29181692556877302777814458986321400489656466451801e26) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(-0.17289852147960591138166959175105713862226251163543e28) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(-0.33335278943933369595132374179688356862292750580931e39) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(-0.12263872763333682349831092285727099989452605376034e45) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(-0.48701336904616759410001262488971836779681613132943e51) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(-0.22105290916442760094388409995759879629964049776431e54) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(-0.13229637034743840505671076760798869416380788293625e68) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(-0.1366732781095952504699323492346597480230682344436e68) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(-0.25352980128001067213484005811593604258686780186494e71) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(-0.10344492997843622358621014677970271541778493092883e77) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(-0.35708629528440082945777717664751643717089957086461e77) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(-0.21185722185121137266498521248929770917300379181853e79) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(-0.32149754008810180834923991111795603959981062687715e79) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(-0.33911822183407967774550313431810368438779491291824e80) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(-0.49725669656032034127826364824272139629326001569461e80) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(-0.57467912676184474582794373376869362777458889332318e80) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(-0.61042399190702385614950227007409923726356134823907e80) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(-0.20649038397643325254431240042336597944248663996534e81) }}, 
      {{ SC_(0.47e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(-0.24696709431217851700660769241070534398842979086119e81) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(-0.73081251542816933061499547454243244509907630404928e19) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.14582296505589710967719479009344828840009419112744e25) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(-0.90957449631659087712712112247901863400515918561829e26) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(-0.73019500469097895638025361029413912228746974366905e38) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(-0.55917144686888800461844088093163341708421213798709e44) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(-0.29466576180300634056033145209488693765195359574125e51) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(-0.14396520232107722845214722810156813503336310705224e54) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(-0.10808468108848590018241505148216350808800192620711e68) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(-0.11167723133344358268979011005448317907310850321513e68) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(-0.21379736691666705252030247283993412307451952101089e71) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(-0.91027710899858407433887015207697753217987172528895e76) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(-0.31530883832891163711848815939046674114575705404719e77) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(-0.18908367686426138734291660914686449144642298547486e79) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(-0.28723623201541760784689044418621614542133762261314e79) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(-0.30470551327123388157317742072532702368474819143648e80) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(-0.44719650598388405593160025177360009532631324734177e80) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(-0.51699841618189755923678686048001067813423272330789e80) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(-0.54923238391076932071348456328947751445343838416207e80) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(-0.18630895494609058661514047861613527358357054138741e81) }}, 
      {{ SC_(0.47e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(-0.22291938031476423138544669688081834222727393053012e81) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.21188547631664387983458447789537038960779105100885e19) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(0.61158506244861312781656870133336928825909623164926e24) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(-0.17052723712233405244856221307226693091950897921076e26) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.17478938058510736433951957505830077037568884031657e37) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(-0.44633578572341736961120985293083747359937999109499e43) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(-0.62246000843956066508460636921261043691312722366536e50) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(-0.38515254499227930245586370980922829833765474037147e53) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(-0.58593299077417591428160573966305567717375507945608e67) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(-0.60568515695883428116393195843293665122325796999439e67) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(-0.12768431820033106051695378990023618139059249428503e71) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(-0.61885634378249806478668848799452081085974299700936e76) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(-0.21662174670925226904784772604358092811731017224908e77) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(-0.1341900951242765058597532246093558391604535926944e79) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(-0.20449017561862799895005210264107308841339187876755e79) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(-0.22069507947458542746378915461099893780826507399505e80) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(-0.32477910194623631679103502403496035389576286494523e80) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(-0.37585584475093384547238256579815704060458771576572e80) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(-0.39945907081998585347317226399285809699766535905174e80) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(-0.13665112891682520480822852537431761728424096575653e81) }}, 
      {{ SC_(0.47e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(-0.16370307847451197027992115292401569912145718345458e81) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(-0.11813099865413477795537497884035409810811280657803e19) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.21402842023494021891915106093184956999714155584467e24) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(-0.12810128759977923559002610898053864419911073001189e26) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(0.37120257551889816079538311739766697847463756349153e36) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(-0.11135166927153545457405380250982248434055893169601e43) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(-0.27794836921154174827998702922968736404916712058401e50) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(-0.19544232559373213732173121212732051192931866132352e53) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(-0.42995017699424363097392751332625656970905083859288e67) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(-0.44454804789003913314223821544545455118368403060047e67) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(-0.98443013852420029593727888070021134858754208879255e70) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(-0.50961481400380441651127671683099065065972319586976e76) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(-0.17933292114266592544897195050104507720745196779275e77) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(-0.11293238937123159255713797695432033331944511181818e79) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(-0.17237017960295976654690034089714988660837720691349e79) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(-0.18765728526232169747171634782102449811174173995231e80) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(-0.27653884835583379075071547248293892229438826686229e80) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(-0.32019390868445758618136628663568557837215114414119e80) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(-0.34037456519754288614125946686307202434894956276373e80) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(-0.11693642962064115379404156842508579672636513953803e81) }}, 
      {{ SC_(0.47e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(-0.14017193684850157741222699877112443503550795244699e81) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(-0.89466120609314228516210904715755615717329203175778e18) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(-0.10016103276034210185411172456445547194477847117306e23) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(-0.36353300748736374321427974922199746818570636764504e25) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.16720365315243105509699869903844787685554556531248e36) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(-0.68422516950767118394926050722591138057549437739037e42) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(-0.21146805708617736266736970708754314077973451679294e50) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(-0.15542241494594643466145075613014091545983100772974e53) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(-0.38760212325012234485031221998573317642866989132491e67) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(-0.40079375598833640654553131365371098692984607177334e67) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(-0.9023616275194773336163444625072266432828844732154e70) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(-0.47757642895787219497682427840089985620840188500397e76) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(-0.16835813632511749253277059606217007686539773673673e77) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(-0.10660710289400912385121909959634463900991534677926e79) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(-0.16280267564764199570569993469188186222215525315461e79) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(-0.17775932911768948405404542624817036690606531716283e80) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(-0.2620731623095434058735154130140302190467099810584e80) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(-0.30349699664404411477129332288673750476486873534444e80) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(-0.32264846541251356042153670699185440954442729813277e80) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(-0.11100501958330418619670658354186774305311964307321e81) }}, 
      {{ SC_(0.47e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(-0.1330894097368999886421269994368707521731222457881e81) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(-0.27548597107449270445767440062519313968233122571891e18) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(-0.11922501994312060431922275030195191285047021350049e24) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(0.19600669398331314172561587759323358311311082712521e25) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.56181869236729241682017267193695077300069120305681e35) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(-0.41443307911664164675878373604354777633662690332216e42) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(-0.16050278287215786158628041890534613699375087100068e50) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(-0.12340689712617057348336866689556016026299902868296e53) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(-0.34933500982453274433379497630520009806163794721203e67) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(-0.36125287985488119582808046247623049104517113093885e67) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(-0.82698773051884716903905029433122674283757755424141e70) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(-0.44750912026298081760502164194062567890563112909532e76) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(-0.15804061480034114641190514223654173288875929552487e77) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(-0.10062851997191212067516862702447404316950592810002e79) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(-0.15375487132050210293189713942656106714176612004073e79) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(-0.16837228630562693123376980832496433586113527563414e80) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(-0.24834800889580593132580284640174709967635193695017e80) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(-0.28765216737046393674419718297918045786386456718342e80) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(-0.3058257902273412588918356492953428723244613608866e80) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(-0.10536804541708571518614017532398260985049098506049e81) }}, 
      {{ SC_(0.47e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(-0.12635710215225658255091329235229878242259040197029e81) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(0.26986992454976592770819924120614132761079638900312e18) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(-0.13099792431495086435691233341154638229046822534438e24) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(0.39646703024037366372607707147648825799206042685986e25) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.38575218603635664817859794140334908872105878127025e34) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(-0.24697091969682189564177002137256167694177836624665e42) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(-0.12152094223473603258659295763119649728937658085167e50) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(-0.97832674506333314549995528333745073115279533541454e52) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(-0.3147642501974616257918022412031949172914637419987e67) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(-0.32552863449814390010014892072963487255479135039077e67) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(-0.75777434202701570054199426264901634167188683315598e70) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(-0.4192942740628328771028678205102129472651245479925e76) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(-0.14834185441761450972327542926146972314012769759308e77) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(-0.94978051964204331332290309139990978572213579331455e78) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(-0.14519915332676075051592690582647416087475905821838e79) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(-0.15947036005378667586869467885967568136324263441618e80) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(-0.23532630583246167554642420769582489949647465273024e80) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(-0.27261688603000689917456761681263189029684023731186e80) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(-0.28986150071124884976793182103900955632612435508163e80) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(-0.100011210187057890542172305672821416265467526888e81) }}, 
      {{ SC_(0.47e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(-0.1199580741414231585465192869757233534716507740408e81) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.28358735383550705677269332681562566538357128062088e19) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(-0.31411726418386757337504314588159522719030226665883e26) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.18938555662734926466542719315959788183570526737809e28) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(0.59971974943566306634244706892336696018873678757955e39) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(0.36974665682359345690923851305669366496655506662195e45) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(0.21492805006741742848975097253679221778904854909598e52) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(0.11230172405985135735776011524109114066208566147381e55) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(0.13487952499537804614110090972274150998760152393817e69) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(0.139439663820356498750781525959079729020770561592e69) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(0.30410239602455926578629287029479170014375483281297e72) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(0.16363653120893027974181361894535807965019048585179e78) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(0.58002570814952860995175631118947153556025307525238e78) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(0.37549727252315700341349823032936065536886812239125e80) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(0.57492322694653018594714296993495232766200247807703e80) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(0.63772190475889197309820972735125572701232776805052e81) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(0.94277836675861962051683414990434629292960464735996e81) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(0.10929391497850682398499813168869711318202391165403e82) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(0.11624160220508684959350126567810510282171513664143e82) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(0.4035777848910840747448134491445414831880774108573e82) }}, 
      {{ SC_(0.48e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(0.48453563178995659405568145006185781997317875117746e82) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(0.15140407730268847151539658726234416469708853673629e20) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(-0.22300338615094545596898556018381222293737602140821e25) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.16487035147743353283757601408540743213442755742657e27) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(0.26636695999632937039112332712648339156580928177024e39) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(0.24710792919025663341092759019942266507202901286161e45) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(0.16622671316280066907974971004782038100936693596303e52) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(0.90196433143408597263371705245331261032121611697379e54) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(0.12164988796063420563542983296194264057122073564454e69) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(0.12577233600939697370378829103561375421846373814764e69) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(0.27874941589655819857280886448319809588506805262647e72) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(0.15329203821108665738319260426738780810841199275891e78) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(0.54431707862108852700597859352471989184316311816592e78) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(0.3543115503380358661469997090804308844515677432094e80) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(0.54277347293772000511221897882315672370202141538931e80) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(0.6038100825754840053236594139194453585735482767587e81) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(0.8930526971025875863890077850800741533002786457905e81) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(0.1035471237108883765267186943510101769042780227208e82) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(0.11013736228601661103200624297736411044907952315904e82) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(0.38292874649344074949038220910220488524382874686077e82) }}, 
      {{ SC_(0.48e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(0.45983892235873874235502068082078728557433577209134e82) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.10149305487959725178666530778928419221775841991847e20) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(0.12250581715920905952009839171250922953038870974382e26) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(-0.66089809616469971823788178277786649052507963821696e27) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.31690208612833099803702370222636697802113260158637e38) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(0.1081219879403560651724952190780263936916895833792e45) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(0.9884229065184398991813841134278089344475419817553e51) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(0.57949175293738296578325383502367150636969103817252e54) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(0.98882036060226524352301188616565040267698119444162e68) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(0.10224864393679922775217922964147341088022903532416e69) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(0.23408595268139269490121475091846006707390452800907e72) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(0.13448502502930735988712497769999606825038935331803e78) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(0.47922991885638500351811571040876847009672541689829e78) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(0.31538777175147893446588546582363980296436578325635e80) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(0.48366031893463359057729818890369060959763064372293e80) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(0.54119332676804817339428870008539027948767028403842e81) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(0.80117527596149111623191044437059786110795225073783e81) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(0.92926204938390180746843671583296203500438539619041e81) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(0.98854652887723442316130080000282467004290987522892e81) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(0.34468324134792752346886723806587548273430808124576e82) }}, 
      {{ SC_(0.48e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(0.41408275768243453994558468167404886818302633691608e82) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(0.16597727196612779081570985096724186865347513181316e19) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.1128438540169180862643954182112710199001368752496e25) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(0.56763123156302316727658482659498035809819718669032e26) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(-0.24191302746236976150925219649079593431714110447074e37) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(0.74093598275293935451100409535462274475817473802054e43) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(0.19756127750343396041467515917820356766416871761768e51) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(0.14857396468155736619207355242702052965761321034194e54) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(0.52782038932246507617372576335724694274236047221278e68) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(0.54604792268184783688285045280818719026417079721788e68) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(0.13804494049961421793103705494136937889708116032135e72) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(0.90600960962193239211982698981138629983108091624061e77) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(0.3263408322579853237853153405867786223689729290169e78) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(0.22204294327710797611559558299744817470822226896886e80) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(0.34161295102097822610902671634635151782488810782443e80) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(0.38905903425420462244805403249704394645580203132721e81) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(0.57756079142518855961689915482445734132330301851694e81) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(0.67059753988085646834969100443151272256593229588289e81) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(0.71368993323494377826275985739688913671837754471799e81) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(0.25100836179969527945312514046506044094438105630308e82) }}, 
      {{ SC_(0.48e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(0.30192424408059560069989136129045064472264782312031e82) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.24295355542453997455088095231618566820565255886206e18) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(0.31186941589283269635905625476109541678859453562036e24) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(-0.68196793727193816642156505861216583004271979577098e25) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(-0.1612747767714563500184577448380993646135282722084e36) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(0.16660832751313705268420772354045591103459787693494e43) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(0.85634966596605094977181188946254508052284604397935e50) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(0.7372449745967162990561233434934863030854907377759e53) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(0.38428251563444070348551872354556973008198369002676e68) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(0.39764899368763662838084739553276377398649024015765e68) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(0.10575274912189266849189880719105075019133754711026e72) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(0.74266142541434778815757076751454493431108051162934e77) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(0.26896494892805084534313152354263703680683325376039e78) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(0.18611704309408815944305474346684789475411519072609e80) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(0.28680904476810422453183371554359045132811636435558e80) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(0.32957438859388121416461677098590323288650748282779e81) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(0.48994352340236260508153466649999730726333518316573e81) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(0.56916687439696826237924177921340648525155058394227e81) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(0.605874449982844372152174236614709835853048538707e81) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(0.21402265660322861366493469926691941290774697319345e82) }}, 
      {{ SC_(0.48e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(0.25759883912134666904888307980053061619353597090161e82) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(-0.65170765066860231061122809484137048896763947289572e18) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(0.30185331261679848617364508230464986959411668850305e24) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(-0.1045500944759301909635844807834163298228426163416e26) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(0.59288763809747050785409542003485122420172931040781e34) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(0.98185810562369934289281672817864772977048439195902e42) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(0.64488160887987358710444218237500193974311152718641e50) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(0.58182255965076986439467258736334538762565973004615e53) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(0.34552230330942846900048750154699641243911670089427e68) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(0.35756961808880298772629426416739267529350563298032e68) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(0.96729132846697895155735362565978483758508702378104e71) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(0.69490378251856056865988833967445494869024032312895e77) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(0.25212913529553909608985446393642002912029348008672e78) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(0.17545633280468724705793283350721343085312365604817e80) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(0.27052877720334002496126372207440226510590083904012e80) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(0.31179845568211226575921222836108619619590095111151e81) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(0.46373620717140826449418312519859428535866418505989e81) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(0.53881717473256385090211244692473273477506371040782e81) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(0.57360960344159301611002056591552439489860580889372e81) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(0.20292215464489819504526404091273263860243500888612e82) }}, 
      {{ SC_(0.48e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(0.2442898981476566701846703798568435409762237463228e82) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(-0.92719362174309501506890249546656362864997069861463e18) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.18262829267367788185442233200269795674364647500256e24) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(-0.8494942507759887679102289302409297151153153362908e25) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(0.62110745617703946760558221394043589542086413409759e35) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(0.56742502650705769613403299213509995343385748863685e42) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(0.48437882600771572551816176346965580274936065618573e50) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(0.45841566252459929091130392046778522736266070136319e53) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(0.31058880232697519456710800391647640263295290617307e68) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(0.32144433010331486814348621791976962618898851988643e68) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(0.8845925554150942346534485962266621633013292683569e71) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(0.65015287049226248689938617548039238079967721021941e77) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(0.23632507381550498144866394971276585583141755053423e78) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(0.16539348080749603499041597080476602653617306323816e80) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(0.25515329007128981466807400813174615839172422703605e80) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(0.2949612270515495726358352475285897626097874235481e81) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(0.43890140628182767136160284055841957539102899136487e81) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(0.51005195799551745722769272862681468898867725368948e81) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(0.54302702441885889022083700098599010766615967280506e81) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(0.19238535010318962352665002338033437761738591038007e82) }}, 
      {{ SC_(0.48e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(0.23165418793243101192957905062161366273396470612577e82) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(-0.65732369719332908736070325426042230103917430961151e18) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.51630368358727017497509998591151574453178249658184e23) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.45302722053561510418415185876444145712325490943094e25) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(0.65968267478067513242344200808077080429297001222462e35) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(0.32045410681023580049226297076253827649207912239021e42) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(0.36285788377297969293156880583845930545998407533405e50) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(0.36058298801826597636130839213404015424738116782174e53) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(0.2791123773072290319879277797961569109038065319732e68) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(0.28889146665350047813347132584680613893350938484736e68) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(0.8088151212123926645992491699617605291341405850413e71) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(0.60822344308597919918909939342937108607316475542016e77) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(0.22149088837374353047633640678661888351740478077492e78) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(0.15589567561107560185718693989076692867895170530502e80) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(0.24063337473861373961648131754909874230424832121421e80) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(0.27901419104617090504896577964262219447346316010648e81) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(0.41536877569858150380696041978883708544138152609185e81) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(0.48279026939251676731023596694555149995899322995829e81) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(0.5140408743477340052440438188820891520335472372969e81) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(0.18238422908448383447243279281305223599083915769127e82) }}, 
      {{ SC_(0.48e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(0.21965838051828869607492712192404132738679962872169e82) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.9754039764404296875e2), SC_(-0.33206177306860901034098418198597629379140610858059e20) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.12698681640625e3), SC_(-0.28196665298434210086077878529005387276221823960713e26) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.1354770050048828125e3), SC_(0.1592616399596531819269368502130603829210905823746e28) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.1883819732666015625e3), SC_(-0.37537932279682254631376130221199241034724019227793e39) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.2210340576171875e3), SC_(-0.71474888666638000785512139053701915411431688780992e45) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.27849822998046875e3), SC_(-0.71229915791301936694098512201872127350700490137862e52) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.30816705322265625e3), SC_(-0.44578729873115166164577362501394188799965110092782e55) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.5468814697265625e3), SC_(-0.12118256060250665066422834145579285785999339602827e70) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.5472205810546875e3), SC_(-0.12537736450854839510520658499000070776107799007353e70) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.6323592529296875e3), SC_(-0.32684152122782175169107512080326284810879619460619e73) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.81472369384765625e3), SC_(-0.23717942745856996833634836183139108617311962055669e79) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.835008544921875e3), SC_(-0.86483275359917540644232605309150757023817316114033e79) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.90579193115234375e3), SC_(-0.61434936319702661022539416657199509660223531462324e81) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.9133758544921875e3), SC_(-0.94956174206533901497672012903515610767471871513573e81) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.9575068359375e3), SC_(-0.11109245320852877885120232969005657495122958717448e83) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.96488848876953125e3), SC_(-0.16565898242054343582618214187951581679447302846679e83) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.9676949462890625e3), SC_(-0.19267234862027382839086629560703055871842322512147e83) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.9688677978515625e3), SC_(-0.20519946682114906608003313954026271917045934968001e83) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.99288128662109375e3), SC_(-0.73227176306812783081581609204908054790199912737931e83) }}, 
      {{ SC_(0.49e2), SC_(0.4e1), SC_(0.9964613037109375e3), SC_(-0.8827169460933748469859793959028017528197667629454e83) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.9754039764404296875e2), SC_(-0.1806576957659205388255875947236321290943175718443e20) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.12698681640625e3), SC_(-0.30426699159943664645767734130843509505595584174795e26) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.1354770050048828125e3), SC_(0.17574867510739653521069445162160112613453333811725e28) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.1883819732666015625e3), SC_(-0.10901236280049317592263797508550901878143091050769e39) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.2210340576171875e3), SC_(-0.46764095747612337444419380033759648904228787494831e45) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.27849822998046875e3), SC_(-0.54607244475021869786123541197090089249763796541558e52) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.30816705322265625e3), SC_(-0.35559086558774306438240191976861062696752948923044e55) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.5468814697265625e3), SC_(-0.10901757180644323010068535815959859380287132246382e70) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.5472205810546875e3), SC_(-0.11280013090760869773482775588643933233923161625877e70) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.6323592529296875e3), SC_(-0.29896657963816593183379423435494303852028938934355e73) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.81472369384765625e3), SC_(-0.22185022363746130259802910140465230536227842128079e79) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.835008544921875e3), SC_(-0.81040104573706655374172819373903558105385684932374e79) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.90579193115234375e3), SC_(-0.5789182081632230236106941956639520081570785403023e81) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.9133758544921875e3), SC_(-0.8952843947715670144654982311528404353045165735968e81) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.9575068359375e3), SC_(-0.10505435238277393879796573555086212136549410440689e83) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.96488848876953125e3), SC_(-0.15672845544951755996229206402871507526147024200888e83) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.9676949462890625e3), SC_(-0.18231763624918499073819442617192954102799542284939e83) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.9688677978515625e3), SC_(-0.19418573059254740497683251524252630812555139736411e83) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.99288128662109375e3), SC_(-0.69397888841878375586677787113886005937761625269323e83) }}, 
      {{ SC_(0.49e2), SC_(0.5e1), SC_(0.9964613037109375e3), SC_(-0.83673305385750097275047732782072302426233318573626e83) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.9754039764404296875e2), SC_(0.9540966553609089780924256830917949985110689839757e19) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.12698681640625e3), SC_(-0.73837653786608238385200036892761464835187841373059e25) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.1354770050048828125e3), SC_(0.52664800837622500334389306290818014369569002330043e27) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.1883819732666015625e3), SC_(0.27387554894270919322792126389178289051542584176489e38) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.2210340576171875e3), SC_(-0.19547983690852244363735927408838035995048749439119e45) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.27849822998046875e3), SC_(-0.3189212872662300839689254440758504118429342094904e52) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.30816705322265625e3), SC_(-0.22529599476815874838053642995371951219025497089071e55) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.5468814697265625e3), SC_(-0.88160317783513066228400969921463950668451679312915e69) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.5472205810546875e3), SC_(-0.91233629806914416357494008857599818372454724161784e69) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.6323592529296875e3), SC_(-0.25001141543272072232834825944285168387476328853162e73) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.81472369384765625e3), SC_(-0.1940429415226012465462652357125761141800206788919e79) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.835008544921875e3), SC_(-0.71140197358250043666692017006337721962305419540361e79) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.90579193115234375e3), SC_(-0.51394981704428462284408793640775540264974115379628e81) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.9133758544921875e3), SC_(-0.79567996866448612027156968893024015193077706862608e81) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.9575068359375e3), SC_(-0.93925780334141741448506784128428988752055950534688e82) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.96488848876953125e3), SC_(-0.14025775342430385358172225488952951794398488374678e83) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.9676949462890625e3), SC_(-0.16321539684532505702958890499479028964977348220227e83) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.9688677978515625e3), SC_(-0.17386556763109194719289301467918033721023976147537e83) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.99288128662109375e3), SC_(-0.6231791505997373453068530187395236100949189310302e83) }}, 
      {{ SC_(0.49e2), SC_(0.7e1), SC_(0.9964613037109375e3), SC_(-0.75168730851786642244750592451710506720345517904775e83) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.9754039764404296875e2), SC_(-0.22157149482634265165652967518786429863749635685014e19) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.12698681640625e3), SC_(-0.37016552044438285038013963527040899364809626611224e24) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.1354770050048828125e3), SC_(-0.82844535979521606557661572890691104503832959473779e25) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.1883819732666015625e3), SC_(0.16937690276952177649994161649173282592330859563473e37) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.2210340576171875e3), SC_(-0.1123319299398139847252326381312609617695809610224e44) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.27849822998046875e3), SC_(-0.60187182694954086721444463173366342578016936417654e51) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.30816705322265625e3), SC_(-0.55291906616527193443616911285859673919321234280903e54) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.5468814697265625e3), SC_(-0.46330766570433160351012234202895592132557379077432e69) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.5472205810546875e3), SC_(-0.479691246084109583779748311318364602958253393456e69) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.6323592529296875e3), SC_(-0.14557179112057066391551669126086976311368495942244e73) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.81472369384765625e3), SC_(-0.1295329418484016324758981437269406217454343072264e79) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.835008544921875e3), SC_(-0.480160202630671811974690597745726960399950703036e79) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.90579193115234375e3), SC_(-0.35894167969179998441359002403031274490177610091877e81) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.9133758544921875e3), SC_(-0.55754327828735213847507517998059581944727327203439e81) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.9575068359375e3), SC_(-0.67017132883446003779409784631118453849390720368906e82) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.96488848876953125e3), SC_(-0.10036100400655956103873022404845651255543315747547e83) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.9676949462890625e3), SC_(-0.11691334699932815101415662742725221700006049862397e83) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.9688677978515625e3), SC_(-0.12459767366822916659583438902633170085293824041689e83) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.99288128662109375e3), SC_(-0.4505653337387251708038852993893455212530397241114e83) }}, 
      {{ SC_(0.49e2), SC_(0.13e2), SC_(0.9964613037109375e3), SC_(-0.54417463316516236218333535495452889567513740674852e83) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.9754039764404296875e2), SC_(0.16195878468668492500334350503693462701305694020104e19) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.12698681640625e3), SC_(-0.36856896240517654816422327682648043937913174107659e24) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.1354770050048828125e3), SC_(0.19859881796548912831158305154291015275078560456686e26) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.1883819732666015625e3), SC_(-0.23672967187849847069440040765217249660610327095681e36) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.2210340576171875e3), SC_(-0.22189524123835152332188839893297287905159259126508e43) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.27849822998046875e3), SC_(-0.25292991496369065504843912064403299970719686840765e51) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.30816705322265625e3), SC_(-0.26811759256582515949042773559121815694960244836161e54) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.5468814697265625e3), SC_(-0.33465588069577286826348055416299150706090746022153e69) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.5472205810546875e3), SC_(-0.34657606038441038404611214060469423120773248842067e69) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.6323592529296875e3), SC_(-0.11080333365418643651448217207622525665458345454771e73) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.81472369384765625e3), SC_(-0.10569011916536682361490220330752518535836583233917e79) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.835008544921875e3), SC_(-0.39397400145962316729456535567553831354513655614438e79) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.90579193115234375e3), SC_(-0.29965167902642908714407053999885142430037329082242e81) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.9133758544921875e3), SC_(-0.46622829618959292833994958386574373327102832749242e81) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.9575068359375e3), SC_(-0.56556493365668541833278026919693598945432955555535e82) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.96488848876953125e3), SC_(-0.84817836551873634898585602690209361799188978565576e82) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.9676949462890625e3), SC_(-0.98860165331969355644235260839852564793962728077414e82) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.9688677978515625e3), SC_(-0.10538163960491416069998803320908176681982874203044e83) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.99288128662109375e3), SC_(-0.38278803532355350068138688168884754502326101704833e83) }}, 
      {{ SC_(0.49e2), SC_(0.16e2), SC_(0.9964613037109375e3), SC_(-0.46261531805865013866332685940823444170448300629497e83) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.9754039764404296875e2), SC_(0.9678801961982469394222069555279757811629299291147e18) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.12698681640625e3), SC_(-0.66715649788378061990578194521830569785015052573541e23) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.1354770050048828125e3), SC_(0.94048723489558937347998570759493822927942988225255e25) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.1883819732666015625e3), SC_(-0.23080079549752376561585945345182398436408597785273e36) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.2210340576171875e3), SC_(-0.12370943067598158903260672611510810607454415206918e43) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.27849822998046875e3), SC_(-0.188441754075703296337994902406532805732885715689e51) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.30816705322265625e3), SC_(-0.209935336600748173050960476854883618187036475357e54) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.5468814697265625e3), SC_(-0.3001036503648300213634318040082918658169957901321e69) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.5472205810546875e3), SC_(-0.31081909857553008527348271418795496367838192512264e69) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.6323592529296875e3), SC_(-0.1011304203695166469989086358196274082787325843099e73) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.81472369384765625e3), SC_(-0.9874108134018121792830331991078063587146342910788e78) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.835008544921875e3), SC_(-0.36876108793006925768557990928189631063310720813571e79) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.90579193115234375e3), SC_(-0.2821060457459603624382772566481300812150609252176e81) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.9133758544921875e3), SC_(-0.43917541846925892584382321165830350676043824358841e81) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.9575068359375e3), SC_(-0.5343850880884741917568590463608273698347394604442e82) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.96488848876953125e3), SC_(-0.80180474480159552253643771438223418945602336714977e82) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.9676949462890625e3), SC_(-0.93471993584643717135214136370605237446212090973335e82) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.9688677978515625e3), SC_(-0.99645543570498230538887827549926522870842683941502e82) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.99288128662109375e3), SC_(-0.36249581985906368117686047759757428116301751615972e83) }}, 
      {{ SC_(0.49e2), SC_(0.17e2), SC_(0.9964613037109375e3), SC_(-0.43818632824388447164485982142255008760686063166269e83) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.9754039764404296875e2), SC_(0.40686574455151924353304460061412152512959230500072e17) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.12698681640625e3), SC_(0.11591264288529981986384413748086738695863142242902e24) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.1354770050048828125e3), SC_(0.9099298411960060556975677735400851416411454596175e24) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.1883819732666015625e3), SC_(-0.16869004987981981885530123205778039482199956444297e36) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.2210340576171875e3), SC_(-0.66966928025275819419203426901598110731158403205496e42) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.27849822998046875e3), SC_(-0.14000387147493172378617872605956722545794965007043e51) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.30816705322265625e3), SC_(-0.16409377034828824395983008480810509545077040522068e54) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.5468814697265625e3), SC_(-0.26904477013213250190672100361664422555370049951479e69) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.5472205810546875e3), SC_(-0.278674665565198598459134092395978001059483073134e69) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.6323592529296875e3), SC_(-0.92284494815365704652374149857360786645719291626335e72) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.81472369384765625e3), SC_(-0.92239552635258593059309458155976712063466657005686e78) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.835008544921875e3), SC_(-0.34512858054851875954071351431061972504996545308229e79) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.90579193115234375e3), SC_(-0.26556669766521075893923565956765347856144361889378e81) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.9133758544921875e3), SC_(-0.4136600894621299443770158108451288909212658208848e81) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.9575068359375e3), SC_(-0.50488896538331923449327552160796839357376071808939e82) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.96488848876953125e3), SC_(-0.75791460417341275540027743032639223191692046801329e82) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.9676949462890625e3), SC_(-0.88371474004688542562937209084337090556325318436441e82) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.9688677978515625e3), SC_(-0.94215273326309641636679457540066621794181087213452e82) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.99288128662109375e3), SC_(-0.34325728484874471882419547525954084340127892512171e83) }}, 
      {{ SC_(0.49e2), SC_(0.18e2), SC_(0.9964613037109375e3), SC_(-0.41502090945064137045190191636038872133346416105012e83) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.9754039764404296875e2), SC_(-0.61663712273817716300739879419901014852621507911144e18) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.12698681640625e3), SC_(0.1675430112440268373613541360720189614118096720872e24) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.1354770050048828125e3), SC_(-0.36203423641601449861439508141043294295914036346919e25) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.1883819732666015625e3), SC_(-0.10272178240175230561295703124970331439270256322051e36) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.2210340576171875e3), SC_(-0.34921517344252239369977129825344283081950490966475e42) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.27849822998046875e3), SC_(-0.10371808309763375449302184547572129491195124253703e51) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.30816705322265625e3), SC_(-0.12803547154646164632369924559470108002603228843851e54) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.5468814697265625e3), SC_(-0.24113353240140959870792822563702853446331984631747e69) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.5472205810546875e3), SC_(-0.24978551889984855064578695981129738716613213464926e69) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.6323592529296875e3), SC_(-0.84196343603241778006381658157743181354377885775922e72) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.81472369384765625e3), SC_(-0.86157318204398801067418464221683001202735009451485e78) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.835008544921875e3), SC_(-0.3229794917111444064930798736319578366982249750048e79) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.90579193115234375e3), SC_(-0.24997713010410319875351696557857678569354844836328e81) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.9133758544921875e3), SC_(-0.38959675198826857041536767909021901669084098876338e81) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.9575068359375e3), SC_(-0.47698754627870214398837894364370617412641440207875e82) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.96488848876953125e3), SC_(-0.7163777266035546050195813883475085233727823154041e82) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.9676949462890625e3), SC_(-0.83543571310763374889834849414881575556735386136858e82) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.9688677978515625e3), SC_(-0.89074864582832301584239019351245730273845614840483e82) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.99288128662109375e3), SC_(-0.32501886194029633537695219597823561980219500935259e83) }}, 
      {{ SC_(0.49e2), SC_(0.19e2), SC_(0.9964613037109375e3), SC_(-0.39305507139881250084440920416798458859478419817795e83) }}
   }};

