/*
	xmalloc/xrealloc functions, and fatal exit function

	Note: the x* functions are lifted straight from the GNU libc info docs
	
	$Id: xmalloc.c,v 1.2 1999/01/16 17:08:59 andy Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#include "junk.h"

void *xmalloc (size_t size)
{
  register void *value = malloc (size);
  if (value == 0)
    fatal ("virtual memory exhausted\n");
  return value;
}

void *xrealloc (void *ptr, size_t size)
{
  register void *value = realloc (ptr, size);
  if (value == 0)
    fatal ("Virtual memory exhausted\n");
  return value;
}

void fatal(char *fmt, ...)
{
  va_list ap;

  va_start(ap, fmt);
  vfprintf(stderr, fmt, ap);
  va_end(ap);

  exit(1);
}
