const PREFSERVICE_CONTRACTID    = '@mozilla.org/preferences-service;1';
const DIRSERVICE_CONTRACTID     = '@mozilla.org/file/directory_service;1';
const IOSERVICE_CONTRACTID      = '@mozilla.org/network/io-service;1';
const RDFSERVICE_CONTRACTID     = '@mozilla.org/rdf/rdf-service;1';
const CONTAINERUTILS_CONTRACTID = '@mozilla.org/rdf/container-utils;1';

const panelsFileId              = 'UPnls';
const uchromFileId              = 'UChrm';
const achromFileId              = 'AChrom';
const prefix                    = 'http://home.netscape.com/NC-rdf#';
const rootNodeUri               = 'urn:sidebar:current-panel-list';
const sidebarNodeUri            = 'urn:sidebar:3rdparty-panel:biofox-sidebar';
const sidebarURL                = 'chrome://biofox/content/biofoxSidebar.xul';
const sidebarTitle              = 'bioFOX';

try
{
	registerSidebar();
}
catch (e)
{
	dump("biofox-sidebar: error on sidebar registration: "+e+"\n");
}

function registerSidebar()
{
	//
	// add sidebar to the master panel list
	//

	try {
		var prefs = Components.classes[PREFSERVICE_CONTRACTID].getService(Components.interfaces.nsIPrefService);
		var branch = prefs.getBranch('sidebar.customize.all_panels.');

		var url = branch.getCharPref('url');
		if (!url.match(/biofox-sidebar/))
		{
			branch.setCharPref('url', url+' chrome://biofox-sidebar/content/local-panels.rdf');
			prefs.savePrefFile(null);
		}
	} catch (e) {}

	//
	// add sidebar to panels.rdf
	//

	var dirService = Components.classes[DIRSERVICE_CONTRACTID].getService(Components.interfaces.nsIProperties);
	var ioService = Components.classes[IOSERVICE_CONTRACTID].getService(Components.interfaces.nsIIOService);
	var rdf  = Components.classes[RDFSERVICE_CONTRACTID].getService(Components.interfaces.nsIRDFService);
	var utils = Components.classes[CONTAINERUTILS_CONTRACTID].getService(Components.interfaces.nsIRDFContainerUtils);
	
	var file = dirService.get(panelsFileId, Components.interfaces.nsIFile);
	if (!file.exists())
	{
		dump("biofox-sidebar: error on sidebar registration: panels.rdf not found\n");
		return;
	}

	var fileHandler = ioService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
	
	file = fileHandler.newFileURI(file).spec;

	var datasource = rdf.GetDataSourceBlocking(file);
	var seqNode = datasource.GetTarget(rdf.GetResource(rootNodeUri), rdf.GetResource(prefix + 'panel-list'), true);
	var sequence = utils.MakeSeq(datasource, seqNode);

	var newNode = rdf.GetResource(sidebarNodeUri);
	if (sequence.IndexOf(newNode) < 0)
	{
		datasource.Assert(newNode, rdf.GetResource(prefix + 'title'), rdf.GetLiteral(sidebarTitle), true);
		datasource.Assert(newNode, rdf.GetResource(prefix + 'content'), rdf.GetLiteral(sidebarURL), true);
		sequence.AppendElement(newNode);

		// refresh the sidebar
		datasource.Assert(rdf.GetResource(rootNodeUri), rdf.GetResource(prefix + 'refresh'), rdf.GetLiteral('true'), true);
		datasource.Unassert(rdf.GetResource(rootNodeUri), rdf.GetResource(prefix + 'refresh'), rdf.GetLiteral('true'));

		datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();

		dump("biofox-sidebar: sidebar registration successful\n");
	}
	else
		dump("biofox-sidebar: sidebar already registered\n");

	//
	// uninstall overlay
	//

	var overlayFiles = [];

	file = dirService.get(uchromFileId, Components.interfaces.nsIFile);
	file.append('overlayinfo');
	file.append('communicator');
	file.append('content');
	file.append('overlays.rdf');
	if (file.exists() && file.isReadable() && file.isWritable())
		overlayFiles.push(file);

	file = dirService.get(achromFileId, Components.interfaces.nsIFile);
	file.append('overlayinfo');
	file.append('communicator');
	file.append('content');
	file.append('overlays.rdf');
	if (file.exists() && file.isReadable() && file.isWritable())
		overlayFiles.push(file);

	for (var i=0; i<overlayFiles.length; i++)
	{
		fileHandler = ioService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
		
		file = fileHandler.newFileURI(overlayFiles[i]).spec;

		datasource = rdf.GetDataSourceBlocking(file);
		
		if (datasource)
		{
			var parents = ['chrome://communicator/content/communicatorOverlay.xul', 'chrome://communicator/content/tasksOverlay.xul'];
			for (var j=0; j<parents.length; j++)
			{
				sequence = utils.MakeSeq(datasource, rdf.GetResource(parents[j]));
				if (sequence)
				{
					sequence.RemoveElement(rdf.GetLiteral('chrome://biofox-sidebar/content/biofoxoverlay.xul'), true);

					// Remove parent container
					if (sequence.GetCount() == 0)
					{
						var it = datasource.ArcLabelsOut(rdf.GetResource(parents[j]));
						while (it.hasMoreElements())
						{
							var property = it.getNext();
							var target = datasource.GetTarget(rdf.GetResource(parents[j]), property, true);
							if (property && target)
								datasource.Unassert(rdf.GetResource(parents[j]), property, target);
						}
					}
				}
			}

			datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
		}
	}

	dump("biofox-sidebar: registration overlay uninstalled\n");
}
