/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2003 Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

static CK_SESSION_HANDLE session;
static CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
static CK_MECHANISM mechanism = {CKM_RSA_PKCS, NULL_PTR, 0};
static CK_RV rv;
static int errors = 0;

static int find_obj(CK_SESSION_HANDLE sess, CK_OBJECT_CLASS cls, CK_OBJECT_HANDLE_PTR p, 
		const unsigned char *id, size_t id_len);
static void initialize(void);
static void test_cat1(void);
static void test_cat2(void);
static void test_cat3(void);
static void test1_1(void);
static void test1_2(void);
static void test1_3(void);
static void test2_1(void);
static void test2_2(void);
static void test3_1(void);
static void test3_2(void);

int c_SignInit()
{
	int n;

	printf("C_SignInit\n");

	initialize();

	session = getSessionInFirstSlot();

	if ((rv = p11->C_Login(session, CKU_USER, "1234", 4)) != CKR_OK) {
		printf("C_Login failed: %s\n", CKR2Str(rv));
		exit(errors++);
	}

	n = find_obj(session, CKO_PRIVATE_KEY, &key, NULL, 0);
	if (n == 0) { 
		printf("    ERR: could not find private key\n");
		errors++;
	} else if (n == -1) {
		printf("    ERR: find private key problem\n");
		errors++;
	} else if (n > 0) {
		test_cat1();
		test_cat2();
		test_cat3();
	}


	return errors;
}

static void test_cat1(void)
{
	printf("  Cat 1\n");

	test1_1();
	test1_2();
	test1_3();
}

static void test_cat2(void)
{
	printf("  Cat 2\n");

	test2_1();
	test2_2();
}

static void test_cat3(void)
{
	printf("  Cat 3\n");

	test3_1();
	test3_2();

}

/**************/
/* category 1 */
/**************/

static void test1_1(void)
{
	if (p11->C_SignInit(12345, &mechanism, key) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_SignInit(1) didn't return CKR_SESSION_HANDLE_INVALID\n but %s\n", CKR2Str(rv));
		errors++;
	}
}

static void test1_2(void)
{
	if ((rv = p11->C_SignInit(session, &mechanism, key)) != CKR_OK) {
		printf("    ERR: C_SignInit(2) didn't return CKR_OK\n but %s\n", CKR2Str(rv));
		errors++;
	}
}

/* test3: before C_Initialize */
static void test1_3(void)
{
	p11->C_Finalize(NULL_PTR);
	if (p11->C_SignInit(12345, &mechanism, key) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_SignInit(3) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}
	initialize(); /* !! */
}

/**************/
/* category 2 */
/**************/

static void test2_1(void)
{
	/* already done in test1_2 !! */
}

static void test2_2(void)
{
	CK_MECHANISM m = {CKM_RSA_9796, NULL_PTR, 0};

	session = getSessionInFirstSlot();

	if ((rv = p11->C_SignInit(session, &m, key)) != CKR_MECHANISM_INVALID) {
		printf("    ERR: C_SignInit(1) didn't return CKR_MECHANISM_INVALID but%s\n", CKR2Str(rv));
		errors++;
	}
}

/**************/
/* category 3 */
/**************/

static void test3_1(void)
{
	/* already done in test1_2 !! */
}

static void test3_2(void)
{
	CK_OBJECT_HANDLE pub;

	session = getSessionInFirstSlot();

	pub = find_object(session, CKO_CERTIFICATE, 0);
	
	if ((rv = p11->C_SignInit(session, &mechanism, pub)) != CKR_KEY_TYPE_INCONSISTENT) {
		printf("    ERR: C_SignInit(2) didn't return CKR_KEY_TYPE_INCONSISTENT but %s\n", CKR2Str(rv));
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		errors++;
	}
}

/******************/
/* help functions */
/******************/

static void initialize(void)
{
	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize didn't return CKR_OK\n");
		++errors;
		return;
	}
}

static int find_obj(CK_SESSION_HANDLE sess, CK_OBJECT_CLASS cls, CK_OBJECT_HANDLE_PTR p, 
		const unsigned char *id, size_t id_len)
{
	CK_ATTRIBUTE attrs;
	CK_ULONG count;
	CK_RV rv;
	int i;

	attrs.type = CKA_CLASS;
	attrs.pValue = &cls;
	attrs.ulValueLen = sizeof(cls);

	rv = p11->C_FindObjectsInit(sess, &attrs, 1);
	if (rv != CKR_OK)
		return -1;

	
	rv = p11->C_FindObjects(sess, p, 1, &count);
	if (rv != CKR_OK) {
		count = -1;
		goto done;
	}
	if (count > 0) {
		rv = p11->C_FindObjects(sess, p, 1, &count);
		if (rv != CKR_OK) {
			count = -1;
			goto done;
		}
	}

done:
	p11->C_FindObjectsFinal(sess);

	return count;
}
