/***************************************************************************
                         -- tree.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef __TREE_H
#define __TREE_H

template <class type> class TreeNode {
public:
	TreeNode() {
		m_next = m_prev = m_child = m_parent = NULL;
		m_object = NULL;
	}
	
	virtual ~TreeNode() {
		// delete this node and all of its siblings and children, and sibling children, but leave the dummy node at this level intact
		if (m_next) {
			m_next->m_prev = NULL;
			delete m_next;
		}
		if (m_prev &&
				m_prev->m_prev) {	// not the dummy node at this level
			m_prev->m_next = NULL;
			delete m_prev;
			}
		if (m_child) delete m_child;
	}

	void clear() {
		if (m_next) m_next->clear();
		if (m_child) m_child->clear();
		if (m_object) {
			delete m_object;
		}
	}
	void remove() {
		if (!m_prev) return; // cant remove() dummy nodes
		if (m_next) m_next->m_prev = m_prev;
		m_prev->m_next = m_next;
		if (m_child) delete m_child;
		delete this;
	}
	TreeNode<type> *insert(TreeNode<type> *nn, bool before=true) {
		// if inserting before the dummy node, then insert it after the dummy
		if (!m_prev) before=false;
		TreeNode<type> *n = new TreeNode<type>;
		n->m_object = nn->m_object;
		if (before) {
			n->m_next = this;
			n->m_prev = m_prev;
			m_prev->m_next = n;
			m_prev = n;
		} else {
			n->m_prev = this;
			n->m_next = m_next;
			if (m_next) m_next->m_prev = n;
			m_next = n;
		}
		n->m_child = new TreeNode;
		n->m_child->m_parent = n;
		return n;
	}
	TreeNode<type> *child() const { return m_child; }
	TreeNode<type> *parent() const { return m_parent; }
	TreeNode<type> *next() const { return m_next; }
	TreeNode<type> *prev() const { return m_prev; }
	type *object() const { return m_object; }
	void setObject(type *o) { m_object = o; }
private:
	type *m_object;
	TreeNode<type> *m_next;
	TreeNode<type> *m_prev;
	TreeNode<type> *m_child;	// points to a dummy node
	TreeNode<type> *m_parent;
};

#endif // __TREE_H
