/***************************************************************************
                         -- plugin.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef __PLUGIN_H
#define __PLUGIN_H

#include <qlistview.h>
#include <qwidget.h>
#include <qobject.h>
#include <qstring.h>
#include <qvariant.h>
#include <stdio.h>
#include "tree.h"

#include <X11/Xlib.h>
#include <X11/Xresource.h>

QString expandTilde(const QString& s);

class Plugin : public QObject {
	Q_OBJECT
public:
	Plugin(QObject*, const char*);
	virtual ~Plugin();
	bool isModified() const { return m_modified; }
	TreeNode<QWidget> *getMembers() const { return tree; }
	QString get_configfile() { return m_configfile; }
public slots:
	virtual bool save() = 0;	// called when 'apply' is pressed
	virtual void load() = 0;	// called when 'reset' is pressed
protected slots:
	void setIsModified();
	void setIsModified(bool b);
private slots:
	virtual void open_new(const QString) = 0;
	virtual void save_as(const QString) = 0;
protected:
	// load the resources from the config files into the Xdb
	bool loaddb(QString global_bb, QString local_bb, QString global_nobb,
			QString local_nobb);
	bool loaddb(QString file);
	bool loadResource(const QString, const QString, const bool);
	int loadResource(const QString, const QString, const int);
	QString *loadResource(const QString, const QString, const char*);
	QColor *loadResource(const QString, const QString, QColor&);
	// save the resources to a config file
	bool savedb(const char*, const char*); // ".bbtools/bbtool.bb .bbtools/bbtool.nobb"
	bool savedb(const char*); // "/home/name/.bbtools/bbtool.bb"
	void saveResource(const QString, const bool);	// saves data to moddb
	void saveResource(const QString, const int);
	void saveResource(const QString, const char*);
	void saveResource(const QString, const QColor&);
	void saveResourceBlank();	// saves a blank line
	void saveResourceComment(QString);	// saves a text comment
	void saveResourceText(QString);	// saves text exactly as passed in
	void clearSaveResources();	// clears moddb

	TreeNode<QWidget> *tree;
	QString m_configfile;
private:
	bool writedbfile(const char*);

	XrmDatabase db;
	QList<QString> *moddb;
	bool m_modified;
};

typedef class Plugin plugin;

#endif // __PLUGIN_H
