/***************************************************************************
                         -- bbconf.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "bbconf.h"
#include "preferences.h"

#include <stdlib.h>

#include <qapplication.h>
#include <qcombobox.h>

extern "C" class bbconf *maker(const QDict<QString> args) {
	return new class bbconf(0, "Plugin_bbconf", args);
}

bbconf::bbconf(QObject *p, const char *n, const QDict<QString> args) : Plugin(p, n) {

	if (QString* loadfile = args["loadfile"] ) {
		m_configfile = expandTilde(loadfile->latin1());
	} else {
		m_configfile = getenv("HOME");
		m_configfile.append("/.bbconf/config");
	}

	TreeNode<QWidget> *t = new TreeNode<QWidget>;
	t->setObject(pref_form = new FormPreferences());
	connect(pref_form, SIGNAL(changed()), this, SLOT(setIsModified()));
	tree->insert(t);
	delete t;
	load();
}

void bbconf::setStyle(const QString s) {
	QApplication::setStyle( s.lower() );
}

void bbconf::load() {

	loaddb(m_configfile);

	style = loadResource("bbconf.style", "Bbconf.Style","Platinum")->latin1();

	for (int i = 0, c = pref_form->cbStyleDropdown->count(); i < c; ++i) {
		if (pref_form->cbStyleDropdown->text(i) == style) {
			pref_form->cbStyleDropdown->setCurrentItem(i);
			break;
		}
	}

	act();
	setIsModified(false);
}

bool bbconf::save() {
	// get the information out of the widgets
	style = pref_form->cbStyleDropdown->currentText();
	
	clearSaveResources();

	// save it to the database
	saveResourceComment("bbconf Configuration file");
	saveResourceBlank();
	saveResource("bbconf.style", style.latin1());

	bool saved = savedb(m_configfile);

	if (saved)
		act();

	setIsModified(!saved);
	return saved;
}

void bbconf::act() {
	setStyle(style);
}
