/*
 * Copyright 2002 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "bakery_gnomeui/Configuration/Dialog_Preferences.h"
#include "bakery_gnomeui/Configuration/Client.h"

namespace Bakery
{

//----------------------------------------------------------------------
// Dialog_Preferences_GnomeUI is the preferences dialog class for
// dialogs that use Gnome::UI widgets.
//----------------------------------------------------------------------

Dialog_Preferences_GnomeUI::Dialog_Preferences_GnomeUI(Gtk::Window& parent, const Glib::ustring& configuration_directory, const Glib::ustring& glade_filename, const Glib::ustring& widget_name, bool instant)
: Dialog_Preferences(parent, configuration_directory, glade_filename, widget_name, instant)
{
  delete m_pConfClient;
  m_pConfClient = new Conf::Client_GnomeUI(configuration_directory);
}

Dialog_Preferences_GnomeUI::~Dialog_Preferences_GnomeUI()
{
}

} //namespace Bakery

