/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMFile;

final class RAMOutputStream
extends OutputStream {
    RAMFile file;
    int pointer = 0;

    public RAMOutputStream(RAMFile f) {
        this.file = f;
    }

    public final void flushBuffer(byte[] src, int len) {
        int bytesToCopy;
        int bufferNumber = this.pointer / 1024;
        int bufferOffset = this.pointer % 1024;
        int bytesInBuffer = 1024 - bufferOffset;
        int n = bytesToCopy = bytesInBuffer >= len ? len : bytesInBuffer;
        if (bufferNumber == this.file.buffers.size()) {
            this.file.buffers.addElement(new byte[1024]);
        }
        byte[] buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
        System.arraycopy(src, 0, buffer, bufferOffset, bytesToCopy);
        if (bytesToCopy < len) {
            int srcOffset = bytesToCopy;
            bytesToCopy = len - bytesToCopy;
            if (++bufferNumber == this.file.buffers.size()) {
                this.file.buffers.addElement(new byte[1024]);
            }
            buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
            System.arraycopy(src, srcOffset, buffer, 0, bytesToCopy);
        }
        this.pointer += len;
        if ((long)this.pointer > this.file.length) {
            this.file.length = this.pointer;
        }
        this.file.lastModified = System.currentTimeMillis();
    }

    public final void close() throws IOException {
        super.close();
    }

    public final void seek(long pos) throws IOException {
        super.seek(pos);
        this.pointer = (int)pos;
    }

    public final long length() throws IOException {
        return this.file.length;
    }
}

