/* Test of conversion: long long --> float.  Random cases.
   $Id: llng2flt-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { 1 };

PROGMEM const struct {		/* Table of test cases:  x, (float)x	*/
    long long x;
    long z;
} t[] = {

    /* x, (float)x	*/
    { 0x73139249c5f2f7a7LL,0x5ee62725 }, /*   1:  8292132184470517671  8.2921322e+18 */
    { 0x04912eec7277fc54LL,0x5c9225de }, /*   2:   329095840842382420  3.2909584e+17 */
    { 0xf3bf8947f381a2ebLL,0xdd44076c }, /*   3:  -882836059820285205 -8.8283606e+17 */
    { 0x0bb4570a3d2fa2eaLL,0x5d3b4571 }, /*   4:   843394731712946922  8.4339473e+17 */
    { 0x248a9e5c067e28f2LL,0x5e122a79 }, /*   5:  2633091050234587378  2.6330911e+18 */
    { 0xfae5032e14762494LL,0xdca35f9a }, /*   6:  -367884298114161516 -3.6788430e+17 */
    { 0x01ddf434dd4130f8LL,0x5beefa1a }, /*   7:   134532071778496760  1.3453207e+17 */
    { 0x98aad99b96055278LL,0xdeceaa4d }, /*   8: -7445899771643604360 -7.4458998e+18 */
    { 0x7f6f9449977cd7caLL,0x5efedf29 }, /*   9:  9182721209026795466  9.1827212e+18 */
    { 0x1639f7394891f222LL,0x5db1cfba }, /*  10:  1601582967909642786  1.6015830e+18 */
    { 0x0207b73bdf6e4272LL,0x5c01edcf }, /*  11:   146286980692329074  1.4628698e+17 */
    { 0x0012fbf54e6fc843LL,0x5997dfaa }, /*  12:     5343580582299715  5.3435806e+15 */
    { 0xfff7dead7aae0899LL,0xd9021528 }, /*  13:    -2288438121461607 -2.2884381e+15 */
    { 0xffda8be6784dcae8LL,0xda15d066 }, /*  14:   -10542227137901848 -1.0542227e+16 */
    { 0x7a5fa76361aca718LL,0x5ef4bf4f }, /*  15:  8817950640697026328  8.8179506e+18 */
    { 0x0044ca3f5ba61501LL,0x5a89947f }, /*  16:    19362671885686017  1.9362672e+16 */
    { 0x00001e45fa610873LL,0x55f22fd3 }, /*  17:       33285902239859  3.3285902e+13 */
    { 0xffe18c60d60ab9e8LL,0xd9f39cf9 }, /*  18:    -8571376742254104 -8.5713767e+15 */
    { 0xffffc59e04ef8e50LL,0xd66987ec }, /*  19:      -64192498397616 -6.4192498e+13 */
    { 0x012cf99edf5caf7cLL,0x5b967ccf }, /*  20:    84716953760739196  8.4716954e+16 */
    { 0x35c79a46c519e9c6LL,0x5e571e69 }, /*  21:  3875235633120799174  3.8752356e+18 */
    { 0x0990c335c829c05fLL,0x5d190c33 }, /*  22:   689265378746548319  6.8926538e+17 */
    { 0xf37c136c61b97044LL,0xdd483ec9 }, /*  23:  -901824469164003260 -9.0182447e+17 */
    { 0x003b95b9d5e0aadaLL,0x5a6e56e7 }, /*  24:    16771649015687898  1.6771649e+16 */
    { 0x0adc420955716e0cLL,0x5d2dc421 }, /*  25:   782573043111259660  7.8257304e+17 */
    { 0xfd708b8f6d8d145bLL,0xdc23dd1c }, /*  26:  -184494136587643813 -1.8449414e+17 */
    { 0x003292831590e074LL,0x5a4a4a0c }, /*  27:    14234840535720052  1.4234841e+16 */
    { 0x0000000c6e1d1945LL,0x5146e1d2 }, /*  28:          53387008325  5.3387008e+10 */
    { 0xfffffd44c2ce1751LL,0xd42ecf4c }, /*  29:       -3003208820911 -3.0032088e+12 */
    { 0xd785c1466d58603dLL,0xde21e8fb }, /*  30: -2916712675426148291 -2.9167127e+18 */
    { 0x000000007309453bLL,0x4ee6128a }, /*  31:           1929987387  1.9299874e+09 */
    { 0xfffc81db11a53edcLL,0xd85f893c }, /*  32:     -983122012979492 -9.8312201e+14 */
    { 0xfff5532cfca5f3e6LL,0xd92acd30 }, /*  33:    -3004772061416474 -3.0047721e+15 */
    { 0x0000037f0ee9758bLL,0x545fc3ba }, /*  34:        3844245910923  3.8442459e+12 */
    { 0x013087993aa0dc6bLL,0x5b9843cd }, /*  35:    85717485103406187  8.5717485e+16 */
    { 0xffff232d09c02607LL,0xd75cd2f6 }, /*  36:     -242798632622585 -2.4279863e+14 */
    { 0x00024d86f1acbc56LL,0x581361bc }, /*  37:      648191929007190  6.4819193e+14 */
    { 0xfffffffbd8d035f4LL,0xd084e5f9 }, /*  38:         -17837312524 -1.7837313e+10 */
    { 0xff58d6b7cc259226LL,0xdb272948 }, /*  39:   -47051711195016666 -4.7051711e+16 */
    { 0xffffff54bee5653bLL,0xd32b411b }, /*  40:        -735531670213 -7.3553167e+11 */
    { 0xffffa5fa281d5417LL,0xd6b40bb0 }, /*  41:      -98981143292905 -9.8981143e+13 */
    { 0xfebb43248216f789LL,0xdba25e6e }, /*  42:   -91405543350536311 -9.1405543e+16 */
    { 0xfffffffffff1e661LL,0xc96199f0 }, /*  43:              -924063 -9.2406300e+05 */
    { 0xffffe75a332520c9LL,0xd5c52e67 }, /*  44:      -27100385566519 -2.7100386e+13 */
    { 0xfffffffff226823dLL,0xcd5d97dc }, /*  45:           -232357315 -2.3235732e+08 */
    { 0xf942323d76ffa939LL,0xdcd7b9b8 }, /*  46:  -485770570231731911 -4.8577057e+17 */
    { 0x0000000000c9e917LL,0x4b49e917 }, /*  47:             13232407  1.3232407e+07 */
    { 0xfffffffffffd6d45LL,0xc824aec0 }, /*  48:              -168635 -1.6863500e+05 */
    { 0xfffffe5247c6440aLL,0xd3d6dc1d }, /*  49:       -1845631761398 -1.8456318e+12 */
    { 0x0000dbcbdae3c8ceLL,0x575bcbdb }, /*  50:      241668597205198  2.4166860e+14 */
    { 0xfa6371227fa31f04LL,0xdcb391dc }, /*  51:  -404355148548989180 -4.0435515e+17 */
    { 0xfea8bff387d3ade1LL,0xdbaba006 }, /*  52:   -96616339311710751 -9.6616339e+16 */
    { 0xfefcec389b96502eLL,0xdb8189e4 }, /*  53:   -72923766072127442 -7.2923766e+16 */
    { 0xffff320a86e84d78LL,0xd74df579 }, /*  54:     -226454182277768 -2.2645418e+14 */
    { 0xffffffffff4c817aLL,0xcb337e86 }, /*  55:            -11763334 -1.1763334e+07 */
    { 0x000002f4bdd8340cLL,0x543d2f76 }, /*  56:        3250180338700  3.2501803e+12 */
    { 0xfffffffffffceaf2LL,0xc8454380 }, /*  57:              -201998 -2.0199800e+05 */
    { 0x000000102f2363f0LL,0x5181791b }, /*  58:          69510325232  6.9510325e+10 */
    { 0x000000000079eabeLL,0x4af3d57c }, /*  59:              7989950  7.9899500e+06 */
    { 0xffc847001b88aaacLL,0xda5ee400 }, /*  60:   -15684532908283220 -1.5684533e+16 */
    { 0x3a203d701f921cbcLL,0x5e6880f6 }, /*  61:  4188415205229862076  4.1884152e+18 */
    { 0x15262d8b264b01c9LL,0x5da9316c }, /*  62:  1523955599577645513  1.5239556e+18 */
    { 0xe453c9f414234618LL,0xdddd61b0 }, /*  63: -1994028159847938536 -1.9940282e+18 */
    { 0x21371377dfcdc5adLL,0x5e04dc4e }, /*  64:  2393403132547548589  2.3934031e+18 */
    { 0xfaf7244e1b619f11LL,0xdca11b76 }, /*  65:  -362781327094604015 -3.6278133e+17 */
    { 0x97af86b51fa11752LL,0xded0a0f3 }, /*  66: -7516641140580214958 -7.5166411e+18 */
    { 0xfe5c71fe5b151b2aLL,0xdbd1c701 }, /*  67:  -118094152954733782 -1.1809415e+17 */
    { 0x053659a9693ff906LL,0x5ca6cb35 }, /*  68:   375586203082160390  3.7558620e+17 */
    { 0x0082165c926c2ec0LL,0x5b02165d }, /*  69:    36616333821750976  3.6616334e+16 */
    { 0x23252d4535abc4b0LL,0x5e0c94b5 }, /*  70:  2532480140742214832  2.5324801e+18 */
    { 0x00032757b2d79982LL,0x5849d5ed }, /*  71:      887682546243970  8.8768255e+14 */
    { 0xfd8c047132785c2dLL,0xdc1cfee4 }, /*  72:  -176761401149727699 -1.7676140e+17 */
    { 0xffcd85041b20f2d3LL,0xda49ebf0 }, /*  73:   -14208971130735917 -1.4208971e+16 */
    { 0x04993bc0e65731ddLL,0x5c932778 }, /*  74:   331361747272675805  3.3136175e+17 */
    { 0x00012a3d0e643058LL,0x57951e87 }, /*  75:      327916699529304  3.2791670e+14 */
    { 0xfe2023d42f15a78cLL,0xdbefee16 }, /*  76:  -135068594591127668 -1.3506859e+17 */
    { 0xff8ef8e6be143ea3LL,0xdae20e33 }, /*  77:   -31814477429850461 -3.1814477e+16 */
    { 0x0098bb420b5044a1LL,0x5b18bb42 }, /*  78:    42990088792065185  4.2990089e+16 */
    { 0xfff9d27e2e8d8fafLL,0xd8c5b03a }, /*  79:    -1738885448233041 -1.7388854e+15 */
    { 0x014b53bce0ea8710LL,0x5ba5a9de }, /*  80:    93260287983650576  9.3260288e+16 */
    { 0xffff49fd1bfe11d1LL,0xd73602e4 }, /*  81:     -200123531521583 -2.0012353e+14 */
    { 0xfffff51b173f1749LL,0xd52e4e8c }, /*  82:      -11978273777847 -1.1978274e+13 */
    { 0xfff8f94f827e6cffLL,0xd8e0d610 }, /*  83:    -1977679926629121 -1.9776799e+15 */
    { 0x000256b3d1153997LL,0x5815acf4 }, /*  84:      658280260385175  6.5828026e+14 */
    { 0xf7dcaf3ae494bb60LL,0xdd02350c }, /*  85:  -586401183987090592 -5.8640118e+17 */
    { 0x00001d570866c5a1LL,0x55eab843 }, /*  86:       32259640313249  3.2259640e+13 */
    { 0x000f7da754cbeaf9LL,0x5977da75 }, /*  87:     4360282286320377  4.3602823e+15 */
    { 0xfdcb84e4e4ec229dLL,0xdc0d1ec7 }, /*  88:  -158887243213430115 -1.5888724e+17 */
    { 0xffd9e12e8a0db6e2LL,0xda187b46 }, /*  89:   -10729934090815774 -1.0729934e+16 */
    { 0xfff8315777d95c95LL,0xd8f9d511 }, /*  90:    -2197548071035755 -2.1975481e+15 */
    { 0xffffe81f83aea56fLL,0xd5bf03e3 }, /*  91:      -26252925819537 -2.6252926e+13 */
    { 0xffffffef8e32290bLL,0xd1838e6f }, /*  92:         -70628792053 -7.0628792e+10 */
    { 0x000000b12c2f63c0LL,0x53312c2f }, /*  93:         760950514624  7.6095051e+11 */
    { 0xff718ef14806ee49LL,0xdb0e710f }, /*  94:   -40093754722947511 -4.0093755e+16 */
    { 0x00338f67d7a87c63LL,0x5a4e3d9f }, /*  95:    14512899974790243  1.4512900e+16 */
    { 0xfffffe5295ce7f4cLL,0xd3d6b519 }, /*  96:       -1844322599092 -1.8443226e+12 */
    { 0x0002b49d999163b7LL,0x582d2766 }, /*  97:      761538932728759  7.6153893e+14 */
    { 0x000000fafa3eb6b9LL,0x537afa3f }, /*  98:        1077940238009  1.0779402e+12 */
    { 0xfffffffffd194f1dLL,0xcc39ac39 }, /*  99:            -48672995 -4.8672995e+07 */
    { 0xe3bb4b0d40919202LL,0xdde225a8 }, /* 100: -2036951886165077502 -2.0369519e+18 */
    { 0x06a7813e651da36cLL,0x5cd4f028 }, /* 101:   479493990322643820  4.7949399e+17 */
    { 0x000035c40cbaec54LL,0x56571033 }, /* 102:       59116143438932  5.9116143e+13 */
    { 0x000006b4730bd70dLL,0x54d68e61 }, /* 103:        7372094035725  7.3720940e+12 */
    { 0x0000186d7381ff65LL,0x55c36b9c }, /* 104:       26858368401253  2.6858368e+13 */
    { 0x01a3dd2cb18b29b3LL,0x5bd1ee96 }, /* 105:   118181199268751795  1.1818120e+17 */
    { 0xfffffffff774fb59LL,0xcd08b04a }, /* 106:           -143328423 -1.4332842e+08 */
    { 0xfffffffe377dee34LL,0xcfe44109 }, /* 107:          -7658934732 -7.6589347e+09 */
    { 0x00000000000da5a7LL,0x495a5a70 }, /* 108:               894375  8.9437500e+05 */
    { 0x000000000000d2a4LL,0x4752a400 }, /* 109:                53924  5.3924000e+04 */
    { 0xffd5de6ecf6ed2acLL,0xda288645 }, /* 110:   -11858856490642772 -1.1858856e+16 */
    { 0x0000002e0aff0e17LL,0x52382bfc }, /* 111:         197752983063  1.9775298e+11 */
    { 0xffffffffff5a8770LL,0xcb257890 }, /* 112:            -10844304 -1.0844304e+07 */
    { 0x000000000860fc3bLL,0x4d060fc4 }, /* 113:            140573755  1.4057376e+08 */
    { 0xfffffffffff18bdcLL,0xc9674240 }, /* 114:              -947236 -9.4723600e+05 */
    { 0x000000000000a5a2LL,0x4725a200 }, /* 115:                42402  4.2402000e+04 */
    { 0xfffffff71a0fb62bLL,0xd10e5f05 }, /* 116:         -38217468373 -3.8217468e+10 */
    { 0xffffffff92807c51LL,0xcedaff07 }, /* 117:          -1837073327 -1.8370733e+09 */
    { 0xfff33821c01f8f56LL,0xd94c7de4 }, /* 118:    -3597457088868522 -3.5974571e+15 */
    { 0x0000000001b731a1LL,0x4bdb98d0 }, /* 119:             28783009  2.8783009e+07 */
    { 0xfffffffff9c5a62bLL,0xccc74b3b }, /* 120:           -104487381 -1.0448738e+08 */
    { 0xdefa1192226a2668LL,0xde0417ba }, /* 121: -2379570133771606424 -2.3795701e+18 */
    { 0x8238d9fcd6b1ed9bLL,0xdefb8e4c }, /* 122: -9063254570126152293 -9.0632546e+18 */
    { 0x3b0ee984d50a16f9LL,0x5e6c3ba6 }, /* 123:  4255595454630860537  4.2555955e+18 */
    { 0x7b522b79dddca175LL,0x5ef6a457 }, /* 124:  8886212817168671093  8.8862128e+18 */
    { 0x1ea55f28cdd2a7caLL,0x5df52af9 }, /* 125:  2208275821151561674  2.2082758e+18 */
    { 0x1411bee8970bcc52LL,0x5da08df7 }, /* 126:  1446146861538462802  1.4461469e+18 */
    { 0xe360e14281cb4bf1LL,0xdde4f8f6 }, /* 127: -2062400953574011919 -2.0624010e+18 */
    { 0xf211470296ec2d99LL,0xdd5eeb90 }, /* 128: -1003943165479342695 -1.0039432e+18 */
    { 0xf7e2ab679be11269LL,0xdd01d54a }, /* 129:  -584716540119543191 -5.8471654e+17 */
    { 0x0589bf28a029c6a7LL,0x5cb137e5 }, /* 130:   399060223205688999  3.9906022e+17 */
    { 0x0002b002273ae716LL,0x582c008a }, /* 131:      756473248016150  7.5647325e+14 */
    { 0x05b4976baf954591LL,0x5cb692ed }, /* 132:   411119954760648081  4.1111995e+17 */
    { 0x7ea897c6b1286a18LL,0x5efd5130 }, /* 133:  9126711524497844760  9.1267115e+18 */
    { 0xfedf7900633660acLL,0xdb904380 }, /* 134:   -81213225697910612 -8.1213226e+16 */
    { 0x030b70caa4561c52LL,0x5c42dc33 }, /* 135:   219393022500412498  2.1939302e+17 */
    { 0x0767e75de3f0a2d2LL,0x5cecfcec }, /* 136:   533649471308866258  5.3364947e+17 */
    { 0x0012b0b7a4433ea1LL,0x599585bd }, /* 137:     5260852362165921  5.2608524e+15 */
    { 0x02aef5ae4a35ed11LL,0x5c2bbd6c }, /* 138:   193361962941672721  1.9336196e+17 */
    { 0xede8acc6ab9b5b6eLL,0xdd90ba9a }, /* 139: -1303602122841171090 -1.3036021e+18 */
    { 0x00030e44a2c4bb0aLL,0x58439129 }, /* 140:      860112881498890  8.6011288e+14 */
    { 0x0034ea8dd4ae3579LL,0x5a53aa37 }, /* 141:    14894593668429177  1.4894594e+16 */
    { 0xfffebd19d06acc8cLL,0xd7a17318 }, /* 142:     -355031384929140 -3.5503138e+14 */
    { 0xfff215eee39c88a9LL,0xd95ea112 }, /* 143:    -3916533908862807 -3.9165339e+15 */
    { 0xfffffa13553b99f7LL,0xd4bd9559 }, /* 144:       -6514035418633 -6.5140354e+12 */
    { 0xffc8e01b5fd7f064LL,0xda5c7f93 }, /* 145:   -15516190519070620 -1.5516191e+16 */
    { 0x03e1610b05ebed12LL,0x5c785843 }, /* 146:   279611351845563666  2.7961135e+17 */
    { 0xffff1304711e79daLL,0xd76cfb8f }, /* 147:     -260565178091046 -2.6056518e+14 */
    { 0x00141a1198c9a26cLL,0x59a0d08d }, /* 148:     5658162414330476  5.6581624e+15 */
    { 0x8d5bbd723a3d620cLL,0xdee54885 }, /* 149: -8260800793180020212 -8.2608008e+18 */
    { 0x46ed7b6949fdeefeLL,0x5e8ddaf7 }, /* 150:  5110876844278542078  5.1108768e+18 */
    { 0x007a7904d0f4536fLL,0x5af4f20a }, /* 151:    34473008751203183  3.4473009e+16 */
    { 0xfffffffcad017c3bLL,0xd054bfa1 }, /* 152:         -14277313477 -1.4277313e+10 */
    { 0x0000000534a1cc2bLL,0x50a6943a }, /* 153:          22357855275  2.2357855e+10 */
    { 0x0000036a1a20c8f7LL,0x545a8688 }, /* 154:        3754239772919  3.7542398e+12 */
    { 0xffffbd0b0f843ce7LL,0xd685e9e1 }, /* 155:      -73619774096153 -7.3619774e+13 */
    { 0xffffff7876dc4294LL,0xd3078924 }, /* 156:        -582121405804 -5.8212141e+11 */
    { 0x033bb8de809972b9LL,0x5c4eee38 }, /* 157:   232983071519503033  2.3298307e+17 */
    { 0xf10aee962b9925ceLL,0xdd6f5117 }, /* 158: -1077786832057850418 -1.0777868e+18 */
    { 0xeae02ecf97a6954bLL,0xdda8fe8a }, /* 159: -1522165204913842869 -1.5221652e+18 */
    { 0x0000000008f833beLL,0x4d0f833c }, /* 160:            150483902  1.5048390e+08 */
    { 0x00000020f6b48594LL,0x5203dad2 }, /* 161:         141577979284  1.4157798e+11 */
    { 0xfffffff74a93061fLL,0xd10b56d0 }, /* 162:         -37403556321 -3.7403556e+10 */
    { 0xfffffff81f5e5f06LL,0xd0fc1434 }, /* 163:         -33833459962 -3.3833460e+10 */
    { 0x004d1b41307c62a8LL,0x5a9a3682 }, /* 164:    21703540007002792  2.1703540e+16 */
    { 0x002b4220d56924baLL,0x5a2d0883 }, /* 165:    12176132785382586  1.2176133e+16 */
    { 0x00000000c1442a79LL,0x4f41442a }, /* 166:           3242470009  3.2424700e+09 */
    { 0xfffffffffea7b53eLL,0xcbac2561 }, /* 167:            -22563522 -2.2563522e+07 */
    { 0xfffffffffe04b92bLL,0xcbfda36a }, /* 168:            -33244885 -3.3244885e+07 */
    { 0xfffffffffaa4d8f2LL,0xccab64e2 }, /* 169:            -89859854 -8.9859854e+07 */
    { 0x0000000000030907LL,0x484241c0 }, /* 170:               198919  1.9891900e+05 */
    { 0x000000000009b1c9LL,0x491b1c90 }, /* 171:               635337  6.3533700e+05 */
    { 0xffc276a00ee7c4d1LL,0xda762580 }, /* 172:   -17321018739145519 -1.7321019e+16 */
    { 0xfffffffff7dbd27eLL,0xcd0242d8 }, /* 173:           -136588674 -1.3658867e+08 */
    { 0x000000006c0c7c81LL,0x4ed818f9 }, /* 174:           1812757633  1.8127576e+09 */
    { 0xfffdffedad7295beLL,0xd8000495 }, /* 175:     -563028647832130 -5.6302865e+14 */
    { 0x000d6697d5702134LL,0x5956697d }, /* 176:     3771977004228916  3.7719770e+15 */
    { 0x0000000000002b20LL,0x462c8000 }, /* 177:                11040  1.1040000e+04 */
    { 0x000000000000034bLL,0x4452c000 }, /* 178:                  843  8.4300000e+02 */
    { 0xfffffffffffce2edLL,0xc84744c0 }, /* 179:              -204051 -2.0405100e+05 */
    { 0x00c9a36fae7b5122LL,0x5b49a370 }, /* 180:    56756170382856482  5.6756170e+16 */
    { 0x37f4cdf40882039eLL,0x5e5fd338 }, /* 181:  4032074014401889182  4.0320740e+18 */
    { 0x2d38f09a64014a75LL,0x5e34e3c2 }, /* 182:  3258618876295989877  3.2586189e+18 */
    { 0xe14ee9b434df2dc5LL,0xddf588b2 }, /* 183: -2211573406801908283 -2.2115734e+18 */
    { 0x0e61df340bad6062LL,0x5d661df3 }, /* 184:  1036354803899129954  1.0363548e+18 */
    { 0xe682b04bc4a810b7LL,0xddcbea7e }, /* 185: -1836711858545356617 -1.8367119e+18 */
    { 0x1e17b36ec3757ea2LL,0x5df0bd9b }, /* 186:  2168399033909214882  2.1683990e+18 */
    { 0x016ec3065b11a1efLL,0x5bb76183 }, /* 187:   103234273541202415  1.0323427e+17 */
    { 0x0008898b3eeef7a0LL,0x590898b4 }, /* 188:     2403030962993056  2.4030310e+15 */
    { 0x00c73706a3e1cc9cLL,0x5b473707 }, /* 189:    56074022024236188  5.6074022e+16 */
    { 0xfc8a36bd6987f45bLL,0xdc5d7251 }, /* 190:  -249326642218404773 -2.4932664e+17 */
    { 0x001ce43e7af4f92aLL,0x59e721f4 }, /* 191:     8132256349878570  8.1322563e+15 */
    { 0xf989ceb229a7fce2LL,0xdccec62a }, /* 192:  -465613821857760030 -4.6561382e+17 */
    { 0x05a6cb0699964db0LL,0x5cb4d961 }, /* 193:   407236045530615216  4.0723605e+17 */
    { 0x0004bcd6ba2d2cb7LL,0x58979ad7 }, /* 194:     1333530339388599  1.3335303e+15 */
    { 0xffea98e57462b99cLL,0xd9ab38d4 }, /* 195:    -6024338220074596 -6.0243382e+15 */
    { 0x00f50a2176cbb484LL,0x5b750a21 }, /* 196:    68972508137370756  6.8972508e+16 */
    { 0x00002955a662f104LL,0x5625569a }, /* 197:       45447840461060  4.5447840e+13 */
    { 0xfffff1c188d0cdceLL,0xd563e773 }, /* 198:      -15661450342962 -1.5661450e+13 */
    { 0xfe6cba4690b8a05cLL,0xdbc9a2dd }, /* 199:  -113511078352609188 -1.1351108e+17 */
    { 0x0074a60a959df41cLL,0x5ae94c15 }, /* 200:    32833661688476700  3.2833662e+16 */
    { 0x02f232ff267895d7LL,0x5c3c8cc0 }, /* 201:   212288203883320791  2.1228820e+17 */
    { 0x01d46c31fd509e5cLL,0x5bea3619 }, /* 202:   131849251059703388  1.3184925e+17 */
    { 0xfff986c239429335LL,0xd8cf27b9 }, /* 203:    -1822156094532811 -1.8221561e+15 */
    { 0x0000049bb5a2392fLL,0x549376b4 }, /* 204:        5066813749551  5.0668137e+12 */
    { 0xfffef5e8e2e9dcc1LL,0xd7850b8f }, /* 205:     -292569365226303 -2.9256937e+14 */
    { 0xffabafef6a4b867fLL,0xdaa8a021 }, /* 206:   -23731930205026689 -2.3731930e+16 */
    { 0x00000064dcf30162LL,0x52c9b9e6 }, /* 207:         433203642722  4.3320364e+11 */
    { 0x000005536fa22f97LL,0x54aa6df4 }, /* 208:        5855913324439  5.8559133e+12 */
    { 0x0005dfec1dce7283LL,0x58bbfd84 }, /* 209:     1653580088898179  1.6535801e+15 */
    { 0xffffffaa8a5d7926LL,0xd2aaeb45 }, /* 210:        -367045805786 -3.6704581e+11 */
    { 0xfffffffab747aaddLL,0xd0a9170b }, /* 211:         -22694876451 -2.2694876e+10 */
    { 0x00000f53b337d7ddLL,0x55753b33 }, /* 212:       16852163483613  1.6852163e+13 */
    { 0x000164d5f5529fc2LL,0x57b26afb }, /* 213:      392345083355074  3.9234508e+14 */
    { 0xffffff7e11eeee13LL,0xd301ee11 }, /* 214:        -558044877293 -5.5804488e+11 */
    { 0x00000004e7d1d920LL,0x509cfa3b }, /* 215:          21069158688  2.1069159e+10 */
    { 0xfffff2569ecac795LL,0xd55a9613 }, /* 216:      -15021131511915 -1.5021132e+13 */
    { 0x000000f997981055LL,0x53799798 }, /* 217:        1071990181973  1.0719902e+12 */
    { 0xffe7df0d7ff63ec6LL,0xd9c10794 }, /* 218:    -6791625343353146 -6.7916253e+15 */
    { 0x020fff13db536735LL,0x5c03ffc5 }, /* 219:   148617773475653429  1.4861777e+17 */
    { 0x0000000000e1c797LL,0x4b61c797 }, /* 220:             14796695  1.4796695e+07 */
    { 0x00001385e1cd8469LL,0x559c2f0e }, /* 221:       21465739920489  2.1465740e+13 */
    { 0xffffffffff1495beLL,0xcb6b6a42 }, /* 222:            -15428162 -1.5428162e+07 */
    { 0xffffffffc55e3bfbLL,0xce6a8710 }, /* 223:           -983680005 -9.8368000e+08 */
    { 0x000000ffb32b15f4LL,0x537fb32b }, /* 224:        1098222605812  1.0982226e+12 */
    { 0x0000000091f16f62LL,0x4f11f16f }, /* 225:           2448519010  2.4485190e+09 */
    { 0xfffffffffff8d6bdLL,0xc8e52860 }, /* 226:              -469315 -4.6931500e+05 */
    { 0xfffffff69fea54dcLL,0xd116015b }, /* 227:         -40266738468 -4.0266738e+10 */
    { 0xffff6abe3a2344e1LL,0xd71541c6 }, /* 228:     -164109724990239 -1.6410972e+14 */
    { 0x000f4b7d3e70dda9LL,0x5974b7d4 }, /* 229:     4305125941239209  4.3051259e+15 */
    { 0x00000003209036d0LL,0x5048240e }, /* 230:          13431224016  1.3431224e+10 */
    { 0x00789ef19fdd9cfdLL,0x5af13de3 }, /* 231:    33951757811686653  3.3951758e+16 */
    { 0xfffffffffffffb7cLL,0xc4908000 }, /* 232:                -1156 -1.1560000e+03 */
    { 0xffffffffffea886cLL,0xc9abbca0 }, /* 233:             -1406868 -1.4068680e+06 */
    { 0xffffffffffffffa1LL,0xc2be0000 }, /* 234:                  -95 -9.5000000e+01 */
    { 0xffffffffffffffbdLL,0xc2860000 }, /* 235:                  -67 -6.7000000e+01 */
    { 0xffffffff96abe445LL,0xced2a837 }, /* 236:          -1767119803 -1.7671198e+09 */
    { 0xffffffffffeb764bLL,0xc9a44da8 }, /* 237:             -1345973 -1.3459730e+06 */
    { 0x0078b8ca448eff80LL,0x5af17195 }, /* 238:    33980176078405504  3.3980176e+16 */
    { 0xffffffffe68f7d72LL,0xcdcb8414 }, /* 239:           -426803854 -4.2680385e+08 */
    { 0xfffffff7ba016b76LL,0xd1045fe9 }, /* 240:         -35534050442 -3.5534050e+10 */
    { 0x9048c71ac3b769aaLL,0xdedf6e72 }, /* 241: -8049965416158107222 -8.0499654e+18 */
    { 0x273611fe4a60b1b3LL,0x5e1cd848 }, /* 242:  2825465600088781235  2.8254656e+18 */
    { 0x0ceed5f6fba00f46LL,0x5d4eed5f }, /* 243:   931917429672513350  9.3191743e+17 */
    { 0xd422ebcd47357477LL,0xde2f7451 }, /* 244: -3160704721565158281 -3.1607047e+18 */
    { 0x0c831f32a4f4313eLL,0x5d4831f3 }, /* 245:   901598652780523838  9.0159865e+17 */
    { 0x1eb73e29a0755eb7LL,0x5df5b9f1 }, /* 246:  2213306090382515895  2.2133061e+18 */
    { 0x0223be126546bb9bLL,0x5c08ef85 }, /* 247:   154175798478551963  1.5417580e+17 */
    { 0x0553b7a6f0123e6dLL,0x5caa76f5 }, /* 248:   383852320876805741  3.8385232e+17 */
    { 0xff88fe251575cd08LL,0xdaee03b6 }, /* 249:   -33497561977991928 -3.3497562e+16 */
    { 0x00367b80df176a49LL,0x5a59ee03 }, /* 250:    15335442171259465  1.5335442e+16 */
    { 0x00e21a5b03cf2ebdLL,0x5b621a5b }, /* 251:    63642322944863933  6.3642323e+16 */
    { 0x00014d0335cca982LL,0x57a6819b }, /* 252:      366151159556482  3.6615116e+14 */
    { 0xce3a1d02a6b30001LL,0xde47178c }, /* 253: -3586522256023289855 -3.5865223e+18 */
    { 0x01114f83399e2b65LL,0x5b88a7c2 }, /* 254:    76930093667986277  7.6930094e+16 */
    { 0xffbefb4f30aae3a2LL,0xda820962 }, /* 255:   -18301030925409374 -1.8301031e+16 */
    { 0x061ae89fb9436c99LL,0x5cc35d14 }, /* 256:   439919686327692441  4.3991969e+17 */
    { 0x2cf622ec55595e21LL,0x5e33d88c }, /* 257:  3239815380379196961  3.2398154e+18 */
    { 0x00002484221099edLL,0x56121088 }, /* 258:       40149925796333  4.0149926e+13 */
    { 0x0004f1ea1e7031dbLL,0x589e3d44 }, /* 259:     1391887742153179  1.3918877e+15 */
    { 0x0000006ed516546eLL,0x52ddaa2d }, /* 260:         476021412974  4.7602141e+11 */
    { 0x00006bd91833fd5cLL,0x56d7b230 }, /* 261:      118580158135644  1.1858016e+14 */
    { 0xfffb85a367ca39e0LL,0xd88f4b93 }, /* 262:    -1260438016083488 -1.2604380e+15 */
    { 0xff909baf66eeab0bLL,0xdadec8a1 }, /* 263:   -31354019743094005 -3.1354020e+16 */
    { 0x002f2377b94fe30dLL,0x5a3c8ddf }, /* 264:    13268321022501645  1.3268321e+16 */
    { 0xffffe5444bfc3c5fLL,0xd5d5dda0 }, /* 265:      -29393481352097 -2.9393481e+13 */
    { 0x000001b84546def0LL,0x53dc22a3 }, /* 266:        1890947882736  1.8909479e+12 */
    { 0x0000015f4ac0c5e9LL,0x53afa560 }, /* 267:        1508787668457  1.5087877e+12 */
    { 0xf3926a2b56d25639LL,0xdd46d95d }, /* 268:  -895536641520544199 -8.9553664e+17 */
    { 0xfff8dd096a38d438LL,0xd8e45ed3 }, /* 269:    -2008767307131848 -2.0087673e+15 */
    { 0x0004cfe6d2d18ab3LL,0x5899fcda }, /* 270:     1354490193218227  1.3544902e+15 */
    { 0x0001e7b1c61b71aeLL,0x57f3d8e3 }, /* 271:      536225695625646  5.3622570e+14 */
    { 0xfffffef4e61d4548LL,0xd3858cf1 }, /* 272:       -1147190557368 -1.1471906e+12 */
    { 0x000000070f2ee4c8LL,0x50e1e5dd }, /* 273:          30319502536  3.0319503e+10 */
    { 0xfff70b90a44f8220LL,0xd90f46f6 }, /* 274:    -2520558930525664 -2.5205589e+15 */
    { 0x01c00804b1a00796LL,0x5be00402 }, /* 275:   126109605819320214  1.2610961e+17 */
    { 0x00000000193889ecLL,0x4dc9c44f }, /* 276:            423135724  4.2313572e+08 */
    { 0x00000001fe016fb7LL,0x4fff00b8 }, /* 277:           8556474295  8.5564743e+09 */
    { 0xfff37eed31d4affdLL,0xd948112d }, /* 278:    -3519617488867331 -3.5196175e+15 */
    { 0xfffffffff3f6a805LL,0xcd409580 }, /* 279:           -201938939 -2.0193894e+08 */
    { 0x04e0a244e9e07440LL,0x5c9c1449 }, /* 280:   351459187800175680  3.5145919e+17 */
    { 0x07ad13832fbf44a6LL,0x5cf5a270 }, /* 281:   553119783399146662  5.5311978e+17 */
    { 0x000000077fd8e65bLL,0x50effb1d }, /* 282:          32209692251  3.2209692e+10 */
    { 0xffff9549575d3ffcLL,0xd6d56d51 }, /* 283:     -117332745830404 -1.1733275e+14 */
    { 0xfe760a455af86d36LL,0xdbc4fadd }, /* 284:  -110889847828746954 -1.1088985e+17 */
    { 0xfe8266c6a9370802LL,0xdbbecc9d }, /* 285:  -107410437674956798 -1.0741044e+17 */
    { 0xffffffd45d3edc3cLL,0xd22e8b05 }, /* 286:        -187414160324 -1.8741416e+11 */
    { 0x0000000006f16825LL,0x4cde2d05 }, /* 287:            116484133  1.1648413e+08 */
    { 0x000023739cd4d39fLL,0x560dce73 }, /* 288:       38979459404703  3.8979459e+13 */
    { 0xffffff82cb352306LL,0xd2fa6996 }, /* 289:        -537756622074 -5.3775662e+11 */
    { 0xffffffffffffc103LL,0xc67bf400 }, /* 290:               -16125 -1.6125000e+04 */
    { 0xffffffffffffa4edLL,0xc6b62600 }, /* 291:               -23315 -2.3315000e+04 */
    { 0x00000019bfe4d718LL,0x51cdff27 }, /* 292:         110593627928  1.1059363e+11 */
    { 0x000000001f3071d7LL,0x4df9838f }, /* 293:            523268567  5.2326857e+08 */
    { 0xfd4be03e1caf88a2LL,0xdc2d07f0 }, /* 294:  -194815601486624606 -1.9481560e+17 */
    { 0x000000009a8744deLL,0x4f1a8745 }, /* 295:           2592556254  2.5925563e+09 */
    { 0xffffffffd81afb46LL,0xce1f9413 }, /* 296:           -669320378 -6.6932038e+08 */
    { 0xffffffffffffff13LL,0xc36d0000 }, /* 297:                 -237 -2.3700000e+02 */
    { 0xffffffd0764aae95LL,0xd23e26d5 }, /* 298:        -204173824363 -2.0417382e+11 */
    { 0x0000000000fc6ec0LL,0x4b7c6ec0 }, /* 299:             16543424  1.6543424e+07 */
    { 0x0000001fa5f2921cLL,0x51fd2f95 }, /* 300:         135928123932  1.3592812e+11 */
    { 0xa1af481776b3234aLL,0xdebca170 }, /* 301: -6796134047065889974 -6.7961340e+18 */
    { 0x188058136cda97f1LL,0x5dc402c1 }, /* 302:  1765507894383122417  1.7655079e+18 */
    { 0x94213c94c45198c1LL,0xded7bd87 }, /* 303: -7772864872218257215 -7.7728649e+18 */
    { 0xc4649aaa08ae6642LL,0xde6e6d95 }, /* 304: -4295138089523845566 -4.2951381e+18 */
    { 0xa5a8893c9ca60b4dLL,0xdeb4aeee }, /* 305: -6509802367944881331 -6.5098024e+18 */
    { 0x1491109e761ed3ebLL,0x5da48885 }, /* 306:  1481984025154212843  1.4819840e+18 */
    { 0xfee7bb5080457fcaLL,0xdb8c2258 }, /* 307:   -78888514031878198 -7.8888514e+16 */
    { 0x044258ba3e21a79aLL,0x5c884b17 }, /* 308:   306905281544169370  3.0690528e+17 */
    { 0x101b8778c3c20de8LL,0x5d80dc3c }, /* 309:  1160670281728134632  1.1606703e+18 */
    { 0xfa377e07c716ece0LL,0xdcb9103f }, /* 310:  -416725868638442272 -4.1672587e+17 */
    { 0x6264a41e6f323a21LL,0x5ec4c948 }, /* 311:  7089972164009540129  7.0899722e+18 */
    { 0xfff1d88e1f13649fLL,0xd962771e }, /* 312:    -3984019732339553 -3.9840197e+15 */
    { 0x000a012bb42b42b0LL,0x592012bb }, /* 313:     2816036985062064  2.8160370e+15 */
    { 0xe63baa04bc95bf6eLL,0xddce22b0 }, /* 314: -1856703484039676050 -1.8567035e+18 */
    { 0x7bdeda4025baf866LL,0x5ef7bdb5 }, /* 315:  8925811480540674150  8.9258115e+18 */
    { 0xfb97e3846bbe3402LL,0xdc8d038f }, /* 316:  -317535090823515134 -3.1753509e+17 */
    { 0xff27f4a2e266d51cLL,0xdb580b5d }, /* 317:   -60811089525943012 -6.0811090e+16 */
    { 0x0003d03522c6ee46LL,0x58740d49 }, /* 318:     1073351565438534  1.0733516e+15 */
    { 0x002ee3e5157d9fd9LL,0x5a3b8f94 }, /* 319:    13198421976260569  1.3198422e+16 */
    { 0xffff857ccaf7b50aLL,0xd6f5066a }, /* 320:     -134703949040374 -1.3470395e+14 */
    { 0x026bb7bda61aa1fcLL,0x5c1aedef }, /* 321:   174435035747361276  1.7443504e+17 */
    { 0xfdb43cbb453b0e12LL,0xdc12f0d1 }, /* 322:  -165440511287816686 -1.6544051e+17 */
    { 0xf962ad324e64c5beLL,0xdcd3aa5a }, /* 323:  -476628178972654146 -4.7662818e+17 */
    { 0x1008da204249d0ecLL,0x5d8046d1 }, /* 324:  1155413136506474732  1.1554131e+18 */
    { 0x00002a36d9c35076LL,0x5628db67 }, /* 325:       46415070056566  4.6415070e+13 */
    { 0x000001e0278f0243LL,0x53f013c8 }, /* 326:        2062247985731  2.0622480e+12 */
    { 0xfa596da0e6ae8d6fLL,0xdcb4d24c }, /* 327:  -407173753467925137 -4.0717375e+17 */
    { 0xd982b1f661c2c065LL,0xde19f538 }, /* 328: -2773458748746579867 -2.7734587e+18 */
    { 0xfff8f3005a579688LL,0xd8e19ff5 }, /* 329:    -1984616972446072 -1.9846170e+15 */
    { 0x001ea54090a67221LL,0x59f52a05 }, /* 330:     8625946024636961  8.6259460e+15 */
    { 0xffd5abeb008b54d7LL,0xda295054 }, /* 331:   -11914398183762729 -1.1914398e+16 */
    { 0xff2e68eadc573d4eLL,0xdb519715 }, /* 332:   -58994387180896946 -5.8994387e+16 */
    { 0xfffd93c8e0d589fcLL,0xd81b0dc8 }, /* 333:     -681933955298820 -6.8193396e+14 */
    { 0xffffffff80c1a18fLL,0xcefe7cbd }, /* 334:          -2134793841 -2.1347938e+09 */
    { 0xfffd3d6a09055af0LL,0xd830a57e }, /* 335:     -776899302958352 -7.7689930e+14 */
    { 0xff091c61d1ab2a50LL,0xdb76e39e }, /* 336:   -69493112792470960 -6.9493113e+16 */
    { 0xfffffff98c29a38eLL,0xd0ce7acc }, /* 337:         -27713231986 -2.7713232e+10 */
    { 0x000000005c2bf82dLL,0x4eb857f0 }, /* 338:           1546385453  1.5463855e+09 */
    { 0x61ab3e01c262d40cLL,0x5ec3567c }, /* 339:  7037787019973678092  7.0377870e+18 */
    { 0xffffffffff2f1c32LL,0xcb50e3ce }, /* 340:            -13689806 -1.3689806e+07 */
    { 0x0166ac44f4a07359LL,0x5bb35622 }, /* 341:   100957453824324441  1.0095745e+17 */
    { 0x000000004e4e3746LL,0x4e9c9c6f }, /* 342:           1313748806  1.3137488e+09 */
    { 0xffffffc4f90e9cbbLL,0xd26c1bc6 }, /* 343:        -253519553349 -2.5351955e+11 */
    { 0x0000390da869562bLL,0x566436a2 }, /* 344:       62730822833707  6.2730823e+13 */
    { 0xffffffffffd20986LL,0xca37d9e8 }, /* 345:             -3012218 -3.0122180e+06 */
    { 0xfffffffffffdc503LL,0xc80ebf40 }, /* 346:              -146173 -1.4617300e+05 */
    { 0x06169fd6c7bf6f65LL,0x5cc2d3fb }, /* 347:   438713758538231653  4.3871376e+17 */
    { 0xffea2e1fd7169885LL,0xd9ae8f01 }, /* 348:    -6141735200188283 -6.1417352e+15 */
    { 0xffdfd47dbbbf2343LL,0xda00ae09 }, /* 349:    -9055037745585341 -9.0550377e+15 */
    { 0xffffffddb56bf499LL,0xd2092a50 }, /* 350:        -147280104295 -1.4728010e+11 */
    { 0x000757c185102befLL,0x58eaf831 }, /* 351:     2066813509708783  2.0668135e+15 */
    { 0xffffff23965055baLL,0xd35c69b0 }, /* 352:        -946665925190 -9.4666593e+11 */
    { 0xffffffff40fed918LL,0xcf3f0127 }, /* 353:          -3204523752 -3.2045238e+09 */
    { 0xffffffffffffc757LL,0xc662a400 }, /* 354:               -14505 -1.4505000e+04 */
    { 0xfffe0b6e040a2b8eLL,0xd7fa48fe }, /* 355:     -550382811337842 -5.5038281e+14 */
    { 0x000000000000001bLL,0x41d80000 }, /* 356:                   27  2.7000000e+01 */
    { 0xfffffffffffffcbcLL,0xc4510000 }, /* 357:                 -836 -8.3600000e+02 */
    { 0x00000000000001acLL,0x43d60000 }, /* 358:                  428  4.2800000e+02 */
    { 0x00000009c2608882LL,0x511c2609 }, /* 359:          41915811970  4.1915812e+10 */
    { 0x00040261e0e953faLL,0x58804c3c }, /* 360:     1128519315313658  1.1285193e+15 */
    { 0x17476f030124f727LL,0x5dba3b78 }, /* 361:  1677431444913583911  1.6774314e+18 */
    { 0x3b72cdd0faf338e9LL,0x5e6dcb37 }, /* 362:  4283712493029898473  4.2837125e+18 */
    { 0xfa74e76b9a7884d2LL,0xdcb16313 }, /* 363:  -399440017590025006 -3.9944002e+17 */
    { 0x0db2d20afbc25ac4LL,0x5d5b2d21 }, /* 364:   987082212962884292  9.8708221e+17 */
    { 0x02d299549d37c0abLL,0x5c34a655 }, /* 365:   203393521879072939  2.0339352e+17 */
    { 0x052256931d47a2b6LL,0x5ca44ad2 }, /* 366:   369953309249217206  3.6995331e+17 */
    { 0xfcc092ffb280e1b5LL,0xdc4fdb40 }, /* 367:  -234025553714159179 -2.3402555e+17 */
    { 0x182888e65c12b77eLL,0x5dc14447 }, /* 368:  1740791778947282814  1.7407918e+18 */
    { 0xff49882e577e9929LL,0xdb3677d2 }, /* 369:   -51360188120262359 -5.1360188e+16 */
    { 0x0dc8eb414805a85bLL,0x5d5c8eb4 }, /* 370:   993302383448926299  9.9330238e+17 */
    { 0x129acebe581af7b8LL,0x5d94d676 }, /* 371:  1340611156013414328  1.3406112e+18 */
    { 0x1c96328a8e0072d4LL,0x5de4b194 }, /* 372:  2059889450237850324  2.0598895e+18 */
    { 0x03cf9edc95f825f7LL,0x5c73e7b7 }, /* 373:   274612772538951159  2.7461277e+17 */
    { 0xf99bab6751cfa6bbLL,0xdccc8a93 }, /* 374:  -460586076632799557 -4.6058608e+17 */
    { 0xfe197d27438e68b3LL,0xdbf3416c }, /* 375:  -136940706067486541 -1.3694071e+17 */
    { 0xfffec7579a1ce02dLL,0xd79c5433 }, /* 376:     -343770891755475 -3.4377089e+14 */
    { 0x0003188ffab5699fLL,0x584623ff }, /* 377:      871431595714975  8.7143160e+14 */
    { 0xffff12b65d3a385eLL,0xd76d49a3 }, /* 378:     -260900519266210 -2.6090052e+14 */
    { 0xfffdc0b700e9e334LL,0xd80fd240 }, /* 379:     -632532703255756 -6.3253270e+14 */
    { 0x0010d13d3d96ed1cLL,0x598689ea }, /* 380:     4733660583882012  4.7336606e+15 */
    { 0xfffcb001c03f4e34LL,0xd853ff90 }, /* 381:     -932378340012492 -9.3237834e+14 */
    { 0xfffffff7877a07f3LL,0xd1078860 }, /* 382:         -36381784077 -3.6381784e+10 */
    { 0x0000462aad788aa0LL,0x568c555b }, /* 383:       77149112928928  7.7149113e+13 */
    { 0xfffbda4d04465404LL,0xd884b65f }, /* 384:    -1167350564498428 -1.1673506e+15 */
    { 0x000007411c834b34LL,0x54e82390 }, /* 385:        7976232635188  7.9762326e+12 */
    { 0xfc8c89347c36412bLL,0xdc5cddb3 }, /* 386:  -248673020896984789 -2.4867302e+17 */
    { 0x00d6c4f4d7112805LL,0x5b56c4f5 }, /* 387:    60452200875370501  6.0452201e+16 */
    { 0x002e8e2f08aea76fLL,0x5a3a38bc }, /* 388:    13104181588961135  1.3104182e+16 */
    { 0x000000026ef0d940LL,0x501bbc36 }, /* 389:          10451212608  1.0451213e+10 */
    { 0xfffffffb9d79df5cLL,0xd08c50c4 }, /* 390:         -18832826532 -1.8832827e+10 */
    { 0xf8dd96bb5800496dLL,0xdce44d29 }, /* 391:  -514089051070903955 -5.1408905e+17 */
    { 0x00457d05c42df8efLL,0x5a8afa0c }, /* 392:    19559237112690927  1.9559237e+16 */
    { 0xffee3b381b1fe17aLL,0xd98e263f }, /* 393:    -5001437421510278 -5.0014374e+15 */
    { 0xfbf8b19e836ae767LL,0xdc80e9cc }, /* 394:  -290286881597626521 -2.9028688e+17 */
    { 0x0000007e83950c4eLL,0x52fd072a }, /* 395:         543373462606  5.4337346e+11 */
    { 0x000000077a47f873LL,0x50ef48ff }, /* 396:          32116308083  3.2116308e+10 */
    { 0xfffffffff2f24351LL,0xcd50dbcb }, /* 397:           -219004079 -2.1900408e+08 */
    { 0xfffff4bca6c939a8LL,0xd5343593 }, /* 398:      -12383887476312 -1.2383887e+13 */
    { 0x0000e4b386d83301LL,0x5764b387 }, /* 399:      251459712594689  2.5145971e+14 */
    { 0xffffffff41bd2d44LL,0xcf3e42d3 }, /* 400:          -3192050364 -3.1920504e+09 */
    { 0x1363a13d0ce5bb87LL,0x5d9b1d0a }, /* 401:  1397137592996445063  1.3971376e+18 */
    { 0xffffffee0993b104LL,0xd18fb362 }, /* 402:         -77148737276 -7.7148737e+10 */
    { 0xe669038c7b54f1e8LL,0xddccb7e4 }, /* 403: -1843938670532038168 -1.8439387e+18 */
    { 0x0000118fb2bf4522LL,0x558c7d96 }, /* 404:       19308876875042  1.9308877e+13 */
    { 0xfc84ce2ebc240fb0LL,0xdc5ecc74 }, /* 405:  -250848979105607760 -2.5084898e+17 */
    { 0x000000000023f364LL,0x4a0fcd90 }, /* 406:              2356068  2.3560680e+06 */
    { 0x00eda43465632019LL,0x5b6da434 }, /* 407:    66890114426675225  6.6890114e+16 */
    { 0x00000003ed479915LL,0x507b51e6 }, /* 408:          16865794325  1.6865794e+10 */
    { 0x000009c0464298c5LL,0x551c0464 }, /* 409:       10721417140421  1.0721417e+13 */
    { 0xffffffff8d0b36eeLL,0xcee5e992 }, /* 410:          -1928644882 -1.9286449e+09 */
    { 0xfffff36c656fd014LL,0xd54939a9 }, /* 411:      -13828092866540 -1.3828093e+13 */
    { 0x00000001ed82178eLL,0x4ff6c10c }, /* 412:           8279693198  8.2796932e+09 */
    { 0xff959df6f797f497LL,0xdad4c412 }, /* 413:   -29944138466593641 -2.9944138e+16 */
    { 0x00006e61d4ffe645LL,0x56dcc3aa }, /* 414:      121366464423493  1.2136646e+14 */
    { 0xffff49037e70182cLL,0xd736fc82 }, /* 415:     -201195621705684 -2.0119562e+14 */
    { 0x000000000001c25dLL,0x47e12e80 }, /* 416:               115293  1.1529300e+05 */
    { 0xd226ca2e020bf67cLL,0xde3764d7 }, /* 417: -3303730977678035332 -3.3037310e+18 */
    { 0x0000000000000026LL,0x42180000 }, /* 418:                   38  3.8000000e+01 */
    { 0x0000000023aeaa10LL,0x4e0ebaa8 }, /* 419:            598649360  5.9864936e+08 */
    { 0xfffffffffff76f58LL,0xc9090a80 }, /* 420:              -561320 -5.6132000e+05 */
    { 0x97a197ef66b6b412LL,0xded0bcd0 }, /* 421: -7520562848255790062 -7.5205628e+18 */
    { 0x321de7051da504ddLL,0x5e48779c }, /* 422:  3611296485379212509  3.6112965e+18 */
    { 0x0b3e8e432d3f4c7aLL,0x5d33e8e4 }, /* 423:   810241402146344058  8.1024140e+17 */
    { 0xc4f50843438a3e7cLL,0xde6c2bdf }, /* 424: -4254485187992600964 -4.2544852e+18 */
    { 0xfdea50578b8de938LL,0xdc056bea }, /* 425:  -150219300629780168 -1.5021930e+17 */
    { 0xc60bc4d677850db2LL,0xde67d0ed }, /* 426: -4176027804048749134 -4.1760278e+18 */
    { 0x103b5f874d6918f6LL,0x5d81dafc }, /* 427:  1169633562956732662  1.1696336e+18 */
    { 0xc7ea4e68fe34221fLL,0xde6056c6 }, /* 428: -4041331502763204065 -4.0413315e+18 */
    { 0x2e8ef598277634c0LL,0x5e3a3bd6 }, /* 429:  3354888806283490496  3.3548888e+18 */
    { 0xf01343bc9e77a46aLL,0xdd7ecbc4 }, /* 430: -1147499002657790870 -1.1474990e+18 */
    { 0x0015c81f45f6a3a4LL,0x59ae40fa }, /* 431:     6131011154256804  6.1310112e+15 */
    { 0xfe2601b734fd917eLL,0xdbecff24 }, /* 432:  -133417252581174914 -1.3341725e+17 */
    { 0xffc6fd82f878d2f0LL,0xda6409f4 }, /* 433:   -16046809692974352 -1.6046810e+16 */
    { 0x057e2bcb5406cac6LL,0x5cafc579 }, /* 434:   395801969543269062  3.9580197e+17 */
    { 0x0021f18390adcc5aLL,0x5a07c60e }, /* 435:     9554221601770586  9.5542216e+15 */
    { 0xfe83af7b7a0cd5e9LL,0xdbbe2842 }, /* 436:  -107049021263260183 -1.0704902e+17 */
    { 0xfffe6cb9ac16c9edLL,0xd7c9a32a }, /* 437:     -443405241497107 -4.4340524e+14 */
    { 0x026cac7b54e31536LL,0x5c1b2b1f }, /* 438:   174704131265729846  1.7470413e+17 */
    { 0xfffff09f1f2fafbdLL,0xd5760e0d }, /* 439:      -16908763025475 -1.6908763e+13 */
    { 0x0a199497a5fe7545LL,0x5d219949 }, /* 440:   727776193842935109  7.2777619e+17 */
    { 0x00001a05bf89b661LL,0x55d02dfc }, /* 441:       28611990632033  2.8611991e+13 */
    { 0x000003deea907e0fLL,0x5477baa4 }, /* 442:        4255952961039  4.2559530e+12 */
    { 0x01d6edd8829af58bLL,0x5beb76ec }, /* 443:   132554753213920651  1.3255475e+17 */
    { 0x017ac6d812de4ccfLL,0x5bbd636c }, /* 444:   106616172528422095  1.0661617e+17 */
    { 0xffffef1d3a359485LL,0xd587162e }, /* 445:      -18566167030651 -1.8566167e+13 */
    { 0x00ebcde6c4313cd6LL,0x5b6bcde7 }, /* 446:    66373010544737494  6.6373011e+16 */
    { 0xdbddf575fadfecdfLL,0xde10882a }, /* 447: -2603655122481320737 -2.6036551e+18 */
    { 0x0000001c7990a8e2LL,0x51e3cc85 }, /* 448:         122298607842  1.2229861e+11 */
    { 0x008f441d1197c706LL,0x5b0f441d }, /* 449:    40325813309523718  4.0325813e+16 */
    { 0x000061cb94152e03LL,0x56c39728 }, /* 450:      107526990671363  1.0752699e+14 */
    { 0x0c72d578939529e4LL,0x5d472d58 }, /* 451:   897013989648968164  8.9701399e+17 */
    { 0xffffc9f3275752efLL,0xd6583363 }, /* 452:      -59428802440465 -5.9428802e+13 */
    { 0x02ffa708c20b66f0LL,0x5c3fe9c2 }, /* 453:   216074963194177264  2.1607496e+17 */
    { 0x001adc7491576f51LL,0x59d6e3a5 }, /* 454:     7560742607220561  7.5607426e+15 */
    { 0x0000c1e956678a54LL,0x5741e956 }, /* 455:      213207921166932  2.1320792e+14 */
    { 0xffe003bedcd2daedLL,0xd9ffe209 }, /* 456:    -9003080971265299 -9.0030810e+15 */
    { 0xf9a32f7283d4c621LL,0xdccb9a12 }, /* 457:  -458470568177121759 -4.5847057e+17 */
    { 0xfffffffed3acd9faLL,0xcf962993 }, /* 458:          -5038614022 -5.0386140e+09 */
    { 0x00024c06d9710d17LL,0x581301b6 }, /* 459:      646542255000855  6.4654226e+14 */
    { 0xffffffff36580277LL,0xcf49a7fe }, /* 460:          -3383229833 -3.3832298e+09 */
    { 0xffee897d3bd35a61LL,0xd98bb416 }, /* 461:    -4915378613167519 -4.9153786e+15 */
    { 0x203538f435409a5fLL,0x5e00d4e4 }, /* 462:  2320823804495960671  2.3208238e+18 */
    { 0x0000000005d877a6LL,0x4cbb0ef5 }, /* 463:             98072486  9.8072486e+07 */
    { 0xffffff80b807e776LL,0xd2fe8ff0 }, /* 464:        -546668288138 -5.4666829e+11 */
    { 0x000000000002b340LL,0x482cd000 }, /* 465:               176960  1.7696000e+05 */
    { 0x00000000001f489dLL,0x49fa44e8 }, /* 466:              2050205  2.0502050e+06 */
    { 0x000000004bea35e6LL,0x4e97d46c }, /* 467:           1273640422  1.2736404e+09 */
    { 0xfffffffffffe315aLL,0xc7e75300 }, /* 468:              -118438 -1.1843800e+05 */
    { 0x000000002b0908b6LL,0x4e2c2423 }, /* 469:            722012342  7.2201234e+08 */
    { 0x000000b5d2441e59LL,0x5335d244 }, /* 470:         780916760153  7.8091676e+11 */
    { 0xffffffffffc6a55eLL,0xca656a88 }, /* 471:             -3758754 -3.7587540e+06 */
    { 0xffffffff3238cbcbLL,0xcf4dc734 }, /* 472:          -3452384309 -3.4523843e+09 */
    { 0x00000000003c4616LL,0x4a711858 }, /* 473:              3950102  3.9501020e+06 */
    { 0xfffffc7d7ef4bb5aLL,0xd460a043 }, /* 474:       -3859045631142 -3.8590456e+12 */
    { 0x0000000000a2c996LL,0x4b22c996 }, /* 475:             10668438  1.0668438e+07 */
    { 0x0000e452a3cf76edLL,0x576452a4 }, /* 476:      251043586733805  2.5104359e+14 */
    { 0x000001e49035e883LL,0x53f2481b }, /* 477:        2081183623299  2.0811836e+12 */
    { 0xffffff42c9b7dabbLL,0xd33d3648 }, /* 478:        -812659516741 -8.1265952e+11 */
    { 0x000042a9327daeafLL,0x56855265 }, /* 479:       73294464003759  7.3294464e+13 */
    { 0xff111a073b6f1661LL,0xdb6ee5f9 }, /* 480:   -67243901069617567 -6.7243901e+16 */
    { 0xf774b4058232630eLL,0xdd08b4c0 }, /* 481:  -615669313290738930 -6.1566931e+17 */
    { 0xc06abafe8e492539LL,0xde7e5514 }, /* 482: -4581644068424440519 -4.5816441e+18 */
    { 0x29bb215751cf867bLL,0x5e26ec85 }, /* 483:  3007033835118364283  3.0070338e+18 */
    { 0xf85c2078859f9496LL,0xdcf47bf1 }, /* 484:  -550529352436050794 -5.5052935e+17 */
    { 0x0871344ced4a47aeLL,0x5d071345 }, /* 485:   608324929674954670  6.0832493e+17 */
    { 0xfe19332d6e194d69LL,0xdbf36669 }, /* 486:  -137022043444392599 -1.3702204e+17 */
    { 0xbf8d9ac80b9f3056LL,0xde80e4ca }, /* 487: -4643885456769994666 -4.6438855e+18 */
    { 0x08b446ea040d4f33LL,0x5d0b446f }, /* 488:   627204219015614259  6.2720422e+17 */
    { 0xff79c8d4d369173eLL,0xdb06372b }, /* 489:   -37778305450436802 -3.7778305e+16 */
    { 0xffe62aea7af53c95LL,0xd9cea8ac }, /* 490:    -7271162820871019 -7.2711628e+15 */
    { 0xfe0949e541a2edfaLL,0xdbfb5b0d }, /* 491:  -141500664287924742 -1.4150066e+17 */
    { 0x0008d9fc336840a4LL,0x590d9fc3 }, /* 492:     2491477031141540  2.4914770e+15 */
    { 0x01a648c02bd9251aLL,0x5bd32460 }, /* 493:   118862430378468634  1.1886243e+17 */
    { 0xfdc7fe066c9bf88aLL,0xdc0e007e }, /* 494:  -159879958202943350 -1.5987996e+17 */
    { 0xf4a5c963388d5b96LL,0xdd35a36a }, /* 495:  -818026329310143594 -8.1802633e+17 */
    { 0xff24d1055f3072b9LL,0xdb5b2efb }, /* 496:   -61694673874292039 -6.1694674e+16 */
    { 0xe4ebb84e0f4ced19LL,0xddd8a23e }, /* 497: -1951263368131318503 -1.9512634e+18 */
    { 0x03300676bbcece5dLL,0x5c4c019e }, /* 498:   229690688022695517  2.2969069e+17 */
    { 0x0000169913a10b25LL,0x55b4c89d }, /* 499:       24846715128613  2.4846715e+13 */
    { 0x069aa2eb34268603LL,0x5cd3545d }, /* 500:   475871841716962819  4.7587184e+17 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d] (%#llx):  %#lx (%g)\n",
             index - 1, t[index-1].x, v.lo, v.fl);
#endif
    exit (index ? index : -1);
}

int main ()
{
    long long x;
    union lofl_u z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x = pgm_read_qword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = x;
	if (v.lo != z.lo)
	    x_exit (i+1);
    }
    return 0;
}
