/* applet.c generated by valac, the Vala compiler
 * generated from applet.vala, do not modify */

/*
 * Copyright (C) 2009 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <libawn/libawn.h>
#include <libdesktop-agnostic/config.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n.h>
#include <libawn/awn-utils.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <float.h>
#include <math.h>


#define TYPE_PREFS_APPLET (prefs_applet_get_type ())
#define PREFS_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFS_APPLET, PrefsApplet))
#define PREFS_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFS_APPLET, PrefsAppletClass))
#define IS_PREFS_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFS_APPLET))
#define IS_PREFS_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFS_APPLET))
#define PREFS_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFS_APPLET, PrefsAppletClass))

typedef struct _PrefsApplet PrefsApplet;
typedef struct _PrefsAppletClass PrefsAppletClass;
typedef struct _PrefsAppletPrivate PrefsAppletPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PrefsApplet {
	AwnAppletSimple parent_instance;
	PrefsAppletPrivate * priv;
};

struct _PrefsAppletClass {
	AwnAppletSimpleClass parent_class;
};

struct _PrefsAppletPrivate {
	DesktopAgnosticConfigClient* panel_client;
	GtkMenu* ctx_menu;
	GList* windows;
	guint timer_id;
	gboolean in_drag;
	guint autohide_cookie;
	AwnApplet* docklet;
	GList* docklet_icons;
};


static gpointer prefs_applet_parent_class = NULL;

#define not_used APPLETSDIR
GType prefs_applet_get_type (void);
#define PREFS_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFS_APPLET, PrefsAppletPrivate))
enum  {
	PREFS_APPLET_DUMMY_PROPERTY
};
PrefsApplet* prefs_applet_new (const char* canonical_name, const char* uid, gint panel_id);
PrefsApplet* prefs_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id);
static void prefs_applet_on_clicked (PrefsApplet* self);
static void _prefs_applet_on_clicked_awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void prefs_applet_on_context_menu_popup (PrefsApplet* self, GdkEventButton* evt);
static void _prefs_applet_on_context_menu_popup_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self);
static void prefs_applet_on_drag_begin (PrefsApplet* self, GdkDragContext* context);
static void _prefs_applet_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender, GdkDragContext* context, gpointer self);
static void prefs_applet_on_drag_end (PrefsApplet* self, GdkDragContext* context);
static void _prefs_applet_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender, GdkDragContext* context, gpointer self);
static gboolean prefs_applet_on_drag_failed (PrefsApplet* self, GdkDragContext* context, GtkDragResult _result_);
static gboolean _prefs_applet_on_drag_failed_gtk_widget_drag_failed (GtkWidget* _sender, GdkDragContext* p0, GtkDragResult p1, gpointer self);
static void prefs_applet_initialize_menu (PrefsApplet* self);
static void prefs_applet_taskmanager_appeared (PrefsApplet* self, const char* name);
static void _prefs_applet_taskmanager_appeared_awn_dbus_watcher_name_appeared (AwnDBusWatcher* _sender, const char* name, gpointer self);
static void prefs_applet_update_taskmanager (PrefsApplet* self, gboolean visible);
static void _lambda10_ (AwnApplet* w, PrefsApplet* self);
static void __lambda10__awn_applet_applet_deleted (AwnApplet* _sender, gpointer self);
static void prefs_applet_real_constructed (GObject* base);
static void prefs_applet_on_quit_click (PrefsApplet* self);
static void _prefs_applet_on_quit_click_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void prefs_applet_run_preferences (PrefsApplet* self, gboolean about_only);
static void _lambda9_ (GtkMenuItem* w, PrefsApplet* self);
static void __lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static char** _dynamic_GetCapabilities0 (DBusGProxy* self, int* result_length1, GError** error);
static void _dynamic_AwnSetVisibility1 (DBusGProxy* self, const char* param1, gboolean param2, GError** error);
static void prefs_applet_on_active_changed (PrefsApplet* self, WnckWindow* old_active);
static void prefs_applet_update_icon (PrefsApplet* self);
static void prefs_applet_on_window_opened (PrefsApplet* self, WnckWindow* window);
static void prefs_applet_on_window_closed (PrefsApplet* self, WnckWindow* window);
static gboolean prefs_applet_on_timer_tick (PrefsApplet* self);
static gboolean _prefs_applet_on_timer_tick_gsource_func (gpointer self);
void prefs_applet_setup_docklet (PrefsApplet* self, GdkNativeWindow window_id);
void prefs_applet_setup_label_for_docklet (AwnLabel* label, AwnApplet* docklet);
static AwnIcon* prefs_applet_new_unbound_icon (void);
static void _lambda0_ (GtkObject* w, PrefsApplet* self);
static void __lambda0__gtk_object_destroy (GtkObject* _sender, gpointer self);
static void _lambda1_ (AwnApplet* w, gint s, PrefsApplet* self);
static void __lambda1__awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self);
static void _lambda2_ (AwnApplet* w, GtkPositionType p, PrefsApplet* self);
static void __lambda2__awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self);
static void _lambda3_ (AwnIcon* w, PrefsApplet* self);
static void __lambda3__awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void prefs_applet_change_icon_size (PrefsApplet* self, gint new_size);
static void _lambda4_ (AwnIcon* w, PrefsApplet* self);
static void __lambda4__awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void _lambda5_ (AwnIcon* w, PrefsApplet* self);
static void __lambda5__awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void _lambda6_ (AwnIcon* w, PrefsApplet* self);
static void __lambda6__awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void _lambda7_ (AwnIcon* w, PrefsApplet* self);
static void __lambda7__awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void _lambda8_ (AwnIcon* w, PrefsApplet* self);
static void __lambda8__awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void _dynamic_RemovePanel2 (DBusGProxy* self, gint param1, GError** error);
static void _prefs_applet_on_window_opened_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self);
static void _prefs_applet_on_window_closed_wnck_screen_window_closed (WnckScreen* _sender, WnckWindow* window, gpointer self);
static void _prefs_applet_on_active_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self);
static GObject * prefs_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void prefs_applet_finalize (GObject* obj);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkTargetEntry PREFS_APPLET_targets[] = {{"awn/awn-panel", (guint) GTK_TARGET_SAME_WIDGET, (guint) 0}};


PrefsApplet* prefs_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id) {
	GParameter * __params;
	GParameter * __params_it;
	PrefsApplet * self;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "canonical-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, canonical_name);
	__params_it++;
	__params_it->name = "uid";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, uid);
	__params_it++;
	__params_it->name = "panel-id";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, panel_id);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


PrefsApplet* prefs_applet_new (const char* canonical_name, const char* uid, gint panel_id) {
	return prefs_applet_construct (TYPE_PREFS_APPLET, canonical_name, uid, panel_id);
}


static void _prefs_applet_on_clicked_awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	prefs_applet_on_clicked (self);
}


static void _prefs_applet_on_context_menu_popup_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self) {
	prefs_applet_on_context_menu_popup (self, event);
}


static void _prefs_applet_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender, GdkDragContext* context, gpointer self) {
	prefs_applet_on_drag_begin (self, context);
}


static void _prefs_applet_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender, GdkDragContext* context, gpointer self) {
	prefs_applet_on_drag_end (self, context);
}


static gboolean _prefs_applet_on_drag_failed_gtk_widget_drag_failed (GtkWidget* _sender, GdkDragContext* p0, GtkDragResult p1, gpointer self) {
	return prefs_applet_on_drag_failed (self, p0, p1);
}


static void _prefs_applet_taskmanager_appeared_awn_dbus_watcher_name_appeared (AwnDBusWatcher* _sender, const char* name, gpointer self) {
	prefs_applet_taskmanager_appeared (self, name);
}


static void _lambda10_ (AwnApplet* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	prefs_applet_update_taskmanager (self, TRUE);
}


static void __lambda10__awn_applet_applet_deleted (AwnApplet* _sender, gpointer self) {
	_lambda10_ (_sender, self);
}


static void prefs_applet_real_constructed (GObject* base) {
	PrefsApplet * self;
	GError * _inner_error_;
	gint _tmp0_;
	DesktopAgnosticConfigClient* _tmp1_;
	gint _tmp5__length1;
	char** _tmp5_;
	char** _tmp4_ = NULL;
	gint _tmp3__length1;
	char** _tmp3_;
	char** _tmp2_ = NULL;
	AwnIcon* icon;
	GdkPixbuf* pixbuf;
	AwnDBusWatcher* watcher;
	self = (PrefsApplet*) base;
	_inner_error_ = NULL;
	G_OBJECT_CLASS (prefs_applet_parent_class)->constructed ((GObject*) AWN_APPLET_SIMPLE (self));
	_tmp1_ = awn_config_get_default ((g_object_get ((AwnApplet*) self, "panel-id", &_tmp0_, NULL), _tmp0_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->panel_client = _tmp1_;
	awn_applet_simple_set_icon_info ((AwnAppletSimple*) self, (_tmp3_ = (_tmp2_ = g_new0 (char*, 4 + 1), _tmp2_[0] = g_strdup ("main-icon"), _tmp2_[1] = g_strdup ("dir"), _tmp2_[2] = g_strdup ("prefs"), _tmp2_[3] = g_strdup ("about"), _tmp2_), _tmp3__length1 = 4, _tmp3_), (_tmp5_ = (_tmp4_ = g_new0 (char*, 4 + 1), _tmp4_[0] = g_strdup ("awn-settings"), _tmp4_[1] = g_strdup ("gtk-directory"), _tmp4_[2] = g_strdup ("gtk-preferences"), _tmp4_[3] = g_strdup ("gtk-about"), _tmp4_), _tmp5__length1 = 4, _tmp5_));
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	awn_applet_simple_set_icon_state ((AwnAppletSimple*) self, "main-icon");
	icon = awn_applet_simple_get_icon ((AwnAppletSimple*) self);
	g_signal_connect_object (icon, "clicked", (GCallback) _prefs_applet_on_clicked_awn_icon_clicked, self, 0);
	g_signal_connect_object (icon, "context-menu-popup", (GCallback) _prefs_applet_on_context_menu_popup_awn_icon_context_menu_popup, self, 0);
	g_signal_connect_object ((GtkWidget*) icon, "drag-begin", (GCallback) _prefs_applet_on_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) icon, "drag-end", (GCallback) _prefs_applet_on_drag_end_gtk_widget_drag_end, self, 0);
	g_signal_connect_object ((GtkWidget*) icon, "drag-failed", (GCallback) _prefs_applet_on_drag_failed_gtk_widget_drag_failed, self, 0);
	gtk_drag_source_set ((GtkWidget*) icon, GDK_BUTTON1_MASK, PREFS_APPLET_targets, G_N_ELEMENTS (PREFS_APPLET_targets), GDK_ACTION_LINK);
	pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1, 1);
	gdk_pixbuf_fill (pixbuf, (guint32) 0);
	gtk_drag_source_set_icon_pixbuf ((GtkWidget*) icon, pixbuf);
	awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) self, "Avant Window Navigator");
	prefs_applet_initialize_menu (self);
	watcher = awn_dbus_watcher_get_default ();
	g_signal_connect_object (watcher, "name-appeared::org.freedesktop.DockManager", (GCallback) _prefs_applet_taskmanager_appeared_awn_dbus_watcher_name_appeared, self, 0);
	prefs_applet_update_taskmanager (self, FALSE);
	g_signal_connect_object ((AwnApplet*) self, "applet-deleted", (GCallback) __lambda10__awn_applet_applet_deleted, self, 0);
	_g_object_unref0 (pixbuf);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _prefs_applet_on_quit_click_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	prefs_applet_on_quit_click (self);
}


static void _lambda9_ (GtkMenuItem* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	prefs_applet_run_preferences (self, TRUE);
}


static void __lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda9_ (_sender, self);
}


static void prefs_applet_initialize_menu (PrefsApplet* self) {
	GtkMenu* _tmp1_;
	GtkWidget* _tmp0_;
	GtkImageMenuItem* quit_item;
	GtkImageMenuItem* about_item;
	GtkImage* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->ctx_menu = (_tmp1_ = _g_object_ref0 ((_tmp0_ = awn_applet_create_default_menu ((AwnApplet*) self), GTK_IS_MENU (_tmp0_) ? ((GtkMenu*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->ctx_menu), _tmp1_);
	quit_item = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL));
	g_signal_connect_object ((GtkMenuItem*) quit_item, "activate", (GCallback) _prefs_applet_on_quit_click_gtk_menu_item_activate, self, 0);
	gtk_widget_show ((GtkWidget*) quit_item);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->ctx_menu, (GtkWidget*) ((GtkMenuItem*) quit_item));
	about_item = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_ ("About Awn")));
	gtk_image_menu_item_set_image (about_item, (GtkWidget*) (_tmp2_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_ABOUT, GTK_ICON_SIZE_MENU))));
	_g_object_unref0 (_tmp2_);
	g_signal_connect_object ((GtkMenuItem*) about_item, "activate", (GCallback) __lambda9__gtk_menu_item_activate, self, 0);
	gtk_widget_show ((GtkWidget*) about_item);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->ctx_menu, (GtkWidget*) ((GtkMenuItem*) about_item));
	awn_utils_show_menu_images (self->priv->ctx_menu);
	_g_object_unref0 (quit_item);
	_g_object_unref0 (about_item);
}


static void prefs_applet_taskmanager_appeared (PrefsApplet* self, const char* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	prefs_applet_update_taskmanager (self, FALSE);
}


static char** _dynamic_GetCapabilities0 (DBusGProxy* self, int* result_length1, GError** error) {
	char** result;
	dbus_g_proxy_call (self, "GetCapabilities", error, G_TYPE_INVALID, G_TYPE_STRV, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	*result_length1 = g_strv_length (result);
	return result;
}


static void _dynamic_AwnSetVisibility1 (DBusGProxy* self, const char* param1, gboolean param2, GError** error) {
	dbus_g_proxy_call (self, "AwnSetVisibility", error, G_TYPE_STRING, param1, G_TYPE_BOOLEAN, param2, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void prefs_applet_update_taskmanager (PrefsApplet* self, gboolean visible) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		DBusGConnection* con;
		DBusGProxy* taskman;
		DBusGProxy* _tmp0_;
		char** _tmp2_;
		gint caps_size;
		gint caps_length1;
		gint _tmp1_;
		char** caps;
		gboolean supports_visibility_setting;
		con = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		taskman = NULL;
		taskman = (_tmp0_ = dbus_g_proxy_new_for_name (con, "org.freedesktop.DockManager", "/org/freedesktop/DockManager", "org.freedesktop.DockManager"), _g_object_unref0 (taskman), _tmp0_);
		caps = (_tmp2_ = _dynamic_GetCapabilities0 (taskman, &_tmp1_, &_inner_error_), caps_length1 = _tmp1_, caps_size = caps_length1, _tmp2_);
		if (_inner_error_ != NULL) {
			_dbus_g_connection_unref0 (con);
			_g_object_unref0 (taskman);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			goto __finally0;
		}
		supports_visibility_setting = FALSE;
		{
			char** cap_collection;
			int cap_collection_length1;
			int cap_it;
			cap_collection = caps;
			cap_collection_length1 = caps_length1;
			for (cap_it = 0; cap_it < caps_length1; cap_it = cap_it + 1) {
				char* cap;
				cap = g_strdup (cap_collection[cap_it]);
				{
					if (_vala_strcmp0 (cap, "x-awn-set-visibility") == 0) {
						supports_visibility_setting = TRUE;
					}
					_g_free0 (cap);
				}
			}
		}
		if (supports_visibility_setting) {
			_dynamic_AwnSetVisibility1 (taskman, "awn-settings", visible, &_inner_error_);
			if (_inner_error_ != NULL) {
				_dbus_g_connection_unref0 (con);
				_g_object_unref0 (taskman);
				caps = (_vala_array_free (caps, caps_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch0_dbus_gerror;
				}
				goto __finally0;
			}
		}
		_dbus_g_connection_unref0 (con);
		_g_object_unref0 (taskman);
		caps = (_vala_array_free (caps, caps_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void prefs_applet_on_active_changed (PrefsApplet* self, WnckWindow* old_active) {
	AwnIcon* icon;
	g_return_if_fail (self != NULL);
	icon = awn_applet_simple_get_icon ((AwnAppletSimple*) self);
	{
		GList* window_collection;
		GList* window_it;
		window_collection = self->priv->windows;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			WnckWindow* window;
			window = (WnckWindow*) window_it->data;
			{
				if (wnck_window_is_active (window)) {
					awn_icon_set_is_active (icon, TRUE);
					return;
				}
			}
		}
	}
	awn_icon_set_is_active (icon, FALSE);
}


static void prefs_applet_on_window_opened (PrefsApplet* self, WnckWindow* window) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (_vala_strcmp0 (wnck_class_group_get_name (wnck_window_get_class_group (window)), "awn-settings") == 0) {
		self->priv->windows = g_list_append (self->priv->windows, window);
	}
	prefs_applet_update_icon (self);
}


static void prefs_applet_on_window_closed (PrefsApplet* self, WnckWindow* window) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (g_list_find (self->priv->windows, window) != NULL) {
		self->priv->windows = g_list_remove (self->priv->windows, window);
	}
	prefs_applet_update_icon (self);
}


static void prefs_applet_update_icon (PrefsApplet* self) {
	AwnIcon* icon;
	g_return_if_fail (self != NULL);
	icon = awn_applet_simple_get_icon ((AwnAppletSimple*) self);
	awn_icon_set_indicator_count (icon, (gint) g_list_length (self->priv->windows));
}


static gboolean prefs_applet_on_timer_tick (PrefsApplet* self) {
	gboolean result;
	GError * _inner_error_;
	gint mouse_x = 0;
	gint mouse_y = 0;
	GdkScreen* screen;
	GdkRectangle rect = {0};
	gint monitor_num;
	gint n_monitors;
	gint default_mon;
	float rel_x;
	float rel_y;
	GtkPositionType pos = 0;
	gboolean _tmp0_ = FALSE;
	gboolean is_top;
	gboolean _tmp1_ = FALSE;
	gboolean is_bottom;
	gboolean _tmp2_ = FALSE;
	gboolean is_left;
	gboolean _tmp3_ = FALSE;
	gboolean is_right;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean on_edge;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	screen = NULL;
	gdk_display_get_pointer (gtk_widget_get_display ((GtkWidget*) awn_applet_simple_get_icon ((AwnAppletSimple*) self)), &screen, &mouse_x, &mouse_y, NULL);
	monitor_num = gdk_screen_get_monitor_at_point (screen, mouse_x, mouse_y);
	n_monitors = gdk_screen_get_n_monitors (screen);
	default_mon = gdk_screen_get_monitor_at_point (screen, 0, 0);
	gdk_screen_get_monitor_geometry (screen, monitor_num, &rect);
	rel_x = (mouse_x - rect.x) / ((float) rect.width);
	rel_y = (mouse_y - rect.y) / ((float) rect.height);
	if (rel_y <= 0.15) {
		_tmp0_ = rel_y >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	is_top = _tmp0_;
	if (rel_y >= 0.85) {
		_tmp1_ = rel_y <= 1;
	} else {
		_tmp1_ = FALSE;
	}
	is_bottom = _tmp1_;
	if (rel_x <= 0.15) {
		_tmp2_ = rel_x >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	is_left = _tmp2_;
	if (rel_x >= 0.85) {
		_tmp3_ = rel_x <= 1;
	} else {
		_tmp3_ = FALSE;
	}
	is_right = _tmp3_;
	if (is_top) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = is_bottom;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = is_left;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = is_right;
	}
	on_edge = _tmp4_;
	if (is_bottom) {
		pos = GTK_POS_BOTTOM;
	} else {
		if (is_top) {
			pos = GTK_POS_TOP;
		} else {
			if (is_left) {
				pos = GTK_POS_LEFT;
			} else {
				if (is_right) {
					pos = GTK_POS_RIGHT;
				} else {
					pos = GTK_POS_BOTTOM;
				}
			}
		}
	}
	{
		desktop_agnostic_config_client_set_bool (self->priv->panel_client, "panel", "monitor_force", FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		if (n_monitors > 1) {
			gint config_mon;
			gboolean _tmp7_ = FALSE;
			config_mon = desktop_agnostic_config_client_get_int (self->priv->panel_client, "panel", "monitor_num", &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			if (default_mon != monitor_num) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = monitor_num != config_mon;
			}
			if (_tmp7_) {
				desktop_agnostic_config_client_set_int (self->priv->panel_client, "panel", "monitor_num", monitor_num, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
			}
		}
		if (on_edge) {
			desktop_agnostic_config_client_set_int (self->priv->panel_client, "panel", "orient", (gint) pos, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("applet.vala:266: Unable to set panel properties. Error: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static gboolean _prefs_applet_on_timer_tick_gsource_func (gpointer self) {
	return prefs_applet_on_timer_tick (self);
}


static void prefs_applet_on_drag_begin (PrefsApplet* self, GdkDragContext* context) {
	AwnTooltip* tooltip;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	self->priv->in_drag = TRUE;
	awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) self, _ ("Drag to change panel orientation"));
	tooltip = awn_icon_get_tooltip (awn_applet_simple_get_icon ((AwnAppletSimple*) self));
	g_object_set (tooltip, "smart-behavior", FALSE, NULL);
	g_object_set (tooltip, "toggle-on-click", FALSE, NULL);
	gtk_widget_show ((GtkWidget*) tooltip);
	if (self->priv->timer_id == 0) {
		self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, _prefs_applet_on_timer_tick_gsource_func, g_object_ref (self), g_object_unref);
	}
	if (self->priv->autohide_cookie == 0) {
		self->priv->autohide_cookie = awn_applet_inhibit_autohide ((AwnApplet*) self, "awn-settings");
	}
}


static void prefs_applet_on_drag_end (PrefsApplet* self, GdkDragContext* context) {
	AwnTooltip* tooltip;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (self->priv->timer_id != 0) {
		g_source_remove (self->priv->timer_id);
		self->priv->timer_id = (guint) 0;
	}
	if (self->priv->autohide_cookie != 0) {
		awn_applet_uninhibit_autohide ((AwnApplet*) self, self->priv->autohide_cookie);
		self->priv->autohide_cookie = (guint) 0;
	}
	tooltip = awn_icon_get_tooltip (awn_applet_simple_get_icon ((AwnAppletSimple*) self));
	gtk_widget_hide ((GtkWidget*) tooltip);
	awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) self, "Avant Window Navigator");
	g_object_set (tooltip, "smart-behavior", TRUE, NULL);
	g_object_set (tooltip, "toggle-on-click", TRUE, NULL);
	self->priv->in_drag = FALSE;
}


static gboolean prefs_applet_on_drag_failed (PrefsApplet* self, GdkDragContext* context, GtkDragResult _result_) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	result = TRUE;
	return result;
}


static void prefs_applet_on_clicked (PrefsApplet* self) {
	guint32 cur_time;
	g_return_if_fail (self != NULL);
	if (self->priv->in_drag) {
		return;
	}
	cur_time = gtk_get_current_event_time ();
	if (g_list_length (self->priv->windows) >= 1) {
		WnckWindow* window;
		window = (WnckWindow*) self->priv->windows->data;
		if (wnck_window_is_active (window)) {
			{
				GList* w_collection;
				GList* w_it;
				w_collection = self->priv->windows;
				for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
					WnckWindow* w;
					w = (WnckWindow*) w_it->data;
					{
						wnck_window_minimize (w);
					}
				}
			}
		} else {
			wnck_window_activate (window, cur_time);
		}
	} else {
		GdkNativeWindow window_id;
		window_id = awn_applet_docklet_request ((AwnApplet*) self, 450, FALSE, TRUE);
		if (((glong) window_id) != 0) {
			prefs_applet_setup_docklet (self, window_id);
		} else {
			gtk_menu_popup (self->priv->ctx_menu, NULL, NULL, NULL, NULL, (guint) 0, cur_time);
		}
	}
}


void prefs_applet_setup_label_for_docklet (AwnLabel* label, AwnApplet* docklet) {
	GtkPositionType pos_type;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (label != NULL);
	g_return_if_fail (docklet != NULL);
	pos_type = awn_applet_get_pos_type (docklet);
	if (pos_type == GTK_POS_TOP) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = pos_type == GTK_POS_BOTTOM;
	}
	if (_tmp0_) {
		gtk_widget_set_size_request ((GtkWidget*) label, -1, awn_applet_get_size (docklet));
		gtk_misc_set_alignment ((GtkMisc*) label, 1.0f, 0.5f);
		gtk_label_set_angle ((GtkLabel*) label, (double) 0);
	} else {
		gint _tmp1_ = 0;
		gtk_widget_set_size_request ((GtkWidget*) label, awn_applet_get_size (docklet), -1);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.5f, 1.0f);
		if (pos_type == GTK_POS_LEFT) {
			_tmp1_ = 90;
		} else {
			_tmp1_ = 270;
		}
		gtk_label_set_angle ((GtkLabel*) label, (double) _tmp1_);
	}
}


static AwnIcon* prefs_applet_new_unbound_icon (void) {
	AwnIcon* result;
	AwnIcon* icon;
	AwnIcon* _tmp3_;
	GObject* _tmp1_;
	GObject* _tmp0_;
	GObject* _tmp2_;
	icon = NULL;
	icon = (_tmp3_ = _g_object_ref0 ((_tmp2_ = g_object_ref (_tmp1_ = g_object_ref_sink (_tmp0_ = g_object_new (AWN_TYPE_ICON, "bind-effects", FALSE, NULL))), AWN_IS_ICON (_tmp2_) ? ((AwnIcon*) _tmp2_) : NULL)), _g_object_unref0 (icon), _tmp3_);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (_tmp0_);
	result = icon;
	return result;
}


static void _lambda0_ (GtkObject* w, PrefsApplet* self) {
	AwnApplet* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (w != NULL);
	self->priv->docklet = (_tmp0_ = NULL, _g_object_unref0 (self->priv->docklet), _tmp0_);
	self->priv->docklet_icons = (_tmp1_ = NULL, _g_list_free0 (self->priv->docklet_icons), _tmp1_);
}


static void __lambda0__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (AwnApplet* w, gint s, PrefsApplet* self) {
	const char* icon_name;
	AwnIcon* _tmp0_;
	AwnThemedIcon* loader;
	g_return_if_fail (w != NULL);
	icon_name = NULL;
	loader = (_tmp0_ = awn_applet_simple_get_icon ((AwnAppletSimple*) self), AWN_IS_THEMED_ICON (_tmp0_) ? ((AwnThemedIcon*) _tmp0_) : NULL);
	{
		GList* widget_collection;
		GList* widget_it;
		widget_collection = self->priv->docklet_icons;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* widget;
			widget = (GtkWidget*) widget_it->data;
			{
				void* ptr;
				ptr = g_object_get_data ((GObject*) widget, "icon-name");
				icon_name = (const char*) ptr;
				if (icon_name != NULL) {
					GtkWidget* _tmp1_;
					AwnIcon* it_icon;
					GdkPixbuf* _tmp2_;
					it_icon = (_tmp1_ = widget, AWN_IS_ICON (_tmp1_) ? ((AwnIcon*) _tmp1_) : NULL);
					awn_icon_set_from_pixbuf (it_icon, _tmp2_ = awn_themed_icon_get_icon_at_size (loader, s, icon_name));
					_g_object_unref0 (_tmp2_);
				} else {
					GtkWidget* _tmp3_;
					prefs_applet_setup_label_for_docklet ((_tmp3_ = widget, AWN_IS_LABEL (_tmp3_) ? ((AwnLabel*) _tmp3_) : NULL), w);
				}
			}
		}
	}
}


static void __lambda1__awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self) {
	_lambda1_ (_sender, size, self);
}


static void _lambda2_ (AwnApplet* w, GtkPositionType p, PrefsApplet* self) {
	GtkWidget* _tmp0_;
	AwnBox* box;
	g_return_if_fail (w != NULL);
	box = (_tmp0_ = gtk_bin_get_child ((GtkBin*) w), AWN_IS_BOX (_tmp0_) ? ((AwnBox*) _tmp0_) : NULL);
	awn_box_set_orientation_from_pos_type (box, p);
	{
		GList* widget_collection;
		GList* widget_it;
		widget_collection = self->priv->docklet_icons;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* widget;
			widget = (GtkWidget*) widget_it->data;
			{
				if (G_TYPE_FROM_INSTANCE ((GObject*) widget) == AWN_TYPE_LABEL) {
					GtkWidget* _tmp1_;
					prefs_applet_setup_label_for_docklet ((_tmp1_ = widget, AWN_IS_LABEL (_tmp1_) ? ((AwnLabel*) _tmp1_) : NULL), w);
				}
			}
		}
	}
}


static void __lambda2__awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self) {
	_lambda2_ (_sender, position, self);
}


static void _lambda3_ (AwnIcon* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	gtk_object_destroy ((GtkObject*) self->priv->docklet);
}


static void __lambda3__awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _lambda4_ (AwnIcon* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	prefs_applet_change_icon_size (self, 32);
}


static void __lambda4__awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _lambda5_ (AwnIcon* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	prefs_applet_change_icon_size (self, 40);
}


static void __lambda5__awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (AwnIcon* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	prefs_applet_change_icon_size (self, 48);
}


static void __lambda6__awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void _lambda7_ (AwnIcon* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	prefs_applet_run_preferences (self, FALSE);
	gtk_object_destroy ((GtkObject*) self->priv->docklet);
}


static void __lambda7__awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static void _lambda8_ (AwnIcon* w, PrefsApplet* self) {
	g_return_if_fail (w != NULL);
	prefs_applet_run_preferences (self, TRUE);
	gtk_object_destroy ((GtkObject*) self->priv->docklet);
}


static void __lambda8__awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	_lambda8_ (_sender, self);
}


void prefs_applet_setup_docklet (PrefsApplet* self, GdkNativeWindow window_id) {
	AwnIcon* icon;
	AwnLabel* label;
	AwnAlignment* align;
	gint icon_size;
	GList* _tmp0_;
	AwnApplet* _tmp2_;
	gint _tmp1_;
	AwnBox* main_box;
	AwnIcon* _tmp3_;
	AwnThemedIcon* icon_loader;
	AwnIconBox* box;
	AwnIcon* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* pixbuf;
	AwnAlignment* _tmp6_;
	AwnLabel* _tmp7_;
	AwnIconBox* _tmp8_;
	AwnIcon* _tmp9_;
	GdkPixbuf* _tmp10_;
	AwnIcon* _tmp11_;
	GdkPixbuf* _tmp12_;
	AwnIcon* _tmp13_;
	GdkPixbuf* _tmp14_;
	AwnLabel* _tmp15_;
	AwnIconBox* _tmp16_;
	AwnIcon* _tmp17_;
	GdkPixbuf* _tmp18_;
	AwnIcon* _tmp19_;
	GdkPixbuf* _tmp20_;
	g_return_if_fail (self != NULL);
	icon = NULL;
	label = NULL;
	align = NULL;
	icon_size = awn_applet_get_size ((AwnApplet*) self);
	self->priv->docklet_icons = (_tmp0_ = NULL, _g_list_free0 (self->priv->docklet_icons), _tmp0_);
	self->priv->docklet = (_tmp2_ = g_object_ref_sink (awn_applet_new ("quick-prefs", "docklet", (g_object_get ((AwnApplet*) self, "panel-id", &_tmp1_, NULL), _tmp1_))), _g_object_unref0 (self->priv->docklet), _tmp2_);
	g_object_set (self->priv->docklet, "quit-on-delete", FALSE, NULL);
	awn_applet_set_behavior ((AwnApplet*) self, AWN_APPLET_DOCKLET_HANDLES_POSITION_CHANGE);
	g_signal_connect_object ((GtkObject*) self->priv->docklet, "destroy", (GCallback) __lambda0__gtk_object_destroy, self, 0);
	g_signal_connect_object (self->priv->docklet, "size-changed", (GCallback) __lambda1__awn_applet_size_changed, self, 0);
	g_signal_connect_object (self->priv->docklet, "position-changed", (GCallback) __lambda2__awn_applet_position_changed, self, 0);
	main_box = g_object_ref_sink ((AwnBox*) awn_box_new (GTK_ORIENTATION_HORIZONTAL));
	awn_box_set_orientation_from_pos_type (main_box, awn_applet_get_pos_type (self->priv->docklet));
	gtk_container_add ((GtkContainer*) self->priv->docklet, (GtkWidget*) main_box);
	icon_loader = (_tmp3_ = awn_applet_simple_get_icon ((AwnAppletSimple*) self), AWN_IS_THEMED_ICON (_tmp3_) ? ((AwnThemedIcon*) _tmp3_) : NULL);
	box = g_object_ref_sink ((AwnIconBox*) awn_icon_box_new_for_applet (self->priv->docklet));
	gtk_container_add ((GtkContainer*) main_box, (GtkWidget*) box);
	icon = (_tmp4_ = prefs_applet_new_unbound_icon (), _g_object_unref0 (icon), _tmp4_);
	g_object_set_data ((GObject*) icon, "icon-name", (void*) "main-icon");
	awn_icon_set_from_pixbuf (icon, _tmp5_ = awn_themed_icon_get_icon_at_size (icon_loader, icon_size, "main-icon"));
	_g_object_unref0 (_tmp5_);
	awn_icon_set_tooltip_text (icon, _ ("Drag to change panel orientation"));
	g_signal_connect_object (icon, "clicked", (GCallback) __lambda3__awn_icon_clicked, self, 0);
	g_signal_connect_object ((GtkWidget*) icon, "drag-begin", (GCallback) _prefs_applet_on_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) icon, "drag-end", (GCallback) _prefs_applet_on_drag_end_gtk_widget_drag_end, self, 0);
	g_signal_connect_object ((GtkWidget*) icon, "drag-failed", (GCallback) _prefs_applet_on_drag_failed_gtk_widget_drag_failed, self, 0);
	gtk_drag_source_set ((GtkWidget*) icon, GDK_BUTTON1_MASK, PREFS_APPLET_targets, G_N_ELEMENTS (PREFS_APPLET_targets), GDK_ACTION_LINK);
	pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1, 1);
	gdk_pixbuf_fill (pixbuf, (guint32) 0);
	gtk_drag_source_set_icon_pixbuf ((GtkWidget*) icon, pixbuf);
	self->priv->docklet_icons = g_list_append (self->priv->docklet_icons, (GtkWidget*) icon);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) icon);
	align = (_tmp6_ = g_object_ref_sink ((AwnAlignment*) awn_alignment_new_for_applet (self->priv->docklet)), _g_object_unref0 (align), _tmp6_);
	label = (_tmp7_ = g_object_ref_sink (awn_label_new ()), _g_object_unref0 (label), _tmp7_);
	gtk_label_set_text ((GtkLabel*) label, _ ("Icon size:"));
	prefs_applet_setup_label_for_docklet (label, self->priv->docklet);
	self->priv->docklet_icons = g_list_append (self->priv->docklet_icons, (GtkWidget*) label);
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) label);
	gtk_box_pack_start ((GtkBox*) main_box, (GtkWidget*) align, TRUE, TRUE, (guint) 6);
	box = (_tmp8_ = g_object_ref_sink ((AwnIconBox*) awn_icon_box_new_for_applet (self->priv->docklet)), _g_object_unref0 (box), _tmp8_);
	gtk_box_pack_start ((GtkBox*) main_box, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
	icon = (_tmp9_ = prefs_applet_new_unbound_icon (), _g_object_unref0 (icon), _tmp9_);
	awn_icon_set_from_pixbuf (icon, _tmp10_ = awn_themed_icon_get_icon_at_size (icon_loader, 32, "dir"));
	_g_object_unref0 (_tmp10_);
	g_signal_connect_object (icon, "clicked", (GCallback) __lambda4__awn_icon_clicked, self, 0);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) icon);
	icon = (_tmp11_ = prefs_applet_new_unbound_icon (), _g_object_unref0 (icon), _tmp11_);
	awn_icon_set_from_pixbuf (icon, _tmp12_ = awn_themed_icon_get_icon_at_size (icon_loader, 40, "dir"));
	_g_object_unref0 (_tmp12_);
	g_signal_connect_object (icon, "clicked", (GCallback) __lambda5__awn_icon_clicked, self, 0);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) icon);
	icon = (_tmp13_ = prefs_applet_new_unbound_icon (), _g_object_unref0 (icon), _tmp13_);
	awn_icon_set_from_pixbuf (icon, _tmp14_ = awn_themed_icon_get_icon_at_size (icon_loader, 48, "dir"));
	_g_object_unref0 (_tmp14_);
	g_signal_connect_object (icon, "clicked", (GCallback) __lambda6__awn_icon_clicked, self, 0);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) icon);
	label = (_tmp15_ = g_object_ref_sink (awn_label_new ()), _g_object_unref0 (label), _tmp15_);
	gtk_box_pack_start ((GtkBox*) main_box, (GtkWidget*) label, TRUE, FALSE, (guint) 0);
	box = (_tmp16_ = g_object_ref_sink ((AwnIconBox*) awn_icon_box_new_for_applet (self->priv->docklet)), _g_object_unref0 (box), _tmp16_);
	gtk_container_add ((GtkContainer*) main_box, (GtkWidget*) box);
	icon = (_tmp17_ = prefs_applet_new_unbound_icon (), _g_object_unref0 (icon), _tmp17_);
	g_object_set_data ((GObject*) icon, "icon-name", (void*) "prefs");
	awn_icon_set_from_pixbuf (icon, _tmp18_ = awn_themed_icon_get_icon_at_size (icon_loader, icon_size, "prefs"));
	_g_object_unref0 (_tmp18_);
	awn_icon_set_tooltip_text (icon, _ ("Dock Preferences"));
	g_signal_connect_object (icon, "clicked", (GCallback) __lambda7__awn_icon_clicked, self, 0);
	self->priv->docklet_icons = g_list_append (self->priv->docklet_icons, (GtkWidget*) icon);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) icon);
	icon = (_tmp19_ = prefs_applet_new_unbound_icon (), _g_object_unref0 (icon), _tmp19_);
	g_object_set_data ((GObject*) icon, "icon-name", (void*) "about");
	awn_icon_set_from_pixbuf (icon, _tmp20_ = awn_themed_icon_get_icon_at_size (icon_loader, icon_size, "about"));
	_g_object_unref0 (_tmp20_);
	awn_icon_set_tooltip_text (icon, _ ("About Awn"));
	g_signal_connect_object (icon, "clicked", (GCallback) __lambda8__awn_icon_clicked, self, 0);
	self->priv->docklet_icons = g_list_append (self->priv->docklet_icons, (GtkWidget*) icon);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) icon);
	gtk_plug_construct ((GtkPlug*) self->priv->docklet, window_id);
	_g_object_unref0 (icon);
	_g_object_unref0 (label);
	_g_object_unref0 (align);
	_g_object_unref0 (main_box);
	_g_object_unref0 (box);
	_g_object_unref0 (pixbuf);
}


static void prefs_applet_change_icon_size (PrefsApplet* self, gint new_size) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		desktop_agnostic_config_client_set_int (self->priv->panel_client, "panel", "size", new_size, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("applet.vala:540: Unable to set panel properties. Error: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void prefs_applet_run_preferences (PrefsApplet* self, gboolean about_only) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		gint argv_size;
		gint argv_length1;
		char** argv;
		argv = (argv_length1 = 0, NULL);
		if (about_only) {
			char** _tmp1_;
			char** _tmp0_ = NULL;
			argv = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("awn-settings"), _tmp0_[1] = g_strdup ("--about"), _tmp0_), argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL), argv_length1 = 2, argv_size = argv_length1, _tmp1_);
		} else {
			char** _tmp3_;
			char** _tmp2_ = NULL;
			argv = (_tmp3_ = (_tmp2_ = g_new0 (char*, 1 + 1), _tmp2_[0] = g_strdup ("awn-settings"), _tmp2_), argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL), argv_length1 = 1, argv_size = argv_length1, _tmp3_);
		}
		gdk_spawn_on_screen (gtk_window_get_screen ((GtkWindow*) self), NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch3_g_error;
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			char* msg;
			char* _tmp4_;
			msg = NULL;
			msg = (_tmp4_ = g_strdup_printf (_ ("Could not open Awn settings: %s"), err->message), _g_free0 (msg), _tmp4_);
			g_warning ("applet.vala:571: %s", msg);
			_g_error_free0 (err);
			_g_free0 (msg);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _dynamic_RemovePanel2 (DBusGProxy* self, gint param1, GError** error) {
	dbus_g_proxy_call (self, "RemovePanel", error, G_TYPE_INT, param1, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void prefs_applet_on_quit_click (PrefsApplet* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		DBusGConnection* con;
		DBusGProxy* awn;
		DBusGProxy* _tmp0_;
		gint _tmp1_;
		con = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch4_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		awn = NULL;
		awn = (_tmp0_ = dbus_g_proxy_new_for_name (con, "org.awnproject.Awn", "/org/awnproject/Awn", "org.awnproject.Awn.App"), _g_object_unref0 (awn), _tmp0_);
		_dynamic_RemovePanel2 (awn, (g_object_get ((AwnApplet*) self, "panel-id", &_tmp1_, NULL), _tmp1_), &_inner_error_);
		if (_inner_error_ != NULL) {
			_dbus_g_connection_unref0 (con);
			_g_object_unref0 (awn);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch4_dbus_gerror;
			}
			goto __finally4;
		}
		_dbus_g_connection_unref0 (con);
		_g_object_unref0 (awn);
	}
	goto __finally4;
	__catch4_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("applet.vala:591: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void prefs_applet_on_context_menu_popup (PrefsApplet* self, GdkEventButton* evt) {
	g_return_if_fail (self != NULL);
	gtk_menu_popup (self->priv->ctx_menu, NULL, NULL, NULL, NULL, (*evt).button, (*evt).time);
}


static void _prefs_applet_on_window_opened_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self) {
	prefs_applet_on_window_opened (self, window);
}


static void _prefs_applet_on_window_closed_wnck_screen_window_closed (WnckScreen* _sender, WnckWindow* window, gpointer self) {
	prefs_applet_on_window_closed (self, window);
}


static void _prefs_applet_on_active_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self) {
	prefs_applet_on_active_changed (self, previous_window);
}


static GObject * prefs_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	PrefsApplet * self;
	parent_class = G_OBJECT_CLASS (prefs_applet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PREFS_APPLET (obj);
	{
		WnckScreen* wnck_screen;
		GList* _tmp0_;
		wnck_screen = wnck_screen_get_default ();
		wnck_set_client_type (WNCK_CLIENT_TYPE_PAGER);
		g_signal_connect_object (wnck_screen, "window-opened", (GCallback) _prefs_applet_on_window_opened_wnck_screen_window_opened, self, 0);
		g_signal_connect_object (wnck_screen, "window-closed", (GCallback) _prefs_applet_on_window_closed_wnck_screen_window_closed, self, 0);
		g_signal_connect_object (wnck_screen, "active-window-changed", (GCallback) _prefs_applet_on_active_changed_wnck_screen_active_window_changed, self, 0);
		self->priv->windows = (_tmp0_ = NULL, _g_list_free0 (self->priv->windows), _tmp0_);
	}
	return obj;
}


static void prefs_applet_class_init (PrefsAppletClass * klass) {
	prefs_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PrefsAppletPrivate));
	G_OBJECT_CLASS (klass)->constructed = prefs_applet_real_constructed;
	G_OBJECT_CLASS (klass)->constructor = prefs_applet_constructor;
	G_OBJECT_CLASS (klass)->finalize = prefs_applet_finalize;
}


static void prefs_applet_instance_init (PrefsApplet * self) {
	self->priv = PREFS_APPLET_GET_PRIVATE (self);
	self->priv->panel_client = NULL;
	self->priv->ctx_menu = NULL;
	self->priv->timer_id = (guint) 0;
	self->priv->in_drag = FALSE;
	self->priv->autohide_cookie = (guint) 0;
}


static void prefs_applet_finalize (GObject* obj) {
	PrefsApplet * self;
	self = PREFS_APPLET (obj);
	_g_object_unref0 (self->priv->ctx_menu);
	_g_list_free0 (self->priv->windows);
	_g_object_unref0 (self->priv->docklet);
	_g_list_free0 (self->priv->docklet_icons);
	G_OBJECT_CLASS (prefs_applet_parent_class)->finalize (obj);
}


GType prefs_applet_get_type (void) {
	static GType prefs_applet_type_id = 0;
	if (prefs_applet_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (PrefsAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prefs_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrefsApplet), 0, (GInstanceInitFunc) prefs_applet_instance_init, NULL };
		prefs_applet_type_id = g_type_register_static (AWN_TYPE_APPLET_SIMPLE, "PrefsApplet", &g_define_type_info, 0);
	}
	return prefs_applet_type_id;
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result;
	AwnApplet* applet;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	textdomain (GETTEXT_PACKAGE);
	applet = (AwnApplet*) g_object_ref_sink (prefs_applet_new (canonical_name, uid, panel_id));
	wnck_screen_force_update (wnck_screen_get_default ());
	result = applet;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




