/*
 *  Aquamarine the KDE window decorator
 *
 *  Copyright (c) 2006 Dennis Kasprzyk <onestone@beryl-project.org>
 *  Copyright (c) 2006 Volker Krause <vkrause@kde.org>
 *  Copyright (c) 2006 David Reveman <davidr@novell.com>
 *
 *  Uses code of:
 *      KWin window manager (www.kde.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xrender.h>

#include <fixx11h.h>

#include <dcopclient.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kglobal.h>
#include <klocale.h>

#include <stdlib.h>

#include "decorator.h"
#include "utils.h"

static const KCmdLineOptions options[] = {
    {"replace", "Replace existing window decorator", 0},
    {"deco <deco>", "Decoration", 0},
    KCmdLineLastOption
};


int
main (int argc, char **argv)
{
    char *display = 0;
    Display *dpy = XOpenDisplay (display);
	if (!dpy)
	{
		qWarning ("cannot connect to X server ");
		exit (1);
	}
    int screen = DefaultScreen (dpy);

    KCmdLineArgs::init (argc, argv, "aquamarine", I18N_NOOP ("Aquamarine"),
                        I18N_NOOP ("KDE Window Decorator for Beryl"), VERSION);
    KCmdLineArgs::addCmdLineOptions (options);

    Atom wm_name = XInternAtom (dpy, "_NET_WM_NAME", false);
    char buf[128];
    sprintf(buf,"WM_S%d",screen);
    Atom wm_sn = XInternAtom (dpy, buf, false);
    Atom manager = XInternAtom (dpy, "MANAGER", false);
    Atom utf8_string = XInternAtom (dpy, "UTF8_STRING", false);

    Bool restart = FALSE;
    int rv = 1;
    do
    {
		Aquamarine::trapXError();

        Bool wmRunning = false;
        do
        {
            XEvent xev;
            WId wm = XGetSelectionOwner(dpy,wm_sn);
            if (wm != None)
            {
                Atom actual;
                int result, format;
                unsigned long n, left;
                unsigned char * data = NULL;

                result = XGetWindowProperty (dpy, wm, wm_name,
                                    0L, 2L, FALSE, utf8_string, &actual, &format,
                                    &n, &left, &data);

                if (result == Success && n && data)
                {
                    printf("Window Manager \"%s\"\n",data);
                    sprintf(buf,"%s",data);
                    if (strcmp(buf,"beryl") == 0)
                    {
                        wmRunning = true;
                    }
                }

				if (data)
					XFree(data);

                if (!wmRunning)
                {
                    XSelectInput(dpy, wm, StructureNotifyMask);
                    printf("Found not compatible window manager. Waiting...\n");
                    do
                    {
                        XWindowEvent(dpy, wm, StructureNotifyMask, &xev);
                    } while (xev.type != DestroyNotify);
                }
            }
            else
            {
                printf("No window manager. Waiting...\n");
                XSelectInput(dpy, RootWindow(dpy, screen), StructureNotifyMask);
                Bool foundWM = false;
                do
                {
                    XNextEvent(dpy, &xev);
                    if (xev.type == ClientMessage &&
                        xev.xclient.message_type == manager &&
                        (Atom)xev.xclient.data.l[1] == wm_sn)
                    {
                        printf("New Window Manager\n");
                        foundWM = true;
                    }
                } while (!foundWM);
            }
			Aquamarine::popXError(dpy);

        } while (!wmRunning);

        Aquamarine::Decorator *app = new Aquamarine::Decorator();

        if (app->isReady ()) {
            rv = app->exec ();
            if (rv == 0)
                restart = app->restart();
        }
        delete app;
        delete KGlobal::_locale; // HACK to fix crash during KApplication restart
        KGlobal::_locale = 0;

    } while (restart);
    return rv;
}
