/*
 *  KControl module for Beryl and Aquamarine
 *
 *  Copyright (c) 2006 Dennis Kasprzyk <onestone@beryl-project.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "aqsettings.h"

#include <qtabwidget.h>
#include <qlayout.h>

#include <kapplication.h>
#include <kaboutdata.h>
#include <kconfig.h>
#include <kdialog.h>
#include <kdebug.h>
#include <dcopclient.h>
#include <kgenericfactory.h>

#include "main.h"
#include "aquamarine_ui.h"

typedef KGenericFactory<KCMBeryl, QWidget> KCMBerylFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_beryl, KCMBerylFactory("kcmberyl"))

KCMBeryl::~KCMBeryl( )
{
}

KCMBeryl::KCMBeryl(QWidget *parent, const char *name, const QStringList &)
    : KCModule(KCMBerylFactory::instance(), parent, name)
{
    KAboutData *about =
    new KAboutData(I18N_NOOP("kcmberyl"), I18N_NOOP("KDE Beryl/Aquamarine Control Module"),
                  0, 0, KAboutData::License_GPL,
                  I18N_NOOP("(c) 2006 Dennis Kasprzyk"));

    about->addAuthor("Dennis Kasprzyk", 0, "onestone@beryl-project.org");

    KGlobal::locale()->insertCatalogue("kdelibs");
    KGlobal::locale()->insertCatalogue("aquamarine");
    KGlobal::locale()->setActiveCatalogue("aquamarine");

    setAboutData( about );

	m_tabs = new QTabWidget( this );


	AquamarineWidget *aq = new AquamarineWidget(m_tabs, "Aquamarine");
	m_tabs->addTab(aq, "Aquamarine");

	addConfig(AqSettings::self(),aq);

	QVBoxLayout *top = new QVBoxLayout( this, 0, KDialog::spacingHint() );
	top->addWidget( m_tabs );

	load();
}


void KCMBeryl::load()
{
	KCModule::load();
}

void KCMBeryl::save()
{
	KCModule::save();
	DCOPClient *client = kapp->dcopClient();
	if (!client->isAttached())
		client->attach();
	client->send("kwin", "KWinInterface", "reconfigure()", "");
}

void KCMBeryl::defaults()
{
	KCModule::defaults();
}

