SET(AQSIS_FLEXBISON_SEARCHPATH)
# If on win32, and the win32libs SVN module has been located, we can
# use the one in there.
IF(WIN32 AND AQSIS_WIN32LIBS)
	SET(AQSIS_FLEXBISON_SEARCHPATH ${AQSIS_WIN32LIBS}/GnuWin32/bin)
ENDIF(WIN32 AND AQSIS_WIN32LIBS)

# Look for flex
FIND_PROGRAM(AQSIS_FLEX_EXECUTABLE
	flex
	PATHS ${AQSIS_FLEXBISON_SEARCHPATH}
	DOC "Location of the flex executable"
)
STRING(COMPARE NOTEQUAL ${AQSIS_FLEX_EXECUTABLE} "AQSIS_FLEX_EXECUTABLE-NOTFOUND" AQSIS_FLEX_EXECUTABLE_FOUND)

# Look for bison
FIND_PROGRAM(AQSIS_BISON_EXECUTABLE
	bison
	PATHS ${AQSIS_FLEXBISON_SEARCHPATH}
	DOC "Location of the bison executable"
)
STRING(COMPARE NOTEQUAL ${AQSIS_BISON_EXECUTABLE} "AQSIS_BISON_EXECUTABLE-NOTFOUND" AQSIS_BISON_EXECUTABLE_FOUND)

IF(AQSIS_BISON_EXECUTABLE_FOUND AND WIN32)
	GET_FILENAME_COMPONENT(AQSIS_BISON_LOCATION "${AQSIS_BISON_EXECUTABLE}" PATH)
	FILE(TO_NATIVE_PATH "${AQSIS_BISON_LOCATION}" BISON_PATH_WINDOWS)
	IF(MSVC_IDE)
		SET(CMAKE_MSVCIDE_RUN_PATH "${CMAKE_MSVCIDE_RUN_PATH};${BISON_PATH_WINDOWS}"
			CACHE STATIC "MSVC IDE Run path" FORCE)
	ENDIF(MSVC_IDE)
	# Also need the custom unistd.h for the win32libs version of flex.
	IF(AQSIS_WIN32LIBS)
		INCLUDE_DIRECTORIES(${AQSIS_WIN32LIBS}/GnuWin32/include)
	ENDIF(AQSIS_WIN32LIBS)
ENDIF(AQSIS_BISON_EXECUTABLE_FOUND AND WIN32)
