/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2001-2003 by Prakash Dayal <prakash@comp-phys.org>,
*                            Matthias Troyer <troyer@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: blitz.h,v 1.10 2003/09/05 08:12:38 troyer Exp $ */

#ifndef IETL_INTERFACE_BLITZ_H
#define IETL_INTERFACE_BLITZ_H

#include <ietl/complex.h>
#include <blitz/array.h>
#include <blitz/vecglobs.h>
#include <ietl/traits.h>


namespace ietl {
  
  template < class Cont, class Gen> 
    void generate(Cont& c, Gen& gen) {
    std::generate(c.begin(),c.end(),gen);
  }

  template <class T, int D>
  typename number_traits<T>::magnitude_type two_norm(const blitz::Array<T,D>& v) {
    return std::sqrt(ietl::real(dot(v,v)));
  }

  template <class T, int D>
  T dot(const blitz::Array<T,D>& x, const blitz::Array<T,D>& y) {
    return blitz::sum(x*y);
  }

  template <class T, int D>
  T dot(const blitz::Array<std::complex<T>,D>& x, const blitz::Array<std::complex<T>,D>& y) {
    
    return blitz::sum(blitz::conj(x)*y);
  }

  template <class T, int D>
  void copy(const blitz::Array<T,D>& x, blitz::Array<T,D>& y) {
    y=x;
    y.makeUnique();
  }
}

namespace std {  
  template <class T, int D>
  void swap(blitz::Array<T,D>& x, blitz::Array<T,D>& y) {
    blitz::cycleArrays(x,y);
  }

}

#endif // IETL_INTERFACE_BLITZ_H

