
window.addEventListener("load", aios_init, false);
window.addEventListener("unload", aios_persistSelTab, false);


var aios_inSidebar = (top.document.getElementById('sidebar-box')) ? true : false;
var aios_inTab = (aios_WIN.aiosLastSelTab) ? true : false;

// Listener fr automatische Aktualisierung hinzufgen u. entfernen
if(aios_inSidebar) {
	window.addEventListener("load", function(e) {
		top.gBrowser.addProgressListener(aiosProgListener, Components.interfaces.nsIWebProgress.NOTIFY_STATE_DOCUMENT);
	}, false);

	window.addEventListener("unload",function(e) {
		top.gBrowser.removeProgressListener(aiosProgListener);
	}, false);
}


function aios_init() {
    try {
        enable_layout = aios_gPrefBranch.getBoolPref("pi.layout");
        enable_layoutall = aios_gPrefBranch.getBoolPref("pi.layoutall");
        if((enable_layout && aios_inSidebar) || enable_layoutall) aios_sidebarLayout();
    }
	catch(e) { }
	
	if(aios_platform == "Darwin") {
		document.getElementById('viewGroup').setAttribute("showLabel", true);
	}
}


function aios_sidebarLayout() {
    document.getElementById('main-window').setAttribute('aiosLayout', true); 
    
    var radioChilds = document.getElementById('viewGroup').childNodes;
    for(var i = 0; i < radioChilds.length; i++) {
        if(radioChilds[i].tagName == "radio") radioChilds[i].setAttribute('tooltiptext', radioChilds[i].label);
    }
}


// automatische Aktualisierung => Aufruf durch aiosProgListener (_common.js)
function aios_onLocationChange() {
	if(aios_inSidebar) {
		aios_persistSelTab();
		location.reload();
	}
}


function aios_onStateChange() {
  aios_onLocationChange();
}


// letzten selektierten Tab merken
function aios_persistSelTab() {
	document.getElementById('main-window').setAttribute("seltab", document.getElementById('viewGroup').selectedIndex);
}




/* Called when PageInfo window is loaded.  Arguments are:
 *  window.arguments[0] - (optional) an object consisting of
 *                         - doc: (optional) document to use for source. if not provided,
 *                                the calling window's document will be used
 *                         - initialTab: (optional) id of the inital tab to display
 */
function onLoadPageInfo()
{
  gBundle = document.getElementById("pageinfobundle");
  gStrings.unknown = gBundle.getString("unknown");
  gStrings.notSet = gBundle.getString("notset");
  gStrings.mediaImg = gBundle.getString("mediaImg");
  gStrings.mediaBGImg = gBundle.getString("mediaBGImg");
  gStrings.mediaObject = gBundle.getString("mediaObject");
  gStrings.mediaEmbed = gBundle.getString("mediaEmbed");
  gStrings.mediaLink = gBundle.getString("mediaLink");
  gStrings.mediaInput = gBundle.getString("mediaInput");
  
    // mod by eXXile
	if(aios_inSidebar){
		var aios_sidebar = top.document.getElementById('sidebar-box');
		var aios_window = document.getElementById('main-window');

		gDocument = aios_WIN.content.document;
		gWindow = aios_WIN.content.window;
	}
	// Original-FF-Teil
    else {
        if ("arguments" in window && window.arguments.length >= 1 && window.arguments[0] && window.arguments[0].doc) {
          gDocument = window.arguments[0].doc;
          gWindow = gDocument.defaultView;
        }
        else if(window.opener) { //mod by eXXile
          if ("gBrowser" in window.opener)
            gWindow = window.opener.gBrowser.contentWindow;
          else
            gWindow = window.opener.frames[0];
            
          gDocument = gWindow.document;
        }
        
        // Page Info im Tab => content des zuletzt aktiven Tabs => gespeichert durch aios_addTab(aUrl) in _common.js
		else if(aios_inTab) {
			gDocument = aios_WIN.aiosLastSelTab.document;
		 	gWindow = aios_WIN.aiosLastSelTab.window;
		 	document.title = gBundle.getString("pageInfo.page.title");
		}
    }
   
   

  // init media view
  var imageTree = document.getElementById("imagetree");
  imageTree.view = gImageView;

  // build the content
  loadPageInfo();

  /* Select the requested tab, if the name is specified */
  var initialTab = "general";
  if ("arguments" in window && window.arguments.length >= 1 && window.arguments[0] && window.arguments[0].initialTab) {
    initialTab = window.arguments[0].initialTab;
  }
  // zuletzt aktiven Tab selektieren - mod by eXXile
  else {
    if(document.getElementById('main-window').getAttribute("seltab")) {
			var initialTabNo = document.getElementById('main-window').getAttribute("seltab");
			var initialTabId = document.getElementById('viewGroup').childNodes[initialTabNo].id;
			initialTab = initialTabId.substring(0, initialTabId.length - 3);
			
		}
  }
  // endmod by eXXile
  
  var radioGroup = document.getElementById("viewGroup");
  initialTab = document.getElementById(initialTab + "Tab") || document.getElementById("generalTab");
  radioGroup.selectedItem = initialTab;
  radioGroup.selectedItem.doCommand();
  window.setTimeout("eval(document.getElementById('viewGroup').selectedItem.getAttribute('oncommand'));", 50);  // mod by eXXile
  radioGroup.focus();
}



var security = {
  // Display the server certificate (static)
  viewCert : function () {
    var cert = security._cert;
    //viewCertHelper(window, cert);
    
    // mod by eXXile
    if(aios_inSidebar) viewCertHelper(aios_WIN.content.window, cert);
    else if(aios_inTab) viewCertHelper(aios_WIN.aiosLastSelTab.window, cert);
    else viewCertHelper(window, cert);	
    // endmod by eXXile
  },

  _getSecurityInfo : function() {
    const nsIX509Cert = Components.interfaces.nsIX509Cert;
    const nsIX509CertDB = Components.interfaces.nsIX509CertDB;
    const nsX509CertDB = "@mozilla.org/security/x509certdb;1";
    const nsISSLStatusProvider = Components.interfaces.nsISSLStatusProvider;
    const nsISSLStatus = Components.interfaces.nsISSLStatus;

    // We don't have separate info for a frame, return null until further notice
    // (see bug 138479)
    if (gWindow != gWindow.top)
      return null;

    var hName = null;
    try {
      hName = gWindow.location.host;
    }
    catch (exception) { }

    var ui = security._getSecurityUI();
    var status = null;
    var sp = null;
    var isBroken = false;
    if (ui) {
      isBroken = (ui.state == Components.interfaces.nsIWebProgressListener.STATE_IS_BROKEN);
      sp = ui.QueryInterface(nsISSLStatusProvider);
      if (sp)
        status = sp.SSLStatus;
    }
    if (status) {
      status = status.QueryInterface(nsISSLStatus);
    }
    if (status) {
      var cert = status.serverCert;
      var issuerName;

      issuerName = this.mapIssuerOrganization(cert.issuerOrganization);
      if (!issuerName) issuerName = cert.issuerName;

      return {
        hostName : hName,
        cAName : issuerName,
        encryptionAlgorithm : status.cipherName,
        encryptionStrength : status.secretKeyLength,
        isBroken : isBroken,
        cert : cert,
        fullLocation : gWindow.location
      };
    } else {
      return {
        hostName : hName,
        cAName : "",
        encryptionAlgorithm : "",
        encryptionStrength : 0,
        isBroken : isBroken,
        cert : null,
        fullLocation : gWindow.location        
      };
    }
  },

  // Find the secureBrowserUI object (if present)
  _getSecurityUI : function() {
    // mod by eXXile
	if(aios_inSidebar) {
	    if ("gBrowser" in top)
	    return top.gBrowser.securityUI;
	}
	else if(aios_inTab) {
	    return aios_WIN.gBrowser.securityUI;
	}
	// Original-FF-Teil
	else {
	    if ("gBrowser" in window.opener)
            return window.opener.gBrowser.securityUI;
        return null;
    }
  },

  // Interface for mapping a certificate issuer organization to
  // the value to be displayed.
  // Bug 82017 - this implementation should be moved to pipnss C++ code
  mapIssuerOrganization: function(name) {
    if (!name) return null;

    if (name == "RSA Data Security, Inc.") return "Verisign, Inc.";

    // No mapping required
    return name;
  },
  
  /**
   * Open the cookie manager window
   */
  viewCookies : function()
  {
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                       .getService(Components.interfaces.nsIWindowMediator);
    var win = wm.getMostRecentWindow("Browser:Cookies");
    if (win)
      win.focus();
    else
      window.openDialog("chrome://browser/content/preferences/cookies.xul",
                        "Browser:Cookies", "");
  },
  
  /**
   * Open the login manager window
   */
  viewPasswords : function()
  {
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                       .getService(Components.interfaces.nsIWindowMediator);
    var win = wm.getMostRecentWindow("Toolkit:PasswordManager");
    if (win)
      win.focus();
    else
      window.openDialog("chrome://passwordmgr/content/passwordManager.xul",
                        "Toolkit:PasswordManager", "");
  },

  _cert : null
};