
window.addEventListener("unload", aios_persistSelTab, false);

// Listener fr automatische Aktualisierung hinzufgen u. entfernen
if(top.document.getElementById('sidebar-box')) {

	window.addEventListener("load", function(e) {
		top.gBrowser.addProgressListener(aiosProgListener, Components.interfaces.nsIWebProgress.NOTIFY_STATE_DOCUMENT);
	}, false);

	window.addEventListener("unload",function(e) {
		top.gBrowser.removeProgressListener(aiosProgListener);
	}, false);
}


// automatische Aktualisierung => Aufruf durch aiosProgListener (_common.js)
function aios_onLocationChange() {
	if(aios_getBoolean('autoReload-mitem', 'checked')) {
		aios_persistSelTab();
		location.reload();
	}
}


function aios_onStateChange() {
  aios_onLocationChange();
}


// letzten selektierten Tab merken
function aios_persistSelTab() {
	document.getElementById('main-window').setAttribute("seltab", document.getElementById('tabbox').selectedIndex);
}


// Tab vor und zurck blttern
function aios_goTab(mode) {
	var tabControl = document.getElementById("tabbox");
	var tabCount = document.getElementById("tabs").childNodes.length;
	var tab = tabControl.selectedIndex;

	switch(mode) {
		case "back":			if(tab > 0) tabControl.selectedIndex = tab - 1; break;
		case "forward":		if(tab < tabCount) tabControl.selectedIndex = tab + 1; break;
	}

	tabControl.selectedTab.focus();
}


// Tabs als menuitems in ein popup packen
function aios_getTabs(aPopup) {
	if(aPopup.childNodes.length != 0) return false;

	var tab, newItem;
	var tabControl = document.getElementById("tabbox");
	var tabCount = document.getElementById("tabs").childNodes.length;

	for(var i = 0; i < tabCount; i++) {
		tab = document.getElementById("tabs").childNodes[i];

		newItem = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "menuitem");
		newItem.setAttribute('type', 'radio');
		newItem.setAttribute('label', tab.getAttribute('label'));
		newItem.setAttribute('oncommand', 'document.getElementById("tabbox").selectedIndex=' + i + '; event.stopPropagation();');

		if(tabControl.selectedIndex == i) newItem.setAttribute('checked', true);

		aPopup.appendChild(newItem);
	}

	return true;
}


function onLoadPageInfo() {
	theBundle = document.getElementById("pageinfobundle");
	gStrings.unknown = theBundle.getString("unknown");
	gStrings.notSet = theBundle.getString("notset");
	gStrings.emptyString = theBundle.getString("emptystring");
	gStrings.noExpiration = theBundle.getString("generalNoExpiration");
	gStrings.linkAnchor = theBundle.getString("linkAnchor");
	gStrings.linkArea = theBundle.getString("linkArea");
	gStrings.linkSubmit = theBundle.getString("linkSubmit");
	gStrings.linkSubmission = theBundle.getString("linkSubmission");
	gStrings.linkRel = theBundle.getString("linkRel");
	gStrings.linkStylesheet = theBundle.getString("linkStylesheet");
	gStrings.linkRev = theBundle.getString("linkRev");
	gStrings.linkX = theBundle.getString("linkX");
	gStrings.mediaImg = theBundle.getString("mediaImg");
	gStrings.mediaBGImg = theBundle.getString("mediaBGImg");
	gStrings.mediaApplet = theBundle.getString("mediaApplet");
	gStrings.mediaObject = theBundle.getString("mediaObject");
	gStrings.mediaEmbed = theBundle.getString("mediaEmbed");
	gStrings.mediaLink = theBundle.getString("mediaLink");
	gStrings.mediaInput = theBundle.getString("mediaInput");

	var docTitle = "";

	// mod by eXXile
	if(top.document.getElementById('sidebar-box')){
		var aios_sidebar = top.document.getElementById('sidebar-box');
		var aios_window = document.getElementById('main-window');

		theDocument = aios_WIN.content.document;
		theWindow = aios_WIN.content.window;
		docTitle = theBundle.getString("pageInfo.title");

		aios_window.setAttribute('class', 'inSidebar');
		document.getElementById('commandBar').hidden = false;
	}
	else {
		// Original-FF-Teil
		if("arguments" in window && window.arguments.length >= 1 && window.arguments[0] && window.arguments[0].doc) {
		   theWindow = null;
		   theDocument = window.arguments[0].doc;
		   docTitle = theBundle.getString("frameInfo.title");
		 }
		else if(window.opener) {
			if("gBrowser" in window.opener) theWindow = window.opener.gBrowser.contentWindow;
			 else theWindow = window.opener.frames[0];

			 theDocument = theWindow.document;
			 docTitle = theBundle.getString("pageInfo.title");
		}
		// ENDE - Original-FF-Teil

		// Page Info im Tab => content des zuletzt aktiven Tabs => gespeichert durch aios_addTab(aUrl) in _common.js
		else if(aios_WIN.aiosLastSelTab) {
			theDocument = aios_WIN.aiosLastSelTab.document;
		  docTitle = theBundle.getString("pageInfo.title");
		 	theWindow = aios_WIN.aiosLastSelTab.window;
		}
	}

	if(!theDocument) return false;
	// endmod by eXXile

	document.title = docTitle;

	document.getElementById("main-window").setAttribute("relatedUrl", theDocument.location.toString());

	// do the easy stuff first
	makeGeneralTab();

	// and then the hard stuff
	makeTabs(theDocument, theWindow);

	/* Call registered overlay init functions */
	for (x in onLoadRegistry)
	{
		 onLoadRegistry[x]();
	}

	/* Select the requested tab, if the name is specified */
	var tabControl = document.getElementById("tabbox");
	if ("arguments" in window && window.arguments.length >= 1 && window.arguments[0] && window.arguments[0].initialTab) {
		 var tab = document.getElementById(window.arguments[0].initialTab);

		 if (tab) {
		   tabControl.selectedTab = tab;
		 }
	}
	// zuletzt aktiven Tab selektieren - mod by eXXile
	else {
		if(document.getElementById('main-window').getAttribute("seltab")) {
			tabControl.selectedIndex = document.getElementById('main-window').getAttribute("seltab");
		}
	}
	// endmod by eXXile

	tabControl.selectedTab.focus();

	return true // added by eXXile
}