
var initialised = false;

var fx_mainWindow, fx_browser, fx_sidebar, fx_sidebarBox, fx_sidebarSplitter, fx_sidebarMenu, fx_maximizedWindow;
var aios_toggleBox, aios_toggleBar, aios_toggleSwitchItem, aios_toggleToolbarItem, aios_toolbar, aios_toolbox, aiostbx_left_toolbox;
var elem_switch, elem_tbb, elem_key, elem_close;


// Sidebar nur zusammenklappen statt schlieen
var aios_collapseSidebar = aios_gPrefBranch.getBoolPref('collapse');
if(aios_collapseSidebar && aios_allowCollapseSidebar()) aios_enableCollapsingSidebar();

	

function aios_getObjects() {
	try {
		fx_mainWindow = document.getElementById('main-window');
		fx_browser = document.getElementById('browser');
		fx_sidebar = document.getElementById('sidebar');
		fx_sidebarBox = document.getElementById('sidebar-box');
		fx_sidebarSplitter = document.getElementById('sidebar-splitter');
		fx_sidebarMenu = document.getElementById('viewSidebarMenu');

		aios_toggleBox = document.getElementById('aios-toggle-toolbox');
		aios_toggleBar = document.getElementById('aios-toggle-toolbar');

		// broadcaster in aios.xul mit gespeichertem Wunsch-Toolbar-Zustand
		// 	=> gespeichert durch onViewToolbarCommand() in tbx.js
		aios_toggleSwitchItem = document.getElementById('aios-viewTogglebar');
		aios_toggleToolbarItem = document.getElementById('aios-viewToolbar');

		aios_toolbar = document.getElementById('aios-toolbar');
		aios_toolbox = aios_toolbar.parentNode;
		aiostbx_left_toolbox = document.getElementById('aiostbx-left-toolbox');

		elem_switch = document.getElementById('aios-toggle-button');
		elem_tbb = document.getElementById('sidebars-togglebutton');
		elem_key = document.getElementById('aiosKey_sidebar');
		elem_close = document.getElementById('sidebar-close-button');
	}
	catch(e) { }
}


var aiosSBListener = {
	QueryInterface: function(aIID) {
		if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
				aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
				aIID.equals(Components.interfaces.nsISupports))
			return this;
			throw Components.results.NS_NOINTERFACE;
		},

	onStateChange: function(aProgress, aRequest, aFlag, aStatus) {

		if(document.getElementById('aiosLoader')) {
			if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP) {
	  		document.getElementById('aiosLoader').setAttribute('hidden', true);
			}

			if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_START) {
				document.getElementById('aiosLoader').setAttribute('hidden', false);
			}
		}

		return 0;
	},

	onProgressChange: function(webProgress, request, curSelfProgress, maxSelfProgress, curTotalProgress, maxTotalProgress) {
		return 0;
	},
	onLocationChange: function(aProgress, aRequest, aURI) { return 0; },
	onStatusChange: function(aProgress, aRequest, aStatus, aMessage ) { return 0; },
	onSecurityChange: function() { return 0; },
	onLinkIconAvailable: function() { return 0; }
}


/*
	Initialisierung
		=> Aufruf durch das onload-Event in aios.xul
*/
function aios_initSidebar() {
	aios_getObjects();
	
	// behebt den Keine-Bookmarks-in-neuem-Fenster-Bug (siehe aios_BrowserStartup)
	//setTimeout(delayedStartup, 0);
	
	// beim ersten Start wird die Icongre an die der Nav-Toolbar angepat
	if(!aios_getBoolean(fx_sidebarBox, 'aiosInit')) {
		fx_sidebarBox.setAttribute('aiosInit', true);
		document.persist(fx_sidebarBox.id, 'aiosInit');

		if(aios_toolbar) aios_toolbar.setAttribute('iconsize', document.getElementById('nav-bar').getAttribute('iconsize'));
	}
	
	//if(aios_appVersion.indexOf("3.") != -1) aios_addCSS("chrome://aios/skin/aios_fx3.css");
	if(aios_appVersion.indexOf("3.") != -1) {
		fx_mainWindow.setAttribute('aiosFxV', 3);
		document.persist(fx_mainWindow.id, 'aiosFxV');
	}
	
	// Sidebar li. oder re.
	// 	=> Aufruf hier nur ntig wg. evtl. Umschaltung zwischen LTR- und RTL-Umschaltung
	aios_setSidebarOrient();
	
	// legt commands (Ziele) fr Manager und Fenster lt. Einstellungen fest
	window.setTimeout("aios_setTargets()", 50);

	// modifiziert alle Sidebar-Tastenkombinationen
	aios_modKeys();

	// Autohide-Feature initialisieren
	aios_initAutohide();
	
	
	// Sidebar nur zusammenklappen statt schlieen
	var aios_collapseSidebar = aios_gPrefBranch.getBoolPref('collapse');
	if(aios_collapseSidebar && aios_allowCollapseSidebar()) {
		
		/*
			der Aufruf von aios_enableCollapsingSidebar() wre hier zeitlich (onLoad) zu spt, 
			da Original-Funktionen zur Laufzeit gendert werden mssen
			
			die anderen folgenden Anpassungen knnen dagegen erst hier erfolgen, 
			weil die Elemente erst jetzt sicher angesprochen werden knnen
		aios_enableCollapsingSidebar();*/
		
		// in jedem Fall das Hidden-Attribut zurcksetzen
		document.getElementById('sidebar-box').setAttribute('hidden', false);
		
		// wenn die Sidebar beim Start nicht geffnet sein soll
		if(!aios_getBoolean(document.getElementById('main-window'), 'aiosOpen')) document.getElementById('sidebar-box').setAttribute('collapsed', true);
	
		// sonst ist nach Deaktivieren/Aktivieren die Sidebar sichtbar aber leer
		var lp = document.getElementById('sidebar-box').getAttribute("aiosLastPanel");
		if(aios_getBoolean(document.getElementById('main-window'), 'aiosOpen') && lp != "") {
			toggleSidebar(lp, true);
			document.getElementById('sidebar-splitter').hidden = false;
			document.getElementById('sidebar-splitter').collapsed = false;
			document.getElementById('sidebar-splitter').setAttribute('state', 'open');
		}
	}
	

	// wenn es keine zuletzt geffnete Sidebar gibt oder diese nicht mehr existiert, dann nimm die Bookmarks
	var lp = fx_sidebarBox.getAttribute("aiosLastPanel");
	if(!lp || (lp && !document.getElementById(lp))) {
		fx_sidebarBox.setAttribute("aiosLastPanel", "viewBookmarksSidebar");
		document.persist(fx_sidebarBox.id, "aiosLastPanel");
	}
	
	// Sidebar, Toolbar u. Switch beim Start gem. Einstellungen
	try {
		var sidebarInit = aios_gPrefBranch.getCharPref('gen.init');
		var toolbarInit = aios_gPrefBranch.getIntPref('gen.toolbar.init');
		var switchInit = aios_gPrefBranch.getIntPref('gen.switch.init');

		// Sidebar beim Start ffnen
		if(sidebarInit == "open") toggleSidebar(fx_sidebarBox.getAttribute('aiosLastPanel'), true);

		// Sidebar beim Start schlieen
		if(sidebarInit == "close" && !aios_isSidebarHidden()) {
			toggleSidebar();
			if(aios_collapseSidebar && aios_allowCollapseSidebar())
			  document.getElementById('sidebar-box').setAttribute('collapsed', true);
		}

		// bestimmte Sidebar beim Start ffnen
		if(sidebarInit != "rem" && sidebarInit != "open" && sidebarInit != "close") {
			if(document.getElementById(sidebarInit)) toggleSidebar(sidebarInit, true);
		}

		if(toolbarInit != 2) aios_toolbar.setAttribute('collapsed', !toolbarInit);
		if(switchInit != 2) aios_toggleBox.setAttribute('hidden', !switchInit);
	}
	catch(e) { }

	// bei Doppelklick die Standardgrsse der Sidebar einstellen
	var fx_sidebarheader = document.getElementsByTagName('sidebarheader')[0];
	fx_sidebarheader.addEventListener("dblclick", function(e) { aios_setSidebarWidth(e); }, false);

	// Sidebars-Men berwachen - ntig fr den Fall, dass ein erster Aufruf durch das View-Men erfolgt
	fx_sidebarMenu.addEventListener('popupshowing', aios_modSidebarMenu, false);

	// Kontext-Men berwachen
	document.getElementById('contentAreaContextMenu').addEventListener('popupshowing', aios_modFFContextMenu, false);

	// Ansicht-Men berwachen
	document.getElementById('menu_viewPopup').addEventListener('popupshowing', aios_modFFViewMenu, false);

	// Tools-Men berwachen
	document.getElementById('menu_ToolsPopup').addEventListener('popupshowing', aios_modFFToolsMenu, false);

	// Sidebar-Ladezustand berwachen
	/*document.getElementById('sidebar').addProgressListener(aiosSBListener, Components.interfaces.nsIWebProgress.NOTIFY_STATE_DOCUMENT);*/

	// Breite der Toolbox lschen (Anpassung der Gre, mgl. unsichtbar), um sie kurze Zeit spter wieder festzusetzen
	// oncommand des "View > Toolbars"-PopUp's erweitern
	if(document.getElementById('menu_viewPopup')) {
		var fx_toolbarPopUp = document.getElementById('menu_viewPopup').firstChild.firstChild;
		var fx_toolbarPopUpCmd = fx_toolbarPopUp.getAttribute('oncommand');
		fx_toolbarPopUp.setAttribute('oncommand', 'aiostbx_adjustToolboxWidth(this);' + fx_toolbarPopUpCmd);
	}

	// BrowserFullScreen erweitern (Verhalten der Sidebar, Sidebar-Switch, usw.)
	var fx_BrowserFullScreen = BrowserFullScreen;
	BrowserFullScreen = function BrowserFullScreen() {
		//if(!window.fullScreen) fx_maximizedWindow = fx_mainWindow.getAttribute('sizemode') == "maximized";
		fx_BrowserFullScreen();
		aios_BrowserFullScreen();
	}

	// Anpassungen fr diverse andere Erweiterungen
	aios_improveCompatibility();

	// Drag&Drop-Funktion fr den Sidebar-Umschalter deaktivieren?
	try {
		var switchDrag = aios_gPrefBranch.getBoolPref("gen.switch.drag");
		var switchDelay = aios_gPrefBranch.getIntPref("gen.switch.delay");

		if(!switchDrag) elem_switch.removeAttribute('ondragenter');
		/*if(switchDrag) {
		  var cmd = "aios_toggleSidebar('switch', true);";
		  elem_switch.setAttribute('ondragenter', 'window.setTimeout("' + cmd + '", ' + switchDelay + ');');
		  alert(elem_switch.getAttribute('ondragenter'));
		}*/
	}
	catch(e) { }

	// Changelog anzeigen?
	try { var changelog = aios_gPrefBranch.getCharPref('changelog'); }
	catch(e) { }

	// mit einer manuell gesetzten 0 lsst sich das abschalten
	// aiosVersion ist die aktuelle Version
	if(parseFloat(changelog) != 0 && fx_sidebarBox) {
		var aiosVersion = fx_sidebarBox.getAttribute('aiosVersion');
		if(aiosVersion && (aiosVersion != changelog)) {

      var aiosUpdated = (changelog != "") ? true : false;

			try {
				aios_gPrefBranch.setCharPref('changelog', aiosVersion);
				var changelog_new = aios_gPrefBranch.getCharPref('changelog');
			}
			catch(e) { }

			// wenn das speichern der aktuellen Version geklappt hat
			if(changelog_new === aiosVersion && gBrowser) {
			  var hp = "http://www.exxile.de/aios_installed.htm?v=" + aiosVersion;
			  if(aiosUpdated) hp = "http://www.exxile.de/aios_updated.htm?v=" + aiosVersion;

        //openUILinkIn(hp, 'tab');
        //window.setTimeout("openUILinkIn('"+hp+"', 'tab');", 500);
        //aios_WIN.gBrowser.selectedTab = aios_WIN.gBrowser.addTab(hp);
			  //window.setTimeout("gBrowser.selectedTab = gBrowser.addTab('" + hp + "');", 1000);

			  window.setTimeout("gBrowser.loadTabs(new Array('"+hp+"'), false);", 500);
			}
		}
	}

	// vertikale Buttons?
	try {
	  var vButtons = aios_gPrefBranch.getBoolPref("vbuttons");

		fx_mainWindow.setAttribute('aiosVButtons', 'true');
		if(!vButtons) fx_mainWindow.setAttribute('aiosVButtons', 'false');
		document.persist(fx_mainWindow.id, 'aiosVButtons');
	}
	catch(e) { }

	initialised = true;
}


/*
	modifiziert alle Sidebar-Tastenkombinationen, damit das
	Verhalten von Sidebar, Toolbar und Switch immer mit den Einstellungen bereinstimmt
		=> Aufruf durch aios_initSidebar() und aios_savePrefs() in prefs.js
*/
function aios_modKeys() {
	// soll die Toolbar angezeigt werden?
	var showToolbar = aios_getBoolean(aios_toggleToolbarItem, 'checked');

	// soll der Switch angezeigt werden?
	var showSwitch = aios_getBoolean(aios_toggleSwitchItem, 'checked');

	// welche Elemente sollen auf eine Tastenkombination reagieren?
	var mode = aios_gPrefBranch.getIntPref('cmode.key');

	var aiosAllKeys = document.getElementsByTagName('key');
	for(var i = 0; i < aiosAllKeys.length; i++) {
		if(aiosAllKeys[i].getAttribute('command')) {

			var elemID = aiosAllKeys[i].getAttribute('command');

			// alle Sidebar-Krzel mit command
			if(document.getElementById(elemID) && document.getElementById(elemID).getAttribute('group') == "sidebar") {
				var tmp_oncommand = document.getElementById(elemID).getAttribute('oncommand');

				// Leerzeichen entfernen und falls ntig ein ";" anhngen
				var oncommand = tmp_oncommand.replace(/ /, "");
				if(oncommand.substr(oncommand.length - 1, 1) != ";") oncommand = oncommand + ";";

				if(showToolbar && (mode == 2 || mode == 3 || mode == 4))
					oncommand = oncommand + " onViewToolbarCommand(eval(aios_isSidebarHidden()));";

				if(showSwitch && mode == 3)
					oncommand = oncommand + " eval(aios_toggleBox.hidden = aios_isSidebarHidden());";

				aiosAllKeys[i].setAttribute('oncommand', oncommand)
			}
		}
	}
}


/*
	stellt bei Doppelklick auf den Sidebarheader die Standardgre der Sidebar wieder her
		=> Aufruf durch EventListener auf dem Header, gesetzt in aios_initSidebar()
*/
function aios_setSidebarWidth(event) {
	aios_getObjects();

	var mode = "def";
	if(event) {
		if(event.shiftKey) mode = "min";
		if(event.ctrlKey) mode = "max";
	}

	try {
		var sWidthVal = aios_gPrefBranch.getIntPref('gen.width.' + mode + 'Val');
		var sWidthUnit = aios_gPrefBranch.getCharPref('gen.width.' + mode + 'Unit');

		if(sWidthUnit == "%") {
			var browserWidth = aios_getBrowserWidth();
			var compWidth = browserWidth[3];

			sWidthVal = parseInt(Math.round((compWidth * sWidthVal) / 100));
		}

		// Sidebarge einstellen
		fx_sidebarBox.setAttribute('width', sWidthVal);
	}
	catch(e) { }
}


/*
stellt die Anzeige der Sidebar ein
		=> Aufruf durch aios_initSidebar() und aios_savePrefs() in prefs.js
		=> 1 = links, 2 = rechts
*/
function aios_setSidebarOrient() {
	aios_getObjects();

	try {
		// Sidebar-Ausrichtung
		var sidebarOrient = aios_gPrefBranch.getIntPref('gen.orient');
		fx_mainWindow.setAttribute('aiosOrient', 'left');
		if(sidebarOrient == 2) fx_mainWindow.setAttribute('aiosOrient', 'right');
		document.persist(fx_mainWindow.id, 'aiosOrient');

		// Links-Rechts <=> Rechts-Links
		var cStyleWindow = document.defaultView.getComputedStyle(fx_mainWindow, '');
		fx_mainWindow.setAttribute('aiosMode', 'ltr');
		if(cStyleWindow.direction == "rtl") fx_mainWindow.setAttribute('aiosMode', 'rtl');
		document.persist(fx_mainWindow.id, 'aiosMode');
		
		// Fix fuer MileWideBack
		if(document.getElementById('back-strip') && sidebarOrient == 2) {
			var mwb = document.getElementById('back-strip');
			var mwbParent = document.getElementById('back-strip').parentNode;
			mwbParent.removeChild(mwb);
			mwbParent.appendChild(mwb);
		}
	}
	catch(e) { }
}


/*
	Sidebar-Status auf Veraenderungen ueberwachen
		=> Aufruf durch observes-Elemente (hidden und collapsed) in 'sidebar-box'
*/
function aios_observeSidebar(mode) {
	aios_getObjects();

	// fr den Fall, dass vor dem ffnen die Toolbar ausgeblendet wurde (z.B. durch Switch im Opera-Modus)
	var showToolbar = aios_getBoolean(aios_toggleToolbarItem, 'checked');
	if(showToolbar && !aios_isSidebarHidden()) onViewToolbarCommand(false);

	// fr den Fall, dass vor dem ffnen der Switch ausgeblendet wurde (z.B. durch Startup-Verhalten)
	var showSwitch = aios_getBoolean(aios_toggleSwitchItem, 'checked');
	if(showSwitch && !aios_isSidebarHidden()) aios_toggleBox.setAttribute('hidden', false);

	// Grippy-Status (CSS achtet auf Attribut 'aios')
	fx_mainWindow.setAttribute('aiosOpen', !fx_sidebarBox.hidden && !fx_sidebarBox.collapsed);
	document.persist(fx_mainWindow.id, 'aiosOpen');

	// Toggle-Button-Status (Button achtet auf Attribut 'checked')
	fx_sidebarBox.setAttribute('checked', !fx_sidebarBox.hidden && !fx_sidebarBox.collapsed);

	// fr den Fall, dass vor dem ffnen der Grippy benutzt wurde...
	if(mode == "hidden") {
		fx_sidebarBox.collapsed = false;
		fx_sidebarSplitter.collapsed = false;
		fx_sidebarSplitter.setAttribute('state', 'open');
	}

	//alert(fx_sidebarBox.getAttribute('sidebarcommand'));
	//document.persist(fx_sidebarBox.id, "sidebarcommand");
}


/*
	Letzte Sidebar merken und als persist speichern
		=> Aufruf durch observes-Element in 'sidebar-box' und aios_modSidebarMenu()
*/
function aios_remLastSidebar() {
	aios_getObjects();

	var actSidebar = false;

	// letzte Sidebar merken und speichern
	var allSidebars = document.getElementsByAttribute('group', 'sidebar');
	for(var i = 0; i < allSidebars.length; i++) {

		// darf kein Element observen (Meneintrge usw.), aber muss eine Sidebar-URL haben
		if(!allSidebars[i].getAttribute('observes') && allSidebars[i].getAttribute('sidebarurl')) {

			// muss eine ID haben und muss "checked" sein
			if(allSidebars[i].getAttribute('id') && aios_getBoolean(allSidebars[i], 'checked')) {

				// command in der "persist"-var "aiosLastPanel" speichern und zurckgeben
				fx_sidebarBox.setAttribute("aiosLastPanel", allSidebars[i].id);
				document.persist(fx_sidebarBox.id, "aiosLastPanel");
				actSidebar = allSidebars[i].id;

				//fx_sidebarBox.setAttribute("sidebarcommand", allSidebars[i].id);
				//document.persist(fx_sidebarBox.id, "sidebarcommand");

				//fx_sidebarBox.setAttribute('src', fx_sidebar.getAttribute('src'));
				//fx_sidebar.setAttribute('src', fx_sidebarBox.getAttribute('src'));
			}
		}
	}

	return actSidebar;
}


/*
	toggelt die Sidebar im Opera-Verhalten
		=> Aufruf durch aios_toggleSidebar() fr Elemente im Opera-Verhalten
*/
function aios_toggleOperaMode(aForcePanel, aForceOpen) {
  aios_getObjects();

  var showToolbar = aios_getBoolean(aios_toggleToolbarItem, 'checked');

	// zu oeffnende Sidebar feststellen
	var openPanel = fx_sidebarBox.getAttribute('aiosLastPanel');						// zuletzt geffnete Sidebar
	if(openPanel == "") openPanel = "viewBookmarksSidebar";									// Lesezeichen wenn keine Sidebar geffnet war
	if(aForcePanel) openPanel = aForcePanel;																// bestimmte Sidebar gewnscht (bei jedem oeffnen)

	// vertikaler Toolbar-Modus
	if(aios_getBoolean(aios_toolbox, 'vertical')) {

		// wenn die Toolbar sichtbar ist
	  if(!aios_getBoolean(aios_toolbar, 'collapsed')) {

	    // wenn die Sidebar sichtbar ist
	    if(!aios_isSidebarHidden() && !aForceOpen) {
	    	fx_sidebarBox.setAttribute("aiosShouldOpen", true);								// Zustand der Sidebar merken (sichtbar)
	    	document.persist(fx_sidebarBox.id, 'aiosShouldOpen');
	    	toggleSidebar();																									// Sidebar ausblenden
	    }
	  	else {
	  		fx_sidebarBox.setAttribute("aiosShouldOpen", false);							// Zustand der Sidebar merken (unsichtbar)
	  		document.persist(fx_sidebarBox.id, 'aiosShouldOpen');
	  	}

	    if(!aForceOpen) onViewToolbarCommand(true);													// Toolbar ausblenden
	    //aios_toolbar.setAttribute('collapsed', true);
	  }
	  // wenn die Toolbar nicht sichtbar ist
	  else {
	    if(showToolbar)																											// Toolbar anzeigen?
	    	onViewToolbarCommand(false);																			// Toolbar einblenden
	    	//aios_toolbar.setAttribute('collapsed', false);

			// wenn Sidebar angezeigt werden soll (Status vor dem letzten Schlieen) oder die Toolbar abgeschaltet wurde
	    if(aios_getBoolean(fx_sidebarBox, 'aiosShouldOpen') || !showToolbar) toggleSidebar(openPanel);
	  }
	}
	// horizontaler Toolbar-Modus
	else {
		// wenn die Sidebar sichtbar ist
	if(!aios_isSidebarHidden()) {
	    	fx_sidebarBox.setAttribute("aiosShouldOpen", true);								// Zustand der Sidebar merken (sichtbar)
	    	document.persist(fx_sidebarBox.id, 'aiosShouldOpen');
	    	toggleSidebar();																									// Sidebar ausblenden
	  }
	  else {
	  	if(lastPanel == "") toggleSidebar(openPanel);

		  //if(showToolbar) aios_toolbar.setAttribute('collapsed', false);
	  }
	}

}


/*
	klont das Firefox-Sidebar-Men fr die Sidebars-Buttons
		=> Aufruf durch Menbutton-Events 'onpopupshowing' aufgerufen
*/
function aios_getSidebarMenu(aPopup) {
	
	aios_getObjects();

	// Men modifizieren (aktiven Menpunkt deaktivieren, Ez Sidebar-Fix u.a.)
	aios_modSidebarMenu();

	/*var aios_sidebarMenu = fx_sidebarMenu.cloneNode(true);
	aios_sidebarMenu.setAttribute('onpopupshowing', 'aios_getSidebarMenu(this);');
	aPopup.parentNode.replaceChild(aios_sidebarMenu, aPopup);*/

	while(aPopup.hasChildNodes()) {
		aPopup.removeChild(aPopup.firstChild);
	}

	for(var i = 0; i < fx_sidebarMenu.childNodes.length; i++) {
		aPopup.appendChild(fx_sidebarMenu.childNodes[i].cloneNode(true));
	}

	// Tooltip des <sidebarheader> deaktivieren, damit er nicht beim Rollover ber <menuitem> immer eingeblendet wird
	// beim Schlieen des Mens den Tooltip wieder zuweisen
	document.getElementById('sidebarheader-hbox').removeAttribute('tooltip');
	aPopup.addEventListener("popuphiding", function() {
	  document.getElementById('sidebarheader-hbox').setAttribute('tooltip', 'sidebarheader-tooltip');
	}, true);
}


/*
	schliet die Sidebar, wenn die Maus den Content-Bereich berfhrt
		=> Aufruf durch mouseover des 'appcontent' und des Sidebar-Switches (mit bergabe von mode)

		=> aios_initSidebar() fgt dem Object "sidebar-box" einen mouseover-Event hinzu,...
		=> dieser mouseover-Event fgt dem "appcontent" einen mouseover-Event hinzu,...
		=> der diese Funktion aufruft
*/
var aios_autoTimeout;
function aios_autoShowHide(mode) {
	//try {
		var autobutton = aios_getBoolean('aios-enableAutohide', 'checked');

		var autoshow = aios_gPrefBranch.getBoolPref('gen.switch.autoshow');
		var onlymax = aios_gPrefBranch.getBoolPref('gen.switch.onlymax');
		var delay = aios_gPrefBranch.getIntPref('gen.switch.delay');
		var hidemethod = aios_gPrefBranch.getIntPref('gen.switch.hidemethod');

		// Feature nicht aktiviert, Feature soll nur bei max. Fenster greifen, Fenster hat nicht den Focus
		if(!autoshow || !autobutton || (onlymax && !aios_isWinMax()) || !aiosFocus) return false;

		/*
			Auslsung durch den Umschalter
		*/
		if(mode == "switch") {
			// wenn Sidebar sichtbar und nicht ausgeblendet werden soll => ignorieren
			if(!aios_isSidebarHidden() && hidemethod == 1) return false;

			// nach bestimmter Zeit ein-/ausblenden
			aios_autoTimeout = window.setTimeout("aios_toggleSidebar('switch')", delay);

			// timeout wieder lschen, wenn die Maus zu kurz auf dem Umschalter war oder geklickt wurde
			elem_switch.addEventListener("mouseout", function(){ window.clearTimeout(aios_autoTimeout); }, true);
			elem_switch.addEventListener("click", function(){ window.clearTimeout(aios_autoTimeout); }, true);

			return true;
		}
		/*
			Auslsung durch den Contentbereich
		*/
		else {

			// wenn Sidebar sichtbar und ausgeblendet werden soll
			if(!aios_isSidebarHidden() && hidemethod == 1) {

				// Event auf "appcontent" wieder lschen, weil sonst die Sidebar wieder eingeblendet wrde
				// => mouseover der Sidebar (in aios_initSidebar()) fgt dem "appcontent" dieses Feature wieder hinzu
				document.getElementById('appcontent').removeEventListener("mouseover", aios_autoShowHide, true);

				// nach bestimmter Zeit ausblenden
				aios_autoTimeout = window.setTimeout("aios_toggleSidebar('switch')", delay);

				// timeout wieder lschen, wenn die Maus zurck in die Sidebar kommt
				fx_sidebarBox.addEventListener("mouseover", function(){ window.clearTimeout(aios_autoTimeout); }, true);
			}
		}
	//}
	//catch(e) { }

	return true;
}


/*
	aktiviert/deaktiviert die Sidebar/Toolbar/Switch je nach Element und Einstellungen
		=> Aufruf durch Toggle-Button, Switch, Shortcut, Open/Close-Menuitems, Sidebar-Close-Button
			=> mode 1: nur die Sidebar ffnen/schlieen
			=> mode 2: Sidebar und Toolbar ffnen/schlieen
			=> mode 3: Sidebar, Toolbar und Togglebar ffnen/schlieen
			=> mode 4: Opera-Verhalten
*/
function aios_toggleSidebar(aMode, aForceOpen) {
	aios_getObjects();
	//aForceOpen = false;			// erlaubt das automatische ein-/ausblenden whrend Drag auf Sidebar Switch

	var prefstring = "key";
	if(aMode == elem_switch || aMode == "switch") prefstring = "switch";
	if(aMode == elem_tbb || aMode == "tbb") prefstring = "tbb";
	if(aMode == elem_close || aMode == "close") prefstring = "close";

	try {
		var mode = aios_gPrefBranch.getIntPref('cmode.' + prefstring);
		var toolBox_enabled = aios_getBoolean('aios-viewToolbar', 'checked');
		var toggleBox_enabled = aios_getBoolean(aios_toggleSwitchItem, 'checked');

		// direkte bergabe per JavaScript z.B. per "Custom Buttons"
		if(aMode === 1) mode = 1;
		if(aMode === 2) mode = 2;
		if(aMode === 3) mode = 3;
		if(aMode === 4) mode = 4;

		// bestimmtes Panel laden?
		var forcePanel;
		var openPanel = aios_gPrefBranch.getCharPref("gen.open.init");
		if(openPanel != "rem" && (prefstring == "key" || prefstring == "switch" || prefstring == "tbb")) forcePanel = openPanel;
		else forcePanel = false;

		if(mode == 4) {
			aios_toggleOperaMode(forcePanel, aForceOpen);
		}
		else {
			if(forcePanel && aios_isSidebarHidden()) toggleSidebar(forcePanel, aForceOpen);
			else toggleSidebar(fx_sidebarBox.getAttribute('aiosLastPanel'), aForceOpen);

			if((mode == 2 || mode == 3) && toolBox_enabled) {
				onViewToolbarCommand(aios_isSidebarHidden());
				//aios_toolbar.setAttribute('collapsed', aios_isSidebarHidden());
			}

			if(mode == 3 && toggleBox_enabled)
				aios_toggleBox.setAttribute('hidden', aios_isSidebarHidden());
		}
	}
	catch(e) { }

	// Breite der Toolbox lschen (Anpassung der Gre, mgl. unsichtbar), um sie kurze Zeit spter wieder festzusetzen
	aiostbx_adjustToolboxWidth(aios_toggleBox);

	return true;
}


/*

*/
function aios_toggleToolbar(which) {
  onViewToolbarCommand(!aios_getBoolean(which, 'checked'));
}


/*
	Sidebar-Toggle per collapsed
		=> Aufruf durch den Grippy selbst bei onClick()
*/
function aios_useGrippy() {
	fx_sidebarBox.collapsed = !fx_sidebarBox.collapsed;
}


/*
	aktiviert/deaktiviert den schmalen Sidebar-Umschalter
		=> Aufruf durch Event-Listener "onresize" in aios.xul, observer (sizemode) in tbx.xul,
			 aios_BrowserFullScreen() und aios_savePrefs() in prefs.js
*/
function aios_checkThinSwitch() {
	if(!initialised) return;

	aios_getObjects();

	var thin_switch, thinmax_switch, switch_width, switch_twidth, athin_switch;

	try {
		thin_switch = aios_gPrefBranch.getBoolPref('gen.switch.thin');
		thinmax_switch = aios_gPrefBranch.getBoolPref('gen.switch.thinmax');

		switch_width = aios_gPrefBranch.getIntPref('gen.switch.width');
		switch_twidth = aios_gPrefBranch.getIntPref('gen.switch.twidth');

		// soll er schmal sein?
		var thin = thin_switch;
		if(thin_switch && thinmax_switch && !aios_isWinMax()) thin = false;

		var width_val = (thin) ? switch_twidth : switch_width;
		var barStyle = "min-width: " + width_val + "px; max-width: " + width_val + "px;";

		if(width_val < 4) elem_switch.setAttribute('style', 'background-image: none;');
		else elem_switch.setAttribute('style', '');

		if(width_val < 2) barStyle += " border: none;";
		aios_toggleBar.setAttribute('style', barStyle);
	}
	catch(e) { }
}


/*
  Steuerung der Mausaktionen des Sidebar-Umschalters
    => Aufruf durch onClick() des Umschalters
*/
function aios_controlSwitch(ev, which) {
  // Linksklick
  if(ev.button == 0 && (!ev.shiftKey && !ev.ctrlKey)) {
    aios_toggleSidebar(which);
    // Titel setzen - eigentlich nur fr Add-ons
    if(window.sidebar && window.sidebar.aios_setTitle) window.sidebar.aios_setTitle();
  }

  // Mittelklick / Ctrl+Linksklick
  if(ev.button == 1 || (ev.button == 0 && ev.ctrlKey)) {
    aios_toggleElement('aios-viewToolbar');
    aios_toggleToolbar('aios-viewToolbar');
  }

  // Rechtsklick / Shift+Linksklick
  if(ev.button == 2 || (ev.button == 0 && ev.shiftKey)) {
    if(aios_isSidebarHidden()) toggleSidebar(fx_sidebarBox.getAttribute('aiosLastPanel'), true);
    else toggleSidebar();
  }
}


/*
	Erweitert die FF-Funktion BrowserFullScreen() zur Steuerung der AIOS-Elemente
		=> Aufruf durch aios_initSidebar()
*/
function aios_BrowserFullScreen() {
	aios_getObjects();

	try {
		// Soll-Zustnde
		var close_toolbar = aios_gPrefBranch.getBoolPref('fs.toolbar');
		var close_sidebar = aios_gPrefBranch.getBoolPref('fs.sidebar');
		var close_switch = aios_gPrefBranch.getBoolPref('fs.switch');
		var enable_restore = aios_gPrefBranch.getBoolPref('fs.restore');

		// Ist-Zustnde
		var rem_toolbarHidden = aios_getBoolean(aios_toolbar, 'collapsed');
		var rem_sidebarHidden = aios_isSidebarHidden();
		var rem_switchHidden = aios_getBoolean(aios_toggleBox, 'hidden');
	}
	catch(e) {
		return false;
	}

	// Fullscreen an
	// 	=> Elemente ausblenden
	if(window.fullScreen) {

		aiostbx_checkSpecialToolbars();

		// Ist-Zustnde speichern
		aios_toggleBox.setAttribute('fsToolbar', rem_toolbarHidden);
		aios_toggleBox.setAttribute('fsSidebar', rem_sidebarHidden);
		aios_toggleBox.setAttribute('fsSwitch', rem_switchHidden);

		// Soll-Zustnde herstellen
		if(close_toolbar && !rem_toolbarHidden) onViewToolbarCommand(true);
		if(close_sidebar && !rem_sidebarHidden) toggleSidebar();
		if(close_switch && !rem_switchHidden) aios_toggleBox.hidden = true;
	}
	// Fullscreen aus
	// 	=> Elemente einblenden
	else if(enable_restore) {

		aiostbx_checkSpecialToolbars();

		if(!aios_getBoolean(aios_toggleBox, 'fsSidebar')) toggleSidebar(fx_sidebarBox.getAttribute('aiosLastPanel'), true);
		else if(!aios_isSidebarHidden()) toggleSidebar();

		onViewToolbarCommand(aios_getBoolean(aios_toggleBox, 'fsToolbar'));
		aios_toggleBox.hidden = aios_getBoolean(aios_toggleBox, 'fsSwitch');
	}

	// aktiviert/deaktiviert den schmalen Sidebar-Umschalter
	aios_checkThinSwitch();

	// Breite der Toolbox lschen (Anpassung der Gre, mgl. unsichtbar), um sie kurze Zeit spter wieder festzusetzen
	aiostbx_adjustToolboxWidth(aios_toggleBox);

	return true;
}


/*
  prft, ob die Funktion "Sidebar Collapse" aus Kompatibilittsgrnden benutzt werden darf
    => Aufruf durch aios_initSidebar()
*/
function aios_allowCollapseSidebar() {
  //alert(typeof newToggleSidebar);
  //if(aios_appVersion.indexOf('3.0') == 0) return false;                  // Minefield (Fx 3)
  if(document.getElementById('ezsidebarBroadcasterSet')) return false;   // EZ Sidebar
  if(typeof window.moztweaksPrefObserver == "object") return false;      // Optimoz Tweaks
  if(typeof newToggleSidebar == "function") return false;                // OutSidebar
  return true;
}


/*
	Sidebar nur zusammenklappen statt schlieen
		=> Aufruf noch vor aios_initSidebar()
*/
function aios_enableCollapsingSidebar() {
	// Ueberwachung des 'hidden'-Attributs verhindern
	var obs = document.getElementById('aios_observeHidden');
	if(obs) obs.parentNode.removeChild(obs);

	/*
		Aenderungen der Funktion toggleSidebar()
	*/
	var new_cmd;
	var new_toggleSidebar = toggleSidebar.toString();
	
	// Sidebar ffnen
	new_cmd = "sidebarBox.removeAttribute('hidden'); sidebarBox.setAttribute('collapsed', false);";
	new_toggleSidebar = new_toggleSidebar.replace(/sidebarBox.hidden = false;/g, new_cmd);

	// If-Abfrage
	new_toggleSidebar = new_toggleSidebar.replace(/if \(sidebarBox.hidden\)/g, "if (sidebarBox.collapsed)");

	// Sidebar-Titel
	new_toggleSidebar = new_toggleSidebar.replace(/sidebarTitle.setAttribute\(\"value\", \"\"\);/g, "");

	// Sidebar schlieen
	new_cmd = "sidebarBox.removeAttribute('hidden'); sidebarBox.setAttribute('collapsed', true);";
	new_toggleSidebar = new_toggleSidebar.replace(/sidebarBox.hidden = true;/g, new_cmd);

	eval('toggleSidebar = ' + new_toggleSidebar + ';');
	
	/*
		Aenderungen der Funktion BrowserStartup()
	*/
	var new_BrowserStartup = BrowserStartup.toString();
	
	// Sidebar ffnen
	new_cmd = "if (openerSidebarBox && !openerSidebarBox.hidden && !openerSidebarBox.collapsed)";
	new_BrowserStartup = new_BrowserStartup.replace(/if \(openerSidebarBox && !openerSidebarBox.hidden\)/g, new_cmd);
	
	eval('BrowserStartup = ' + new_BrowserStartup + ';');
}


/*
// Firefox: Bei Verwendung dieser Methode funktioniert u.a. die Lesezeichenleiste in neuen Fenstern nicht mehr, 
// wenn das Fenster bei geschlossener Sidebar geffnet wurde

function aios_BrowserStartup() {
  var sidebarSplitter;
  if (window.opener && !window.opener.closed) {
    
    var openerSidebarBox = window.opener.document.getElementById("sidebar-box");
    
    if (openerSidebarBox && !openerSidebarBox.hidden && !openerSidebarBox.collapsed) { // mod by eXXile
      
      var sidebarBox = document.getElementById("sidebar-box");
      var sidebarTitle = document.getElementById("sidebar-title");
      sidebarTitle.setAttribute("value", window.opener.document.getElementById("sidebar-title").getAttribute("value"));
      sidebarBox.setAttribute("width", openerSidebarBox.boxObject.width);
      var sidebarCmd = openerSidebarBox.getAttribute("sidebarcommand");
      
      
      // added by eXXile => Fix, damit beim ffnen eines neuen Fensters die richtige Sidebar angezeigt wird
      if(sidebarCmd != "") window.setTimeout("toggleSidebar(window.opener.document.getElementById('sidebar-box').getAttribute('sidebarcommand'), true)", 0);
      
      
      sidebarBox.setAttribute("sidebarcommand", sidebarCmd);
      sidebarBox.setAttribute("src", window.opener.document.getElementById("sidebar").getAttribute("src"));
      gMustLoadSidebar = true;
      sidebarBox.hidden = false;
      
      
      sidebarBox.collapsed = false; // mod by eXXile
      
      
      sidebarSplitter = document.getElementById("sidebar-splitter");
      sidebarSplitter.hidden = false;
      document.getElementById(sidebarCmd).setAttribute("checked", "true");
    }
  }
  else {
    var box = document.getElementById("sidebar-box");
    if (box.hasAttribute("sidebarcommand")) {
      var commandID = box.getAttribute("sidebarcommand");
      if (commandID) {
        var command = document.getElementById(commandID);
        if (command) {
          gMustLoadSidebar = true;
          box.hidden = false;
          
          
          box.collapsed = false; // mod by eXXile
          
          
          sidebarSplitter = document.getElementById("sidebar-splitter");
          sidebarSplitter.hidden = false;
          command.setAttribute("checked", "true");
        }
        else {
          box.removeAttribute("sidebarcommand");
        }
      }
    }
  }
}


var aios_collapseSidebar = aios_gPrefBranch.getBoolPref('collapse');
if(aios_collapseSidebar && aios_allowCollapseSidebar()) {
	// BrowserStartup erweitern
	var fx_BrowserStartup = BrowserStartup;
	BrowserStartup = function BrowserStartup() {
		fx_BrowserStartup();
		aios_BrowserStartup();
	}
}*/

// Fx3: 	Bei Verwendung dieser Methode funktioniert SidebarCollapsing nicht
// Flock: 	Bei Verwendung dieser Methode funktionieren die Favoriten im Favoriten-Men der Hauptmenleiste nicht mehr
/*
function aios_BrowserStartup()
{
  gBrowser = document.getElementById("content");

  window.tryToClose = WindowIsClosing;

  var uriToLoad = null;
  // Check for window.arguments[0]. If present, use that for uriToLoad.
  if ("arguments" in window && window.arguments.length >= 1 && window.arguments[0])
    uriToLoad = window.arguments[0];

  gIsLoadingBlank = uriToLoad == "about:blank";

  if (!gIsLoadingBlank)
    prepareForStartup();

//@line 607 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8.0-Release/WINNT_5.2_Depend/mozilla/browser/base/content/browser.js"
  // only load url passed in when we're not page cycling

  if (uriToLoad && !gIsLoadingBlank) {
    if ("arguments" in window && window.arguments.length >= 3)
      loadURI(uriToLoad, window.arguments[2], null);
    else
      loadOneOrMoreURIs(uriToLoad);
  }

//@line 617 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8.0-Release/WINNT_5.2_Depend/mozilla/browser/base/content/browser.js"

  var sidebarSplitter;
  if (window.opener && !window.opener.closed) {
    if (window.opener.gFindMode && window.opener.gFindMode == FIND_NORMAL) {
      var openerFindBar = window.opener.document.getElementById("FindToolbar");
      if (openerFindBar && !openerFindBar.hidden)
        openFindBar();
    }

    var openerSidebarBox = window.opener.document.getElementById("sidebar-box");
    // The opener can be the hidden window too, if we're coming from the state
    // where no windows are open, and the hidden window has no sidebar box.
    if (openerSidebarBox && !openerSidebarBox.hidden && !openerSidebarBox.collapsed) { // mod by eXXile
      var sidebarBox = document.getElementById("sidebar-box");
      var sidebarTitle = document.getElementById("sidebar-title");
      sidebarTitle.setAttribute("value", window.opener.document.getElementById("sidebar-title").getAttribute("value"));
      sidebarBox.setAttribute("width", openerSidebarBox.boxObject.width);
      var sidebarCmd = openerSidebarBox.getAttribute("sidebarcommand");

			// added by eXXile => Fix, damit beim ffnen eines neuen Fensters die richtige Sidebar angezeigt wird
    	if(sidebarCmd != "") window.setTimeout("toggleSidebar(window.opener.document.getElementById('sidebar-box').getAttribute('sidebarcommand'), true)", 0);

      sidebarBox.setAttribute("sidebarcommand", sidebarCmd);
      sidebarBox.setAttribute("src", window.opener.document.getElementById("sidebar").getAttribute("src"));
      gMustLoadSidebar = true;
      sidebarBox.hidden = false;
      sidebarBox.collapsed = false; // mod by eXXile
      sidebarSplitter = document.getElementById("sidebar-splitter");
      sidebarSplitter.hidden = false;
      document.getElementById(sidebarCmd).setAttribute("checked", "true");
    }
  }
  else {
    var box = document.getElementById("sidebar-box");
    if (box.hasAttribute("sidebarcommand")) {
      var commandID = box.getAttribute("sidebarcommand");
      if (commandID) {
        var command = document.getElementById(commandID);
        if (command) {
          gMustLoadSidebar = true;
          box.hidden = false;
          box.collapsed = false; // mod by eXXile
          sidebarSplitter = document.getElementById("sidebar-splitter");
          sidebarSplitter.hidden = false;
          command.setAttribute("checked", "true");
        }
        else {
          // Remove the |sidebarcommand| attribute, because the element it
          // refers to no longer exists, so we should assume this sidebar
          // panel has been uninstalled. (249883)
          box.removeAttribute("sidebarcommand");
        }
      }
    }
  }

  // Certain kinds of automigration rely on this notification to complete their
  // tasks BEFORE the browser window is shown.
  var obs = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
  obs.notifyObservers(null, "browser-window-before-show", "");

  // Set a sane starting width/height for all resolutions on new profiles.
  if (!document.documentElement.hasAttribute("width")) {
    var defaultWidth = 994, defaultHeight;
    if (screen.availHeight <= 600) {
      document.documentElement.setAttribute("sizemode", "maximized");
      defaultWidth = 610;
      defaultHeight = 450;
    }
    else {
      // Create a narrower window for large or wide-aspect displays, to suggest
      // side-by-side page view.
      if ((screen.availWidth / 2) >= 800)
        defaultWidth = (screen.availWidth / 2) - 20;
      defaultHeight = screen.availHeight - 10;
//@line 701 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8.0-Release/WINNT_5.2_Depend/mozilla/browser/base/content/browser.js"
    }
    document.documentElement.setAttribute("width", defaultWidth);
    document.documentElement.setAttribute("height", defaultHeight);
  }

  setTimeout(delayedStartup, 0);
}


var aios_collapseSidebar = aios_gPrefBranch.getBoolPref('collapse');
if(aios_collapseSidebar && aios_allowCollapseSidebar()) {
	BrowserStartup = aios_BrowserStartup;
}*/




/*
  Erweiterung der Fx-Funktionen zur Ausblendung der neuen toolboxes in der Druckvorschau
*/
function onEnterPrintPreview() {
  if(aios_gElem('aios-toggle-toolbox')) aios_gElem('aios-toggle-toolbox').setAttribute('style', 'display:none;');
  if(aios_gElem('aiostbx-left-toolbox')) aios_gElem('aiostbx-left-toolbox').setAttribute('style', 'display:none;');
  if(aios_gElem('aiostbx-sidebarright-toolbox')) aios_gElem('aiostbx-sidebarright-toolbox').setAttribute('style', 'display:none;');
  if(aios_gElem('aiostbx-right-toolbox')) aios_gElem('aiostbx-right-toolbox').setAttribute('style', 'display:none;');
  if(aios_gElem('aiostbx-bottom-toolbox')) aios_gElem('aiostbx-bottom-toolbox').setAttribute('style', 'display:none;');
  
  // Fix fr Print-Preview Bug: ohne diesen Aufruf wird der ganze Browser geschlossen, 
  // wenn die Druckvorschau bei geschlossener Sidebar mit dem roten X des Browsers geschlossen wird
  document.getElementById('sidebar-box').setAttribute('hidden', true);
  
  toggleAffectedChrome(true);
}

function onExitPrintPreview() {
  if(aios_gElem('aios-toggle-toolbox')) aios_gElem('aios-toggle-toolbox').setAttribute('style', '');
  if(aios_gElem('aiostbx-left-toolbox')) aios_gElem('aiostbx-left-toolbox').setAttribute('style', '');
  if(aios_gElem('aiostbx-sidebarright-toolbox')) aios_gElem('aiostbx-sidebarright-toolbox').setAttribute('style', '');
  if(aios_gElem('aiostbx-right-toolbox')) aios_gElem('aiostbx-right-toolbox').setAttribute('style', '');
  if(aios_gElem('aiostbx-bottom-toolbox')) aios_gElem('aiostbx-bottom-toolbox').setAttribute('style', '');
  
  // Fix fr Print-Preview Bug: ohne diesen Aufruf wird der ganze Browser geschlossen, 
  // wenn die Druckvorschau bei geschlossener Sidebar mit dem roten X des Browsers geschlossen wird
  document.getElementById('sidebar-box').setAttribute('hidden', false);
  
  toggleAffectedChrome(false);
}