
// {ec8030f7-c20a-464f-9b0e-13a3a9e97384} => Firefox; {a463f10c-3994-11da-9945-000d60ca027b} => Flock
var aios_appID = Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).ID;
// Firefox, Flock
var aios_appVendor = Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).vendor;
var aios_appVersion = Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).version;
// WINNT => WinXP
var aios_platform = Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULRuntime).OS;


// globale Variablen fr Preferences-Zugriff
var aios_pBranch = Components.interfaces.nsIPrefBranch;
var aios_gPref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
var aios_gPrefBranch = aios_gPref.getBranch("extensions.aios.");

// globale Variablen fr Browser-Zugriff
var aios_WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
var aios_WIN = aios_WM.getMostRecentWindow('navigator:browser');
var aios_APPCONTENT = aios_WIN.document.getElementById('appcontent');


// globale Variablen und Funktionen zur berwachung auf Progress-Vernderungen
// Verwendung in pageInfo.xul und viewSource.xul
var aios_ProgListStart = Components.interfaces.nsIWebProgressListener.STATE_START;
var aios_ProgListStop = Components.interfaces.nsIWebProgressListener.STATE_STOP;

var aiosProgListener = {
	QueryInterface: function(aIID) {
		if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
				aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
				aIID.equals(Components.interfaces.nsISupports))
			return this;
			throw Components.results.NS_NOINTERFACE;
		},

	onStateChange: function(aProgress, aRequest, aFlag, aStatus) {
		//if(aFlag & aios_ProgListStart) { /* This fires when the load event is initiated */ }
		//if(aFlag & aios_ProgListStop) { /* This fires when the load finishes */ }
		if(aFlag & aios_ProgListStop) {
		  if(typeof aios_onStateChange == "function") aios_onStateChange();
		}
		return 0;
	},

	onLocationChange: function(aProgress, aRequest, aURI) {
		// This fires when the location bar changes i.e load event is confirmed
		// or when the user switches tabs
		if(typeof aios_onLocationChange == "function") aios_onLocationChange();
		return 0;
	},

	// For definitions of the remaining functions see XulPlanet.com
	onProgressChange: function() { return 0; },
	onStatusChange: function() { return 0; },
	onSecurityChange: function() { return 0; },
	onLinkIconAvailable: function() { return 0; }
}


/*
	Variablen zur Verwendung der Erweiterung "DebugLogger" - http://mozmonkey.com/debuglogger/
*/
if(Components.classes["@mozmonkey.com/debuglogger/manager;1"]) {
	var aios_debugLogMngr = Components.classes["@mozmonkey.com/debuglogger/manager;1"].
													getService(Components.interfaces.nsIDebugLoggerManager);
	var aios_debugLogger = aios_debugLogMngr.registerLogger("aios");
}
//aios_debugLogger.log(3, "Hello World");


/*
	Debug-Funktion unter Verwendung der JavaScript-Konsole
*/
function aios_debug(aMsg) {
	var aConsoleService = Components.classes["@mozilla.org/consoleservice;1"].
   												getService(Components.interfaces.nsIConsoleService),

	msg = 'AIOS: ' + aMsg;
	aConsoleService.logStringMessage(msg);
}
//aios_debug('Hallo');


/*
	ffnet ein neues Tab mit der bergebenen Adresse im Vordergrund
*/
var aiosLastSelTab;		// wird fr Page Info/Page Source/MultiPanel im Tab bentigt
function aios_addTab(aUrl) {

	var browser = aios_WIN.getBrowser();
	aiosLastSelTab = aios_WIN.content;

	var browserDoc;
	var existTab = null;
	var emptyTab = null;

	// alle geffneten Tabs durchgehen
	for(var i = 0; i < browser.tabContainer.childNodes.length; i++) {
		browserDoc = browser.getBrowserAtIndex(i).contentWindow.document;
		//alert(browser.getBrowserAtIndex(i).currentURI.spec);
		
		isPermaTab = (browser.tabContainer.childNodes[i].getAttribute('isPermaTab')) ? true : false;
		//alert(isPermaTab);
		
		/*var attribs = browser.tabContainer.childNodes[i].attributes;
		//var attribs = browser.mCurrentTab.attributes;
		for(var a = 0; a < attribs.length; a++) {
			alert(attribs[a].name + ": " + attribs[a].value);
		}*/
		
		// wenn der Tab leer ist
		if(browserDoc.location.href == "about:blank" && browser.selectedTab.getAttribute('openBy') != "aios" && !isPermaTab && emptyTab == null)
			emptyTab = i;
		// wenn der Tab schon existiert
		if(browserDoc.location.href == aUrl && !isPermaTab && existTab == null)
			existTab = i;
	}

	// wenn der Tab schon existiert
	if(existTab != null) {
		browser.selectedTab = browser.tabContainer.childNodes[existTab];
		return browser.selectedTab;
	}

	// wenn der Tab leer ist
	if(emptyTab != null) {
		// URL ffnen und Tab selektieren
		browser.getBrowserAtIndex(emptyTab).contentWindow.document.location.href = aUrl;
		browser.selectedTab = browser.tabContainer.childNodes[emptyTab];
		browser.selectedTab.setAttribute('openBy', 'aios');
		return browser.selectedTab;
	}

	// wenn kein leerer Tab vorhanden war, wird ein neuer geffnet
	browser.selectedTab = browser.addTab(aUrl);
	browser.selectedTab.setAttribute('openBy', 'aios');
	return browser.selectedTab;
}


/*
  fgt dem Dokument dynamisch ein Stylesheet hinzu
    => Aufruf u.a. durch aios_init() und aios_sidebarLayout() bei den Add-ons, Downloads
*/
function aios_addCSS(aURI) {
	var css = document.createElementNS('http://www.w3.org/1999/xhtml', 'link');
	css.setAttribute('rel', 'stylesheet');
	css.setAttribute('href', aURI);
	css.setAttribute('type', 'text/css');
	document.documentElement.appendChild(css);
}


/*
	errechnet die Breite des Browsers exkl. der AIOS-Toolbar
		=> Aufruf durch aios_setSidebarDefWidth() in aios.js und aios_setSidebarWidth() in general.js
*/
function aios_getBrowserWidth() {
	var cStyleSidebar = aios_WIN.document.defaultView.getComputedStyle(aios_WIN.document.getElementById('sidebar-box'), '');
	var cStyleSplitter = aios_WIN.document.defaultView.getComputedStyle(aios_WIN.document.getElementById('sidebar-splitter'), '');
	var cStyleContent = aios_WIN.document.defaultView.getComputedStyle(aios_WIN.document.getElementById('appcontent'), '');

	var widthSidebar = parseInt(cStyleSidebar.width) + parseInt(cStyleSidebar.paddingLeft) + parseInt(cStyleSidebar.paddingRight) + parseInt(cStyleSidebar.marginLeft) + parseInt(cStyleSidebar.marginRight);

	var widthSplitter = parseInt(cStyleSplitter.width) + parseInt(cStyleSplitter.paddingLeft) + parseInt(cStyleSplitter.paddingRight) + parseInt(cStyleSplitter.marginLeft) + parseInt(cStyleSplitter.marginRight);

	var widthContent = parseInt(cStyleContent.width) + parseInt(cStyleContent.paddingLeft) + parseInt(cStyleContent.paddingRight) + parseInt(cStyleContent.marginLeft) + parseInt(cStyleContent.marginRight);

	var compWidth = widthSidebar + widthSplitter + widthContent;

	var ret_arr = new Array(widthSidebar, widthSplitter, widthContent, compWidth);
	return(ret_arr);
}


/*
	erweitert das Attribut "class" eines Elementes
*/
function aios_appendClass(elem, appClass) {
	if(typeof elem == "string") elem = document.getElementById(elem);

	var old_class = elem.getAttribute('class');
	if(old_class.indexOf(appClass) < 0) elem.setAttribute('class', old_class + " " + appClass);
}


/*
	lscht einen Klassennamen im Attribut "class" eines Elementes
*/
function aios_stripClass(elem, stripClass) {
	if(typeof elem == "string") elem = document.getElementById(elem);

	var old_class = elem.getAttribute('class');

	if(old_class.indexOf(stripClass) >= 0) {
		var pos = old_class.indexOf(stripClass);

		var slice1 = old_class.substring(0, pos);
		slice1 = slice1.replace(/ /, "");
		var slice2 = old_class.substring(pos + stripClass.length, old_class.length);
		slice2 = slice2.replace(/ /, "");

		elem.setAttribute('class', slice1 + " " + slice2);
	}

}


function aios_gElem(aID) {
	if(aios_WIN && aios_WIN.document.getElementById(aID)) return aios_WIN.document.getElementById(aID);
	return false;
}


/*
	gibt den boolschen Wert eines Wertes zurck
		=> getAttribute(val) liefert nur "true" oder "false" als String
*/
function aios_getBoolean(aElem, aVal) {
	var elem, bool;

	if(typeof aElem == "object") {
		elem = aElem;
	}
	else if(typeof aElem == "string" && document.getElementById(aElem)) {
		elem = document.getElementById(aElem);
	}

	if(elem) {
		if(typeof elem.getAttribute == "function") bool = elem.getAttribute(aVal);
	}

	if(bool == "true") return true;
	else return false;
}


/*
	Dialoge ffnen
*/
function aios_openDialog(which, args) {
	var theUrl, theId, theFeatures, theArgs;
	var theArgs = args;

	switch(which) {
		case "prefs":
			theUrl = "chrome://aios/content/prefs/prefs.xul";
			theId = "aiosPrefsDialog";
			theFeatures = "chrome,titlebar,toolbar,centerscreen,";
			theFeatures+= (aios_platform == "Darwin") ? "dialog=no" : "modal";
			break;

		case "about":
			theUrl = "chrome://aios/content/about.xul";
			theId = "aiosAboutDialog";
			theFeatures = "chrome,modal";
			break;

		case "bookmarks":
			theUrl = "chrome://browser/content/bookmarks/bookmarksPanel.xul";
			theId = "aiosGlobal:Bookmarks";
			theFeatures = "width=640,height=480,chrome,resizable,centerscreen";
			break;

		case "history":
			theUrl = "chrome://browser/content/history/history-panel.xul";
			theId = "aiosGlobal:History";
			theFeatures = "width=640,height=480,chrome,resizable,centerscreen";
			break;

		case "multipanel":
			theUrl = "chrome://browser/content/web-panels.xul";
			theId = "aiosGlobal:MultiPanel";
			theFeatures = "width=640,height=480,chrome,resizable,centerscreen";
			break;
	}

	if(which == "prefs" || which == "about") openDialog(theUrl, theId, theFeatures, theArgs);
	else toOpenWindowByType(theId, theUrl, theFeatures);
}


/*
	prft welche Elemente angezeigt werden sollen
		=> Aufruf jeweils durch Initialisierung
*/
function aios_synchElements(aElems) {
	var elem, child;

	for(var i = 0; i < aElems.length; i++) {
		elem = document.getElementById(aElems[i]);

		if(elem) {

			childElems = elem.getAttribute('aiosChilds');

			if(childElems) {
				childMode = !aios_getBoolean(elem, 'checked');
				aios_toggleChilds(childElems, childMode);
			}
		}
	}
}


/*
	toggelt einen Menpunkt und das/die zugehrige/n Element/e
		=> Aufruf durch die menuitems in der aios.xul
*/
function aios_toggleElement(aMenuitem) {
  var menuitem;
  
  if(typeof aMenuitem != "object") aMenuitem = document.getElementById(aMenuitem);

	if(aMenuitem.getAttribute('observes')) {
		menuitem = document.getElementById(aMenuitem.getAttribute('observes'));
	}
	else {
		menuitem = document.getElementById(aMenuitem.id);
	}

	var mode = aios_getBoolean(menuitem, 'checked');
	var childElems = menuitem.getAttribute('aiosChilds');

	menuitem.setAttribute('checked', !mode);
	aios_toggleChilds(childElems, mode);
}


/*
	toggelt Kindelemente eines Menpunkts
		=> Aufruf durch aios_toggleElement()
*/
function aios_toggleChilds(childElems, childMode) {
	var child_str, child;

	if(childElems != "") {
		var childElems_arr = childElems.split(",");

		for(var i = 0; i < childElems_arr.length; i++) {
			child_str = childElems_arr[i].replace(/ /, "");

			var idChilds_arr = document.getElementsByAttribute('id', child_str);

			// wenn es nur ein Element mit der ID gibt...
			if(idChilds_arr.length == 1) {
				child = document.getElementById(child_str);
			}
			// wenn es mehrere Elemente mit der ID gibt...
			else {
				for(var j = 0; j < idChilds_arr.length; j++) {
					//... nimm das auf der AIOS-Toolbar
					if(idChilds_arr[j].parentNode.id == "aios-toolbar") child = idChilds_arr[j];
				}
			}

			if(child) child.setAttribute('hidden', childMode);
		}
	}
}