
var aiosOS = Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULRuntime).OS;

if(aiosOS != "Darwin") {
	var aiostbx_toolboxes = null;
	var aiostbx_navToolbox = null;
	var aiostbx_bindingBoxes = new Array("aiostbx-tableft-toolbox", "aiostbx-tabright-toolbox", "aiostbx-belowtabs-toolbox");
	var gToolbox, gToolboxes, gToolboxDocument;
}


/*
	Mindest- und Maximalbreite der vertikalen Toolbar einstellen
		=> Aufruf durch
					=> tbx.js
							aiostbx_init() 					 => erstmalige Festlegung
							aiostbx_setToolbarMode() => Anpassung wegen mgl. nderungen (Mode, Icongre, Position usw.)

					=> tbx.xul
							oncommand() des Toolbar-Kontextmens => Anpassung wegen mgl. nderungen (Mode, Icongre, Position usw.)

					=> tbx_customize.js
							ondraggesture() & ondragdrop() der Toolboxen => Anpassung wegen mgl. neuer oder entfernter Buttons

					=> aios.js
							aios_toggleSidebar() => Anpassung nach Toolbarein-/ausblendung ber Shortcut, Togglebutton, Switch, Close-Button

		=> festsetzen ntig, weil sonst die Toolboxen bei Grennderung der Sidebar mit verndert werden
		=> per JS statt CSS, weil es wegen Themes dynamisch sein mu
*/
function aiostbx_adjustToolboxWidth(fix) {
	
	// Aufruf durch Drag-Event der Toolbox
	if(typeof fix == "object") {
		fix = false;
		window.setTimeout('aiostbx_adjustToolboxWidth(true)', 200);
	}

	var computedStyle, myWidth;
	var vToolboxes = document.getElementsByAttribute('vertical', 'true');

	for(var i = 0; i < vToolboxes.length; i++) {
		if(vToolboxes[i].tagName == "toolbox") {

			myWidth = 0;

			// Breite festsetzen (Toolbox hat feste Breite)
			if(fix) {

				var boxChilds = vToolboxes[i].childNodes;

				// Breite aller enthaltenen Toolbars zusammenrechnen
				for(var j = 0; j < boxChilds.length; j++) {
					if(boxChilds[j].tagName == "toolbar") {
						computedStyle = document.defaultView.getComputedStyle(boxChilds[j], null);

						myWidth = myWidth + parseInt(computedStyle.width);
						myWidth = myWidth + parseInt(computedStyle.paddingLeft);
						myWidth = myWidth + parseInt(computedStyle.paddingRight);
						myWidth = myWidth + parseInt(computedStyle.marginLeft);
						myWidth = myWidth + parseInt(computedStyle.marginRight);
						myWidth = myWidth + parseInt(computedStyle.borderLeftWidth);
						myWidth = myWidth + parseInt(computedStyle.borderRightWidth);
					}
				}

				vToolboxes[i].style.maxWidth = myWidth + "px";
			}

			// Breite wieder lschen (Toolbox flexibel)
			else {
				vToolboxes[i].removeAttribute('width');
				vToolboxes[i].removeAttribute('style');
			}
		}//end if(vToolboxes[i].tagName == "toolbox")
	}
	
	return true;
}

/*
function aiostbx_closeTab() {
	var node = document.getElementById('aiostbx-tabright-toolbox');
	while(node.localName != 'tabbrowser') node = node.parentNode;
	node.removeCurrentTab();
}*/


/*
	Sidebar unter die Tableiste verschieben - sehr experimentell
		=> in binding.xml mu dann "aioBrowser" entkommentiert werden
*/
function aiostbx_setSidebarUnderTabs() {
	
	var aioBrowser = document.getElementById("aioBrowser");
	var sidebar = document.getElementById("sidebar-box");
	var splitter = document.getElementById("sidebar-splitter");

	aioBrowser.appendChild(splitter);
	aioBrowser.appendChild(sidebar);
	
	return true;
}


// by Stephen Clavering with mods by eXXile
function aiostbx_getToolboxes() {

  aiostbx_toolboxes = [];
  aiostbx_navToolbox = document.getElementById("navigator-toolbox");

	var aiostbx_tmpBoxes = document.getElementsByTagName('toolbox');

	for(var z = 0; z < aiostbx_tmpBoxes.length; z++) {
		aiostbx_toolboxes.push(aiostbx_tmpBoxes[z]);
	}

  for(var i = 0; i < aiostbx_bindingBoxes.length; i++) {
  	if(document.getElementById(aiostbx_bindingBoxes[i]))
  		aiostbx_toolboxes.push(document.getElementById(aiostbx_bindingBoxes[i]));
  }

  return aiostbx_toolboxes;
}


/*
	Workaround fuer Bookmark-Buttons-Bug: Bookmarks werden sonst bei maximiertem Fenster nach rechts verschoben
		=> funzt nur, wenn der Button immer ganz rechts bleibt
		=> Aufruf durch aiostbx_init() in 'tbx.js' und initDialog(), notifyParentComplete() in 'tbx_customize.js'
*/
function aiostbx_bmBugFix(append) {
	
	var doc = aios_WIN.top.document;
	if(window.opener) doc = window.opener.top.document;
	if(!doc.getElementById('aiostbx-toolbar-statusbar-right')) return false;

	var aiostbx_bmbugfixElemParent = doc.getElementById('aiostbx-toolbar-statusbar-right');

	if(doc.getElementById('aiostbx-bmbugfix'))
		aiostbx_bmbugfixElemParent.removeChild(aiostbx_bmbugfixElemParent.lastChild);

	if(append) {
		var newButton = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "toolbarbutton");
		newButton.setAttribute('id', 'aiostbx-bmbugfix');
		newButton.setAttribute('class', 'toolbarbutton-1');

		aiostbx_bmbugfixElemParent.appendChild(newButton);
	}

	return true;
}


if(aiosOS != "Darwin") {
	
	var persistCurrentSets;
	persistCurrentSets = function () {
	  // it would be nice to test for each individual toolbox, but that requires
	  // replicating all the drag+drop code just to change one or two lines
	
		//alert(document.getElementById("navigator-toolbox").getAttribute("incustomisemode"));
	
	  /*
	  	mod by eXXile
	  		=> sonst wird ein Pos.-Wechsel einer Toolbar nur gespeichert,
	  		wenn auch ein Button auf die Toolbar oder von der toolbar gezogen wurde)
	
	  	if(!gToolboxChanged) return;
	  */
	
	  // wenn die Position nicht ber das Konfigurationsfenster gendert wurde
		if(document.getElementById("CustomizeToolbarWindow") == null) {
			if(window.opener) gToolbox = window.opener.top.document.getElementById("navigator-toolbox");
			else gToolbox = document.getElementById("navigator-toolbox");
	
			gToolboxes = aiostbx_getToolboxes();
			gToolboxDocument = gToolbox.ownerDocument;
	
			//alert(persistCurrentSets.caller);
			if(document.getElementById("navigator-toolbox").getAttribute("incustomisemode") == "true") return;
		}
	
	
	  var docElt = gToolboxDocument.documentElement;
	
	  for(var j = 0; j < gToolboxes.length; j++) {
	
	    var toolbox = gToolboxes[j];
	
	    var customCount = 0;
	    for(var i = 0; i < toolbox.childNodes.length; ++i) {
	      // Look for customizable toolbars that need to be persisted.
	      var toolbar = toolbox.childNodes[i];
	
	      // modby eXXile
	      // if(isCustomizableToolbar(toolbar)) {
	      if(toolbar.localName == "toolbar" && toolbar.getAttribute("customizable") == "true") {
	      // endmod
	
	        // Calculate currentset and store it in the attribute.
	        var currentSet = toolbar.currentSet;
	        toolbar.setAttribute("currentset", currentSet);
	
	        var customIndex = toolbar.hasAttribute("customindex");
	        if(customIndex) {
	          if(!toolbar.firstChild) {
	            // Remove custom toolbars whose contents have been removed.
	            toolbox.removeChild(toolbar);
	            --i;
	          } else if(toolbox.toolbarset.getAttribute('anonymous')=='true') {
	            // for the toolbox below the tab bar.  in xbl, so attributes can't
	            // be persisted.  so we store the info on the document root instead
	            //var docElt = gToolboxDocument.documentElement;
	            var attrPrefix = '_toolbarset_' + toolbox.toolbarset.getAttribute('anonid') + '_toolbar';
	
	            // Persist custom toolbar info on the <toolbarset/>
	            docElt.setAttribute(attrPrefix+(++customCount), toolbar.toolbarName + ":" + currentSet);
	            gToolboxDocument.persist(docElt.id, attrPrefix+customCount);
	          } else {
	            // Persist custom toolbar info on the <toolbarset/>
	            toolbox.toolbarset.setAttribute("toolbar"+(++customCount),
	                                             toolbar.toolbarName + ":" + currentSet);
	            gToolboxDocument.persist(toolbox.toolbarset.id, "toolbar"+customCount);
	          }
	
	        } else if(toolbar.getAttribute('anonymous')=='true') {
	          // for the tab-strip toolbars.  they're in XBL, so persistence doesn't work
	          // instead we persist a custom attribute on the document.
	          var attr = "_toolbar_currentset_"+toolbar.getAttribute('anonid');
	//          gToolboxDocument.documentElement
	          docElt.setAttribute(attr,currentSet);
	          gToolboxDocument.persist(gToolboxDocument.documentElement.id,attr);
	
	        } else {
	          // Persist the currentset attribute directly on hardcoded toolbars.
	          gToolboxDocument.persist(toolbar.id, "currentset");
	        }
	      }
	    }
	
	    // Remove toolbarX attributes for removed toolbars.
	    // (we need the |if| because the toolboxes on the tabbar do not have a toolbarset)
	    var toolbarset = toolbox.toolbarset;
	    if(!toolbarset) continue;
	
	    if(toolbarset.getAttribute('anonymous')=='true') {
	      // for the toolbarbox below the tab bar
	//      var docElt = gToolboxDocument.documentElement;
	      //var
	      attrPrefix = '_toolbarset_' + toolbarset.getAttribute('anonid') + '_toolbar';
	      while(docElt.hasAttribute(attrPrefix+(++customCount))) {
	        docElt.removeAttribute(attrPrefix+customCount);
	        gToolboxDocument.persist(docElt.id, attrPrefix+customCount);
	      }
	    } else {
	      while(toolbox.toolbarset.hasAttribute("toolbar"+(++customCount))) {
	        toolbox.toolbarset.removeAttribute("toolbar"+customCount);
	        gToolboxDocument.persist(toolbox.toolbarset.id, "toolbar"+customCount);
	      }
	    }
	  }
	}
	
}