
var aiosOS = Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULRuntime).OS;

// Sidebarheader eine ID zuweisen, Schlieen-Button entfernen
var sidebarheader = document.getElementById('sidebar-throbber').parentNode;
sidebarheader.setAttribute('id', 'sidebarheader');
sidebarheader.removeChild(sidebarheader.lastChild);
var gPref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);


function aiostbx_init() {
	// Maximalbreite der vertikalen Toolboxen einstellen
	window.setTimeout('aiostbx_adjustToolboxWidth(true)', 50);

	//window.setTimeout('aiostbx_checkGoogleToolbar()', 200);

	// BrowserFullScreen erweitern (Toolboxen sichtbar/unsichtbar machen)
	//if(aiosOS != "Darwin") {
		var fx_BrowserFullScreen = BrowserFullScreen;
		BrowserFullScreen = function BrowserFullScreen() {
			fx_BrowserFullScreen();
			aiostbx_BrowserFullScreen();
		}
	//}

	// Ueberwachung der Toolbars auf der Tabbar und der Statusbar
	aiostbx_checkSpecialToolbars();

	// Sidebar unter die Tableiste verschieben
	//aiostbx_setSidebarUnderTabs();

	// Label der Toolbareinstellungen tauschen, wenn der Browser im RTL-Modus ist (Sidebar rechts)
	var str_left = document.getElementById("aiostbx-left").getAttribute('label');
	var str_sidebarleft = document.getElementById("aiostbx-sidebarleft").getAttribute('label');
	var str_right = document.getElementById("aiostbx-right").getAttribute('label');

	try {
		var wStyle = document.defaultView.getComputedStyle(document.getElementById("browser"), '');
		if(wStyle.direction == "rtl") {
			document.getElementById("aiostbx-left").setAttribute('label', str_right);
			document.getElementById("aiostbx-sidebarright").setAttribute('label', str_sidebarleft);
			document.getElementById("aiostbx-right").setAttribute('label', str_left);
		}
	}
	catch(e) { }

	// dem Kontextmen der Toolbars die Einstellungsmglichkiten hinzufgen
	aiostbx_getCustomizeMenu();

	// Bookmark-Buttons-Bugfix fr rechte Statusleisten-Toolbar => Button hinzufgen
  //window.setTimeout("aiostbx_bmBugFix(true);", 1000);
  //aiostbx_bmBugFix(true);
}


function aiostbx_checkGoogleToolbar() {
	//alert(GTB_GoogleToolbar.prototype._addButton);
}


/*
	Ueberwachung der Toolbars auf der Tabbar und der Statusbar
		=> Aufruf durch aiostbx_init() und durch aios_savePrefs() in prefs.js
*/
function aiostbx_checkSpecialToolbars() {
	try {
		var enable_tabbar = gPref.getBoolPref('extensions.aios.tbx.tabbar');
		var enable_statusbar = gPref.getBoolPref('extensions.aios.tbx.statusbar');

		document.getElementById('aiostbx-tableft-toolbox').setAttribute('hidden', !enable_tabbar);
		document.getElementById('aiostbx-tabright-toolbox').setAttribute('hidden', !enable_tabbar);

		document.getElementById('aiostbx-toolbox-statusbar-left').setAttribute('hidden', !enable_statusbar);
		document.getElementById('aiostbx-toolbox-statusbar-right').setAttribute('hidden', !enable_statusbar);
	}
	catch(e) { }
}


/*
	Kontextmen der Toolbars erstellen
		=> ntig weil sonst wie beim Sidebars-Button das Men beim 2. Aufruf nicht funktionieren wrde (fehlendes hide-Event)
		=> Aufruf durch aiostbx_init() und oncommand der Kontextmens
*/
function aiostbx_getCustomizeMenu() {
	var contextMenuID = "aiostbx-toolbar-context-menu";
	var contextMenuSepID = "aiostbx-toolbar-context-menu-sep";

	// altes Men entfernen
	if(document.getElementById(contextMenuID))
		document.getElementById(contextMenuID).parentNode.removeChild(document.getElementById(contextMenuID));

  // alten Separator entfernen
  if(document.getElementById(contextMenuSepID))
		document.getElementById(contextMenuSepID).parentNode.removeChild(document.getElementById(contextMenuSepID));

	// neues Men einfgen
	var tmp_customiseMenu = document.getElementById('aiostbx-toolbar-context-tmpMenu');
	var customiseMenu = tmp_customiseMenu.cloneNode(true);
	customiseMenu.setAttribute('hidden', false);
	customiseMenu.setAttribute('id', contextMenuID);

	// Meneintrge aus dem Konfigurations-Kontextmen einfgen
	var customiseContext = document.getElementById('toolbar-customise-context-menu');
	var newItem;

	for(var j = 0; j < customiseContext.childNodes.length; j++) {
		newItem = customiseContext.childNodes[j].cloneNode(true);
		customiseMenu.firstChild.appendChild(newItem);
	}

	tmp_customiseMenu.parentNode.appendChild(customiseMenu);

	var newSep = document.createElement("menuseparator");
	newSep.setAttribute('id', contextMenuSepID);
	tmp_customiseMenu.parentNode.insertBefore(newSep, customiseMenu);

	document.getElementById('toolbar-context-menu').hidePopup();
}


/*
	blendet Toolboxen bei Fullscreen ein oder aus
		=> bentigt, weil
			  => 1. die Breite der vertikalen Boxen eingestellt wurde und so die Boxen nicht automatisch unsichtbar werden
			  => 2. die Boxen per Binding-Einbindung (auf und unter der Tableiste) nicht ein-/ausgeblendet werden
		=> erweitert die FF-Funktion BrowserFullScreen()
		=> Aufruf bzw. Erweiterung durch aiostbx_init()
*/
function aiostbx_BrowserFullScreen() {

	var toolboxes = [];

	// vertikale Toolboxen in Array berfhren
	var vToolboxes = document.getElementsByAttribute('vertical', 'true');
	for(var i = 0; i < vToolboxes.length; i++) {
		if(vToolboxes[i].tagName == "toolbox") toolboxes.push(vToolboxes[i]);
	}

	// Extra-Toolboxen dazupacken, die je nach Fullscreen-Modus ein- oder ausgeschaltet werden sollen
	for(var j = 0; j < aiostbx_bindingBoxes.length; j++) {
  	if(document.getElementById(aiostbx_bindingBoxes[j]))
  		toolboxes.push(document.getElementById(aiostbx_bindingBoxes[j]));
  }

	// Toolboxen durchlaufen
	for(i = 0; i < toolboxes.length; i++) {
		var boxChilds = toolboxes[i].childNodes;
		var fsChilds = 0;

		// Child-Elemente durchlaufen (Toolbars)
		for(j = 0; j < boxChilds.length; j++) {
			if(boxChilds[j].getAttribute("fullscreentoolbar") == "true") fsChilds++;
			else {
				// Toolbars unterhalb der Tableiste je nach Einstellung ein- bzw. ausblenden
				// geht nicht durch FF ???
				if(toolboxes[i].getAttribute('id') == "aiostbx-belowtabs-toolbox")
					boxChilds[j].setAttribute('collapsed', window.fullScreen);
			}
		}

		// wenn alle Childs der Toolbar im Fullscreen-Modus unsichtbar sind, mache auch die Box unsichtbar
		if(toolboxes[i].getAttribute('id') != "aios-toggle-toolbox") {
			if(window.fullScreen) toolboxes[i].setAttribute('hidden', !(fsChilds > 0));
			else toolboxes[i].setAttribute('hidden', false);
		}

	}
}


// onshowing + oncommand handlers for the context menu for toolbars while customising
// by Stephen Clavering with mods by eXXile
function aiostbx_initCustomiseContext(evt, popup) {

  var toolbar = document.popupNode;
  while(toolbar.localName != "toolbar") toolbar = toolbar.parentNode;
  var toolbox = toolbar.parentNode;
  var isPlainToolbox = toolbox.getAttribute('class').indexOf('aiostbx-toolbox-plain') >= 0;
  var isDefaultToolbar = toolbar.getAttribute('defaultset') != "";
  var isAIOSToolbar = toolbar.getAttribute('id') == "aios-toolbar";
  var isCustomizableToolbar = toolbar.getAttribute('customizable') == "true";
  var isStatusbarToolbar = toolbar.parentNode.parentNode.localName == "statusbar";
  var isAutoHideEnabled = typeof autoHIDE == "object";
  var child;

  // Einstellungen
  var mode = toolbar.getAttribute("mode");
  var small = toolbar.getAttribute("iconsize") == "small";
  var flexbuttons = toolbar.getAttribute("flexbuttons") == "true";
  var fullscreentoolbar = toolbar.getAttribute("fullscreentoolbar") == "true";
  var position = toolbox.getAttribute("id");

	for(var i = 0; i < popup.childNodes.length; i++) {
		child = popup.childNodes[i];

		// M O D E
		if(child.getAttribute('name') == "mode") {
			child.setAttribute('checked', child.getAttribute('value') == mode);

			// keinen "Icon + Text"-Modus in der Tabbar und der Statusleiste
			child.hidden = child.value == "full" && isPlainToolbox;
		}

		// S M A L L I C O N S
		if(child.getAttribute('value') == "smallicons") {
			child.setAttribute('checked', small);
			child.setAttribute('disabled', mode == "text");
		}

		// F L E X I B L E   B U T T O N S
		if(child.getAttribute('value') == "flexbuttons") {
			child.setAttribute('checked', flexbuttons);

			// keine flexiblen Buttons in der Tabbar und der Statusleiste
			child.hidden = isPlainToolbox;
			popup.childNodes[i-1].hidden = isPlainToolbox;
		}

		// F U L L S C R E E N
		if(child.getAttribute('value') == "fullscreentoolbar") {
			child.setAttribute('checked', fullscreentoolbar);

			// Fullscreen-Option fr AIOS-Toolbar entfernen
			// 	=> sonst kann die Toolbar z.B. mit dem Switch nicht wieder sichtbar gemacht werden
			// Fullscreen-Option fr Statusbar-Toolbars entfernen, wenn "autohide" nicht installiert/aktiviert ist
			child.hidden = isAIOSToolbar || (isStatusbarToolbar && !isAutoHideEnabled);
			popup.childNodes[i-1].hidden = isAIOSToolbar || (isStatusbarToolbar && !isAutoHideEnabled);
		}

		// P O S I T I O N
		if(child.getAttribute('name') == "position") {
			child.setAttribute('checked', child.getAttribute('value') == position);

			// nicht verschiebbar in der Tabbar, der Statusleiste, Standard-Toolbars oder unkonfigurierbare Toolbars
			child.hidden = isPlainToolbox || isDefaultToolbar || !isCustomizableToolbar;
			// Separator ausblenden
			if(child.id == "position1") popup.childNodes[i-1].hidden = isPlainToolbox || isDefaultToolbar || !isCustomizableToolbar;
		}

		// Toolbar-Enhancement-Fix
		// 	=> alle Elemente ausblenden, die nicht von AIOS in dieses Men eingefgt wurden
		//  => verhindert doppelte Eintrge
		if(child.getAttribute('aios') != "true" && child.getAttribute('id').indexOf('aiostbx') < 0 && child.getAttribute('value').indexOf('aiostbx') < 0) {
			child.setAttribute('hidden', true);
		}
	}
}


// Toolbar-Eigenschaften ndern (Position, Modus, Icongre, ...)
// by Stephen Clavering with mods by eXXile
function aiostbx_setToolbarMode(evt, aPopup) {
  var toolbar = document.popupNode;
  while(toolbar.localName!="toolbar") toolbar = toolbar.parentNode;

  var value = evt.originalTarget.value;
  var group = evt.originalTarget.getAttribute("name"); // radio group

  if(value == "smallicons") {
    var small = evt.originalTarget.getAttribute("checked") == "true";
    var size = small ? "small" : "large";
    toolbar.parentNode.setToolbarIconSize(toolbar, size);
  }
  else if(value == "fullscreentoolbar") {
    var showInFullScreen = evt.originalTarget.getAttribute("checked") == "true";
    toolbar.parentNode.showToolbarInFullscreen(toolbar, showInFullScreen);
  }
  // mod by eXXile
  else if(value == "flexbuttons") {
    var flexbuttons = evt.originalTarget.getAttribute("checked") == "true";
    toolbar.parentNode.setToolbarFlexButtons(toolbar, flexbuttons);
  }
  // endmod
  else if(group == "mode") {
    toolbar.parentNode.setToolbarMode(toolbar, value);
  }
  else if(group == "position") {
    // We could just remove the <toolbar/> from its current location and append to the
    // desired toolbox, but that would mean we wouldn't respect the rule that custom
    // toolbars appear wherever the <toolbarset/> is.  Also it caused an interesting
    // bug where all the items on the toolbar would be duplicated sometimes after the
    // toolbar was moved.  Finally, we can't just get the currentSet of the existing
    // toolbar and pass it to appendCustomToolbar because currentSet always returns
    // "__empty" during customisation, because all the items are wrapped in extra elements.
    var items = [];
    while(toolbar.hasChildNodes()) items.push(toolbar.removeChild(toolbar.lastChild));
    toolbar.parentNode.removeChild(toolbar);

    var newToolbox = document.getElementById(value);
    var newToolbar = newToolbox.appendCustomToolbar(toolbar.toolbarName, "__empty", true);
    while(items.length) newToolbar.appendChild(items.pop());
  }

	// Breiten der vert. Toolboxen lschen (Anpassung der Gre), um sie kurze Zeit spter wieder festzusetzen
  aiostbx_adjustToolboxWidth(aPopup);
}


if(aiosOS != "Darwin") {
	
	// replacement start-customisation function that passes all our toolboxes as args to the window
	// by Stephen Clavering with mods by eXXile
	BrowserCustomizeToolbar = function() {
		// Disable the toolbar context menu items
	  var menubar = document.getElementById("main-menubar");
	  for(var i = 0; i < menubar.childNodes.length; ++i)
	    menubar.childNodes[i].setAttribute("disabled", true);
	
	  document.getElementById("cmd_CustomizeToolbars").setAttribute("disabled", "true");
	
	  if(!aiostbx_toolboxes) aiostbx_getToolboxes();
	
	  openDialog("chrome://global/content/customizeToolbar.xul", "CustomizeToolbar",
	             "chrome,all,dependent", aiostbx_navToolbox, aiostbx_toolboxes);
	}
	
}

	
	// override to make it look at all 4 toolboxes
	// by Stephen Clavering with mods by eXXile
	// erzeugt das Men fr Ansicht => Toolbars (Tabbar & Statusbar auslassen
	// Aufruf durch onpopupshowing() des Toolbar-Kontextmens (browser.xul)
	onViewToolbarsPopupShowing = function (aEvent) {
	
	  var popup = aEvent.target;
	  var i;
	
		// keine Toolbars im "Toolbar Properties"-Men anzeigen
		if(popup.parentNode.id == "aiostbx-toolbar-context-menu") return;
	
	  // Empty the menu
	  for(i = popup.childNodes.length-1; i >= 0; --i) {
	    var deadItem = popup.childNodes[i];
	    if(deadItem.hasAttribute("toolbarid"))
	      popup.removeChild(deadItem);
	  }
	
	  var firstMenuItem = popup.firstChild;
	
		var toolboxIds = [];
		var toolboxes = document.getElementsByTagName('toolbox');
		for(var z = 0; z < toolboxes.length; z++) {
			toolboxIds.push(toolboxes[z].getAttribute('id'));
		}
	
		toolboxIds.push("aiostbx-belowtabs-toolbox");
	
	  for(var j = 0; j < toolboxIds.length; j++) {
	    var toolbox = document.getElementById(toolboxIds[j]);
	
			if(toolbox) {
				for (i = 0; i < toolbox.childNodes.length; ++i) {
		      var toolbar = toolbox.childNodes[i];
		      var toolbarName = toolbar.getAttribute("toolbarname");
	
		      var type = toolbar.getAttribute("type");
		      // inkl. Fix fr PersonalMenu (CompactMenu)
		      //  => ansonsten kann die Menleiste nicht ber das Kontextmen deaktiviert werden
		      if(toolbarName && (type != "menubar" || typeof CompactMenuCE == "object")) {
		        var menuItem = document.createElement("menuitem");
		        menuItem.setAttribute("toolbarid", toolbar.id);
		        menuItem.setAttribute("type", "checkbox");
		        menuItem.setAttribute("label", toolbarName);
		        menuItem.setAttribute("accesskey", toolbar.getAttribute("accesskey"));
		        // Fix fr z.B. Google-Toolbar
		        menuItem.setAttribute("checked", toolbar.getAttribute("collapsed") != "true" && toolbar.getAttribute("hidden") != "true");
		        popup.insertBefore(menuItem, firstMenuItem);
	
		        menuItem.addEventListener("command", onViewToolbarCommand, false);
		      }
		      toolbar = toolbar.nextSibling;
		    }
			}
	  }
	
	  return;
	}
	
	
	// rewritten to be based on toolbar ids rather than the toolbarindex
	// (which was a stupid thing to use anyway :p )
	// by Stephen Clavering with mods by eXXile
	onViewToolbarCommand = function (aEvent) {
	  var toolbar;
	
	  if(typeof aEvent == "object") {
	  	var id = aEvent.originalTarget.getAttribute("toolbarid");
	  	toolbar = document.getElementById(id);
	
	 	var hide = aEvent.originalTarget.getAttribute("checked") != "true";
	  	toolbar.parentNode.hideToolbar(toolbar,hide);
	
	  	// gewnschten AIOS-Toolbar-Zustand im broadcaster in aios.xul speichern
	  	if(id == "aios-toolbar" && document.getElementById('aios-viewToolbar'))
	  		document.getElementById('aios-viewToolbar').setAttribute('checked', !hide);
	
	  	// Fix fr Google-Toolbar (gewnschten Zustand speichern)
	  	if(id == "gtbToolbar" && document.getElementById('aios-viewToolbar')) {
	  		document.getElementById('aios-viewToolbar').setAttribute('gtbToolbar', !hide);
	  		document.persist('aios-viewToolbar', 'gtbToolbar');
	  	}
	  }
		else {
			toolbar = document.getElementById('aios-toolbar');
			if(toolbar.parentNode.hideToolbar) toolbar.parentNode.hideToolbar(toolbar, aEvent);
		}
	}