
/*
	Fixes fr andere Erweiterungen
		=> Aufruf durch aios_initSidebar() in aios.js
*/
function aios_improveCompatibility() {
	// Optimoz-Tweaks
	if(typeof window.moztweaksPrefObserver == "object") {
		aios_optimozTweaksMode(true);
		window.setTimeout("aios_optimozTweaksMode(true)", 300);
	}
	
	// Console2
	if(document.getElementById('viewConsole2Sidebar')) {
		window.setTimeout("aios_modConsole2()", 300);
	}
	
	// MinimizeToTray
    if(document.getElementById('extensions.mook.minimizetotray.traypopup')) {
    	aios_modMinimizeToTray();
    }
    
    // MileWideBack
    // wird in aios.js => aios_setSidebarOrient() ausgefuehrt
    
    // StumbleUpon
    if(document.getElementById('su_splitter_first')) {
    	document.getElementById('su_splitter_first').style.display = "none";
    }
    
    // FoxSaver
    if(typeof FoxSaver == "object") {
		aios_FoxSaver();
    }
    
    // Autohide
    if(typeof autoHIDE == "object") {
		aios_Autohide();
    }
}


/*
	Anpassungen fr MinimizeToTray (sonst ffnet sich der Download-Manager nicht bei Aufruf ber das Trayicon)
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modMinimizeToTray() {
	
	var mmttMenuItems = document.getElementById('extensions.mook.minimizetotray.traypopup').childNodes;
	var itemCmd;
	
	for(var i = 0; i < mmttMenuItems.length; i++) {
		itemCmd = mmttMenuItems[i].getAttribute('oncommand');
		if(itemCmd.indexOf("toOpenWindowByType('Download:Manager'") >= 0) {
			var newCmd = 'aios_WIN.aiosIsWindow = true; window.setTimeout("aios_WIN.aiosIsWindow=false;", 500);' + itemCmd;
			mmttMenuItems[i].setAttribute('oncommand', newCmd);
		}
	}
	
	return true;
}


/*
	Console2-Anpassungen
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modConsole2() {
	
	// meinen Sidebar-Men-Eintrag der Console2 zuweisen
	document.getElementById('console-mitem').setAttribute('observes', 'viewConsole2Sidebar');

	// meinen Broadcaster lschen > keine Auswahlmglichkeit in den Prefs
	if(document.getElementById('viewConsoleSidebar')) {
		var consoleBroad = document.getElementById('viewConsoleSidebar');
		consoleBroad.parentNode.removeChild(consoleBroad);
	}

	// Console2-Button
	var coButton = document.getElementById('console2-button');
	if(coButton) {
		if(coButton.parentNode.tagName == "toolbarpaletteitem")
			coButton.parentNode.parentNode.removeChild(coButton.parentNode);
		else coButton.parentNode.removeChild(coButton);
	}
	
	return true;
}


/*
	Optimoz-Tweaks-Anapssungen
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_optimozTweaksMode(mode) {
	
	aios_getObjects();

	// 	=> bei jedem MouseOver ntig, weil sich die Einstellungen von OptiMoz gendert haben knnten
	if(mode == true) {
		aios_toggleBox.addEventListener("mouseover", aios_optimozTweaksMode, false);
		aiostbx_left_toolbox.addEventListener("mouseover", aios_optimozTweaksMode, false);
	}
	else {
		try {
			var hidemethod = aios_gPref.getIntPref('moztweaks.sidebar.hidemethod');
		}
		catch(e) { }

		// 	=> Event-Listener entfernen und hinzufgen
		if(hidemethod == 0) {
			aios_toggleBox.removeEventListener("mousemove", mtSidebarMouseMoveListener, false);
			aios_toggleBox.addEventListener("mousemove", mtMouseMoveListener, false);
			aios_toggleBox.addEventListener("mousemove", mtPreventHiding, true);

			aiostbx_left_toolbox.removeEventListener("mousemove", mtSidebarMouseMoveListener, false);
			aiostbx_left_toolbox.addEventListener("mousemove", mtMouseMoveListener, false);
			aiostbx_left_toolbox.addEventListener("mousemove", mtPreventHiding, true);
		}
		else if(hidemethod == 1) {
			aios_toggleBox.removeEventListener("mousemove", mtMouseMoveListener, false);
			aios_toggleBox.removeEventListener("mousemove", mtPreventHiding, false);
			aios_toggleBox.addEventListener("mousemove", mtSidebarMouseMoveListener, false);

			aiostbx_left_toolbox.removeEventListener("mousemove", mtMouseMoveListener, false);
			aiostbx_left_toolbox.removeEventListener("mousemove", mtPreventHiding, false);
			aiostbx_left_toolbox.addEventListener("mousemove", mtSidebarMouseMoveListener, false);
		}
	}

	return true;
}


/*
	FoxSaver-Anapssungen
		=> Aufruf durch aios_improveCompatibility()
		=> ohne Anpassung wird die Sidebar nach Beenden von FoxSaver auf 0 Pixel gesetzt und kann erst nach einem Neustart erneut geffnet werden
		=> ohne Anpassung bleiben der Sidebarumschalter, die Toolbars und der Splitter sichtbar
		=> collapsed kann nicht auf 'sidebar-box' angewendet werden, weil sonst die Sidebar nach Beenden von FoxSaver immer sichtbar wre, auch wenn sie vorher unsichtbar war
*/
function aios_FoxSaver() {
	var new_cmd;
	
	//alert(FoxSaver.Util.expendToFullerScreen);
	var new_expendToFullerScreen = FoxSaver.Util.expendToFullerScreen.toString();
	
	new_cmd = 'document.getElementById("sidebar-box").setAttribute("style", "display:none;"); document.getElementById("aios-toggle-toolbox").setAttribute("collapsed", "true"); document.getElementById("aios-toolbox-left").setAttribute("collapsed", "true"); document.getElementById("aios-toolbox-right").setAttribute("collapsed", "true"); document.getElementById("sidebar-splitter").setAttribute("collapsed", "true");';
	new_expendToFullerScreen = new_expendToFullerScreen.replace(/C\.setAttribute\(\"moz-collapsed\"\, \"true\"\)\;/g, new_cmd);
	
	//new_expendToFullerScreen = new_expendToFullerScreen.replace(/moz-collapsed/g, "collapsed");
	
	eval('FoxSaver.Util.expendToFullerScreen = ' + new_expendToFullerScreen + ';');
	//alert(FoxSaver.Util.expendToFullerScreen);
	
	
	//alert(FoxSaver.Util.collapseFullerScreen);
	var new_collapseFullerScreen = FoxSaver.Util.collapseFullerScreen.toString();
	
	new_cmd = 'document.getElementById("sidebar-box").removeAttribute("style"); document.getElementById("aios-toggle-toolbox").removeAttribute("collapsed"); document.getElementById("aios-toolbox-left").removeAttribute("collapsed"); document.getElementById("aios-toolbox-right").removeAttribute("collapsed"); document.getElementById("sidebar-splitter").removeAttribute("collapsed");';
	new_collapseFullerScreen = new_collapseFullerScreen.replace(/B\.removeAttribute\(\"moz-collapsed\"\)\;/g, new_cmd);
	
	new_collapseFullerScreen = new_collapseFullerScreen.replace(/\!F\.isSidebarCollapsed/g, "1==1");
	
	//new_collapseFullerScreen = new_collapseFullerScreen.replace(/moz-collapsed/g, "collapsed");
	
	eval('FoxSaver.Util.collapseFullerScreen = ' + new_collapseFullerScreen + ';');
	//alert(FoxSaver.Util.collapseFullerScreen);
}


/*
	Autohide-Anapssungen
		=> Aufruf durch aios_improveCompatibility()
		=> wenn das Attribut 'fullscreentoolbar' immer verwendet wrde, wrde ohne Autohide der Switch und die Toolbar immer ausgeblendet
*/
function aios_Autohide() {
	
	aios_getObjects();
	
	aios_toggleBar.setAttribute('fullscreentoolbar', 'true');
	aios_toolbar.setAttribute('fullscreentoolbar', 'true');
}