#ifndef CalendarEventCell_h
#define CalendarEventCell_h

#include <Foundation/NSCalendarDate.h>
#include <AppKit/AppKit.h>
#include "Agenda.h"
#include "CalendarEventModel.h"

@class CalendarEventView;

@interface CalendarEventCell:NSView
{
	id __owner;
	id _delegate;

	id __model;

	NSMutableAttributedString *_str;
	NSMutableAttributedString *_str2;
	BOOL _isSelected;
	BOOL _isEdited;
	BOOL _isFaded;
	NSTextView *_textView;
	NSScrollView *_scrollView;

}
- (id) initWithOwner:(CalendarEventView *)owner
			   model:(CalendarEventModel *)model;

- (void) setStartDate:(NSCalendarDate *)startDate
		 timeInterval:(NSTimeInterval)stopTime;

- (NSCalendarDate *) startDate;
- (void) setTimeInterval:(NSTimeInterval)stopTime;
- (NSTimeInterval) timeInterval;
- (NSCalendarDate *) stopDate;
- (NSTimeInterval) timeInterval;

- (void) setSelected:(BOOL)select;
- (BOOL) isSelected;
- (void) calculateFrameHeight;


/* observer delegate */
- (void) calendarEventModel:(CalendarEventModel *)model
		 didUpdateStartDate:(NSCalendarDate *)startDate
			   timeInterval:(NSTimeInterval)time;
@end

#endif
