/*
   Project: XMLLib

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-09 15:14:15 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "ULConnectivityNode.h"

@implementation ULConnectivityNode

- (void) _createConnectivityMatrix
{
	//we'll retain the matrix to avoid having to do this
	//over and over

	int row;
	id connection;
	NSEnumerator* connectionEnum;

	connectivityMatrix = [[ULMatrix alloc] initWithRows: 
					[[attributes valueForKey:@"numberofconnections"] intValue]  
					columns: 2];

	connectionEnum = [children objectEnumerator];	

	row = 0;
	while(connection = [connectionEnum nextObject])
	{
		[connectivityMatrix setElementAtRow: row column: 0 withValue:
			[[connection attributes] valueForKey:@"atomoneindex"]];
		[connectivityMatrix setElementAtRow: row column: 1 withValue:
			[[connection attributes] valueForKey:@"atomtwoindex"]];
		row++;
	}


	[connectivityMatrix retain];
}
	

- (ULMatrix*) connectivityMatrix
{
	if(connectivityMatrix == nil)
		[self _createConnectivityMatrix];

	return connectivityMatrix;
}

- (ULMatrix*) connectivityMatrixWithOffset: (int) offset
{
		
	int norows, row, offsetIndex;
	ULMatrix* offsetMatrix;

	if(connectivityMatrix == nil)
		[self _createConnectivityMatrix];

	norows = [connectivityMatrix Rows];
	offsetMatrix = [[ULMatrix alloc] initWithRows: norows columns: 2];
	
	for(row=0; row < norows; row++)
	{
		offsetIndex = [[connectivityMatrix elementAtRow: row column: 0] intValue] + offset;
		[offsetMatrix setElementAtRow: row column: 0 withValue: [NSNumber numberWithInt: offsetIndex]];
		offsetIndex = [[connectivityMatrix elementAtRow: row column: 1] intValue] + offset;
		[offsetMatrix setElementAtRow: row column: 1 withValue: [NSNumber numberWithInt: offsetIndex]];
	}

	return offsetMatrix;
}
@end
