/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-23 14:09:36 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULMODELCONTROLLER_H_
#define _ULMODELCONTROLLER_H_

#include <Foundation/Foundation.h>
#include <ULFramework/ULSystemController.h>
#include <ULFramework/ULProcessManager.h>
#include "ULFramework/ULIOManager.h"
#include "ULFramework/ULOptionsController.h"
#include "ULFramework/ULDatabaseInterface.h"
#include "ULFramework/ULOptions.h"
#include "ULFramework/ULSystem.h"

/**
The containing and controlling class for the UL model classes.
Its main responsibility is to create processes from the current system
and options objects and to provide information on the state of the model.

\note: This class will be deprecated when the new simulation creation
method is implemented

\ingroup mControl

*/

@interface ULModelController : NSObject
{
	id systemController;
	id optionsController;
	id processManager;
	id ioManager;
	id simulationDatabase;
	id analysisManager;
}

/** Creates a new process*/

- (void) createProcessWithSystem: (ULSystem*) system 
	options: (ULOptions*) options
	host: (NSString*) host;

/** Save the database indexes **/

- (void) saveDatabase;

@end

#endif // _ULMODELCONTROLLER_H_

