#include "ULDatabaseBrowser.h"

@implementation ULDatabaseBrowser (ULDatabaseBrowserDataDisplay)

/**
Outline view delegate methods
FIXME: Removed input referencing for UL0.52
*/

//FIXME: Consider caching availableObjects so we dont have to keep
//requesting it?

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item
{
	id object, temp;
	int itemLevel;

	itemLevel = [outlineView levelForItem: item];

	switch(itemLevel)
	{
		case -1:
			object = [[databaseInterface availableClients] objectAtIndex: index];
			break;
		case 0:
			object = [[databaseInterface schemaInformationForClient: [path itemForLevel: 0]]
					objectAtIndex: index];
			break;		

		case 1:
			object = [[databaseInterface 
					contentTypeInformationForSchema:
						[[path itemForLevel: 1] objectForKey: @"ULSchemaName"]
					ofClient: [path itemForLevel: 0]]
					objectAtIndex: index];
			break;		
		case 2:	
			//older items didnt have a Class metadata attribute which
			//means we cant distinguish system from options. We add it here
			//if its missing. This will be moved to the database index itself
			//as an update step for the new version.
			
			//NSLog(@"Checking database %@", [path itemForLevel: 0]);
			object = [[databaseInterface availableObjectsOfClass: 
						[[path itemForLevel: 2] objectForKey: @"ULObjectClassName"]
					inSchema: [[path itemForLevel: 1] objectForKey: @"ULSchemaName"]	
					ofClient: [path itemForLevel: 0]]
					objectAtIndex: index];
			
			//The returned objects dont contain the clients name (since it is volatile)
			//which we need so we add it here.
			//FIXME: Maybe the client should do this.
			if([object objectForKey: @"DatabaseClient"] ==  nil)
				[object setObject: [path itemForLevel: 0] forKey: @"DatabaseClient"];

			if([object objectForKey: @"Class"] ==  nil)
				[object setObject: 
					[[path itemForLevel: 2] objectForKey: @"ULObjectClassName"]
					forKey: @"Class"];
			break;
		/*case 3:
			temp = [databaseInterface inputReferencesForObjectWithID: 
				[[path itemForLevel:3] objectForKey: @"Identification"]
				ofClass: [[path itemForLevel: 2] objectForKey: @"ULObjectClassName"]
				inSchema: [[path itemForLevel: 1] objectForKey: @"ULSchemaName"]
				ofClient: [path itemForLevel: 0]];
			object = [temp objectAtIndex: index];*/
	}	

	[path setItem: object forLevel: itemLevel + 1];
	return object;
}

- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
	int itemLevel, noChildren;
	id temp;

	if(item == nil)
		itemLevel = -1;
	else
		itemLevel = [path currentLevel];
	
	/*NSLog(@"Gettin number of children for item %@ at level %d", item, itemLevel);
	NSLog(@"Current path %@", [path currentPath]);*/
	
	switch(itemLevel)
	{
		case -1:
			noChildren = [[databaseInterface availableClients] count];
			break;
		case 0:
			noChildren = [[databaseInterface 
					schemaInformationForClient: [path itemForLevel: 0]]
					count];
			break;		
		case 1:
			noChildren = [[databaseInterface 
					contentTypeInformationForSchema:
						[[path itemForLevel: 1] objectForKey: @"ULSchemaName"]
					ofClient: [path itemForLevel: 0]] count];
			break;		
		case 2:			
			noChildren = [[databaseInterface availableObjectsOfClass: 
						[[path itemForLevel: 2] objectForKey: @"ULObjectClassName"]
					inSchema: [[path itemForLevel: 1] objectForKey: @"ULSchemaName"]
					ofClient: [path itemForLevel: 0]] count];
			break;	
	/*	case 3:
			temp = [databaseInterface inputReferencesForObjectWithID: 
					[[path itemForLevel:3] objectForKey: @"Identification"]
					ofClass: [[path itemForLevel: 2] objectForKey: @"ULObjectClassName"]
					inSchema: [[path itemForLevel: 1] objectForKey: @"ULSchemaName"]
					ofClient: [path itemForLevel: 0]];
			noChildren = [temp count];
			break;*/
		default:
			noChildren = 0;
	}			

//	NSLog(@"This item has %d children", noChildren);

	return noChildren;
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
	int itemLevel;
	id temp;

	itemLevel = [outlineView levelForItem:item];
	if(itemLevel < 3)
		return YES;
/*	else if(itemLevel == 3)
	{
		temp = [databaseInterface inputReferencesForObjectWithID: 
				[item objectForKey: @"Identification"]
			ofClass: [item objectForKey: @"Class"]
			inSchema: [item objectForKey: @"Schema"]
			ofClient: [item objectForKey: @"DatabaseClient"]];
		
		if([temp count] == 0)
			return NO;
		else
			return YES;
	}*/
	else
		return NO;
}

- (id)outlineView:(NSOutlineView *)outlineView 
	objectValueForTableColumn:(NSTableColumn *)tableColumn 
	byItem:(id)item
{
	int itemLevel;
	id obj;

	itemLevel = [outlineView levelForItem: item];

	//NSLog(@"Getting value for item %@ at level %d\n",item, itemLevel);

	switch(itemLevel)
	{
		case 0:
			obj = [[[NSMutableAttributedString alloc] 
				initWithString: item] autorelease];
			[obj addAttribute: NSForegroundColorAttributeName
				value: [NSColor blueColor]
				range: NSMakeRange(0, [obj length])];
			return obj;	
		case 1:
			return [item objectForKey:@"ULSchemaName"];	
		case 2:
			return [item objectForKey: @"ULObjectDisplayName"];
		default:
			return [item objectForKey: @"Name"];
	}		
}

/**
Outline view delegate
*/

//to allow deselectAll
//FIXME: The rows are deselected from a programming point of view but graphically
//they still appear selected.
- (BOOL)selectionShouldChangeInOutlineView:(NSOutlineView *)outlineView
{
	return YES;
}

- (void) outlineViewSelectionDidChange: (NSNotification*) aNotification
{
	int row;
	id selectedRows, item;

	//udpate whats been selected

	[selectedSystems removeAllObjects];
	[selectedOptions removeAllObjects];
	[selectedDataSets removeAllObjects];
	[selectedSimulations removeAllObjects];
	selectedRows = [browserView selectedRowIndexes];
	if([selectedRows count] == 0)
		return;

	row = [selectedRows firstIndex];
	while(row != NSNotFound)
	{
		item = [browserView itemAtRow: row];
		if([browserView levelForItem: item] >= 3)
		{
			if([[item objectForKey:@"Class"] isEqual: @"ULSystem"])
				[selectedSystems addObject: item];
			else if([[item objectForKey: @"Class"] isEqual: @"ULOptions"])
				[selectedOptions addObject: item];
			else if([[item objectForKey: @"Class"] isEqual: @"AdDataSet"])
				[selectedDataSets addObject: item];
			else if([[item objectForKey: @"Class"] isEqual: @"ULSimulation"])
				[selectedSimulations addObject: item];
		}

		row = [selectedRows indexGreaterThanIndex: row];
	}
}

- (BOOL) outlineView: (NSOutlineView*) outlineView shouldSelectItem: (id) item
{
	if(!isActive)
	{
		//take ownership of the pasteboard
		
		//NSLog(@"Not active - taking control of pasteboard and activating self");
		[[ULPasteboard appPasteboard] setPasteboardOwner: self];
		[[NSNotificationCenter defaultCenter]
			postNotificationName: @"ULDatabaseBrowserDidBecomeActiveNotification"
			object: self];
	}		

	return YES;
}	

@end
