/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _SCAAS_
#define _SCASS_

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <float.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include "Base/AdVector.h"
#include "Base/AdSorter.h"
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunKernel.h"

/** 
BoundaryImplementor for Surface Constrained All-Atom Solvent
\todo Instead of setSystem should use setSolute and setSolvent (or setSolutes) 
\ingroup Cinter
**/

@interface SCAAS: AdBoundaryImplementor
{
	bool isChargedSolute;
	int no_solvent_atoms;
	int no_solute_atoms;
	int atoms_per_molecule;
	int no_solvent_molecules;
	int no_surface_molecules;
	int inside_count;
	double targetTemperature;
	double KBT;			//boltzmanns contstant times the target temperature
	double solute_charge;
	double surface_region;
	double inner_sphere;
	double solvent_mass;		//mass of a solvent molecule
	double solvent_density;
	double occlusion_factor;
	double alpha;		 	//for equilibrium radial distance calculation		
	double beta;			//for equilibrium radial distance calculation	
	double variance;
	double sigma;
	double *polarisation_angles; 	//hold the polarisation angle of each surface molecule	
	IntMatrix *solventIndexMatrix;		//a matrix telling which atoms make up each molecule
	AdMatrix *coordinatesMatrix;
	AdMatrix *velocitiesMatrix;
	AdMatrix *accelerationsMatrix;
	int (*comparison_pt) (const void*, const void*);
	gsl_rng* twister;	
	Vector3D *radial_distance;		//holds the centre of mass of each molecule
	Vector3D *dipoles;
	Vector3D *cavityCentre; 		
	Sort *radial_sorter;
	Sort *polarisation_sorter;
	id system;
	id solventSystem;
	id soluteSystem;
	id memoryManager;
}
@end

#endif
