#!/usr/bin/ruby

$:<<'../lib'
require 'test/unit'
require 'activeldap'

# Load all demo sub-objects
Dir['../examples/objects/*.rb'].each {|t| require t}


class SpeedTest < Test::Unit::TestCase

  def test_0_bind
    assert_nothing_raised() do
      ActiveLDAP::Base.close
      ActiveLDAP::Base.connect(
        :user => 'root',
        :host => '127.0.0.1',
        :port => 389,
        :base => 'dc=localdomain',
        :password_block => Proc.new{'password'}, 
        :allow_anonymous => false)
    end
  end

  def test_1_user_speed
    count = 0
    loop do
      break if count == 100
      user = User.new('speedtestuser')
      user.objectClass << 'person'
      user.cn = 'Speedy McTestUser'
      user.surname = 'McTestUser'

      user.uidNumber = 11111
      user.gidNumber = 11111
      user.homeDirectory = '/var/tmp/speeedy'
      user.write
      count += 1
    end
  end

  def test_2_cleanup
    User.new('speedtestuser').delete
  end

end
 
