/* ------------------------------------------------------------------------
 * $Id: VisitorImpl.cc,v 1.10 2001/08/21 14:43:04 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-09-06 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Polhem/NodeImpl.hh"
#include "Polhem/TransformImpl.hh"
#include "Polhem/VisitorImpl.hh"

using namespace Nobel;

// -- Code Segment

VisitorImpl::VisitorImpl()
{ 
    // empty
}

VisitorImpl::~VisitorImpl()
{
    // Deallocate transforms on the stack
    while (_trafos.empty() == false) {
	delete _trafos.top();
	_trafos.pop();
    }
}

Transform_ptr VisitorImpl::transformation()
{
    if (_trafos.empty() == true) return Transform::_nil();
    else return _trafos.top()->_this();
}

void VisitorImpl::save()
{
    TransformImpl *current = new TransformImpl;
    if (!_trafos.empty()) 
	*current = *_trafos.top();
    _trafos.push(current);
}

void VisitorImpl::restore()
{
    delete _trafos.top();
    _trafos.pop();
}

void VisitorImpl::traverse(Node_ptr child, Transform_ptr t)
{
    // Make sure this is not a nil reference
    if (CORBA::is_nil(child))
	return;
    
    // Save the old state, apply new transform, traverse child and restore
    save();
    multiplyTransform(t);
    child->traverse(Visitor_var(_this()));
    restore();
}
