/* ------------------------------------------------------------------------
 * $Id: EmitterImpl.cc,v 1.6 2001/08/28 13:18:51 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-04-22 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Celsius/Guard.hh"
#include "Polhem/EmitterImpl.hh"

using namespace Nobel;

// -- Code Segment

EmitterImpl::~EmitterImpl() { }

void EmitterImpl::emit(const Event &e)
{
    Guard<Mutex> guard(_emutex);

    // Emit the event to all listeners
    for (std::list<Listener_var>::iterator i = _listeners.begin();
	 i != _listeners.end(); i++)
	(*i)->receive(e);
}

void EmitterImpl::addListener(Listener_ptr l)
{
    Guard<Mutex> guard(_emutex);

    // Add the listener to the listener vector
    _listeners.push_back(Listener::_duplicate(l));
}

void EmitterImpl::removeListener(Listener_ptr l)
{
    Guard<Mutex> guard(_emutex);

    // Find the listener and remove it if found.  (@@@We need to do
    // more than compare IORs here!!! See pp 257 Henning & Vinoski.)
    for (std::list<Listener_var>::iterator i = _listeners.begin();
	 i != _listeners.end(); i++) {
	if (l->_is_equivalent(*i)) {
	    _listeners.erase(i);
	    break;
	}
    }
}

void EmitterImpl::clearListeners()
{
    Guard<Mutex> guard(_emutex);

    // Clear the list of listeners
    _listeners.clear();
}

void EmitterImpl::emitSubjectChanged()
{
    Nobel::Event e;

    // Create and emit the event
    e.type = Nobel::SubjectChanged;
    e.obj = _this();
    emit(e);
}
