/* ------------------------------------------------------------------------
 * VisitorImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-09-06 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _VisitorImpl_hh_
#define _VisitorImpl_hh_

// -- System Includes
#include <stack>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Polhem/TransformImpl.hh"
#include "Nobel/Visitor.hh"

// -- Forward Declarations
class TransformImpl;

// -- Class Declarations
class VisitorImpl : public virtual POA_Nobel::Visitor,
		    public virtual PortableServer::RefCountServantBase {
    
public:

    /// IDL Functions
    virtual Nobel::Transform_ptr transformation();
    virtual void visit(Nobel::Node_ptr n) = 0;
    virtual void traverse(Nobel::Node_ptr child, Nobel::Transform_ptr t);

    /**
     * Save the visitor state. This will push the current transform to
     * the state stack and create a new, identical current transform.
     **/
    virtual void save();
    
    /**
     * Restore the visitor state. Pop the changes made to the visitor
     * state since the last save off the state stack and reinstate the
     * old state.
     **/
    virtual void restore();
    
    /**
     * Premultiply a given transform with the current transform,
     * yielding a new transform. This means, in effect, applying the
     * local transform of a node child to the current global
     * transform.
     * 
     * @param t the new transform to premultiply to the current.
     **/    
    virtual void multiplyTransform(Nobel::Transform_ptr t);

protected:

    /**
     * Default constructor.
     **/ 
    VisitorImpl();

    /**
     * Destructor.
     **/
    virtual ~VisitorImpl();
        
    std::stack<TransformImpl *> _trafos;
};

// -- Inlines

inline void VisitorImpl::multiplyTransform(Nobel::Transform_ptr t) {
    if (_trafos.empty() == false && CORBA::is_nil(t) == false)
	_trafos.top()->premultiply(t);
}

#endif /* VisitorImpl.hh */
